/*
 * Decompiled with CFR 0.152.
 */
package net.sf.smc.generator;

import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.smc.generator.SmcCodeGenerator;
import net.sf.smc.generator.SmcOptions;
import net.sf.smc.model.SmcAction;
import net.sf.smc.model.SmcElement;
import net.sf.smc.model.SmcFSM;
import net.sf.smc.model.SmcGuard;
import net.sf.smc.model.SmcMap;
import net.sf.smc.model.SmcParameter;
import net.sf.smc.model.SmcState;
import net.sf.smc.model.SmcTransition;
import net.sf.smc.model.TargetLanguage;

public final class SmcCppGenerator
extends SmcCodeGenerator {
    public SmcCppGenerator(SmcOptions options) {
        super(options, TargetLanguage.C_PLUS_PLUS.suffix());
    }

    @Override
    public void visit(SmcFSM fsm) {
        String mapName;
        SmcMap map;
        String packageName = fsm.getPackage();
        String rawSource = fsm.getSource();
        String context = fsm.getContext();
        String fsmClassName = fsm.getFsmClassName();
        int packageDepth = 0;
        this.mTarget.println("//");
        this.mTarget.println("// ex: set ro:");
        this.mTarget.println("// DO NOT EDIT.");
        this.mTarget.println("// generated by smc (http://smc.sourceforge.net/)");
        this.mTarget.print("// from file : ");
        this.mTarget.print(this.mSrcfileBase);
        this.mTarget.println(".sm");
        this.mTarget.println("//");
        this.mTarget.println();
        if (rawSource != null && rawSource.length() > 0) {
            this.mTarget.println(rawSource);
            this.mTarget.println();
        }
        for (String include : fsm.getIncludes()) {
            this.mTarget.print("#include ");
            this.mTarget.println(include);
        }
        this.mTarget.print("#include \"");
        if (!this.mSrcDirectory.equals(this.mHeaderDirectory)) {
            this.mTarget.print(this.findPath(this.mSrcDirectory, this.mHeaderDirectory));
        } else {
            this.mTarget.print(this.mSrcDirectory);
        }
        this.mTarget.print(this.mTargetfileBase);
        this.mTarget.format(".%s\"%n", this.mHeaderSuffix);
        this.mTarget.println();
        this.mTarget.println("using namespace statemap;");
        for (String imp : fsm.getImports()) {
            this.mTarget.print("using namespace ");
            this.mTarget.print(imp);
            this.mTarget.println(";");
        }
        this.mTarget.println();
        if (packageName != null && packageName.length() > 0) {
            this.mIndent = "";
            StringTokenizer tokenizer = new StringTokenizer(packageName, "::");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                ++packageDepth;
                this.mTarget.print(this.mIndent);
                this.mTarget.print("namespace ");
                this.mTarget.println(token);
                this.mTarget.print(this.mIndent);
                this.mTarget.println("{");
                this.mIndent = this.mIndent + "    ";
            }
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("// Static class declarations.");
        Iterator<SmcMap> mapIt = fsm.getMaps().iterator();
        int index = 0;
        while (mapIt.hasNext()) {
            map = mapIt.next();
            mapName = map.getName();
            for (SmcState state : map.getStates()) {
                this.mTarget.print(this.mIndent);
                this.mTarget.print(mapName);
                this.mTarget.print("_");
                this.mTarget.print(state.getClassName());
                this.mTarget.print(" ");
                this.mTarget.print(mapName);
                this.mTarget.print("::");
                this.mTarget.print(state.getInstanceName());
                this.mTarget.print("(\"");
                this.mTarget.print(mapName);
                this.mTarget.print("::");
                this.mTarget.print(state.getClassName());
                this.mTarget.print("\", ");
                this.mTarget.print(index);
                this.mTarget.println(");");
                ++index;
            }
        }
        if (this.mSerialFlag) {
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            if (this.mCRTPFlag) {
                this.mTarget.print("template<> ");
            }
            this.mTarget.print("const int ");
            this.mTarget.print(fsmClassName);
            if (this.mCRTPFlag) {
                this.mTarget.print("<");
                this.mTarget.print(context);
                this.mTarget.print(">");
            }
            this.mTarget.println("::MIN_INDEX = 0;");
            this.mTarget.print(this.mIndent);
            if (this.mCRTPFlag) {
                this.mTarget.print("template<> ");
            }
            this.mTarget.print("const int ");
            this.mTarget.print(fsmClassName);
            if (this.mCRTPFlag) {
                this.mTarget.print("<");
                this.mTarget.print(context);
                this.mTarget.print(">");
            }
            this.mTarget.print("::MAX_INDEX = ");
            this.mTarget.print(--index);
            this.mTarget.println(";");
            this.mTarget.print(this.mIndent);
            if (this.mCRTPFlag) {
                this.mTarget.print("template<> ");
            }
            this.mTarget.print(context);
            this.mTarget.print("State* ");
            this.mTarget.print(fsmClassName);
            if (this.mCRTPFlag) {
                this.mTarget.print("<");
                this.mTarget.print(context);
                this.mTarget.print(">");
            }
            this.mTarget.println("::_States[] = ");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("{");
            mapIt = fsm.getMaps().iterator();
            String separator = "";
            while (mapIt.hasNext()) {
                map = mapIt.next();
                mapName = map.getName();
                for (SmcState state : map.getStates()) {
                    this.mTarget.print(separator);
                    this.mTarget.println();
                    this.mTarget.print(this.mIndent);
                    this.mTarget.print("    &");
                    this.mTarget.print(mapName);
                    this.mTarget.print("::");
                    this.mTarget.print(state.getClassName());
                    separator = ",";
                }
            }
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.println("};");
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            if (this.mCRTPFlag) {
                this.mTarget.print("template<> ");
            }
            this.mTarget.print(context);
            this.mTarget.print("State& ");
            this.mTarget.print(fsmClassName);
            if (this.mCRTPFlag) {
                this.mTarget.print("<");
                this.mTarget.print(context);
                this.mTarget.print(">");
            }
            this.mTarget.println("::valueOf(int stateId)");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("{");
            if (this.mNoExceptionFlag) {
                this.mTarget.print(this.mIndent);
                this.mTarget.println("    assert(stateId >= MIN_INDEX);");
                this.mTarget.print(this.mIndent);
                this.mTarget.println("    assert(stateId <= MAX_INDEX);");
            } else {
                this.mTarget.print(this.mIndent);
                this.mTarget.print("    if ((stateId < MIN_INDEX) || ");
                this.mTarget.println("(stateId > MAX_INDEX))");
                this.mTarget.print(this.mIndent);
                this.mTarget.println("    {");
                this.mTarget.print(this.mIndent);
                this.mTarget.println("        throw (");
                this.mTarget.print(this.mIndent);
                this.mTarget.println("            IndexOutOfBoundsException(");
                this.mTarget.print(this.mIndent);
                this.mTarget.print("                stateId, MIN_INDEX, ");
                this.mTarget.println("MAX_INDEX));");
                this.mTarget.print(this.mIndent);
                this.mTarget.println("    }");
            }
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    return static_cast<");
            this.mTarget.print(context);
            this.mTarget.print("State&>(*(");
            this.mTarget.println("_States[stateId]));");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("}");
        }
        List<SmcTransition> transList = fsm.getTransitions();
        for (SmcTransition trans : transList) {
            if (trans.getName().equals("Default")) continue;
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("void ");
            this.mTarget.print(context);
            this.mTarget.print("State::");
            this.mTarget.print(trans.getName());
            this.mTarget.print("(");
            this.mTarget.print(fsmClassName);
            if (this.mCRTPFlag) {
                this.mTarget.print("<");
                this.mTarget.print(context);
                this.mTarget.print(">");
            }
            this.mTarget.print("& context");
            List<SmcParameter> params = trans.getParameters();
            for (SmcParameter param : params) {
                this.mTarget.print(", ");
                param.accept(this);
            }
            this.mTarget.println(")");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("{");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    Default(context);");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("}");
        }
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("void ");
        this.mTarget.print(context);
        this.mTarget.print("State::Default(");
        this.mTarget.print(fsmClassName);
        if (this.mCRTPFlag) {
            this.mTarget.print("<");
            this.mTarget.print(context);
            this.mTarget.print(">");
        }
        this.mTarget.println("& context)");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("{");
        if (this.mDebugLevel >= 0) {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    if (context.getDebugFlag())");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    {");
            if (this.mNoStreamsFlag) {
                this.mTarget.print(this.mIndent);
                this.mTarget.print("        TRACE(");
                this.mTarget.println("\"TRANSITION   : Default\\n\");");
            } else {
                this.mTarget.print(this.mIndent);
                this.mTarget.print("        std::ostream& str = ");
                this.mTarget.println("context.getDebugStream();");
                this.mTarget.println();
                this.mTarget.print(this.mIndent);
                this.mTarget.println("        str << \"TRANSITION   : Default\"");
                this.mTarget.print(this.mIndent);
                this.mTarget.println("            << std::endl;");
            }
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    }");
            this.mTarget.println();
        }
        if (!this.mNoExceptionFlag) {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    throw (");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("        TransitionUndefinedException(");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            context.getState().getName(),");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("            context.getTransition()));");
            this.mTarget.println();
        } else {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    assert(false);");
            this.mTarget.println();
        }
        this.mTarget.print(this.mIndent);
        this.mTarget.println("}");
        mapIt = fsm.getMaps().iterator();
        while (mapIt.hasNext()) {
            mapIt.next().accept(this);
        }
        if (packageName != null && packageName.length() > 0) {
            for (int i = packageDepth - 1; i >= 0; --i) {
                for (int j = 0; j < i; ++j) {
                    this.mTarget.print("    ");
                }
                this.mTarget.println("}");
            }
        }
        this.mTarget.println();
        this.mTarget.println("//");
        this.mTarget.println("// Local variables:");
        this.mTarget.println("//  buffer-read-only: t");
        this.mTarget.println("// End:");
        this.mTarget.println("//");
    }

    @Override
    public void visit(SmcMap map) {
        if (map.hasDefaultState()) {
            SmcState defaultState = map.getDefaultState();
            for (SmcTransition trans : defaultState.getTransitions()) {
                trans.accept(this);
            }
        }
        for (SmcState state : map.getStates()) {
            state.accept(this);
        }
    }

    @Override
    public void visit(SmcState state) {
        String indent2;
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String fsmClassName = map.getFSM().getFsmClassName();
        String mapName = map.getName();
        String className = state.getClassName();
        List<SmcAction> actions = state.getEntryActions();
        if (actions != null && !actions.isEmpty()) {
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("void ");
            this.mTarget.print(mapName);
            this.mTarget.print("_");
            this.mTarget.print(className);
            this.mTarget.print("::Entry(");
            this.mTarget.print(fsmClassName);
            if (this.mCRTPFlag) {
                this.mTarget.print("<");
                this.mTarget.print(context);
                this.mTarget.print(">");
            }
            this.mTarget.println("& context)");
            this.mTarget.println();
            this.mTarget.println("{");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    ");
            this.mTarget.print(context);
            this.mTarget.println("& ctxt = context.getOwner();");
            this.mTarget.println();
            indent2 = this.mIndent;
            this.mIndent = this.mIndent + "    ";
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mIndent = indent2;
            this.mTarget.print(this.mIndent);
            this.mTarget.println("}");
        }
        if ((actions = state.getExitActions()) != null && !actions.isEmpty()) {
            this.mTarget.println();
            this.mTarget.print(this.mIndent);
            this.mTarget.print("void ");
            this.mTarget.print(mapName);
            this.mTarget.print("_");
            this.mTarget.print(className);
            this.mTarget.print("::Exit(");
            this.mTarget.print(fsmClassName);
            if (this.mCRTPFlag) {
                this.mTarget.print("<");
                this.mTarget.print(context);
                this.mTarget.print(">");
            }
            this.mTarget.println("& context)");
            this.mTarget.println();
            this.mTarget.println("{");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    ");
            this.mTarget.print(context);
            this.mTarget.println("& ctxt = context.getOwner();");
            this.mTarget.println();
            indent2 = this.mIndent;
            this.mIndent = this.mIndent + "    ";
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mIndent = indent2;
            this.mTarget.print(this.mIndent);
            this.mTarget.println("}");
        }
        for (SmcTransition trans : state.getTransitions()) {
            trans.accept(this);
        }
    }

    @Override
    public void visit(SmcTransition transition) {
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String fsmClassName = map.getFSM().getFsmClassName();
        String mapName = map.getName();
        String stateName = state.getClassName();
        String instanceName = state.getInstanceName();
        String transName = transition.getName();
        SmcGuard nullGuard = null;
        List<SmcGuard> guards = transition.getGuards();
        Iterator<SmcGuard> git = guards.iterator();
        String fqStateName = !stateName.contains("::") ? mapName + "::" + stateName : stateName;
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.print("void ");
        this.mTarget.print(mapName);
        this.mTarget.print("_");
        this.mTarget.print(stateName);
        this.mTarget.print("::");
        this.mTarget.print(transName);
        this.mTarget.print("(");
        this.mTarget.print(fsmClassName);
        if (this.mCRTPFlag) {
            this.mTarget.print("<");
            this.mTarget.print(context);
            this.mTarget.print(">");
        }
        this.mTarget.print("& context");
        for (SmcParameter param : transition.getParameters()) {
            this.mTarget.print(", ");
            param.accept(this);
        }
        this.mTarget.println(")");
        this.mTarget.print(this.mIndent);
        this.mTarget.println("{");
        if (transition.hasCtxtReference()) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    ");
            this.mTarget.print(context);
            this.mTarget.println("& ctxt = context.getOwner();");
        }
        this.mTarget.println();
        if (this.mDebugLevel >= 0) {
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    if (context.getDebugFlag())");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    {");
            if (this.mNoStreamsFlag) {
                this.mTarget.print(this.mIndent);
                this.mTarget.print("        TRACE(\"LEAVING STATE   : ");
                this.mTarget.print(fqStateName);
                this.mTarget.println("\\n\");");
            } else {
                this.mTarget.print(this.mIndent);
                this.mTarget.print("        std::ostream& str = ");
                this.mTarget.println("context.getDebugStream();");
                this.mTarget.println();
                this.mTarget.print(this.mIndent);
                this.mTarget.print("        str << \"LEAVING STATE   : ");
                this.mTarget.print(fqStateName);
                this.mTarget.println("\"");
                this.mTarget.println("                << std::endl;");
            }
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    }");
            this.mTarget.println();
        }
        this.mGuardIndex = 0;
        this.mGuardCount = guards.size();
        while (git.hasNext()) {
            SmcGuard guard = git.next();
            if (guard.getCondition().isEmpty()) {
                nullGuard = guard;
                continue;
            }
            guard.accept(this);
            ++this.mGuardIndex;
        }
        if (nullGuard != null) {
            if (nullGuard.hasActions() || !nullGuard.getEndState().equals("nil") || nullGuard.getTransType() == SmcElement.TransType.TRANS_PUSH || nullGuard.getTransType() == SmcElement.TransType.TRANS_POP) {
                nullGuard.accept(this);
            }
            this.mTarget.println();
        } else if (this.mGuardIndex > 0) {
            if (this.mGuardCount == 1) {
                this.mTarget.print(this.mIndent);
                this.mTarget.println("    }");
            }
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    else");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    {");
            this.mTarget.print(this.mIndent);
            this.mTarget.print("         ");
            if (!instanceName.equals("DefaultState")) {
                this.mTarget.print(mapName);
                this.mTarget.print("_Default::");
            } else {
                this.mTarget.print(context);
                this.mTarget.print("State::");
            }
            this.mTarget.print(transName);
            this.mTarget.print("(context");
            for (SmcParameter param : transition.getParameters()) {
                this.mTarget.print(", ");
                this.mTarget.print(param.getName());
            }
            this.mTarget.println(");");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    }");
            this.mTarget.println();
        }
        this.mTarget.println();
        this.mTarget.print(this.mIndent);
        this.mTarget.println("}");
    }

    @Override
    public void visit(SmcGuard guard) {
        String indent3;
        String sep;
        Iterator<SmcParameter> pit;
        List<SmcParameter> parameters;
        Object transName;
        String indent2;
        SmcTransition transition = guard.getTransition();
        SmcState state = transition.getState();
        SmcMap map = state.getMap();
        String context = map.getFSM().getContext();
        String mapName = map.getName();
        String stateName = state.getClassName();
        SmcElement.TransType transType = guard.getTransType();
        String endStateName = guard.getEndState();
        String fqEndStateName = "";
        String pushStateName = guard.getPushState();
        String condition = guard.getCondition();
        List<SmcAction> actions = guard.getActions();
        if (transType != SmcElement.TransType.TRANS_POP && endStateName.length() > 0 && !endStateName.equals("nil") && !endStateName.contains("::")) {
            endStateName = mapName + "::" + endStateName;
        }
        if (!stateName.contains("::")) {
            stateName = mapName + "::" + stateName;
        }
        boolean loopbackFlag = this.isLoopback(transType, endStateName);
        if (pushStateName != null && pushStateName.length() > 0 && !pushStateName.contains("::")) {
            pushStateName = mapName + "::" + pushStateName;
        }
        if (this.mGuardCount > 1) {
            indent2 = this.mIndent + "        ";
            if (this.mGuardIndex == 0 && condition.length() > 0) {
                this.mTarget.print(this.mIndent);
                this.mTarget.print("    if (");
                this.mTarget.print(condition);
                this.mTarget.println(")");
                this.mTarget.print(this.mIndent);
                this.mTarget.println("    {");
            } else if (condition.length() > 0) {
                this.mTarget.println();
                this.mTarget.print(this.mIndent);
                this.mTarget.print("    else if (");
                this.mTarget.print(condition);
                this.mTarget.println(")");
                this.mTarget.println(this.mIndent);
                this.mTarget.println("    {");
            } else {
                this.mTarget.println();
                this.mTarget.print(this.mIndent);
                this.mTarget.println("    else");
                this.mTarget.print(this.mIndent);
                this.mTarget.println("    {");
            }
        } else if (condition.length() == 0) {
            indent2 = this.mIndent + "    ";
        } else {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    if (");
            this.mTarget.print(condition);
            this.mTarget.println(")");
            this.mTarget.print(this.mIndent);
            this.mTarget.println("    {");
            indent2 = this.mIndent + "        ";
        }
        if (actions.isEmpty() && !endStateName.isEmpty()) {
            fqEndStateName = endStateName;
        } else if (!actions.isEmpty()) {
            if (loopbackFlag) {
                fqEndStateName = "endState";
                this.mTarget.print(indent2);
                this.mTarget.print(context);
                this.mTarget.print("State& ");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(" = context.getState();");
                this.mTarget.println();
            } else {
                fqEndStateName = endStateName;
            }
        }
        if (transType == SmcElement.TransType.TRANS_POP || !loopbackFlag) {
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent2);
                this.mTarget.println("if (context.getDebugFlag())");
                this.mTarget.print(indent2);
                this.mTarget.println("{");
                if (this.mNoStreamsFlag) {
                    this.mTarget.print(indent2);
                    this.mTarget.print("    TRACE(\"BEFORE EXIT     : ");
                    this.mTarget.print(stateName);
                    this.mTarget.println("::Exit(context)\\n\");");
                } else {
                    this.mTarget.print(indent2);
                    this.mTarget.print("    std::ostream& str = ");
                    this.mTarget.println("context.getDebugStream();");
                    this.mTarget.println();
                    this.mTarget.print(indent2);
                    this.mTarget.print("    str << \"BEFORE EXIT     : ");
                    this.mTarget.print(stateName);
                    this.mTarget.println("::Exit(context)\"");
                    this.mTarget.print(indent2);
                    this.mTarget.println("        << std::endl;");
                }
                this.mTarget.print(indent2);
                this.mTarget.println("}");
                this.mTarget.println();
            }
            this.mTarget.print(indent2);
            this.mTarget.println("context.getState().Exit(context);");
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent2);
                this.mTarget.println("if (context.getDebugFlag())");
                this.mTarget.print(indent2);
                this.mTarget.println("{");
                if (this.mNoStreamsFlag) {
                    this.mTarget.print(indent2);
                    this.mTarget.print("    TRACE(\"AFTER EXIT      : ");
                    this.mTarget.print(stateName);
                    this.mTarget.println("::Exit(context)\\n\");");
                } else {
                    this.mTarget.print(indent2);
                    this.mTarget.print("    std::ostream& str = ");
                    this.mTarget.println("context.getDebugStream();");
                    this.mTarget.println();
                    this.mTarget.print(indent2);
                    this.mTarget.print("    str << \"AFTER EXIT      : ");
                    this.mTarget.print(stateName);
                    this.mTarget.println("::Exit(context)\"");
                    this.mTarget.print(indent2);
                    this.mTarget.println("            << std::endl;");
                }
                this.mTarget.print(indent2);
                this.mTarget.println("}");
                this.mTarget.println();
            }
        }
        if (this.mDebugLevel >= 0) {
            transName = transition.getName();
            parameters = transition.getParameters();
            this.mTarget.print(indent2);
            this.mTarget.println("if (context.getDebugFlag())");
            this.mTarget.print(indent2);
            this.mTarget.println("{");
            if (this.mNoStreamsFlag) {
                this.mTarget.print(indent2);
                this.mTarget.print("    TRACE(\"ENTER TRANSITION: ");
                this.mTarget.print(stateName);
                this.mTarget.print("::");
                this.mTarget.print((String)transName);
                this.mTarget.print("(");
                pit = parameters.iterator();
                sep = "";
                while (pit.hasNext()) {
                    this.mTarget.print(sep);
                    pit.next().accept(this);
                    sep = ", ";
                }
                this.mTarget.println(")\\n\");");
            } else {
                this.mTarget.print(indent2);
                this.mTarget.print("    std::ostream& str = ");
                this.mTarget.println("context.getDebugStream();");
                this.mTarget.println();
                this.mTarget.print(indent2);
                this.mTarget.print("    str << \"ENTER TRANSITION: ");
                this.mTarget.print(stateName);
                this.mTarget.print("::");
                this.mTarget.print((String)transName);
                this.mTarget.print("(");
                pit = parameters.iterator();
                sep = "";
                while (pit.hasNext()) {
                    this.mTarget.print(sep);
                    pit.next().accept(this);
                    sep = ", ";
                }
                this.mTarget.println(")\"");
                this.mTarget.print(indent2);
                this.mTarget.println("        << std::endl;");
            }
            this.mTarget.print(indent2);
            this.mTarget.println("}");
            this.mTarget.println();
        }
        if (actions.size() > 0) {
            this.mTarget.print(indent2);
            this.mTarget.println("context.clearState();");
        }
        if (actions.isEmpty()) {
            if (condition.length() > 0) {
                this.mTarget.print(indent2);
                this.mTarget.println("// No actions.");
            }
            indent3 = indent2;
        } else {
            if (!this.mNoCatchFlag) {
                this.mTarget.print(indent2);
                this.mTarget.println("try");
                this.mTarget.print(indent2);
                this.mTarget.println("{");
                indent3 = indent2 + "    ";
            } else {
                indent3 = indent2;
            }
            String indent4 = this.mIndent;
            this.mIndent = indent3;
            for (SmcAction action : actions) {
                action.accept(this);
            }
            this.mIndent = indent4;
        }
        if (this.mDebugLevel >= 0) {
            transName = transition.getName();
            parameters = transition.getParameters();
            indent3 = !this.mNoCatchFlag && !actions.isEmpty() ? indent2 + "    " : indent2;
            this.mTarget.print(indent3);
            this.mTarget.println("if (context.getDebugFlag())");
            this.mTarget.print(indent3);
            this.mTarget.println("{");
            if (this.mNoStreamsFlag) {
                this.mTarget.print(indent3);
                this.mTarget.print("    TRACE(\"EXIT TRANSITION : ");
                this.mTarget.print(stateName);
                this.mTarget.print("::");
                this.mTarget.print((String)transName);
                this.mTarget.print("(");
                pit = parameters.iterator();
                sep = "";
                while (pit.hasNext()) {
                    this.mTarget.print(sep);
                    pit.next().accept(this);
                    sep = ", ";
                }
                this.mTarget.println(")\\n\");");
            } else {
                this.mTarget.print(indent3);
                this.mTarget.print("    std::ostream& str = ");
                this.mTarget.println("context.getDebugStream();");
                this.mTarget.println();
                this.mTarget.print(indent3);
                this.mTarget.print("    str << \"EXIT TRANSITION : ");
                this.mTarget.print(stateName);
                this.mTarget.print("::");
                this.mTarget.print((String)transName);
                this.mTarget.print("(");
                pit = parameters.iterator();
                sep = "";
                while (pit.hasNext()) {
                    this.mTarget.print(sep);
                    pit.next().accept(this);
                    sep = ", ";
                }
                this.mTarget.println(")\"");
                this.mTarget.print(indent3);
                this.mTarget.println("        << std::endl;");
            }
            this.mTarget.print(indent3);
            this.mTarget.println("}");
            this.mTarget.println();
        }
        if (!(transType != SmcElement.TransType.TRANS_SET || actions.size() <= 0 && loopbackFlag)) {
            this.mTarget.print(indent3);
            this.mTarget.print("context.setState(");
            this.mTarget.print(fqEndStateName);
            this.mTarget.println(");");
        } else if (transType == SmcElement.TransType.TRANS_PUSH) {
            if (!loopbackFlag || actions.size() > 0) {
                this.mTarget.print(indent3);
                this.mTarget.print("context.setState(");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(");");
            }
            if (!loopbackFlag) {
                if (this.mDebugLevel >= 1) {
                    this.mTarget.println();
                    this.mTarget.print(indent3);
                    this.mTarget.println("if (context.getDebugFlag())");
                    this.mTarget.print(indent3);
                    this.mTarget.println("{");
                    if (this.mNoStreamsFlag) {
                        this.mTarget.print(indent3);
                        this.mTarget.print("    TRACE(\"BEFORE ENTRY    : ");
                        this.mTarget.print(fqEndStateName);
                        this.mTarget.println("::Entry(context)\\n\");");
                    } else {
                        this.mTarget.print(indent3);
                        this.mTarget.print("    std::ostream& str = ");
                        this.mTarget.println("context.getDebugStream();");
                        this.mTarget.println();
                        this.mTarget.print(indent3);
                        this.mTarget.print("    str << \"BEFORE ENTRY    : ");
                        this.mTarget.print(fqEndStateName);
                        this.mTarget.println("::Entry(context)\"");
                        this.mTarget.print(indent3);
                        this.mTarget.println("        << std::endl;");
                    }
                    this.mTarget.print(indent3);
                    this.mTarget.println("}");
                }
                this.mTarget.println();
                this.mTarget.print(indent3);
                this.mTarget.println("context.getState().Entry(context);");
                if (this.mDebugLevel >= 1) {
                    this.mTarget.println();
                    this.mTarget.print(indent3);
                    this.mTarget.println("if (context.getDebugFlag())");
                    this.mTarget.print(indent3);
                    this.mTarget.println("{");
                    if (this.mNoStreamsFlag) {
                        this.mTarget.print(indent3);
                        this.mTarget.print("    TRACE(\"AFTER ENTRY     : ");
                        this.mTarget.print(fqEndStateName);
                        this.mTarget.println("::Entry(context)\\n\");");
                    } else {
                        this.mTarget.print(indent3);
                        this.mTarget.print("    std::ostream& str = ");
                        this.mTarget.println("context.getDebugStream();");
                        this.mTarget.println();
                        this.mTarget.print(indent3);
                        this.mTarget.print("    str << \"AFTER ENTRY     : ");
                        this.mTarget.print(fqEndStateName);
                        this.mTarget.println("::Entry(context)\"");
                        this.mTarget.print(indent3);
                        this.mTarget.println("        << std::endl;");
                    }
                    this.mTarget.print(indent3);
                    this.mTarget.println("}");
                }
            }
            this.mTarget.print(indent3);
            this.mTarget.print("context.pushState(");
            this.mTarget.print(pushStateName);
            this.mTarget.println(");");
        } else if (transType == SmcElement.TransType.TRANS_POP) {
            this.mTarget.print(indent3);
            this.mTarget.println("context.popState();");
        }
        if (!actions.isEmpty() && !this.mNoCatchFlag) {
            this.mTarget.print(indent2);
            this.mTarget.println("}");
            this.mTarget.print(indent2);
            this.mTarget.println("catch (...)");
            this.mTarget.print(indent2);
            this.mTarget.println("{");
            if (transType == SmcElement.TransType.TRANS_SET) {
                this.mTarget.print(indent3);
                this.mTarget.print("context.setState(");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(");");
            } else if (transType == SmcElement.TransType.TRANS_PUSH) {
                this.mTarget.print(indent3);
                this.mTarget.print("context.setState(");
                this.mTarget.print(fqEndStateName);
                this.mTarget.println(");");
                if (!loopbackFlag) {
                    if (this.mDebugLevel >= 1) {
                        this.mTarget.println();
                        this.mTarget.print(indent3);
                        this.mTarget.println("if (context.getDebugFlag())");
                        this.mTarget.print(indent3);
                        this.mTarget.println("{");
                        if (this.mNoStreamsFlag) {
                            this.mTarget.print(indent3);
                            this.mTarget.print("    TRACE(\"BEFORE ENTRY    : ");
                            this.mTarget.print(fqEndStateName);
                            this.mTarget.println("::Entry(context)\\n\");");
                        } else {
                            this.mTarget.print(indent3);
                            this.mTarget.print("    std::ostream& str = ");
                            this.mTarget.println("context.getDebugStream();");
                            this.mTarget.println();
                            this.mTarget.print(indent2);
                            this.mTarget.print("    str << \"BEFORE ENTRY    : ");
                            this.mTarget.print(fqEndStateName);
                            this.mTarget.println("::Entry(context)\"");
                            this.mTarget.print(indent2);
                            this.mTarget.println("        << std::endl;");
                        }
                        this.mTarget.print(indent3);
                        this.mTarget.println("}");
                        this.mTarget.println();
                    }
                    this.mTarget.println();
                    this.mTarget.print(indent3);
                    this.mTarget.println("context.getState().Entry(context);");
                    if (this.mDebugLevel >= 1) {
                        this.mTarget.print(indent3);
                        this.mTarget.println("    if (context.getDebugFlag())");
                        this.mTarget.print(indent3);
                        this.mTarget.println("    {");
                        if (this.mNoStreamsFlag) {
                            this.mTarget.print(indent3);
                            this.mTarget.print("        TRACE(\"AFTER ENTRY     : ");
                            this.mTarget.print(fqEndStateName);
                            this.mTarget.println("::Entry(context)\\n\");");
                        } else {
                            this.mTarget.print(indent3);
                            this.mTarget.print("        std::ostream& str = ");
                            this.mTarget.println("context.getDebugStream();");
                            this.mTarget.println();
                            this.mTarget.print(indent2);
                            this.mTarget.print("        str << \"AFTER ENTRY     : ");
                            this.mTarget.print(fqEndStateName);
                            this.mTarget.println("::Entry(context)\"");
                            this.mTarget.print(indent2);
                            this.mTarget.println("            << std::endl;");
                        }
                        this.mTarget.print(indent3);
                        this.mTarget.println("    }");
                        this.mTarget.println();
                    }
                }
                this.mTarget.print(indent3);
                this.mTarget.print("context.pushState(");
                this.mTarget.print(pushStateName);
                this.mTarget.println(");");
            } else if (transType == SmcElement.TransType.TRANS_POP) {
                this.mTarget.print(indent3);
                this.mTarget.println("context.popState();");
            }
            if (!this.mNoExceptionFlag) {
                this.mTarget.print(indent3);
                this.mTarget.println("throw;");
                this.mTarget.print(indent2);
            }
            this.mTarget.println("}");
        }
        if (transType == SmcElement.TransType.TRANS_SET && !loopbackFlag || transType == SmcElement.TransType.TRANS_PUSH) {
            if (this.mDebugLevel >= 1) {
                this.mTarget.print(indent2);
                this.mTarget.println("if (context.getDebugFlag())");
                this.mTarget.print(indent2);
                this.mTarget.println("{");
                if (this.mNoStreamsFlag) {
                    this.mTarget.print(indent2);
                    this.mTarget.print("    TRACE(\"BEFORE ENTRY    : ");
                    this.mTarget.print(fqEndStateName);
                    this.mTarget.println("::Entry(context)\\n\");");
                } else {
                    this.mTarget.print(indent2);
                    this.mTarget.print("    std::ostream& str = ");
                    this.mTarget.println("context.getDebugStream();");
                    this.mTarget.println();
                    this.mTarget.print(indent2);
                    this.mTarget.print("    str << \"BEFORE ENTRY    : ");
                    this.mTarget.print(fqEndStateName);
                    this.mTarget.println("::Entry(context)\"");
                    this.mTarget.print(indent2);
                    this.mTarget.println("        << std::endl;");
                }
                this.mTarget.print(indent2);
                this.mTarget.println("}");
            }
            this.mTarget.print(indent2);
            this.mTarget.println("context.getState().Entry(context);");
            if (this.mDebugLevel >= 1) {
                this.mTarget.println();
                this.mTarget.print(indent2);
                this.mTarget.println("if (context.getDebugFlag())");
                this.mTarget.print(indent2);
                this.mTarget.println("{");
                if (this.mNoStreamsFlag) {
                    this.mTarget.print(indent2);
                    this.mTarget.print("    TRACE(\"AFTER ENTRY     : ");
                    this.mTarget.print(fqEndStateName);
                    this.mTarget.println("::Entry(context)\\n\");");
                } else {
                    this.mTarget.print(indent2);
                    this.mTarget.print("    std::ostream& str = ");
                    this.mTarget.println("context.getDebugStream();");
                    this.mTarget.println();
                    this.mTarget.print(indent2);
                    this.mTarget.print("    str << \"AFTER ENTRY     : ");
                    this.mTarget.print(fqEndStateName);
                    this.mTarget.println("::Entry(context)\"");
                    this.mTarget.print(indent2);
                    this.mTarget.println("        << std::endl;");
                }
                this.mTarget.print(indent2);
                this.mTarget.println("}");
                this.mTarget.println();
            }
        }
        if (transType == SmcElement.TransType.TRANS_POP && !endStateName.equals("nil") && endStateName.length() > 0) {
            String popArgs = guard.getPopArgs();
            this.mTarget.print(indent2);
            this.mTarget.print("context.");
            this.mTarget.print(endStateName);
            this.mTarget.print("(");
            if (popArgs.length() > 0) {
                this.mTarget.print(popArgs);
            }
            this.mTarget.println(");");
        }
        if (this.mGuardCount > 1) {
            this.mTarget.print(this.mIndent);
            this.mTarget.print("    }");
        }
    }

    @Override
    public void visit(SmcAction action) {
        String name = action.getName();
        this.mTarget.print(this.mIndent);
        if (action.isEmptyStateStack()) {
            this.mTarget.println("context.emptyStateStack();");
        } else {
            if (!action.isStatic()) {
                this.mTarget.print("ctxt.");
            }
            this.mTarget.print(name);
            this.mTarget.print('(');
            Iterator<String> it = action.getArguments().iterator();
            String sep = "";
            while (it.hasNext()) {
                this.mTarget.print(sep);
                this.mTarget.print(it.next());
                sep = ", ";
            }
            this.mTarget.println(");");
        }
    }

    @Override
    public void visit(SmcParameter parameter) {
        this.mTarget.print(parameter.getType());
        this.mTarget.print(" ");
        this.mTarget.print(parameter.getName());
    }
}

