/*
 * 名称：puyuetianUI前端框架 js驱动
 * 版本：4.4.1
 * 发布：2015-10-10
 * 更新：2023-05-07
 * 作者：蒲乐天
 * 官网：https://www.puyuetian.com
 */

var K = {
	// puyuetian.js版本
	version: '4.4.1.20230507',
	// puyuetian.js文件所在的路径
	basePath: '/',
	// 网站所在的根目录
	WWW_DIR: '/',
	// 上传文件默认的接口，该值可在初始化完成后更改
	uploadURL: '/general/upload',
	/**
	 * isset函数，类似php的isset
	 * @param {*} obj 待检测的对象
	 * @returns {boolean}
	 */
	isset(obj) {
		if (typeof (obj) == "undefined") {
			return false;
		}
		return true;
	},
	/**
	 * 返回可用的本地url地址
	 * @param {string} url 待处理的本站相对url地址
	 * @param {boolean} full 是否返回完整地址，包括域名
	 * @returns {string}
	 */
	URL(url, full = false) {
		url = (K.WWW_DIR + '/' + (url || '')).replace(/[\/]+/g, '/');
		if (full) {
			url = location.protocol + '//' + location.hostname + (location.port ? ':' + location.port : '') + url;
		}
		return url;
	},
	/**
	 * 语言转换方法
	 * @param {string} txt 待转换的字符串
	 * @returns {string}
	 */
	L(txt) {
		var l = K.language_dictionary || false;
		if (l) {
			for (var k in l) {
				if (K.in_array(txt, k, false, '|')) {
					return l[k];
				}
			}
		}
		return txt;
	},
	/**
	 * 加载js/css文件
	 * @param {string|object} urls 待加载的js/css文件地址
	 * @param {Function} success 加载成功后执行
	 * @returns {boolean}
	 */
	require(urls, success) {
		if (!urls) {
			console.log('K.require() urls参数不能为空');
			return false;
		}
		if (typeof (urls) == "string") {
			var _urls = urls.split(',');
			urls = {
				js: [],
				css: []
			};
			for (var i in _urls) {
				var suffixs = _urls[i].split('.'),
					suffix = suffixs[(suffixs.length - 1)];
				if (K.in_array(suffix, 'js,css')) {
					urls[suffix].push(_urls[i]);
				}
			}
			if (!urls['js'].length) {
				urls['js'] = false;
			}
			if (!urls['css'].length) {
				urls['css'] = false;
			}
		}
		if (!urls['js'] && !urls['css']) {
			return false;
		}
		var _success = function () {
			if (typeof (success) == "function") {
				setTimeout(function () {
					success();
				}, 0);
			}
		};
		var _init_js = function () {
			if (typeof (urls['js']) == "string") {
				urls['js'] = urls['js'].split(',');
			}
			var _n = 0;
			var _count = urls['js'].length;
			var _load_js = function () {
				var url = urls['js'][_n];
				var id = '_' + K.md5(url);
				$('head').append([
					'<script type="text/template" id="',
					id,
					'" src="',
					url,
					'"></script>'
				].join(''));
				$.getScript(url, function (r, s) {
					if (s != "success") {
						console.log('js加载失败：id:' + id + ',url:' + url);
					}
					_n++;
					if (_n >= _count) {
						_success();
					} else {
						_load_js();
					}
				});
			};
			_load_js();
		};
		// 加载css
		if (urls['css']) {
			if (typeof (urls['css']) == "string") {
				urls['css'] = urls['css'].split(',');
			}
			for (var _n = 0; _n < urls['css'].length; _n++) {
				var id = '_' + K.md5(urls['css'][_n]);
				if (!$('#' + id).length) {
					$('head').append([
						'<link id="',
						id,
						'" href="',
						urls['css'][_n],
						'" rel="stylesheet" />'
					].join(''));
				}
			}
		}
		// 加载js
		if (urls['js']) {
			_init_js();
		}
		return true;
	},
	/**
	 * 加载js/css文件，仅加载一次
	 * @param {string|object} urls 待加载的js/css文件地址
	 * @param {Function} success 加载成功后执行
	 * @param {object} obj 该js携带的对象，用来判断是否加载过
	 * @returns {boolean}
	 */
	require_once(urls, success, obj) {
		if (typeof (urls) == "string") {
			urls = urls.split(',');
		}
		if (typeof (obj) != "undefined") {
			console.log('对象存在已忽略加载：urls:' + urls.join(','));
			if (typeof (success) == "function") {
				success();
			}
			return true;
		}
		var _urls = [];
		for (var i = 0; i < urls.length; i++) {
			var url = urls[i];
			var id = '_' + K.md5(url);
			if (!$('#' + id).length) {
				_urls.push(url);
			} else {
				console.log('js/css已忽略加载：id:' + id + ',url:' + url);
				if ($('#' + id)[0].tagName.toLowerCase() == 'script' && typeof (success) == "function") {
					setTimeout(function () {
						success();
					}, 0);
				}
			}
		}
		if (!_urls.length) {
			return false;
		}
		urls = _urls.join(',');
		K.require(urls, success);
		return true;
	},
	/**
	 * trim方法，去掉字符两边的空格或其他字符
	 * K.trim(s str, s space, (l|r) alr)
	 * @param {string} str 待处理的字符串
	 * @param {string} space 待被替换的字符，默认为空格
	 * @param {string} alr l仅处理左边，r仅处理右边，默认两边都处理
	 * @returns {string}
	 */
	trim(str, space = ' ', alr = '') {
		if (!str || !space) {
			return str || '';
		}
		str += '';
		space += '';
		// 该函数可以循环去除指定字符
		var a = function (str) {
			var len = space.length;
			if (!alr || alr == 'l') {
				if (str.substr(0, len) == space) {
					str = str.substr(len);
					str = a(str);
				}
			}
			if (!alr || alr == 'r') {
				if (str.substr(str.length - len) == space) {
					str = str.substr(0, str.length - len);
					str = a(str);
				}
			}
			return str;
		};
		return a(str);
	},
	/**
	 * 类似PHP ltrim函数
	 * @param {string} str 待处理字符串
	 * @param {string} space 待被替换的字符，默认为空格
	 * @returns {string}
	 */
	ltrim(str, space = ' ') {
		return K.trim(str, space, 'l');
	},
	/**
	 * 类似PHP rtrim函数
	 * @param {string} str 待处理字符串
	 * @param {string} space 待被替换的字符，默认为空格
	 * @returns {string}
	 */
	rtrim(str, space = ' ') {
		return K.trim(str, space, 'r');
	},
	/**
	 * 数组去重
	 * @param {object} array 待去重数组
	 * @returns {object}
	 */
	array_unique(array) {
		if (typeof (array) != "object") {
			return [];
		}
		var temp = [];
		for (var i = 0; i < array.length; i++) {
			if (temp.indexOf(array[i]) == -1) {
				temp.push(array[i]);
			}
		}
		return temp;
	},
	/**
	 * 获取url参数函数，类似PHP $_GET变量
	 * K._get(s $paramname, b $decode, s url):s
	 * @param {String} $paramname 待获取的参数名称
	 * @param {Boolean} $decode 是否解码url，防止中文乱码，默认解码
	 * @param {String} $url 待被处理url，默认为当前url
	 * @returns {*}
	 */
	_get($paramname, $decode = true, $url = '') {
		var $a, $i, $param = {};
		if (!$url) {
			$url = location.search;
		}
		var $spos = $url.indexOf('?');
		if ($spos == -1 || ($spos + 1) == $url.length) {
			return $paramname ? null : {};
		}
		var $params = $url.substring($spos + 1, $url.length).split('&');
		for ($i = 0; $i < $params.length; $i++) {
			$a = $params[$i].split('=');
			if ($a.length == 2) {
				$param[$a[0]] = $decode ? decodeURIComponent($a[1]) : $a[1];
			}
		}
		if ($paramname) {
			return $param[$paramname] || null;
		}
		return $param;
	},
	/**
	 * 计算字符串，数组，或者对象的长度
	 * @param {*} obj 待处理的对象
	 * @returns {Number}
	 */
	count(obj) {
		return K.length(obj);
	},
	/**
	 * 同K.count()
	 * 计算字符串，数组，或者对象的长度
	 * @param {*} obj 待处理的对象
	 * @returns {number}
	 */
	length(obj) {
		if (typeof (obj) == "string" || typeof (obj) == "number") {
			obj = obj.toString();
			return obj.length;
		}
		if (typeof (obj) == "object") {
			var i = 0;
			for (var k in obj) {
				i++;
			}
			return i;
		}
		return 0;
	},
	/**
	 * 获取当前系统的时间戳,秒
	 * @param {*} date 为时间因子（Y-m-d H:i:s），将该日期时间转化为时间戳，默认为当前时间
	 * @returns {Number}
	 */
	time(date = null) {
		if (date) {
			date = new Date(date);
		} else {
			date = new Date();
		}
		return Date.parse(date) / 1000;
	},
	/**
	 * 将时间戳格式化为日期时间格式
	 * @param {String} format 格式，默认Y-m-d H:i:s
	 * @param {number} time 基于这个时间戳来格式化
	 * @returns {string}
	 */
	date(format = 'Y-m-d H:i:s', time = 0) {
		if (!time) {
			time = K.time();
		}
		var $date = new Date(time * 1000),
			$y = $date.getFullYear(),
			$m = $date.getMonth() + 1,
			$d = $date.getDate(),
			$h = $date.getHours(),
			$i = $date.getMinutes(),
			$s = $date.getSeconds(),
			format2 = '',
			y = $y.toString(),
			m = $m.toString(),
			d = $d.toString(),
			h = $h.toString(),
			i = $i.toString(),
			s = $s.toString();
		if ($m < 10) {
			m = '0' + $m;
		}
		if ($d < 10) {
			d = '0' + $d;
		}
		if ($h < 10) {
			h = '0' + $h;
		}
		if ($i < 10) {
			i = '0' + $i;
		}
		if ($s < 10) {
			s = '0' + $s;
		}
		format2 = format.replace(/Y/ig, y);
		format2 = format2.replace(/m/ig, m);
		format2 = format2.replace(/d/ig, d);
		format2 = format2.replace(/H/ig, h);
		format2 = format2.replace(/i/ig, i);
		format2 = format2.replace(/s/ig, s);
		return format2;
	},
	/**
	 * 截取指定字符串，替代将被弃用的substr
	 * @param {string} string 待处理的字符串
	 * @param {number} start 截取开始位置
	 * @param {number} length 截取长度
	 * @returns {string}
	 */
	substr(string, start = 0, length = 0) {
		string = string.toString();
		if (start < 0) {
			start = string.length + start;
		}
		var end = string.length;
		if (length > 0) {
			end += start;
		}
		return string.substring(start, end);
	},
	/**
	 * 去除html标签，类似php strip_tags函数
	 * @param {string} str 待处理的字符串
	 * @param {string} marks 需要被保留的标签，举例<p><b>或p,b
	 * @returns {string}
	 */
	strip_tags(str = '', marks = '') {
		str = str.toString();
		if (marks) {
			var marks_array = [];
			if (marks.indexOf('<') > -1) {
				marks_array = marks.substring(1, marks.length - 1).split('><');
			} else {
				marks_array = marks.split(',');
			}
			marks = '';
			for (var i in marks_array) {
				marks += '|' + marks_array[i] + ' |' + marks_array[i] + '>';
				marks += '|/' + marks_array[i] + ' |/' + marks_array[i] + '>';
			}
			marks = marks.substring(1);
		}
		var regex = '<' + (marks ? '(?!' + marks + ')' : '') + '[\\W\\w]+?>';
		return str.replace(new RegExp(regex, 'ig'), '');
	},
	/**
	 * 替换字符串函数，类似php str_replace函数
	 * @param {string|object} search 搜索的字符串 数组或字符串类型
	 * @param {string|object} replace 要被替换成的字符串 数组或字符串类型，数组时若无法与search对应完整，空缺部分将会被替换为空字符串
	 * @param {string} subject 被搜索替换的字符串
	 * @returns {string}
	 */
	str_replace(search, replace, subject) {
		if (!K.in_array(typeof (subject), 'string,number')) {
			subject = '';
		}
		subject = subject.toString();
		if (K.in_array(typeof (search), 'string,number')) {
			search = search.toString();
			search = [search];
		}
		if (K.in_array(typeof (replace), 'string,number')) {
			replace = replace.toString();
		}
		for (var i = 0; i < search.length; i++) {
			if (search[i] === null || replace === null) {
				continue;
			}
			var new_str = replace;
			if (typeof (new_str) == "object") {
				if (new_str[i] === null) {
					continue;
				}
				new_str = typeof (new_str[i]) != "undefined" ? (new_str[i] + '') : '';
			}
			var strs = '\\$()*+.[]?^{}|';
			for (var j = 0; j < strs.length; j++) {
				search[i] = search[i].replace(new RegExp('\\' + strs[j], 'g'), '\\' + strs[j]);
			}
			subject = subject.replace(new RegExp(search[i], 'g'), new_str);
		}
		return subject;
	},
	/**
	 * html转为字符串或字符串转为html
	 * @param {string} str 待处理的字符串
	 * @param {boolean} encode true为html转为字符串，false为字符串转为html
	 * @returns {string}
	 */
	htmlspecialchars(str, encode = true) {
		var html = ['&', '<', '>', '"'],
			html2 = ['&amp;', '&lt;', '&gt;', '&quot;'];
		if (!encode) {
			var tmp = html;
			html = html2;
			html2 = tmp;
		}
		return K.str_replace(html, html2, str);
	},
	/**
	 * 获取json字符串数据或对象数据，可以设置相应的值
	 * @param {string|object} $data 待处理的JSON字符串或对象
	 * @param {string|null} $key 待获取或设置的键名，若无$value则为获取
	 * @param {*} $value 待设置的键值
	 * @returns {object}
	 */
	json_data($data, $key = null, $value = null) {
		if (typeof ($data) != "object") {
			$data = JSON.parse($data);
		}
		if ($key === null) {
			return $data;
		}
		var $keys = $key.split('.'),
			$_d = $data,
			$str = '';
		for (var $k in $keys) {
			var $v = $keys[$k];
			$str += '[\'' + $v + '\']';
			if (!$_d[$v]) {
				if ($value === null) {
					// 要获取的值为空
					return null;
				}
				$_d[$v] = [];
				eval('$data' + $str + '=[];');
			}
			$_d = $_d[$v];
		}
		// 获取key值
		if ($value === null) {
			return $_d;
		}
		// 设置key值
		eval('$data' + $str + '=$value;');
		return $data;
	},
	/**
	 * 选择select选择框,适用于初始赋值
	 * @param {string|object} selector 待初始化的对象或选择器字符串
	 * @returns {boolean} true
	 */
	select_selected(selector) {
		if (!selector) {
			selector = 'body';
		}
		//select选择
		var selects = $(selector).find('select[data-value]');
		for (var i = 0; i < selects.length; i++) {
			var o = $(selects[i]);
			o.find('option[value="' + o.data('value') + '"]').prop('selected', true);
		}
		return true;
	},
	/**
	 * 美化控件方法
	 * @param {string|object} selector 待美化的对象或选择器字符串
	 * @returns {boolean}
	 */
	input_beautify(selector) {
		var o = selector;
		if (!o) {
			o = 'body';
		}
		o = $(o);
		K.select_selected(o);
		K.input2checkboxs(o.find('._input_checkboxs'), {
			hidden: 1
		});
		K.input2checkbox(o.find('._input_checkbox'));
		K.input2password(o.find('._input_password'), {
			maxlength: 16,
			minlength: 5,
			title: K.L('密码为5-16位,留空或格式非法为不修改')
		});
		K.input2json(o.find('._input_json'));
		K.select2toggle(o.find('._input_toggle'));
		K.input2label(o.find('._input_label'));
		K.input2datetime(o.find('._input_time'));
		K.input2datetime(o.find('._input_datetime'), {
			return_time: 0
		});
		K.input2number(o.find('._input_number'));
		K.codemirror(o.find('textarea._input_code'));
		K.editor.init(o.find('textarea._input_editor'));
		return true;
	},
	/**
	 * form数据转为字符串类型
	 * @param {string|object} selector form对象或字符串标识
	 * @returns {string}
	 */
	formdata2string(selector) {
		var formdata = K.formdata2array(selector),
			formstring = '';
		for (var name in formdata) {
			formstring += '&' + name + '=' + encodeURIComponent(formdata[name]);
		}
		return K.trim(formstring, '&');
	},
	/**
	 * form数据转为对象
	 * @param {string|object} selector form对象或字符串标识
	 * @returns {object}
	 */
	formdata2array(selector) {
		var forminputs = $(selector).find(' :input'),
			formarray = {};
		for (var i = 0; i < forminputs.length; i++) {
			var obj = $(forminputs[i]),
				name = obj.attr('name') || '',
				type = obj.attr('type') || '';
			if (!name) {
				continue;
			}
			if (['checkbox', 'radio'].indexOf(type) > -1 && !obj.prop('checked')) {
				continue;
			}
			var value = obj.val() || '';
			if (typeof (formarray[name]) != "undefined") {
				value = K.trim((formarray[name] + ',' + value).replace(/[\,]+/g, ','), ',');
			}
			formarray[name] = value;
		}
		return formarray;
	},
	/**
	 * 设置列表生成HTML
	 * @param {object} data [{"name":"","title":"","content":"","type":"","value":"","attr":"","checked":false,"data":""},]
	 * name		为input控件name
	 * title	为设置名称
	 * content	为设置详细说明
	 * type		为控件类型：text,number,email,label,password,checkbox,checkboxs,textarea,code,nav,json,editor,switch,toggle,upload,uploads,time,datetime,自定义的html包含{$name}{$value}变量
	 * value	为控件初始值
	 * attr		自定义的标签属性例如：class=""
	 * checked	若为checkbox则有效
	 * data		若为checkbox则有效
	 * @returns {string}
	 */
	return_set_html(data) {
		// 生成编辑数据
		var html = '<div class="pk-row">';
		for (var i in data) {
			var name = data[i]['name'],
				title = data[i]['title'],
				content = data[i]['content'] || '',
				type = data[i]['type'],
				attr = data[i]['attr'],
				value = K.htmlspecialchars(data[i]['value'] || ''),
				checked = data[i]['checked'] || false,
				checkboxs_data = data[i]['data'] || '';
			if (typeof (checkboxs_data) == "object") {
				checkboxs_data = JSON.stringify(checkboxs_data);
			}
			if (name == 'id') {
				html += '<input type="hidden" name="id" value="' + K.cnum(value) + '" />';
				continue;
			}
			if (type == 'hidden') {
				html += '<input type="hidden" name="' + name + '" value="' + value + '" />';
				continue;
			}
			html += [
				'<div class="pk-row pk-margin-bottom-15" data-name="',
				name,
				'">',
				'<div class="pk-w-sm-12 _title" style="font-size:14px;padding-bottom:5px;color:#777',
				K.in_array(type, 'checkbox,checkboxs') ? ';border-bottom:solid 1px #eee;margin-bottom:10px' : '',
				'">',
				title
			].join('');
			if (content) {
				html += [
					'<i style="cursor:pointer;font-style:normal;font-size:12px;display:inline-block;width:16px;height:16px;border-radius:16px;text-align:center;line-height:16px;color:#fff;background:#0e90d2;margin-left:7px" data-content="',
					K.htmlspecialchars(content),
					'" onclick="',
					'K.alert(\'<div class=pk-text-sm>\'+$(this).data(\'content\')+\'</div>\',0)',
					'">?</i>'
				].join('');
			}
			html += '</div><div class="pk-w-sm-12 _content">';
			if (K.in_array(type, 'text,number,email,label,password,checkbox,checkboxs')) {
				html += [
					'<input type="',
					K.in_array(type, 'number,email,checkbox') ? type : 'text',
					'" name="',
					name,
					'" class="pk-textbox _input_',
					type,
					'" value="',
					type == 'number' ? K.cnum(value) : value,
					'"',
					type == 'checkbox' ? (checked ? ' checked' : '') : ' autocomplete="off"',
					type == 'checkboxs' ? ' data-data="' + K.htmlspecialchars(checkboxs_data) + '"' : '',
					' ',
					attr || '',
					'/>'
				].join('');
			} else if (K.in_array(type, 'textarea,code,nav,json,editor')) {
				html += [
					'<textarea class="pk-textarea _input_',
					type,
					'" name="',
					name,
					'" ',
					attr || 'rows="9"',
					'>',
					value,
					'</textarea>'
				].join('');
			} else if (K.in_array(type, 'switch,toggle')) {
				html += [
					'<select class="pk-textbox _input_toggle" name="',
					name,
					'" data-value="',
					value,
					'" ',
					attr || '',
					'><option value="0"',
					value == "0" ? ' selected' : '',
					'>关闭</option><option value="1"',
					value == "1" ? ' selected' : '',
					'>开启</option></select>'
				].join('');
			} else if (K.in_array(type, 'upload,uploads')) {
				var _id = '_' + K.random_string();
				html += [
					'<input id="',
					_id,
					'" type="text" name="',
					name,
					'" class="pk-textbox _input_',
					type,
					'" value="',
					value,
					'" ',
					attr || 'autocomplete="off"',
					'><span style="height:38px;line-height:38px;top:0;right:0;padding:0 10px;position:absolute;font-size:14px">'
				].join('');
				if (type == 'upload') {
					html += [
						'<a href="javascript:;" class="pk-text-primary pk-hover-underline" onclick="',
						'var url=$(this).parent().prev(\'input\').val()||false;url&&K.iframe(url,url)',
						'" style="margin-right:5px;background:white;padding:0 5px">',
						K.L('预览'),
						'</a>'
					].join('');
				}
				var accept = '';
				if (attr) {
					accept = $('<div><div ' + attr + '></div></div>').find('div').attr('accept') || "";
				}
				html += [
					'<a href="javascript:;" class="pk-text-primary pk-hover-underline" onclick="',
					'var input=$(this).parent().prev(\'input\');K.upload({',
					(type == 'upload' ? 'return_object:input' : 'multiple:1,success:function(r){if(!r[\'code\']){K.alert(r[\'msg\'],2);return false}r=r[\'data\'];for(var i in r){if(!r[i][\'code\']){K.alert(\'No.\'+(i+1)+\':\'+r[i][\'msg\'],2);continue}var path=r[i][\'data\'][\'filepath\'];$(\'#' + _id + '\').val(K.trim($(\'#' + _id + '\').val()+\',\'+path,\',\')).change()}}'),
					',accept:\'' + accept + '\'})" style="background:white;padding:0 5px">',
					K.L('上传'),
					'</a></span>'
				].join('');
				if (type == 'uploads') {
					html += '<div id="' + _id + '_div" class="pk-row"></div>';
					// 绑定多文件事件
					setTimeout(function () {
						$('#' + _id).on('input propertychange change', function () {
							var me = $(this),
								v = me.val() || '';
							v = v.toString();
							if (!v) {
								return false;
							}
							var vs = v.split(',');
							$('#' + _id + '_div').html('');
							for (var i = 0; i < vs.length; i++) {
								var path = vs[i],
									a = path.split('/'),
									filename = a[a.length - 1],
									image = filename.split('.'),
									isimg = K.in_arrays(image[image.length - 1], 'jpg,jpeg,bmp,png,gif');
								$('#' + _id + '_div').append([
									'<div class="pk-w-md-3 pk-w-sm-6" style="padding:5px">',
									'<a class="pk-hover-underline" href="javascript:;" onclick="',
									isimg ? "K.iframe('" + path + "','" + path + "')" : "window.open('" + path + "','_blank')",
									'">',
									isimg ? '<img src="' + path + '" style="width:100%;height:150px" />' : filename,
									'</a>',
									'<p class="pk-text-danger pk-text-center pk-text-sm">',
									'<a class="_del" href="javascript:;" data-url="',
									path,
									'">',
									K.L('删除'),
									'</a>',
									'</p>',
									'</div>'
								].join('')).find('>div:last a._del').on('click', function () {
									var val = me.val() || '';
									val = val.toString();
									val = val.replace($(this).data('url'), '');
									val = K.trim(val.replace(/[\,]+/g, ','), ',');
									me.val(val);
									$(this).parent().parent().remove();
								});
							}
						}).trigger('change');
					}, 1000);
				}
			} else if (K.in_array(type, 'time,datetime')) {
				html += [
					'<input type="text" name="',
					name,
					'" class="pk-textbox _input_',
					type,
					'" value="',
					value,
					'" autocomplete="off" readonly />'
				].join('');
			} else {
				html += K.str_replace(["{$name}", "{$value}"], [name, value], type);
			}
			html += '</div>';
			html += '</div>';
		}
		html += '</div>';
		return html;
	},
	/**
	 * 设置DOM生成
	 * @param {object} params {selector:$(o),data:[{"name":"","title":"","content":"","type":"","value":"","attr":"","checked":false,"data":"",required:false},],submit:提交url或function(formdata,object),complete:(object),submit_text:"保存"}
	 * @returns {object}
	 */
	create_form(params) {
		var obj = $(params['selector']);
		if (!obj.length) {
			return false;
		}
		obj.html(K.return_set_html(params['data']));
		if (params['submit']) {
			obj.find('>div:eq(0)').append([
				'<div class="pk-row">',
				'<div class="pk-w-sm-12">',
				'<button type="button" class="pk-btn pk-btn-primary submit-btn">',
				params['submit_text'] ? params['submit_text'] : K.L('保存'),
				'</button>',
				'</div>',
				'</div>'
			].join(''));
			if (typeof (params['submit']) == "function") {
				obj.find('button:last').on('click', function () {
					params['submit'](K.formdata2array(obj), obj);
				});
			} else {
				obj.find('button:last').on('click', function () {
					var formdata = K.formdata2array(obj);
					for (var name in params['data']) {
						if ((params['data'][name]['required'] === true || K.cnum(params['data'][name]['required'])) && formdata[params['data'][name]['name']] === "") {
							K.msg(params['data'][name]['title'] + K.L('必填'), 0);
							return false;
						}
					}
					$.post(params['submit'], formdata, function (rd) {
						if (!rd['code']) {
							K.alert(rd['msg'], 2);
							return false;
						}
						K.msg(rd['msg'], 1);
					});
				});
			}
		}
		if (typeof (params['complete']) == "function") {
			params['complete'](obj);
		}
		K.input_beautify(obj);
		return obj;
	},
	/**
	 * 设置窗口弹出
	 * @param {object} params  {data:[{"name":"","title":"","content":"","type":"","value":"","required":true},],title:"",submit:提交url或function(formdata,object),complete:(object),submit_ok:function(){//提交成功后执行}}
	 * @returns {number|false}
	 */
	setup_window(params) {
		return K.P({
			type: 0,
			title: params['title'] || K.L('设置页'),
			content: K.return_set_html(params['data']),
			area: K.is_small_screen() ? ['100%', '100%'] : ['720px', '80%'],
			noclose: typeof (params['noclose']) == "undefined" ? 1 : params['noclose'],
			submit: function (_id, _v, o) {
				var formdata = K.formdata2array(o.find('.pk-popup-body'));
				for (var name in params['data']) {
					if ((params['data'][name]['required'] === true || K.cnum(params['data'][name]['required'])) && formdata[params['data'][name]['name']] === "") {
						K.msg(params['data'][name]['title'] + K.L('必填'), 0);
						return false;
					}
				}
				if (typeof (params['submit']) == "function") {
					params['submit'](formdata, o);
					return true;
				}
				$.post(params['submit'] || '', formdata, function (rd) {
					if (!rd['code']) {
						K.alert(rd['msg'], 2);
						return false;
					}
					if (typeof (params['noclose']) == "undefined") {
						K.close(_id);
					}
					K.msg(rd['msg'], 1);
					if (typeof (params['submit_ok']) == "function") {
						params['submit_ok'](formdata, o);
					}
				}, 'json');
			},
			complete: function (_id, o) {
				K.input_beautify(o);
				o.find('.pk-popup-submit').html(K.L('保存'));
				if (typeof (params['complete']) == "function") {
					params['complete'](o);
					return true;
				}
			}
		});
	},
	/**
	 * 生成随机字符串
	 * @param {string|number} length 长度，默认7位
	 * @param {string} chars 随机因子，默认字母及数字
	 * @returns {string}
	 */
	random_string(length = 7, chars = '') {
		chars = chars.toString() || '';
		if (chars === '') {
			chars = 'qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM0123456789';
		}
		length = parseInt(length + '') || 7;
		var $chars = chars,
			maxPos = $chars.length,
			pwd = '';
		for (var i = 0; i < length; i++) {
			pwd += $chars.charAt(Math.floor(Math.random() * maxPos));
		}
		return pwd;
	},
	/**
	 * cookie相关，设置及获取
	 * @param {string} name 获取或设置的键名
	 * @param {*} value 设置的键值若为null则为获取
	 * @param {number} exptime 设置的cookie多少秒后过期，默认一天
	 * @returns {*}
	 */
	cookie(name, value = null, exptime = 86400) {
		// 获取
		if (name && value == null) {
			var arr = null,
				reg = new RegExp("(^| )" + name + "=([^;]*)(;|$)");
			if (arr = document.cookie.match(reg)) {
				return decodeURIComponent(arr[2]);
			}
			return null;
		}
		// 设置
		exptime = (parseInt(exptime + '') || 0) * 1000;
		var exp = new Date();
		exp.setTime(exp.getTime() + exptime);
		document.cookie = name + "=" + encodeURIComponent(value) + ";expires=" + exp.toUTCString();
		return true;
	},
	/**
	 * 强制转化为数字类型
	 * @param {*} str 待处理的字符串或数字
	 * @param {*} r 不合法时返回的值
	 * @param {boolean} isint 是否强制为整数
	 * @param {number|null|false} min 最小值
	 * @param {number|null|false} max 最大值
	 * @param {boolean} minormax 小于最小值时返回最小值，大于最大值时返回最大值
	 * @returns {*}
	 */
	cnum(str, r = 0, isint = true, min = null, max = null, minormax = false) {
		str = (isint ? parseInt(str) : parseFloat(str));
		if (!str && str !== 0) {
			str = r;
		}
		if ((min !== null && min !== false) && str < min) {
			str = minormax ? min : r;
		}
		if ((max !== null && max !== false) && str > max) {
			str = minormax ? max : r;
		}
		return str;
	},
	/**
	 * 查看字符串是否在数组或字符串里，in_array的别称
	 * @param {string} needle 搜索的字符串
	 * @param {string|object} haystack 被搜索的字符串或数组
	 * @param {boolean} allin true时needle所有的值都在才会返回true，反之只要1个值在返回true
	 * @param {string} delimiter 如果被搜索的对象是字符串用什么来分割，默认,，如果为空则不分割整体被搜索
	 * @returns {boolean}
	 */
	in_arrays(needle, haystack, allin = true, delimiter = ',') {
		return K.in_array(needle, haystack, allin, delimiter);
	},
	/**
	 * 查看字符串是否在数组或字符串里
	 * @param {string|object} needle 搜索的字符串或数组
	 * @param {string|object} haystack 被搜索的字符串或数组
	 * @param {boolean} allin true时needle所有的值都在才会返回true，反之只要1个值在返回true
	 * @param {string} delimiter 如果被搜索的对象是字符串用什么来分割，默认,，如果为空则不分割整体被搜索
	 * @returns {boolean}
	 */
	in_array(needle, haystack, allin = true, delimiter = ',') {
		if (typeof (needle) == "undefined" || typeof (haystack) == "undefined") {
			return false;
		}
		if (['string', 'number'].indexOf(typeof (needle)) > -1) {
			needle += '';
			if (delimiter) {
				needle = needle.split(delimiter);
			} else {
				needle = [needle];
			}
		} else {
			for (var i in needle) {
				needle[i] += '';
			}
		}
		if (['string', 'number'].indexOf(typeof (haystack)) > -1) {
			haystack += '';
			if (delimiter) {
				haystack = haystack.split(delimiter);
			} else {
				haystack = [haystack];
			}
		} else {
			for (var i in haystack) {
				haystack[i] += '';
			}
		}
		for (var k in needle) {
			if (haystack.indexOf(needle[k]) > -1) {
				if (!allin) {
					return true;
				}
			} else {
				if (allin) {
					return false;
				}
			}
		}
		if (allin) {
			return true;
		}
		return false;
	},
	/**
	 * 将图片处理对象或图片转化为base64
	 * 该方法为异步方法
	 * @param {object} data {object,width,height,success,fail}
	 * object 为img图片地址（不支持跨域）或img对象或input对象
	 * width和height为处理后图片的宽度及高度，如果不设置或只设置一项将会自动调整
	 * success和error为函数对象，success(v){}成功转换，v为该图片的base64值，error(e){}转换失败，e为错误对象
	 * @returns {boolean}
	 */
	image2base64_asyn(data) {
		if (typeof (data['object']) == "undefined") {
			// 自行选文件
			$('body').append('<input class="pk-hide" type="file" accept="image/*">').find('input[type="file"]:last').on('change', function () {
				data['object'] = this;
				K.image2base64(data);
				$(this).remove();
			}).trigger('click');
			return false;
		}
		var source_object = data['object'],
			width = data['width'] || null,
			height = data['height'] || null,
			success = data['success'] || null,
			error = data['error'] || null,
			_id = '_' + K.random_string();
		$('body').append('<div id="' + _id + '"><img><canvas></canvas></div>');
		var _div = $('#' + _id);
		var _img = _div.find('img');
		if (typeof (source_object) == "string") {
			_img.attr('src', source_object);
		} else {
			if (($(source_object)[0].tagName || '').toLowerCase() == 'img') {
				_img.attr('src', $(source_object).attr('src') || '');
			} else {
				_img.attr('src', K.createObjectURL(source_object));
			}
		}
		var _do = function (imgobj) {
			var _canvas = _div.find('canvas'),
				_canvas_context = _canvas[0].getContext('2d'),
				_old_width = imgobj.width(),
				_old_height = imgobj.height();
			if (width || height) {
				// 以高度来自适应宽度
				if (!width) {
					width = height / _old_height * _old_width;
				}
				if (!height) {
					height = width / _old_width * _old_height;
				}
			} else {
				width = _old_width;
				height = _old_height;
			}
			_canvas.attr({
				width,
				height
			});
			if (!_canvas_context) {
				return '';
			}
			_canvas_context.drawImage(imgobj[0], 0, 0, width, height);
			return _canvas[0].toDataURL('image/png');
		};
		_img.on({
			load: function () {
				var base64 = _do(_img);
				//console.log(base64);
				//调用成功函数
				if (typeof (success) == "function") {
					success(base64);
				}
				_div.remove();
			},
			error: function (e) {
				//调用失败函数
				if (typeof (error) == "function") {
					error(e);
				}
				console.log(e);
				_div.remove();
			}
		});
		return true;
	},
	/**
	 * 创建当前对象的url本地地址
	 * @param {*} source_object input对象或选择器字符串
	 */
	createObjectURL(source_object) {
		var url = window.URL || window.webkitURL;
		return url.createObjectURL($(source_object)[0].files[0]) || '';
	},
	/**
	 * 表格对象存储对象
	 */
	_table: {},
	/**
	 * 表格生成方法，api数据的显示
	 * @param {object} data {elem,data,id,cols,tool,tool_on,checkbox,page,where,order,success,complete,fail}
	 * {
	 * elem/selector:selector|false, // 表格生成的对象，将会替换该表格，若为空则弹窗展示表格
	 * area:[width,height,top,right,bottom,left]|false, // 仅弹窗模式有效
	 * title:string|false, // 仅弹窗模式有效
	 * data:[{field:value},]|string, // 数据或api接口地址，api返回格式：{code:1,msg:"",data:{list:[{field:value},],count:1}} count为数据总数，若count为空则仅显示页数不显示总页数
	 * id:string|false, // 该表格的id参数值，默认随机生成
	 * cols:[{field:"",width:0,align:"",title:"",rowspan:1,colspan:1,class:"",style:"",format:function(v,row)},],
	 * tool:string|selector, // 是否显示工具栏,html对象或html,工具栏的样式可以在tool的对象上设置，可以使用${键名}来显示当前数据行相应的值，参数：class,style,th_class,th_style,td_class,td_style
	 * tool_on:object|function, // 工具栏事件绑定，类似jq.on()，若不指定事件方法默认为click
	 * checkbox:false, // 是否显示多选框，默认不显示
	 * page:{page:1,limit:10}, // 是否分页,仅在api接口模式下有效
	 * where:{"id":["=","1"]}, // 检索因子,仅api接口模式下有效
	 * order:'id desc' // 排序规则，仅api接口模式下有效
	 * success:function(tableDom,list,data) // 表格完全加载成功后执行，已写入数据
	 * complete:function(tableDom,data) // 表格初始化完成后执行，未写入数据
	 * fail:function(tableDom,msg,data) // 表格加载出错执行
	 * }
	 * @returns {object|false}
	 */
	table(data) {
		if (!data) {
			return false;
		}
		if (data.selector) {
			data.elem = data.selector;
		}
		if (!data.elem) {
			// 弹窗展示表格
			return K.P({
				type: 0,
				area: data.area || (K.is_small_screen() ? ['100%', '100%'] : ['50%', '70%']),
				title: data.title || K.L('表格'),
				content: '<div class="_table"></div>',
				complete(id, o) {
					data.elem = o.find('._table');
					K._table[id] = K.table(data);
				}
			});
		}
		data.data = data.data || [];
		data.where = data.where || {};
		data.order = data.order || '';
		data.tool_on = data.tool_event || (data.tool_on || false);
		if (typeof (data.tool_on) == "function") {
			data.tool_on = {
				click: data.tool_on
			};
		}
		if (data.nocheckbox) {
			data.checkbox = false;
		}
		if (typeof (data.checkbox) == "undefined") {
			data.checkbox = false;
		}
		var o = $(data.elem);
		if (o.hasClass('pk-autotable')) {
			// 是否有fail方法
			if (typeof (data.fail) == "function") {
				data.fail(o, K.L('已初始化过'), data);
			}
			return false;
		}
		var id = data.id || '_' + K.random_string(7),
			html = '<table id="' + id + '" class="pk-table pk-table-bordered">',
			fields = [];
		if (data.cols) {
			html += '<thead><tr>';
			if (data.checkbox) {
				html += [
					'<th style="width:50px;text-align:center">',
					'<input type="checkbox" name="select_checkbox_all" ',
					'onchange="$(this).parents(\'table\').find(\'tbody input[data-table_checkbox]\').prop(\'checked\',$(this).prop(\'checked\'))"></th>'
				].join('');
			}
			for (var col in data.cols) {
				var th = data.cols[col];
				if (!th.field) {
					continue;
				}
				fields.push({
					field: th.field
				});
				html += [
					'<th data-field="',
					th.field,
					'" rowspan="',
					th.rowspan || 1,
					'" colspan="',
					th.colspan || 1,
					'" style="',
					th.width ? 'width:' + th.width + 'px;' : '',
					th.align ? 'text-align:' + th.align + ';' : '',
					'">',
					th.title || '',
					'</th>'
				].join('');
			}
			if (data.tool) {
				var tool_o = $(data.tool),
					tool_class = tool_o.attr('class') || '',
					tool_style = tool_o.attr('style') || '',
					tool_width = tool_o.attr('width') || false,
					tool_align = tool_o.attr('align') || false,
					tool_th_class = tool_o.attr('th_class') || '',
					tool_td_class = tool_o.attr('td_class') || '',
					tool_th_style = tool_o.attr('th_style') || '',
					tool_td_style = tool_o.attr('td_style') || '';
				if (tool_width) {
					tool_style = ';width:' + tool_width + 'px;' + tool_style;
				}
				if (tool_align) {
					tool_style = ';text-align:' + tool_align + ';' + tool_style;
				}
				html += [
					'<th class="',
					tool_class,
					' ',
					tool_th_class,
					'" style="',
					tool_style,
					';',
					tool_th_style,
					'">',
					K.L('操作'),
					'</th>'
				].join('');
			}
			html += '</tr></thead>';
		}
		html += '<tbody></tbody>';
		data.page = data.page || false;
		if (typeof (data.page) != "object") {
			data.page = {
				page: data.page,
				limit: 10
			};
		}
		if (typeof (data.page) == "object") {
			data.page = {
				page: K.cnum(data.page.page, 1, true, 1),
				limit: K.cnum(data.page.limit, 10, true, 1)
			};
		}
		var page = 1,
			limit = 10,
			limits = [10, 20, 50, 100, 200, 500];
		if (data.page) {
			page = data.page.page;
			limit = data.page.limit;
		}
		if (data.page && typeof (data.data) != "object") {
			html += [
				'<tfoot style="display:none"><tr><td colspan="99" style="padding:5px">',
				'<div class="pk-row">',
				'<div class="pk-w-sm-12">',
				'<select class="_limit" data-page="limit" style="height:22px;line-height:22px;font-size:12px;color:#444;border:none">',
			].join('');
			for (var i = 0; i < limits.length; i++) {
				html += [
					'<option value="',
					limits[i],
					'">',
					limits[i],
					K.L('条'),
					'/',
					K.L('页'),
					'</option>'
				].join('');
			}
			html += [
				'</select>',
				'<button class="pk-btn pk-btn-xs pk-btn-success _prev" data-page="',
				page - 1,
				'">',
				K.L('上一页'),
				'</button><span class="pk-btn pk-btn-xs pk-btn-success _page" style="background:transparent;color:#777" data-page="',
				page,
				'" disabled>',
				page,
				'</span>',
				'<button class="pk-btn pk-btn-xs pk-btn-success _next" data-page="',
				page + 1,
				'">',
				K.L('下一页'),
				'</button><button class="pk-btn pk-btn-xs pk-btn-secondary _go" data-page="n">',
				K.L('跳转'),
				'</button></div></div></td></tr></tfoot>',
			].join('');
		}
		html += '</table>';
		o.addClass('pk-autotable').hide().after(html);
		var to = $('#' + id);
		if (typeof (data.complete) == "function") {
			data.complete(to, data);
		}
		// limit选择
		to.find('>tfoot select._limit').val(limit);
		var alldata = data,
			_load_data = function (data, page, limit, where, order, success) {
				var iscomplete = 1;
				if (typeof (data) == "object") {
					// 空数据
					if (!data.length) {
						to.find('>tbody').html('<tr><td colspan="99" style="text-align:center">' + K.L('无数据') + '</td></tr>');
						// 是否有success方法
						if (typeof (data.success) == "function") {
							data.success(to, data, alldata);
						}
						return true;
					}
					// 写入数据
					var html = '';
					for (var i in data) {
						html += '<tr data-key="' + i + '">';
						if (alldata.checkbox) {
							html += [
								'<td style="text-align:center">',
								'<input type="checkbox" name="id[]" value="',
								data[i].id,
								'" data-table_checkbox /></td>'
							].join('');
						}
						for (var j in fields) {
							var th = [],
								field = '';
							for (var k in data[i]) {
								if (k == fields[j].field) {
									th = data[i];
									field = k;
									break;
								}
							}
							th.key = i;
							var fd = alldata.cols[j];
							html += [
								'<td data-field="',
								field,
								'" class="',
								fd.class || '',
								'" rowspan="',
								fd.rowspan || 1,
								'" colspan="',
								fd.colspan || 1,
								'" style="',
								fd.align ? 'text-align:' + fd.align + ';' : '',
								fd.style || '',
								'">',
							].join('');
							if (typeof (fd.format) == "function") {
								html += fd.format(th[field], th);
							} else {
								html += typeof (th[field]) == "undefined" ? '' : th[field];
							}
							html += '</td>';
						}
						if (alldata.tool) {
							var h = $(alldata.tool).html();
							// 替换掉${k}的值
							for (var _k in th) {
								K.str_replace('${' + _k + '}', th[_k], h);
							}
							html += [
								'<td class="pk-table-tool-td ',
								tool_class,
								' ',
								tool_td_class,
								'" data-key="',
								i,
								'" style="',
								tool_style,
								';',
								tool_td_style,
								'">',
								h,
								'</td>'
							].join('');
						}
						html += '</tr>';
					}
					to.find('>tbody').html(html);
					_on_event(alldata, data, to);
				} else {
					iscomplete = 0;
					page = page || 1;
					limit = limit || 10;
					where = where || {};
					order = order || '';
					where = JSON.stringify(where);
					// 获取数据
					$.getJSON(data, {
						page,
						limit,
						where,
						order
					}, function (data) {
						if (!data.code) {
							var msg = data.msg || K.L('未知错误');
							to.find('>tbody').html([
								'<tr><td colspan="99" style="text-align:center">',
								msg,
								'</td></tr>'
							].join(''));
							// 是否有fail方法
							if (typeof (alldata.fail) == "function") {
								alldata.fail(to, msg, alldata);
							}
							return false;
						}
						if (!K.isset(data.data) || !K.isset(data.data.list)) {
							var err = K.L('返回数据格式错误') + ',' + K.L('正确举例') + ':{"code":1,"msg":"","data":{"list":[{field:value},],"count":1}}';
							to.find('>tbody').html([
								'<tr><td colspan="99" style="text-align:center">',
								err,
								'</td></tr>'
							].join(''));
							// 是否有fail方法
							if (typeof (alldata.fail) == "function") {
								alldata.fail(to, err, alldata);
							}
							return false;
						}
						_load_data(data.data.list, page, limit, where, order, success);
						// 上下页处理
						to.find('>tfoot').show().find('._prev,._page,._next,._go').data({
							limit
						}).show();
						to.find('>tfoot').find('._page,._go').data('page', page);
						to.find('>tfoot ._prev').data('page', page - 1);
						to.find('>tfoot ._next').data('page', page + 1);
						if (K.cnum(data.data.count)) {
							var pagecount = Math.ceil(data.data.count / limit);
							to.find('>tfoot ._go').data({
								page,
								pagecount
							});
							if (pagecount == 1 || page == 1) {
								to.find('>tfoot').find('button._prev').hide();
							}
							if (pagecount < 3) {
								to.find('>tfoot').find('button._go').hide();
							}
							if (pagecount <= page) {
								to.find('>tfoot').find('button._next').hide();
							}
							to.find('>tfoot').find('span._page').html(page + '/' + pagecount);
						} else if (data.data.count === null) {
							if (page == 1) {
								to.find('>tfoot').find('button._prev').hide();
							}
							to.find('>tfoot').find('span._page').html(page);
						} else {
							to.find('>tfoot').hide();
						}
					}).fail(function (jqXHR, textStatus, errorThrown) {
						console.log(jqXHR, textStatus, errorThrown);
						// 是否有fail方法
						if (typeof (alldata.fail) == "function") {
							alldata.fail(to, errorThrown, alldata);
						}
					});
				}
				if (typeof (success) == "function" && iscomplete) {
					success(to, data, alldata);
				}
			};
		var _on_event = function (data, list, to) {
			// 绑定上下页
			if (data.page) {
				var where = data.where,
					order = data.order;
				to.find('>tfoot:not(._oned)').addClass('_oned').find('button._prev,button._next,button._go').on('click', function () {
					var page = K.cnum($(this).data('page'), 1, true, 1),
						limit = K.cnum($(this).data('limit'), 10, true, 1),
						pagecount = K.cnum($(this).data('pagecount'), 0, true, 0);
					if (!$(this).hasClass('_go')) {
						_load_data(data.data, page, limit, where, order);
						return true;
					}
					K.P({
						type: 2,
						title: K.L('请输入页码'),
						noclose: 1,
						submit: function (_id, v) {
							if (!K.cnum(v, false, true, 1)) {
								K.msg(K.L('只能输入正整数'), 2);
								return false;
							}
							if (parseInt(v) == page) {
								K.msg(K.L('目标页为本页'), 0);
								return false;
							}
							if (pagecount && parseInt(v) > pagecount) {
								K.msg(K.L('超出了最大页数'), 0);
								return false;
							}
							K.close(_id);
							_load_data(data.data, v, limit, where, order);
						},
						complete: function (_id, _o) {
							_o.find('.pk-popup-input').attr({
								type: 'number',
								min: 1
							}).val(page);
						}
					});
				}).end().find('select._limit').on('change', function () {
					_load_data(data.data, 1, K.cnum($(this).val(), 10, true, 10, 500), where, order);
				});
			}
			// 绑定工具栏事件
			if (data.tool_on) {
				var _tool_btns = to.find('td.pk-table-tool-td .pk-table-tool-event,a,button');
				for (var e_n in data.tool_on) {
					_tool_btns.on(e_n, function () {
						var key = $(this).parents('td.pk-table-tool-td:eq(0)').data('key');
						data.tool_on[e_n]($(this), list[key], list);
					});
				}
			}
		};
		// 初始化表格数据
		_load_data(data.data, page, limit, data.where, data.order, data.success);
		to['reload'] = function (page2, limit2, where2, order2, success2) {
			page2 = page2 || page;
			limit2 = limit2 || limit;
			where2 = where2 || data.where;
			order2 = order2 || data.order;
			success2 = success2 || data.success;
			_load_data(data.data, page2, limit2, where2, order2, success2);
		};
		return to;
	},
	/**
	 * 下方菜单弹出方法
	 * @param {object} options {cancel,mask,close,data}，可直接options=data，其他项则会自动默认
	 * cancel	是否显示取消按钮
	 * mask		是否显示遮挡层
	 * close	是否自动关闭
	 * data		菜单数据：[{text:"",click:function(){}},]
	 * @returns {object|boolean}
	 */
	actionsheet(options) {
		if (!options) {
			return false;
		}
		if (!options.data) {
			options.data = options;
		}
		options.cancel = K.isset(options.cancel) ? options.cancel : true;
		options.mask = K.isset(options.mask) ? options.mask : true;
		options.close = K.isset(options.close) ? options.close : true;
		if (!options.data) {
			return false;
		}
		var _rnd = '_' + K.random_string(7);
		if (options.mask) {
			$('body').append('<div id="' + _rnd + '_mask" class="pk-actionsheet-mask"></div>');
		}
		$('body').append('<div id="' + _rnd + '" class="pk-actionsheet"></div>');
		var o = $('#' + _rnd),
			_close = function () {
				o.animate({
					height: 0
				}, 500);
				setTimeout(function () {
					$('#' + _rnd + ',#' + _rnd + '_mask').remove();
				}, 500);
			};
		for (var i = 0; i < options.data.length; i++) {
			var _o = options.data[i];
			o.append('<div>' + _o.text + '</div>').find('>div:last').data({
				click: _o.click
			}).on('click', function () {
				$(this).data('click')();
				if (options.close) {
					_close();
				}
			});
		}
		if (options.cancel) {
			o.append('<div class="_cancel">' + K.L('取消') + '</div>').find('>div:last').on({
				click: function () {
					_close();
				}
			});
		}
		var height = o.height();
		o.height(0);
		o.animate({
			height
		}, 500);
		o['mask'] = $('#' + _rnd + '_mask');
		return o;
	},
	/**
	 * 弹出式提示框,支持select变换
	 * @param {object|string} selector 待转换select或对象
	 * @param {object} options 参数设置，也可设置在dom对象data-pk-hintbox-options属性内
	 * options = {
		 data:[{name,value,disabled,selected,click},],
		 css:弹出框的css,
		 spanstyle:'',	//仅select对象时有效
		 spanclass:'',	//仅select对象时有效,
		 hover:false,	//true为鼠标划过弹出,false为点击弹出,
		 click:'',	// 全局点击事件,会带回value参数,
		 arrowcenteratobject:true,	//箭头根据谁来居中,默认自己居中,true为根据selector的对象
	 }
	 select option 可携带icon属性添加图标，url地址
	 * @returns {boolean|object}
	 */
	select2hintbox(selector, options = {}) {
		selector = $(selector);
		if (!selector.length) {
			return false;
		}
		var _do = function (o, os) {
			if (o.data('pk-hintbox-object')) {
				return false;
			}
			if (o.data('value')) {
				o.val(o.data('value'));
			}
			var _id = '_' + K.random_string(),
				html = '';
			if (o.data('pk-hintbox-options')) {
				os = o.data('pk-hintbox-options');
				if (typeof (os) != "object") {
					try {
						os = JSON.parse(os);
					} catch (e) {
						os = {};
					}
				}
			}
			var d = os.data || [];
			if (!d.length && o.prop('tagName') == 'SELECT') {
				var _s = o.find('option');
				for (var i = 0; i < _s.length; i++) {
					var _a = $(_s[i]);
					d.push({
						name: (_a.attr('icon') ? '<i style="float:left;width:20px;height:100%;margin-right:5px;background-image:url(' + _a.attr('icon') + ');background-repeat:no-repeat;background-size:20px auto;background-position:left center;display:list-item"></i>' : '') + _a.html(),
						value: _a.attr('value'),
						disabled: _a.prop('disabled'),
						selected: _a.prop('selected')
					});
				}
			}
			var ishtml = false;
			if (typeof (d) == "object") {
				for (var i = 0; i < d.length; i++) {
					html += [
						'<div class="',
						d[i].disabled ? '_disabled' : '',
						' pk-hint-item" data-index="',
						i,
						'" data-value="',
						K.htmlspecialchars(d[i].value),
						'">',
						d[i].name,
						'</div>',
					].join('');
				}
			} else {
				ishtml = true;
				html = d;
			}
			var _o = o.data('pk-hintbox-object', true).after([
				'<div id="',
				_id,
				'" class="pk-hint ',
				_id,
				'"><div class="pk-hint-body"><div class="pk-hint-header"></div><div class="pk-hint-content">',
				html,
				'</div></div></div>',
			].join('')).parent().css('position', 'relative').end().next('#' + _id);
			_o.css(os.css || {});
			//绑定事件
			o.on({
				click: function () {
					if ($(this).find('i').data('direction') == 'up') {
						$(this).find('i').text('∨');
						$(this).find('i').data('direction', 'down');
					} else {
						$(this).find('i').text('∧');
						$(this).find('i').data('direction', 'up');
					}
					$('#' + _id).toggleClass('pk-hide');
				}
			});
			if (o.prop('tagName') == 'SELECT') {
				var _span_width = o.outerWidth(),
					_span_height = o.outerHeight(),
					_span = o.addClass('pk-hide').before([
						'<span style="display:inline-block;position:relative;max-width:100%"></span>'
					].join('')).prev('span').on({
						click: function () {
							if ($(this).find('i').data('direction') == 'up') {
								$(this).find('i').text('∨');
								$(this).find('i').data('direction', 'down');
							} else {
								$(this).find('i').text('∧');
								$(this).find('i').data('direction', 'up');
							}
							$('#' + _id).toggleClass('pk-hide');
						}
					}).attr({
						class: os.spanclass || o.attr('class'),
						style: os.spanstyle || o.attr('style')
					}).removeClass('pk-hide').html(
						(os.spanhtml || [
							'<span class="',
							_id,
							'">',
							o.find('option[selected]').html() || o.find('option:eq(0)').html(),
							'</span><i data-direction="down">∨</i>'
						].join(''))
					);
				_span.find('>span').css({
					display: 'inline-block',
					whiteSpace: 'nowrap',
					overflow: 'hidden',
					maxWidth: '100%'
				}).end().find('>i').css({
					float: 'right',
					fontWeight: 'bold',
					fontStyle: 'normal',
					height: _span.outerHeight() + 'px',
					lineHeight: _span.outerHeight() + 'px'
				});
				_span.css({
					width: _span_width,
					height: _span_height,
					minWidth: _span.find('>span').outerWidth() + _span.find('>i').outerWidth()
				});
				// div top
				// div居中
				_o.css({
					left: K.cnum(_span.offset().left - o.parent().offset().left + (_span.outerWidth() - _o.outerWidth()) / 2, 0, false, 0),
					top: _span.offset().top - o.parent().offset().top + _span.outerHeight()
				});
			} else {
				// div top
				// div居中
				_o.css({
					left: K.cnum(o.offset().left - o.parent().offset().left + (o.outerWidth() - _o.outerWidth()) / 2, 0, false, 0),
					top: o.offset().top - o.parent().offset().top + o.outerHeight()
				});
			}
			// left 矫正
			var window_width = $(window).width() || 0;
			if (window_width && _o.offset().left + _o.outerWidth() > window_width) {
				_o.css('left', window_width - o.parent().offset().left - _o.outerWidth());
			}
			// 箭头相对o居中
			var _left = (_o.outerWidth() - 22) / 2;
			if (os.arrowcenteratobject) {
				_left = K.cnum(o.offset().left - _o.offset().left + (o.outerWidth() - 22) / 2, 0, false, 0);
			}
			$('head').append([
				'<style>.pk-hint.' + _id + ' .pk-hint-body::before{left:' + _left + 'px}',
				'.pk-hint.' + _id + ' .pk-hint-body::after{left:' + (_left + 2) + 'px}</style>'
			].join(''));
			_o.addClass('pk-hide');
			!ishtml && _o.find('.pk-hint-content>div').on('click', function () {
				var value = $(this).data('value') || '',
					html = $(this).html() || '',
					index = $(this).data('index') || 0,
					_typeof = typeof (d[index].click);
				if (o.prop('tagName') == 'SELECT') {
					if ($(this).hasClass('_selected') || $(this).hasClass('_disabled')) {
						return false;
					}
					$(this).siblings().removeClass('_selected');
					$(this).addClass('_selected');
					_span.find('span').html(html);
					o.val(value).change();
					_span.click();
				} else {
					o.click();
				}
				if (_typeof != "undefined") {
					if (_typeof == "function") {
						d[index].click(value, os);
					} else {
						eval(d[index].click);
					}
					return true;
				}
				_typeof = typeof (os.click);
				if (_typeof != "undefined") {
					if (_typeof == "function") {
						os.click(value, os);
					} else {
						eval(os.click);
					}
					return true;
				}
			});
			if (o.prop('tagName') == 'SELECT') {
				// 初始化选择
				_o.find('.pk-hint-content>div').each(function () {
					if ($(this).data('value') == o.val()) {
						$(this).siblings().removeClass('_selected');
						$(this).addClass('_selected');
						_span.find('span').html($(this).html() || '');
						return true;
					}
				});
			}
			// 是否为hover事件,而非click
			if (!os.hover || K.is_small_screen()) {
				return _o;
			}
			// console.log(os.hover);
			// hover
			// console.log(_o);
			if (!$(o).hasClass('pk-hide')) {
				$(o).data('id', _id).on({
					mouseover: function () {
						var o = $('#' + $(this).data('id'));
						if (o.hasClass('pk-hide')) {
							o.removeClass('pk-hide');
						}
					}
				});
			} else {
				$('.' + _id).parent().data('id', _id).on({
					mouseover: function () {
						window['pk_select2hintbox_tempid'] = $(this).data('id');
						var o = $('#' + $(this).data('id'));
						if (o.hasClass('pk-hide')) {
							$(this).find('i').text('∧').data('direction', 'up');
							o.removeClass('pk-hide');
						}
					}
				});
			}
			$('body').on({
				click: function (e) {
					var id = window['pk_select2hintbox_tempid'],
						div = $('#' + id),
						o = $('.' + id).parent();
					if (div.hasClass('pk-hide')) {
						return false;
					}
					o.find('i').text('∨').data('direction', 'down');
					div.addClass('pk-hide');
				}
			});
			return _o;
		};
		var __os = [];
		for (var i = 0; i < selector.length; i++) {
			__os.push(_do($(selector[i]), options));
		}
		if (__os.length == 1) {
			return __os[0];
		}
		return __os;
	},
	/**
	 * 颜色选择器
	 * @param {string|false} colorHex #000000格式的颜色值，初始默认值
	 * @param {function} success s(rgb)用户操作后返回选择的颜色的Hex值
	 * @returns {number|boolean}
	 */
	colorPicker(colorHex, success) {
		if (!colorHex || typeof (colorHex) != "string" || colorHex[0] != '#' || colorHex.length != 7) {
			colorHex = '#000000';
		}
		var rgb1 = colorHex.toUpperCase();
		return K.P({
			type: 1,
			title: K.L("选择颜色"),
			noclose: 1,
			content: [
				'<div class="pk-row"><div class="pk-w-sm-6 pk-padding-0"><input type="color" class="pk-textbox pk-textbox-noshadow pk-float-right" style="width:86px;border-right:0" value="',
				rgb1,
				'"></div><div class="pk-w-sm-6 pk-padding-0"><select class="pk-textbox pk-textbox-noshadow pk-float-left" style="width:86px" onchange="$(this).parent().prev().find(\'input\').val($(this).val())" value="',
				rgb1,
				'"><option value="#000000">',
				K.L('黑色'),
				'</option><option value="#808080">',
				K.L('灰色'),
				'</option><option value="#FF0000">',
				K.L('红色'),
				'</option><option value="#FFFF00">',
				K.L('黄色'),
				'</option><option value="#008000">',
				K.L('绿色'),
				'</option><option value="#0000FF">',
				K.L('蓝色'),
				'</option><option value="#800080">',
				K.L('紫色'),
				'</option><option value="#FFC0CB">',
				K.L('粉色'),
				'</option><option value="#FFA500">',
				K.L('橙色'),
				'</option></select></div></div>'
			].join(''),
			submit: function (id, value, o) {
				var rgb = o.find('.pk-popup-body input[type="color"]').val();
				if (rgb[0] != '#' || rgb.length != 7) {
					K.msg(K.L('颜色参数不正确，请重新输入或选择'), 2);
					return false;
				}
				rgb = rgb.toUpperCase();
				if (typeof (success) == "function") {
					success(rgb);
				}
				K.close(id);
			},
			complete: function (id, o) {
				o.find('.pk-popup-body select option[value="' + rgb1 + '"]').prop({
					selected: true
				});
			}
		});
	},
	/**
	 * 时间选择器
	 * @param {*} datetime 初始化时默认显示的日期时间，留空则为当前时间，仅认2000-02-02 18:00:00格式,或单独的一个格式
	 * @param {function} success success(datetime)选择后返回日期时间
	 * @returns {number|boolean}
	 */
	timePicker(datetime, success) {
		if (!datetime) {
			datetime = K.date();
		}
		if (datetime == 'date') {
			datetime = K.date('Y-m-d');
		}
		if (datetime == 'time') {
			datetime = K.date('H:i:s');
		}
		datetime = datetime.split(' ');
		if (datetime[0].indexOf('-') > -1) {
			var date = datetime[0],
				ymd = date.split('-');
		} else if (datetime[0].indexOf(':') > -1) {
			var time = datetime[0],
				his = time.split(':');
		}
		if (datetime[1]) {
			var time = datetime[1],
				his = time.split(':');
		}
		var html = '<div class="pk-row"><div class="pk-w-sm-12 pk-text-center _ymdhis">';
		if (date) {
			html += '<select class="_y_">';
			for (var i = parseInt(K.date('Y')) + 40; i >= 1949; i--) {
				var _y = i + '';
				html += '<option value="' + _y + '" ' + (_y == ymd[0] ? 'selected' : '') + '>' + _y + '</option>';
			}
			html += '</select> - ';
			html += '<select class="_m_">';
			for (var i = 1; i <= 12; i++) {
				var _m = i < 10 ? '0' + i : i;
				_m += '';
				html += '<option value="' + _m + '" ' + (_m == ymd[1] ? 'selected' : '') + '>' + _m + '</option>';
			}
			html += '</select> - ';
			html += '<select class="_d_">';
			for (var i = 1; i <= 31; i++) {
				var _d = i < 10 ? '0' + i : i;
				_d += '';
				html += '<option value="' + _d + '" ' + (_d == ymd[2] ? 'selected' : '') + '>' + _d + '</option>';
			}
			html += '</select>';
		}
		if (time) {
			if (date) {
				html += '&nbsp;&nbsp;&nbsp;';
			}
			html += '<select class="_h_">';
			for (var i = 0; i <= 23; i++) {
				var _h = i < 10 ? '0' + i : i;
				_h += '';
				html += '<option value="' + _h + '" ' + (_h == his[0] ? 'selected' : '') + '>' + _h + '</option>';
			}
			html += '</select> : ';
			html += '<select class="_i_">';
			for (var i = 0; i <= 59; i++) {
				var _i = i < 10 ? '0' + i : i;
				_i += '';
				html += '<option value="' + _i + '" ' + (_i == his[1] ? 'selected' : '') + '>' + _i + '</option>';
			}
			html += '</select> : ';
			html += '<select class="_s_">';
			for (var i = 0; i <= 59; i++) {
				var _s = i < 10 ? '0' + i : i;
				_s += '';
				html += '<option value="' + _s + '" ' + (_s == his[2] ? 'selected' : '') + '>' + _s + '</option>';
			}
			html += '</select>';
		}
		html += '</div></div>';
		return K.P({
			type: 2,
			title: K.L("日期时间"),
			submit: function (id, value) {
				if (typeof (success) == "function") {
					success(value);
				}
			},
			complete: function (id, obj) {
				obj.find('.pk-popup-body .pk-popup-input').addClass('pk-hide').after(html);
				obj.find('._ymdhis').css({
					height: '39px',
					lineHeight: '28px',
					padding: '5px 0'
				}).find('select').css({
					border: 'none',
					appearance: 'none',
					'-moz-appearance': 'none',
					'-webkit-appearance': 'none',
					fontSize: '14px',
					borderBottom: 'solid 1px #000',
					cursor: 'pointer',
					height: '100%'
				});
				// 绑定选择事件
				obj.find('.pk-popup-body select').on('change propertychange', function () {
					var _datetime = '';
					if (date) {
						var y = obj.find('select._y_').val();
						var m = obj.find('select._m_').val();
						var d = obj.find('select._d_').val();
						_datetime = y + '-' + m + '-' + d;
					}
					if (time) {
						if (_datetime) {
							_datetime += ' ';
						}
						var h = obj.find('select._h_').val();
						var i = obj.find('select._i_').val();
						var s = obj.find('select._s_').val();
						_datetime += h + ':' + i + ':' + s;
					}
					obj.find('.pk-popup-body .pk-popup-input').val(_datetime);
				}).trigger('change');
			}
		});
	},
	/**
	 * viewer.js 图片浏览组件
	 * 具体用法参考:https://github.com/fengyuanchen/viewerjs
	 */
	viewer(selector, options = {}) {
		selector = $(selector);
		if (!selector.length) {
			return false;
		}
		if (!options) {
			options = {};
		}
		options.button = options.button || !K.is_small_screen();
		options.navbar = options.navbar || 2;
		options.title = options.title || 2;
		options.toolbar = options.toolbar || 2;
		options.className = options.className || 'pk-viewer';
		options.complete = options.complete || false;
		options.filter = options.filter || function (image) {
			return image.complete;
		};
		K.require_once(K.basePath + '../css/viewer.min.css,' + K.basePath + 'viewer.min.js', function () {
			selector.find('img').css('cursor', 'pointer');
			var _os = [];
			for (var i = 0; i < selector.length; i++) {
				_os.push(new window['Viewer']($(selector[i])[0], options));
			}
			if (_os.length == 1) {
				_os = _os[0];
			}
			if (typeof (options.complete) == "function") {
				options.complete(_os);
			}
		}, window['Viewer']);
		return true;
	},
	/**
	 * 是否时小屏设备,默认小于1100的是
	 */
	is_small_screen(width = 1100) {
		return ($(window).width() || window.screen.width) < width ? true : false;
	},
	/**
	 * md5加密
	 * @param {string} string 待md5加密的字符串
	 * @returns {string}
	 */
	md5(string) {
		string += '';

		function md5_RotateLeft(lValue, iShiftBits) {
			return (lValue << iShiftBits) | (lValue >>> (32 - iShiftBits));
		}

		function md5_AddUnsigned(lX, lY) {
			var lX4, lY4, lX8, lY8, lResult;
			lX8 = (lX & 0x80000000);
			lY8 = (lY & 0x80000000);
			lX4 = (lX & 0x40000000);
			lY4 = (lY & 0x40000000);
			lResult = (lX & 0x3FFFFFFF) + (lY & 0x3FFFFFFF);
			if (lX4 & lY4) {
				return (lResult ^ 0x80000000 ^ lX8 ^ lY8);
			}
			if (lX4 | lY4) {
				if (lResult & 0x40000000) {
					return (lResult ^ 0xC0000000 ^ lX8 ^ lY8);
				} else {
					return (lResult ^ 0x40000000 ^ lX8 ^ lY8);
				}
			} else {
				return (lResult ^ lX8 ^ lY8);
			}
		}

		function md5_F(x, y, z) {
			return (x & y) | ((~x) & z);
		}

		function md5_G(x, y, z) {
			return (x & z) | (y & (~z));
		}

		function md5_H(x, y, z) {
			return (x ^ y ^ z);
		}

		function md5_I(x, y, z) {
			return (y ^ (x | (~z)));
		}

		function md5_FF(a, b, c, d, x, s, ac) {
			a = md5_AddUnsigned(a, md5_AddUnsigned(md5_AddUnsigned(md5_F(b, c, d), x), ac));
			return md5_AddUnsigned(md5_RotateLeft(a, s), b);
		};

		function md5_GG(a, b, c, d, x, s, ac) {
			a = md5_AddUnsigned(a, md5_AddUnsigned(md5_AddUnsigned(md5_G(b, c, d), x), ac));
			return md5_AddUnsigned(md5_RotateLeft(a, s), b);
		};

		function md5_HH(a, b, c, d, x, s, ac) {
			a = md5_AddUnsigned(a, md5_AddUnsigned(md5_AddUnsigned(md5_H(b, c, d), x), ac));
			return md5_AddUnsigned(md5_RotateLeft(a, s), b);
		};

		function md5_II(a, b, c, d, x, s, ac) {
			a = md5_AddUnsigned(a, md5_AddUnsigned(md5_AddUnsigned(md5_I(b, c, d), x), ac));
			return md5_AddUnsigned(md5_RotateLeft(a, s), b);
		};

		function md5_ConvertToWordArray(string) {
			var lWordCount;
			var lMessageLength = string.length;
			var lNumberOfWords_temp1 = lMessageLength + 8;
			var lNumberOfWords_temp2 = (lNumberOfWords_temp1 - (lNumberOfWords_temp1 % 64)) / 64;
			var lNumberOfWords = (lNumberOfWords_temp2 + 1) * 16;
			var lWordArray = Array(lNumberOfWords - 1);
			var lBytePosition = 0;
			var lByteCount = 0;
			while (lByteCount < lMessageLength) {
				lWordCount = (lByteCount - (lByteCount % 4)) / 4;
				lBytePosition = (lByteCount % 4) * 8;
				lWordArray[lWordCount] = (lWordArray[lWordCount] | (string.charCodeAt(lByteCount) <<
					lBytePosition));
				lByteCount++;
			}
			lWordCount = (lByteCount - (lByteCount % 4)) / 4;
			lBytePosition = (lByteCount % 4) * 8;
			lWordArray[lWordCount] = lWordArray[lWordCount] | (0x80 << lBytePosition);
			lWordArray[lNumberOfWords - 2] = lMessageLength << 3;
			lWordArray[lNumberOfWords - 1] = lMessageLength >>> 29;
			return lWordArray;
		};

		function md5_WordToHex(lValue) {
			var WordToHexValue = "",
				WordToHexValue_temp = "",
				lByte, lCount;
			for (lCount = 0; lCount <= 3; lCount++) {
				lByte = (lValue >>> (lCount * 8)) & 255;
				WordToHexValue_temp = "0" + lByte.toString(16);
				WordToHexValue = WordToHexValue + WordToHexValue_temp.substr(WordToHexValue_temp.length - 2, 2);
			}
			return WordToHexValue;
		};

		function md5_Utf8Encode(string) {
			string = string.replace(/\r\n/g, "\n");
			var utftext = "";
			for (var n = 0; n < string.length; n++) {
				var c = string.charCodeAt(n);
				if (c < 128) {
					utftext += String.fromCharCode(c);
				} else if ((c > 127) && (c < 2048)) {
					utftext += String.fromCharCode((c >> 6) | 192);
					utftext += String.fromCharCode((c & 63) | 128);
				} else {
					utftext += String.fromCharCode((c >> 12) | 224);
					utftext += String.fromCharCode(((c >> 6) & 63) | 128);
					utftext += String.fromCharCode((c & 63) | 128);
				}
			}
			return utftext;
		};
		var x = Array();
		var k, AA, BB, CC, DD, a, b, c, d;
		var S11 = 7,
			S12 = 12,
			S13 = 17,
			S14 = 22;
		var S21 = 5,
			S22 = 9,
			S23 = 14,
			S24 = 20;
		var S31 = 4,
			S32 = 11,
			S33 = 16,
			S34 = 23;
		var S41 = 6,
			S42 = 10,
			S43 = 15,
			S44 = 21;
		string = md5_Utf8Encode(string);
		x = md5_ConvertToWordArray(string);
		a = 0x67452301;
		b = 0xEFCDAB89;
		c = 0x98BADCFE;
		d = 0x10325476;
		for (k = 0; k < x.length; k += 16) {
			AA = a;
			BB = b;
			CC = c;
			DD = d;
			a = md5_FF(a, b, c, d, x[k + 0], S11, 0xD76AA478);
			d = md5_FF(d, a, b, c, x[k + 1], S12, 0xE8C7B756);
			c = md5_FF(c, d, a, b, x[k + 2], S13, 0x242070DB);
			b = md5_FF(b, c, d, a, x[k + 3], S14, 0xC1BDCEEE);
			a = md5_FF(a, b, c, d, x[k + 4], S11, 0xF57C0FAF);
			d = md5_FF(d, a, b, c, x[k + 5], S12, 0x4787C62A);
			c = md5_FF(c, d, a, b, x[k + 6], S13, 0xA8304613);
			b = md5_FF(b, c, d, a, x[k + 7], S14, 0xFD469501);
			a = md5_FF(a, b, c, d, x[k + 8], S11, 0x698098D8);
			d = md5_FF(d, a, b, c, x[k + 9], S12, 0x8B44F7AF);
			c = md5_FF(c, d, a, b, x[k + 10], S13, 0xFFFF5BB1);
			b = md5_FF(b, c, d, a, x[k + 11], S14, 0x895CD7BE);
			a = md5_FF(a, b, c, d, x[k + 12], S11, 0x6B901122);
			d = md5_FF(d, a, b, c, x[k + 13], S12, 0xFD987193);
			c = md5_FF(c, d, a, b, x[k + 14], S13, 0xA679438E);
			b = md5_FF(b, c, d, a, x[k + 15], S14, 0x49B40821);
			a = md5_GG(a, b, c, d, x[k + 1], S21, 0xF61E2562);
			d = md5_GG(d, a, b, c, x[k + 6], S22, 0xC040B340);
			c = md5_GG(c, d, a, b, x[k + 11], S23, 0x265E5A51);
			b = md5_GG(b, c, d, a, x[k + 0], S24, 0xE9B6C7AA);
			a = md5_GG(a, b, c, d, x[k + 5], S21, 0xD62F105D);
			d = md5_GG(d, a, b, c, x[k + 10], S22, 0x2441453);
			c = md5_GG(c, d, a, b, x[k + 15], S23, 0xD8A1E681);
			b = md5_GG(b, c, d, a, x[k + 4], S24, 0xE7D3FBC8);
			a = md5_GG(a, b, c, d, x[k + 9], S21, 0x21E1CDE6);
			d = md5_GG(d, a, b, c, x[k + 14], S22, 0xC33707D6);
			c = md5_GG(c, d, a, b, x[k + 3], S23, 0xF4D50D87);
			b = md5_GG(b, c, d, a, x[k + 8], S24, 0x455A14ED);
			a = md5_GG(a, b, c, d, x[k + 13], S21, 0xA9E3E905);
			d = md5_GG(d, a, b, c, x[k + 2], S22, 0xFCEFA3F8);
			c = md5_GG(c, d, a, b, x[k + 7], S23, 0x676F02D9);
			b = md5_GG(b, c, d, a, x[k + 12], S24, 0x8D2A4C8A);
			a = md5_HH(a, b, c, d, x[k + 5], S31, 0xFFFA3942);
			d = md5_HH(d, a, b, c, x[k + 8], S32, 0x8771F681);
			c = md5_HH(c, d, a, b, x[k + 11], S33, 0x6D9D6122);
			b = md5_HH(b, c, d, a, x[k + 14], S34, 0xFDE5380C);
			a = md5_HH(a, b, c, d, x[k + 1], S31, 0xA4BEEA44);
			d = md5_HH(d, a, b, c, x[k + 4], S32, 0x4BDECFA9);
			c = md5_HH(c, d, a, b, x[k + 7], S33, 0xF6BB4B60);
			b = md5_HH(b, c, d, a, x[k + 10], S34, 0xBEBFBC70);
			a = md5_HH(a, b, c, d, x[k + 13], S31, 0x289B7EC6);
			d = md5_HH(d, a, b, c, x[k + 0], S32, 0xEAA127FA);
			c = md5_HH(c, d, a, b, x[k + 3], S33, 0xD4EF3085);
			b = md5_HH(b, c, d, a, x[k + 6], S34, 0x4881D05);
			a = md5_HH(a, b, c, d, x[k + 9], S31, 0xD9D4D039);
			d = md5_HH(d, a, b, c, x[k + 12], S32, 0xE6DB99E5);
			c = md5_HH(c, d, a, b, x[k + 15], S33, 0x1FA27CF8);
			b = md5_HH(b, c, d, a, x[k + 2], S34, 0xC4AC5665);
			a = md5_II(a, b, c, d, x[k + 0], S41, 0xF4292244);
			d = md5_II(d, a, b, c, x[k + 7], S42, 0x432AFF97);
			c = md5_II(c, d, a, b, x[k + 14], S43, 0xAB9423A7);
			b = md5_II(b, c, d, a, x[k + 5], S44, 0xFC93A039);
			a = md5_II(a, b, c, d, x[k + 12], S41, 0x655B59C3);
			d = md5_II(d, a, b, c, x[k + 3], S42, 0x8F0CCC92);
			c = md5_II(c, d, a, b, x[k + 10], S43, 0xFFEFF47D);
			b = md5_II(b, c, d, a, x[k + 1], S44, 0x85845DD1);
			a = md5_II(a, b, c, d, x[k + 8], S41, 0x6FA87E4F);
			d = md5_II(d, a, b, c, x[k + 15], S42, 0xFE2CE6E0);
			c = md5_II(c, d, a, b, x[k + 6], S43, 0xA3014314);
			b = md5_II(b, c, d, a, x[k + 13], S44, 0x4E0811A1);
			a = md5_II(a, b, c, d, x[k + 4], S41, 0xF7537E82);
			d = md5_II(d, a, b, c, x[k + 11], S42, 0xBD3AF235);
			c = md5_II(c, d, a, b, x[k + 2], S43, 0x2AD7D2BB);
			b = md5_II(b, c, d, a, x[k + 9], S44, 0xEB86D391);
			a = md5_AddUnsigned(a, AA);
			b = md5_AddUnsigned(b, BB);
			c = md5_AddUnsigned(c, CC);
			d = md5_AddUnsigned(d, DD);
		}
		return (md5_WordToHex(a) + md5_WordToHex(b) + md5_WordToHex(c) + md5_WordToHex(d)).toLowerCase();
	},
	/**
	 * html模板渲染引擎
	 * 目前支持if和for语法
	 * <if condition|if=""></if><else></else>
	 * <for data="" key="[key]" value="[value]"></for>
	 * <for index="[i]" start="[0]" end="" judge="[<]" step="[1]"></for>
	 * 变量格式${var},${__ME__}为当前带入变量的所有值,d|data为当前带入的数据
	 * @param {string} html 为模板代码
	 * @param {object} arr 为数组,键名为要替换的值
	 * @param {string} prefix 为数组的前缀
	 * @returns {string}
	 */
	template(html, arr = {}, prefix = '') {
		if (typeof (html) != "string") {
			return '';
		}
		if (typeof (arr) != "object") {
			arr = {};
		}
		var fordo = function (html, arr) {
			var data = arr,
				h = $('<div>' + html + '</div>'),
				d = data,
				s = h.find('for');
			for (var i = 0; i < s.length; i++) {
				var o = $(s[i]);
				var _h = o.html();
				var _r = '';
				if (o.attr('data')) {
					var knt = o.attr('key') || 'key',
						kn = '__' + knt + '__',
						dn = o.attr('data'),
						vnt = o.attr('value') || 'value',
						vn = '__' + vnt + '__';
					try {
						eval("(function(){for(var " + kn + " in " + dn + "){var " + vn + "={" + vnt + ":" + dn + "[" + kn + "]," + knt + ":" + kn + "};_r+=K.template(_h," + vn + ")}})()");
					} catch (e) {
						console.log(e);
					}
				} else {
					var step = o.attr('step') || 1,
						int = o.attr('index') || 'i',
						sn = o.attr('start') || 0,
						en = o.attr('end'),
						judge = o.attr('gudge') || '<';
					try {
						eval("(function(){for(var " + int + "=" + sn + ";" + int + judge + en + ";" + int + "+=" + step + "){_r+=K.template(_h,{" + int + "})}})()");
					} catch (e) {
						console.log(e);
					}
				}
				if (_r) {
					o.after(_r);
				}
				o.remove();
			}
			return h.html();
		};
		var marksdo = function (html, arr) {
			// for循环
			// 标签判断
			// if
			var data = arr,
				h = $('<div>' + html + '</div>'),
				s = h.find('else');
			var d = data;
			if (s.length) {
				// console.log('else');
				// else转为if
				var _html = html;
				for (var i = 0; i < s.length; i++) {
					var o = $(s[i]).prevAll('if');
					if (!o.length) {
						console.log('模板代码错误无法渲染：' + html);
						return false;
					}
					var condition = '!(' + (o.attr('condition') || o.attr('if')) + ')';
					var string = $(s[i])[0].outerHTML,
						replace = $(s[i]).attr('condition', condition)[0].outerHTML;
					//console.
					replace = '<if' + K.substr(replace, 5, replace.length - 12) + '</if>';
					html = K.str_replace(string, replace, html);
				}
				return marksdo(html, arr);
			}
			s = h.find('if');
			var n = 0;
			for (var i = 0; i < s.length; i++) {
				var o = $(s[i]);
				if (o.parents('for').length) {
					n++;
					continue;
				}
				var condition = (o.attr('condition') || o.attr('if')) || '',
					t = false;
				try {
					var _eval = 'if(' + condition + ')t=true;';
					eval(_eval);
				} catch (e) {
					console.log(e);
				}
				if (t) {
					o.after(o.html());
				}
				o.remove();
			}
			html = h.html();
			if (h.find('if').length && h.find('if').length != n) {
				return marksdo(html, arr);
			}
			//console.log(html);
			return html;
		};
		var varsdo = function (html, arr, prefix = '') {
			// 替换全局
			html = K.str_replace('${__ME__}', K.htmlspecialchars(JSON.stringify(arr)), html);
			// 先替换变量
			for (var i in arr) {
				if (typeof (arr[i]) == "object") {
					html = K.str_replace('${' + prefix + i + '}', K.htmlspecialchars(JSON.stringify(arr[i])), html);
					html = varsdo(html, arr[i], prefix + i + '.');
				} else {
					html = K.str_replace('${' + prefix + i + '}', arr[i], html);
				}
			}
			return html;
		};
		return varsdo(fordo(marksdo(html, arr), arr), arr, prefix).replace(/\$\{[a-z0-9_\.]+\}/gi, '');
	},
	/**
	 * 该方法为列表循环的快捷方法，arr为列表数组，当多个数据时使用该方法
	 * @param {string} html 为模板代码
	 * @param {object} arr 为数据列表，数组
	 * @returns {string}
	 */
	templates(html, arr = []) {
		var rh = '';
		for (var i in arr) {
			rh += K.template(html, arr[i]);
		}
		return rh;
	},
	/**
	 * 数组/对象转换为http query字符串
	 * @param {object} arr 待转换的数组
	 * @returns {string}
	 */
	array2querystring(arr) {
		var querystring = '';
		for (var i in arr) {
			querystring += '&' + i + '=' + encodeURIComponent(arr[i]);
		}
		return querystring.substring(1);
	},
	/**
	 * http query字符串转换为数组/对象
	 * @param {string} querystring 待转换的字符串
	 * @returns {object}
	 */
	querystring2array(querystring) {
		querystring = K.trim(querystring, '?', 'l');
		var arr = {};
		var arr1 = querystring.split('&');
		for (var i = 0; i < arr1.length; i++) {
			if (!arr1[i]) {
				continue;
			}
			var arr2 = arr1[i].split('=');
			if (arr2.length == 2) {
				arr[arr2[0]] = decodeURIComponent(arr2[1]);
			}
		}
		return arr;
	},
	/*
	 * 将字符串生成二维码
	 * str			需要被二维码的字符串
	 * selector		二维码生成的标签对象
	 * width,height,title,complete,submit 宽高
	 */
	/**
	 * 将字符串生成二维码
	 * @param {string} text 需要被二维码的字符串
	 * @param {object} options {width,height,title,complete,submit}
	 * width:100 // 二维码宽度
	 * height:100 // 二维码高度
	 * success:function(selector) // 二维码生成成功后执行
	 * title:'' // 不指定selector时弹框的标题
	 * complete:function() // 弹框模式时的complete
	 * submit:function() // 弹框模式时用户点击确认按钮时触发
	 * @returns {boolean|number}
	 */
	qrcode(text, options = {}) {
		if (!options.width) {
			options.width = K.is_small_screen() ? 128 : 256;
		}
		if (!options.height) {
			options.height = K.is_small_screen() ? 128 : 256;
		}
		var _do = function (selector) {
			K.require_once(K.basePath + 'jquery.qrcode.min.js', function () {
				$(selector)['qrcode']({
					width: options.width,
					height: options.height,
					text
				});
				K.canvas2image($(selector).find('canvas:eq(0)'));
				if (typeof (options.success) == "function") {
					options.success($(selector));
				}
			}, $()['qrcode']);
		};
		if (!options.selector) {
			return K.P({
				type: 0,
				title: options.title ? options.title : text,
				content: '<div style="padding:10px"><div class="_qrcode" style="width:' + options
					.width + 'px;height:' +
					options.height + 'px;margin:0 auto"></div></div>',
				complete(id, o) {
					_do(o.find('._qrcode'));
					if (typeof (options.complete) == "function") {
						options.complete(id);
					}
				},
				submit(id, value, o) {
					if (typeof (options.submit) == "function") {
						options.submit(id, value, o);
					}
				}
			});
		} else {
			_do(options.selector);
		}
		return true;
	},
	/**
	 * 将canvas对象转化为image
	 * @param {string|object} canvas canvas对象或选择器字符串
	 * @returns {boolean}
	 */
	canvas2image(canvas) {
		$(canvas).after('<img src="' + $(canvas)[0].toDataURL('image/png') + '" />');
		$(canvas).remove();
		return true;
	},
	/**
	 * 固定选择器,需要传入对象及数据,适用于input内的值以,分割并需要checkbox选择开关
	 * @param {string|object} selector 生成对象或选择器字符串
	 * @param {object} options {data:[{title:"",value:""},],hidden:true,readonly:true}
	 * data:[{title:"",value:""},] checkbox列表的标题和值
	 * hidden:true 是否隐藏input控件
	 * readonly:true input控件是否只读
	 * @returns {boolean}
	 */
	input2checkboxs(selector, options = {}) {
		if (!selector) {
			return false;
		}
		options.data = options.data || false;
		options.hidden = (typeof (options.hidden) == 'undefined' ? true : options.hidden);
		options.readonly = (typeof (options.readonly) == 'undefined' ? true : options.readonly);
		var selectors = $(selector),
			_do = function (o) {
				if (o.data('pk-checkboxs-object')) {
					return false;
				}
				var data = options.data;
				if (!data) {
					data = o.data('data') || false;
				}
				if (!data) {
					data = window['_input2checkboxs_data'] || false;
				}
				// data若为字符串，自动转为数组形式
				if (typeof (data) == "string") {
					data = data.split(',');
					var newdata = [];
					for (var i in data) {
						newdata.push({
							title: data[i],
							value: data[i]
						});
					}
					data = newdata;
				}
				// 兼容以前版本的value:title格式
				if (!data[0]) {
					var newdata = [];
					for (var value in data) {
						newdata.push({
							title: data[value],
							value
						});
					}
					data = newdata;
				}
				if (!data) {
					return false;
				}
				var id = '_' + K.random_string(7);
				o.data('pk-checkboxs-object', true).css('margin-bottom', '10px').after('<div id="' + id +
					'" class="pk-row pk-text-sm" style="color:#555"></div>');
				if (options.hidden) {
					o.addClass('pk-hide');
				}
				if (options.readonly) {
					o.prop('readonly', true);
				}
				var _o = $('#' + id),
					_old_value = o.val();
				for (var k in data) {
					_o.append([
						'<div class="pk-w-sm-6 pk-margin-bottom-5" data-value="',
						K.htmlspecialchars(data[k]['value']),
						'"><input type="checkbox" value="',
						K.htmlspecialchars(data[k]['value']),
						'" title="',
						K.htmlspecialchars(data[k]['title']),
						'" ',
						(K.in_array(data[k]['value'], _old_value) ? 'checked' : ''),
						'></div>'
					].join(''));
				}
				// 美化
				K.input2checkbox(_o.find('input[type="checkbox"]'));
				// 自动更新数据
				var _setInterval = setInterval(function () {
					if (!o.length) {
						clearInterval(_setInterval);
						return false;
					}
					// 先去掉所有的key
					var value = o.val();
					value = value.split(',');
					for (var i in data) {
						for (var j = 0; j < value.length; j++) {
							if (value[j] == data[i]['value']) {
								value[j] = '';
							}
						}
					}
					value = value.join(',');
					// 写入已选择的key
					var s = _o.find('input[type="checkbox"]:checked');
					for (var _i = 0; _i < s.length; _i++) {
						value = $(s[_i]).val() + ',' + value;
					}
					value = value.replace(/[,]+/g, ',');
					value = K.trim(value, ',');
					if (value == _old_value) {
						return false;
					}
					o.val(value);
					_old_value = value;
				}, 200);
			};
		for (var i = 0; i < selectors.length; i++) {
			_do($(selectors[i]));
		}
		return true;
	},
	/**
	 * 获取当前系统类型
	 * @returns {string} 返回当前用户系统名称
	 */
	os() {
		var userAgent = navigator.userAgent.toLowerCase();
		if (userAgent.indexOf('win') > -1) {
			return 'windows';
		} else if (userAgent.indexOf('iphone') > -1) {
			return 'iphone';
		} else if (userAgent.indexOf('mac') > -1) {
			return 'mac';
		} else if (userAgent.indexOf('android') > -1) {
			return 'android';
		} else if (userAgent.indexOf('linux') > -1) {
			return 'linux';
		}
		return 'unknown';
	},
	/**
	 * 查看json数据
	 * @param {object|string} data 对象或者字符串
	 * @param {object|string} selector 展示json数据的对象
	 */
	lookJson(data, selector) {
		if (typeof (data) == "string") {
			data = JSON.parse(data);
		}
		var html = '<table class="pk-table pk-table-bordered pk-text-sm">';
		html += '<tr><th style="width:150px">' + K.L('名称') + '</th><th>' + K.L('内容') + '</th></tr>';
		for (var i in data) {
			if (i == 'key') {
				continue;
			}
			html += '<tr><td>' + K.htmlspecialchars(i) + '</td><td>' + K.htmlspecialchars(data[i]) + '</td></tr>';
		}
		html += '</table>';
		if (selector) {
			$(selector).html(html);
		} else {
			K.P({
				type: 0,
				title: K.L('详情'),
				content: html,
				area: K.is_small_screen() ? ['100%', '100%'] : ['70%', '80%']
			});
		}
	},
	/**
	 * 美化json数据设置,仅支持单层数据及字符串
	 * @param {string|object} objs input对象或选择器字符串
	 * @returns {boolean}
	 */
	input2json(objs) {
		var _do = function (obj) {
			if (obj.data('pk-json-object')) {
				return false;
			}
			try {
				var data = JSON.parse(obj.val());
			} catch (e) {
				var data = JSON.parse('{}');
			}
			var _add = function (_key, _value) {
				o.append([
					'<div class="pk-row pk-margin-bottom-10">',
					'<div class="pk-w-sm-4">',
					'<input type="text" class="pk-textbox _key" value="',
					_key ? K.htmlspecialchars(_key) : '',
					'">',
					'</div>',
					'<div class="pk-w-sm-7" style="padding-left:5px">',
					'<input type="text" class="pk-textbox _value" value="',
					_value ? K.htmlspecialchars(_value) : '',
					'">',
					'</div>',
					'<div class="pk-w-sm-1 pk-text-center pk-height pk-cursor-pointer" style="line-height:38px">',
					'<i class="pk-text-danger" style="font-style:normal;">×</i>',
					'</div></div>'
				].join(''));
				o.find('i:last').on('click', function () {
					$(this).parents('div.pk-row:eq(0)').remove();
				});
			};
			var _id = '_' + K.random_string(7);
			obj.data('pk-json-object', true).addClass('pk-hide').after([
				'<div id="',
				_id,
				'" class="pk-row">',
				'<div class="pk-row pk-margin-bottom-5">',
				'<div class="pk-w-sm-4">',
				K.L('名称'),
				'</div>',
				'<div class="pk-w-sm-7" style="padding-left:5px">',
				K.L('内容'),
				'</div>',
				'</div>',
				'</div>',
				'<div class="pk-text-right">',
				'<a href="javascript:" class="pk-text-xs pk-text-primary pk-hover-underline">',
				K.L('添加一项'),
				'</a>',
				'</div>'
			].join(''));
			var o = $('#' + _id);
			o.next().find('a').on('click', function () {
				_add();
			});
			for (var i in data) {
				_add(i, data[i]);
			}
			var _setInterval = setInterval(function () {
				if (!$('#' + _id).length) {
					clearInterval(_setInterval);
					return false;
				}
				var d = {};
				var s = o.find('>div.pk-row');
				for (var i = 0; i < s.length; i++) {
					var _key = $(s[i]).find('._key').val() || false;
					var _value = $(s[i]).find('._value').val() || '';
					if (!_key) {
						continue;
					}
					d[_key] = _value;
				}
				obj.val(JSON.stringify(d));
			}, 200);
		};
		$(objs).each(function () {
			_do($(this));
		});
		return true;
	},
	// 美化checkbox控件
	/**
	 *
	 * @param {string|object} obj input[type="checkbox"]对象或选择器字符串，可多个，留空为当前页面所有input
	 * @returns {boolean}
	 */
	input2checkbox(obj) {
		if (!obj) {
			obj = 'input[type="checkbox"]';
		}
		var objs = $(obj);
		for (var i = 0; i < objs.length; i++) {
			var o = $(objs[i]);
			if (o.data('pk-checkbox-object') || o.attr('type') != 'checkbox') {
				continue;
			}
			var title = o.attr('title') || o.val();
			var checked = o.prop('checked');
			var checkbox_icon =
				'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAABMElEQVRoQ+2aMY6DUAxE7Q5KWlp+n9wo5AY5Sm6w5ERLev+WlhI6R0ZQ7EpbrEZKQBokEgk0xn6PVLHKepjZRVVvInLeru30u3f3e0rpEf1pfOScv0Sk3WnDf7XVNU1zVTNrVTUGkKIopCzLXc8xTZPM87z06O5XzTl/x2sTzdd1vevmt+aGYdiG6GMAjxtVVS3nEY5xHCXO5TfAAT6gjAY+AP3HI2mABkACfIVAgHCcBmCEYAEaAAHCcRqAEYIFaAAECMdpAEYIFqABECAcpwEYIViABkCAcJwGYIRgARoAAcJxGoARggVoAAQIx2kARggWoAEQIBynARghWOC3gV5ETgf9o/t5/FWDsGlmnapeQLNvjbv7I6XULtsq6xCx9BHrNqe3dvL/hz3XdZsuoi/Jfc1l6+K7IwAAAABJRU5ErkJggg==';
			var checkbox_icon2 =
				'data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAACiUlEQVRoQ+2azWsTQRiHf4OSBGsiKw0KalGz4MFK6sGbd+tBEP+BpgcPgohe9KIXj548eTW99+bFkwhtRejB5NCLzragIJEoJRtLPkgdmZgNSbO7OjszdgqzhwSS3Xee531ndieTIRgclNIFQsh9AHPBZ4a+Vxhjz13XXeJ8hL94nvcSQMlQ4CiscqFQWCSU0hIhhAsglUohnU4b7dHpdNDtdvuMjLFF4nneB95tOHw+nzcaPoCr1+uBRIULMP5FNptFLpc7EAK+76PZbPZZrcB+lMxWYD+yPtqmrYCtgGQGbBeSTGDs5bTVwFqjhhOpI5g/fib0XGMr8Hr7C559rgyhb02fw91TsxMSRgrshQ+o3xRvmC8QBT916DBezV43WyAKnlM/PXsFV4+dNFcgDv7hzBzmHYMHcVJ4Xg7hQbzaqMFrNWJvbSK3Vhl4YYHl+iZefN0Y8l1zTuPRzGUR3rFzZeGFBR5471D9+WMMIqmECnhhgSdb61jzaxMZF5VQBS8sUOu2cPvjW+zs9hJLqIQXFuAX8PkJ70pJJFTDJxJIKqEDPrGAqIQueCmBf5XQCS8t8DeJi1MONna2Q58TcdMDkQeL8JM4LHjYwGZgIH/WiycOVfBKKhDQjUrw9clwdEAlvFKBse7U64UaqIZXLhBI3Pm0gl3WXyceHjrgtQjwoO/9b3i8tY5f4BIMN6fP417I71mRwRp1rpJBHBV8+fsmLmQcXDrqqGANjaFVQBv1SGAr8D+yHNeGrYCtgGQGbBeSTKD05XsrwJeDiwf0j+7qxFaDTCYjnSGdAdrt9vhWg/5kjNIyIWRBZ8OqYzPGllzXLQ2n8INNH3y7TVF1Y4rjVQfbbco87m+qy7F0ju2lugAAAABJRU5ErkJggg==';
			o.addClass('pk-hide').after([
				'<label class="pk-cursor-pointer" style="background-image:url(',
				checked ? checkbox_icon2 : checkbox_icon,
				');background-repeat:no-repeat;background-position:0 center"><span>',
				title,
				'</span></label>'
			].join('')).next('label').on('click', function () {
				$(this).prev('input[type="checkbox"]').trigger('click');
				var checked = $(this).prev('input[type="checkbox"]').prop('checked');
				if (checked) {
					$(this).css('background-image', 'url(' + checkbox_icon2 + ')');
				} else {
					$(this).css('background-image', 'url(' + checkbox_icon + ')');
				}
			});
			//调整尺寸
			var _o = o.next('label'),
				_h = _o.outerHeight() || 16;
			_o.css({
				'padding-left': _h + 'px',
				'background-size': (_h - 4) + 'px ' + (_h - 4) + 'px'
			});
		}
		return true;
	},
	// 美化select开关按钮
	/**
	 *
	 * @param {string|object} selector select对象或选择器字符串
	 * @param {object} options {width,height,color_on,color_off}
	 * width:100 宽度，默认100
	 * height:38 高度，默认38
	 * color_on:'#000' 开启时的颜色
	 * color_off:'#000' 关闭时的颜色
	 * @returns {boolean}
	 */
	select2toggle(selector, options = {}) {
		if (!selector) {
			selector = 'select';
		}
		options.width = options.width || 100;
		options.height = options.height || 38;
		options.color_on = options.color_on || '#0c3';
		options.color_off = options.color_off || '#aaa';
		var kqgb = '开启,关闭,启用,禁用,打开,显示,隐藏,open,close,on,off'.split(',');
		var kq = '开启,启用,打开,显示,open,on';
		var gb = '关闭,禁用,隐藏,close,off';
		var $selects = $(selector);
		if (!$selects.length) {
			return false;
		}
		var n = 0;
		for (var $i = 0; $i < $selects.length; $i++) {
			var _o = $($selects[$i]);
			var _a = _o.find('option');
			var _id = '_' + K.random_string(32);
			// 已经是pk-toggle对象
			if (_o.data('pk-toggle-object')) {
				continue;
			}
			// select对象不是2个option都放弃
			if (_a.length != 2) {
				continue;
			}
			// 不符合开启关闭的要求
			if (!K.in_array([$(_a[0]).html().toLowerCase(), $(_a[1]).html().toLowerCase()], kqgb)) {
				continue;
			}
			// 计算数量
			n = n + 1;
			//pk-toggle大小设置
			var _w = options.width || $($selects[$i]).outerWidth(),
				_h = options.height || $($selects[$i]).outerHeight(),
				_o_id = _o.attr('id') || '',
				_o_name = _o.attr('name') || '',
				_html = [
					'<div id="',
					_id,
					'" data-id="',
					_o_id,
					'" data-name="',
					_o_name,
					'" class="pk-toggle">',
					'<div class="pk-toggle-on pk-hide" data-target="' + gb + '" style="background:' + options.color_on + ';border:solid 2px ' + options.color_on + ';border-radius:2px;cursor:pointer;width:100%;height:100%"><div style="width:50%;height:100%;background:#fff;float:right;border-radius:2px"></div></div>',
					'<div class="pk-toggle-off pk-hide" data-target="' + kq + '" style="background:' + options.color_off + ';border:solid 2px ' + options.color_off + ';border-radius:2px;cursor:pointer;width:100%;height:100%"><div style="width:50%;height:100%;background:#fff;float:left;border-radius:2px"></div></div>',
					'</div>'
				].join('');
			//写入pk-toggle
			_o.addClass('pk-hide').data('pk-toggle-object', true).after(_html);
			//object
			var obj = $('#' + _id);
			obj.css({
				width: _w,
				height: _h,
				display: 'inline-block'
			});
			//选择pk-toggle
			if (kq.indexOf(_o.find('option:selected').html()) > -1) {
				obj.find('.pk-toggle-on').removeClass('pk-hide');
			} else if (gb.indexOf(_o.find('option:selected').html()) > -1) {
				obj.find('.pk-toggle-off').removeClass('pk-hide');
			} else {
				if (kq.indexOf(_o.find('option:eq(0)').html()) > -1) {
					obj.find('.pk-toggle-on').removeClass('pk-hide');
				} else {
					obj.find('.pk-toggle-off').removeClass('pk-hide');
				}
			}
			obj.find('>div').on('click', function () {
				var _p = $(this).parent(),
					_t = $(this).data('target').split(','),
					_s = _p.prev('select');
				for (var $_i = 0; $_i < 2; $_i++) {
					var _o = _s.find('option:eq(' + $_i + ')');
					if (_t.indexOf((_o.html() || '').toLowerCase()) > -1) {
						_o.prop('selected', true);
						_p.find('>div').removeClass('pk-hide');
						$(this).addClass('pk-hide');
						return true;
					}
				}
			});
		}
		return true;
	},
	/**
	 * 只能输入整数的框
	 * @param {object|string} selector input对象或选择器字符串
	 * @param {object} options {return_value, min, max}
	 * return_value:1 //出错返回值,
	 * min:0 //最小值,
	 * max:9 //最大值
	 * @returns {boolean}
	 */
	input2number(selector, options = {}) {
		if (!selector) {
			return false;
		}
		options.return_value = options.return_value || '';
		options.min = options.min || false;
		options.max = options.max || false;
		var objs = $(selector);
		for (var i = 0; i < objs.length; i++) {
			var o = $(objs[i]);
			if (o.data('pk-number-object')) {
				continue;
			}
			o.data('pk-number-object', true).attr({
				placeholder: K.L('只能输入整数')
			}).on('input propertychange change', function () {
				var v = $(this).val() || '';
				v = v.toString();
				v = K.str_replace('.', '', v);
				$(this).val(K.cnum(v, options.return_value, true, options.min, options.max, true));
			});
		}
		return true;
	},
	/**
	 * 输入的内容变为md5码,如果为空则恢复初始值
	 * @param {string|object} selector input对象或选择器字符串
	 * @param {object} options {minlength, maxlength}
	 * minlength //最小长度
	 * maxlength //最大长度
	 * @returns {boolean}
	 */
	input2password(selector, options = {}) {
		if (!selector) {
			return false;
		}
		options.minlength = K.cnum(options.minlength, 0, true, 1);
		options.maxlength = K.cnum(options.maxlength, false, true, 1);
		var objs = $(selector);
		for (var i = 0; i < objs.length; i++) {
			var o = $(objs[i]);
			if (o.data('pk-password-object')) {
				continue;
			}
			var v = o.val() || '';
			v = v.toString();
			o.addClass('pk-hide').data('pk-password-object', true).after([
				'<input type="text" class="',
				o.attr('class'),
				'" data-value="',
				K.htmlspecialchars(v),
				'">'
			].join('')).next('input').removeClass('pk-hide').attr({
				placeholder: options.title || K.L('留空为不修改')
			}).on('input propertychange change', function () {
				var v = $(this).val() || '';
				v = v.toString();
				if (
					v &&
					((options.minlength && K.length(v) >= options.minlength) || !options.minlength) &&
					((options.maxlength && K.length(v) <= options.maxlength) || !options.maxlength)
				) {
					v = K.md5(v);
				} else {
					v = $(this).data('value');
				}
				$(this).prev('input').val(v);
			});
		}
		return true;
	},
	/**
	 * 美化时间输入框
	 * @param {string|object} selector input对象或选择器字符串
	 * @param {object} options {type, return_time}
	 * type //日期时间格式，默认'Y-m-d H:i:s',
	 * return_time //是否返回时间戳，默认true，返回的格式为时间戳
	 * @returns {boolean}
	 */
	input2datetime(selector, options = {}) {
		if (!selector) {
			return false;
		}
		if (!options) {
			options = {};
		}
		options.type = options.type || 'Y-m-d H:i:s';
		options.return_time = typeof (options.return_time) == "undefined" ? true : options.return_time;
		var objs = $(selector);
		for (var i = 0; i < objs.length; i++) {
			var o = $(objs[i]);
			if (o.data('pk-datetime-object')) {
				continue;
			}
			var v = o.val();
			if (options.return_time && v) {
				v = K.date(options.type, K.cnum(v, 0, true, 0));
			}
			o.data('pk-datetime-object', true).hide().after([
				'<input type="text" class="',
				o.attr('class'),
				'" value="',
				v,
				'" readonly placeholder="',
				K.L('请选择日期时间'),
				'" style="cursor:pointer">'
			].join('')).next('input[readonly]').on('click', function () {
				var This = $(this);
				K.timePicker(This.val(), function (value) {
					value = K.date(options.type, K.time(value));
					This.val(value);
					if (options.return_time) {
						value = K.time(value);
					}
					This.prev().val(value);
				});
			});
		}
		return true;
	},
	/**
	 * 分隔符input人性化，可以将input的内容分割开，拆分为单独小块设置
	 * @param {string|object} selector input对象或选择器字符串
	 * @param {object} options {height,select,add,del,move,edit,delimiter,str_start,str_end,number}
	 * height			高度(宽度自适应)
	 * select			标签选择模式,该模式不可编辑/删除/移动,=字符串或数组,只能在select中选择
	 * add				是否显示添加按钮
	 * del/move/edit	删除/移动/编辑按钮,select模式下无效
	 * delimiter		input内容以什么字符分割,默认,
	 * str_start		input内容开头的字符串,该字符串不会被记入分割字符串里
	 * str_end			input内容结尾的字符串
	 * number			只能输入数字,默认什么都可以输入
	 * @returns {boolean}
	 */
	input2label(selector, options = {}) {
		if (!selector) {
			return false;
		}
		var _init = function (selector, options) {
			$(selector).data('pk-labelbox-object', false).next('div.pk-labelbox').remove();
			K.input2label(selector, options);
		};
		var _do = function (selector, options) {
			options.height = options.height || false;
			options.select = typeof (options.select) == "undefined" ? false : options.select;
			options.add = options.add || true;
			options.del = options.del || true;
			options.move = options.move || true;
			options.edit = options.edit || true;
			options.delimiter = options.delimiter || ',';
			options.str_start = options.str_start || '';
			options.str_end = options.str_end || '';
			options.number = options.number || false;
			if (options.select !== false) {
				if (['string', 'number'].indexOf(typeof (options.select)) > -1) {
					options.select += '';
					options.select = options.select.split(options.delimiter);
				}
				options.move = false;
				options.edit = false;
				options.del = false;
			}
			var delimiter = options.delimiter || ',',
				start = options.str_start || '',
				end = options.str_end || '';
			options['number'] = options.number || false;
			var obj = $(selector);
			if (obj.data('pk-labelbox-object')) {
				return false;
			}
			if (obj.data('labelbox-delimiter')) {
				delimiter = obj.data('labelbox-delimiter');
			}
			if (obj.data('labelbox-start')) {
				start = obj.data('labelbox-start');
			}
			if (obj.data('labelbox-end')) {
				end = obj.data('labelbox-end');
			}
			if (obj.data('labelbox-number')) {
				options.number = obj.data('labelbox-number');
			}
			var width = obj.outerWidth(),
				height;
			if (options.height) {
				height = options.height;
			} else {
				height = K.cnum(obj.outerHeight(), false, true, 1) || 38;
				options.height = height;
			}
			var style = 'height:' + height + 'px;line-height:' + (height - 2) + 'px',
				_id = '_' + K.random_string(32);
			obj.addClass('pk-hide').data('pk-labelbox-object', true).after([
				'<div id="',
				_id,
				'" class="pk-labelbox"></div>'
			].join(''));
			var o = $('#' + _id),
				v = obj.val() || '',
				tip = obj.attr('placeholder') || K.L('添加');
			v = v.toString();
			if (start) {
				v = K.trim(v, start, 'l');
			}
			if (end) {
				v = K.trim(v, end, 'r');
			}
			var vs = v.split(delimiter);
			//去重
			var temp = []; //一个新的临时数组
			for (var i = 0; i < vs.length; i++) {
				if (temp.indexOf(vs[i]) == -1) {
					temp.push(vs[i]);
				}
			}
			if (temp != vs) {
				vs = temp;
				v = '';
				for (var i = 0; i < vs.length; i++) {
					v += delimiter + vs[i];
				}
				v = K.trim(v, delimiter, 'l');
				obj.val(start + v + end);
			}
			if (options.select !== false) {
				for (var i = 0; i < options.select.length; i++) {
					if (options.select[i] == '') {
						continue;
					}
					var em = '<em style="float:left;width:8px;height:8px;margin:1px 0 0 1px;background:#00f;border-radius:1px"></em>',
						html = '<div data-index="' + i + '" style="' + style + '">';
					html += '<span class="_text"></span>';
					o.append(html).find('>div:last>span:eq(0)').text(options.select[i]).prepend([
						'<i style="border:solid 1px #00f;height:12px;width:12px;float:left;margin-top:12px;border-radius:2px;margin-right:5px">',
						K.in_array(options.select[i], vs) ? em : '',
						'</i>'
					].join(''));
				}
				o.find('._text').on('click', function () {
					if ($(this).find('>i').find('>em').length) {
						$(this).find('>i').html('');
					} else {
						$(this).find('>i').html(em);
					}
					// 重新输入一下内容
					var _o = o.find('em');
					var _v = '';
					for (var j = 0; j < _o.length; j++) {
						_v += delimiter + $(_o[j]).parent().parent().text();
					}
					_v = start + K.trim(_v, delimiter) + end;
					obj.val(_v);
				});
			} else {
				for (var i = 0; i < vs.length; i++) {
					//去空
					if (!vs[i]) {
						continue;
					}
					var html = '<div data-index="' + i + '" style="' + style + '">';
					if (options.move) {
						html += '<i data-ud="up" title="' + K.L('前移') + '" style="color:#0f0">&lang;</i>';
					}
					html += '<span class="_text" title="' + (options.edit ? K.L('编辑') : '') + '"></span>';
					if (options.del) {
						html += '<i title="' + K.L('删除') +
							'" style="color:#f00" class="_del">×</i>';
					}
					if (options.move) {
						html += '<i data-ud="down" title="' + K.L('后移') + '" style="color:#0f0">&rang;</i>';
					}
					o.append(html);
					var _o = o.find('>div:last');
					//写入值
					_o.find('>span:eq(0)').text(vs[i]);
					//移动事件
					options.move && _o.find('>i[data-ud]').on('click', function () {
						var index = $(this).parent().data('index');
						if ($(this).data('ud') == 'up') {
							if (index == 0) {
								return false;
							}
							vs[index] = vs.splice(index - 1, 1, vs[index])[0];
						} else {
							if (index == vs.length - 1) {
								return false;
							}
							vs[index] = vs.splice(index + 1, 1, vs[index])[0];
						}
						v = '';
						for (var i = 0; i < vs.length; i++) {
							v += delimiter + vs[i];
						}
						obj.val(start + K.trim(v, delimiter) + end);
						_init(selector, options);
					});
					//删除事件
					options.del && _o.find('i._del').on('click', function () {
						var index = $(this).parent().data('index');
						vs.splice(index, 1);
						v = '';
						for (var i = 0; i < vs.length; i++) {
							v += delimiter + vs[i];
						}
						obj.val(start + K.trim(v, delimiter) + end);
						_init(selector, options);
					});
					//编辑事件
					options.edit && _o.find('>span:eq(0)').on('click', function () {
						var index = $(this).parent().data('index');
						var _v = $(this).parent().find('span').text();
						K.P({
							type: 2,
							title: K.L("编辑"),
							noclose: 1,
							submit: function (id, value) {
								if (!K.trim(value)) {
									K.p_o(id).find('.pk-popup-input').focus();
									return false;
								}
								for (var i = 0; i < delimiter.length; i++) {
									if (value.indexOf(delimiter[i]) > -1) {
										K.msg(K.L('存在不允许的字符') + '"' + delimiter[i] +
											'"');
										return false;
									}
								}
								if (options.number && K.cnum(value, false, true, 0) ===
									false) {
									K.msg(K.L('只能输入正整数'));
									return false;
								}
								vs[index] = value;
								v = '';
								for (var i = 0; i < vs.length; i++) {
									v += delimiter + vs[i];
								}
								obj.val(start + K.trim(v, delimiter) + end);
								_init(selector, options);
								K.close(id);
							},
							complete: function (id) {
								K.p_o(id).find('.pk-popup-input').val(vs[index]);
							}
						});
					});
				}
			}
			//添加事件
			options.add && o.append('<div style="' + style + '">' + K.L('添加') + '</div>');
			options.add && o.find('>div:last').on('click', function () {
				K.P({
					type: 2,
					title: tip,
					noclose: 1,
					submit: function (id, value) {
						if (!K.trim(value)) {
							K.p_o(id).find('.pk-popup-input').focus();
							return false;
						}
						for (var i = 0; i < delimiter.length; i++) {
							if (value.indexOf(delimiter[i]) > -1) {
								K.msg(K.L('存在不允许的字符') + '"' + delimiter[i] + '"');
								return false;
							}
						}
						if (options.number && K.cnum(value, false, true, 0) === false) {
							K.msg(K.L('只能输入正整数'));
							return false;
						}
						if (options.select) {
							options.select.push(K.trim(value, delimiter));
						} else {
							v = v.toString();
							v += delimiter + value;
							obj.val(start + K.trim(v, delimiter) + end);
						}
						_init(selector, options);
						// o.remove();
						// K.input2label(obj, options);
						K.close(id);
					}
				});
			});
			return true;
		};
		var n = 0;
		for (var i = 0; i < $(selector).length; i++) {
			_do($(selector)[i], options) && n++;
		}
		return true;
	},
	/**
	 * ajax文件上传
	 * @param {object} data 可以为input、img对象，或{file,accept,multiple,return_object,url,timeout,beforeSend,success,error,complete}
	 * data = {
	 * file,					// 上传的文件input对象，若不存在则自动生成
	 * accept,					// 上传的文件类型input[accept]，默认*.*,audio/*,image/*,video/*,.json,.js
	 * multiple					// 是否为多文件上传，默认单文件
	 * return_object,			// 上传成功后返回的文件地址回传给的input或img对象,可空
	 * url,						// 上传文件的接口地址，返回格式举例：{"code":1,"msg":"ok","data":[{"code":1,"data":{"id":"3","uid":"1","filetype":"image/jpeg","filesize":"327792","filepath":"/upload/image/jpeg/2023/02/15/1/6b4a732feed02673e5981cd6ecf5f013.jpg","filename":"6b4a732feed02673e5981cd6ecf5f013.jpg","dir_path":"/upload/image/jpeg/2023/02/15/1/","md5_file":"e90f8c41613cd270526888595a9ae796","uploadtime":"1676430463"},"msg":"ok"}],"time":1680409908}
	 * timeout:10,				// 超时时间，默认10s
	 * beforeSend,				// 上传前执行的函数function(xhr) {}
	 * success,					// 上传成功的回调函数function(_data) {} filepath为必须返回参数
	 * error,					// 上传失败或错误的回调函数function(xhr, msg, obj) {}
	 * complete					// 上传完成的回调函数function(xhr, ts) {}
	 * }
	 * @returns {boolean}
	 */
	upload(data) {
		if (!data) {
			data = {};
		}
		if (typeof (data) == 'object' && $(data)[0].tagName && !data['return_object']) {
			var tagname = $(data)[0].tagName.toLowerCase();
			if (K.in_arrays(tagname, 'img,input')) {
				data['return_object'] = data;
			}
		}
		if (typeof (data['file']) == "undefined") {
			var id = '_' + K.random_string(32),
				accept = data['accept'] ? data['accept'] : '*.*',
				multiple = data['multiple'] ? ' multiple="multiple"' : '';
			$('body').append([
				'<input id="',
				id,
				'" type="file" style="display:none"',
				multiple,
				' accept="',
				accept,
				'" />'
			].join(''));
			$('#' + id).on('change', function () {
				data['file'] = this;
				K.upload(data);
			}).trigger('click');
			return false;
		}
		if (!data['url']) {
			data['url'] = K.uploadURL;
		}
		var formdata = new FormData(),
			_fn = '_' + K.random_string();
		formdata.append('upload_input_name', _fn);
		for (var i = 0; i < $(data['file'])[0].files.length; i++) {
			formdata.append(_fn + '[' + i + ']', $(data['file'])[0].files[i]);
		}
		var pid;
		$.ajax({
			type: 'POST',
			url: data['url'],
			data: formdata,
			cache: false,
			processData: false,
			timeout: data.timeout || 10000,
			contentType: false,
			beforeSend: function (xhr) {
				if (typeof (data['beforeSend']) == "function") {
					data['beforeSend'](xhr);
				} else {
					pid = K.loading(K.L('上传中') + '...');
				}
			},
			success: function (_data) {
				//console.log(_data);
				if (typeof (data['success']) == "function") {
					data['success'](_data);
					return true;
				}
				if (!_data['code']) {
					K.alert(_data['msg'], 2);
					return false;
				}
				_data = _data['data'];
				// 仅一个文件
				if (_data.length == 1) {
					if (!_data[0]['code']) {
						K.alert(_data[0]['msg'], 2);
						return false;
					}
					K.msg(K.L('上传成功'), 1);
					if (data['return_object']) {
						var o = $(data['return_object']);
						if (o[0].tagName.toLowerCase() == 'img') {
							o.attr('src', _data[0]['data']['filepath']);
						} else {
							o.val(_data[0]['data']['filepath']);
						}
					}
					return true;
				}
				// 多个文件上传
				var txt = '',
					url = '';
				for (var i = 0; i < _data.length; i++) {
					txt += [
						'<p>',
						K.L('第'),
						i + 1,
						K.L('个文件'),
						':',
						_data[i]['code'] ? K.L('上传成功') : _data[i]['msg'],
						'</p>'
					].join('');
					if (_data[i]['code']) {
						url += ',' + _data[i]['data']['filepath'];
					}
				}
				if (data['return_object']) {
					var o = $(data['return_object']);
					if (o[0].tagName.toLowerCase() == 'img') {
						// 多个文件若返回对象为img则只显示第一个图片
						var imgurl = url.substring(1).split(',')[0];
						o.attr('src', imgurl);
					} else {
						o.val(url.substring(1));
					}
				}
				K.alert(txt);
				return true;
			},
			error: function (xhr, msg, obj) {
				if (typeof (data['error']) == "function") {
					data['error'](xhr, msg, obj);
				}
				console.log(xhr, msg, obj);
			},
			complete: function (xhr, ts) {
				if (typeof (data['complete']) == "function") {
					data['complete'](xhr, ts);
				}
				pid && K.close(pid);
			}
		});
		return true;
	},
	/**
	 * editor原创编辑器
	 * editor.init(selector,options) 初始化编辑器实例
	 */
	editor: {
		execs: {},
		clicks: {},
		commands: {},
		imagelist: {},
		do(id, selector) {
			selector = $(selector);
			var o = $('#' + id),
				c_w = o.find('iframe')[0].contentWindow;
			if (!c_w) {
				return false;
			}
			var eo = c_w['contentDocument'] || c_w.document;
			if (!eo) {
				return false;
			}
			eo = $(eo);
			var io = o.find('>iframe'),
				so = o.find('>textarea'),
				to = o.find('>div'),
				eob = eo.find('body');
			K.editor.execs[id] = function (p1, p2, p3) {
				if (io.is(":hidden")) {
					if (p1 == 'inserthtml') {
						so.val(so.val() + (p3 || ''));
					}
				} else {
					eob.focus();
					eo[0].execCommand(p1, p2, p3);
				}
			};
			K.editor.commands[id] = {
				id,
				o,
				io,
				so,
				to,
				eo,
				eob,
				exec(p1, p2, p3) {
					K.editor.execs[id](p1, p2, p3);
				},
				insert(html) {
					K.editor.commands[id].exec('inserthtml', false, html);
				},
				val(html) {
					if (typeof (html) == "undefined") {
						if (so.is(":hidden")) {
							return eob.html();
						} else {
							return so.val();
						}
					}
					if (so.is(":hidden")) {
						eob.html(html);
					} else {
						so.val(html);
					}
				},
				source() {
					if (so.is(":hidden")) {
						to.find('[name="source"]').addClass('pk-active');
						so.show().val(selector.val());
						io.hide();
						eob.html('');
					} else {
						to.find('[name="source"]').removeClass('pk-active');
						io.show();
						eob.html(so.val());
						so.hide().val('');
					}
				},
				bold() {
					K.editor.commands[id].exec('bold');
				},
				italic() {
					K.editor.commands[id].exec('italic');
				},
				underline() {
					K.editor.commands[id].exec('underline');
				},
				strikethrough() {
					K.editor.commands[id].exec('strikethrough');
				},
				justifyleft() {
					K.editor.commands[id].exec('justifyleft');
				},
				justifycenter() {
					K.editor.commands[id].exec('justifycenter');
				},
				justifyright() {
					K.editor.commands[id].exec('justifyright');
				},
				unlink() {
					K.editor.commands[id].exec('unlink');
				},
				undo() {
					K.editor.commands[id].exec('undo');
				},
				redo() {
					K.editor.commands[id].exec('redo');
				},
				fontname() {
					var e = K.editor.commands[id];
					K.P({
						title: K.L('字体'),
						type: 2,
						submit(_id, _v) {
							e.exec('fontname', '', _v);
						},
						complete(_id, _o) {
							_o.find('.pk-popup-input').after([
								'<select class="pk-popup-input">',
								'<option value="SimSun">',
								K.L('宋体'),
								'</option>',
								'<option value="FangSong">',
								K.L('仿宋'),
								'</option>',
								'<option value="SimHei">',
								K.L('黑体'),
								'</option>',
								'<option value="Microsoft YaHei">',
								K.L('微软雅黑'),
								'</option>',
								'<option value="Microsoft JhengHei">',
								K.L('微软正黑体'),
								'</option>',
								'<option value="NSimSun">',
								K.L('新宋体'),
								'</option>',
								'<option value="KaiTi">',
								K.L('楷体'),
								'</option>',
								'<option value="YouYuan">',
								K.L('幼圆'),
								'</option>',
								'<option value="LiSu">',
								K.L('隶书'),
								'</option>',
								'<option value="STXihei">',
								K.L('华文细黑'),
								'</option>',
								'<option value="STCaiyun">',
								K.L('华文彩云'),
								'</option>',
								'<option value="STXingkai">',
								K.L('华文行楷'),
								'</option>',
								'<option value="STXinwei">',
								K.L('华文新魏'),
								'</option>',
								'<option value="FZShuTi">',
								K.L('方正舒体'),
								'</option>',
								'<option value="FZYaoti">',
								K.L('方正姚体'),
								'</option>',
								'</select>'
							].join('')).remove();
						}
					});
				},
				fontsize() {
					var e = K.editor.commands[id];
					K.P({
						type: 2,
						title: K.L('字体大小'),
						submit: function (_id, _v) {
							e.exec('fontsize', '', _v);
						},
						complete(_id, _o) {
							_o.find('.pk-popup-input').after([
								'<select class="pk-popup-input">',
								'<option value="1">12px</option>',
								'<option value="2">14px</option>',
								'<option value="3">16px</option>',
								'<option value="4">18px</option>',
								'<option value="5">24px</option>',
								'<option value="6">32px</option>',
								'<option value="7">48px</option>',
								'</select>'
							].join('')).remove();
						}
					});
				},
				forecolor() {
					K.colorPicker(false, function (rgb) {
						K.editor.commands[id].exec('forecolor', '', rgb);
					});
				},
				backcolor() {
					K.colorPicker(false, function (rgb) {
						K.editor.commands[id].exec('backcolor', '', rgb);
					});
				},
				link(title = '', url = '', target = '_blank', is_attachment = false) {
					var e = K.editor.commands[id];
					K.P({
						type: 1,
						title: K.L('链接'),
						noclose: 1,
						content: [
							'<div class="pk-row">',
							'<div class="pk-w-sm-12 pk-margin-bottom-10">',
							'<input type="text" class="pk-textbox" placeholder="',
							K.L('链接文本'),
							'" value="',
							K.htmlspecialchars(title),
							'">',
							'</div>',
							'<div class="pk-w-sm-12 pk-margin-bottom-10">',
							'<input type="text" class="pk-textbox" placeholder="',
							K.L('链接地址'),
							'" value="',
							K.htmlspecialchars(url),
							'">',
							'</div>',
							'<div class="pk-w-sm-12">',
							'<select class="pk-textbox">',
							'<option value="_blank">',
							K.L('链接在新窗口打开'),
							'</option>',
							'<option value="">',
							K.L('链接在当前窗口打开'),
							'</option>',
							'</select>',
							'</div>',
							'</div>'
						].join(''),
						submit(_id, _v, _o) {
							var text = _o.find('.pk-popup-body input:eq(0)').val(),
								href = _o.find('.pk-popup-body input:eq(1)').val(),
								target = _o.find('.pk-popup-body select:eq(0)').val();
							if (!href) {
								K.msg(K.L('链接地址不能为空'));
								return false;
							}
							if (!text && e.eo[0].getSelection && so.is(":hidden")) {
								var sel = e.eo[0].getSelection();
								if (sel.rangeCount) {
									var container = document.createElement("div");
									for (var i = 0, len = sel.rangeCount; i < len; ++i) {
										container.appendChild(sel.getRangeAt(i).cloneContents());
									}
									text = container.innerHTML;
								}
							}
							if (!text) {
								text = href;
							}
							K.close(_id);
							e.insert([
								'<a target="',
								target,
								'" href="',
								href,
								'"',
								is_attachment ? ' class="pk-attachment-link"' : '',
								'>',
								text,
								'</a>'
							].join(''));
						},
						complete(_id, _o) {
							_o.find('select').val(target);
						}
					});
				},
				code() {
					K.P({
						type: 2,
						title: K.L('插入代码'),
						inputtype: 'textarea',
						area: K.is_small_screen() ? ['100%', '100%'] : ['720px', '50%'],
						submit(_id, _v) {
							if (!_v) {
								return false;
							}
							K.editor.commands[id].insert([
								'<br><p><code>',
								K.htmlspecialchars(_v),
								'</code></p><p><br></p>'
							].join(''));
						},
						complete(_id, _o) {
							_o.find('.pk-popup-input').css({
								height: '98%'
							});
						}
					});
				},
				image() {
					var il = K.editor.imagelist[id] || [],
						table;
					K.P({
						type: 1,
						title: K.L('图片'),
						noclose: 1,
						area: K.is_small_screen() ? ['100%', '100%'] : ['720px', '50%'],
						content: [
							'<div class="pk-row">',
							'<div class="pk-w-sm-12">',
							'<table></table>',
							'</div>',
							'</div>'
						].join(''),
						submit(_id, _v, _o) {
							var is = _o.find('table input[name="id[]"]:checked'),
								h = '';
							for (var i = 0; i < is.length; i++) {
								var im = $(is[i]).parents('tr').find('img');
								h += [
									'<img src="',
									im.attr('src'),
									'" alt="',
									im.attr('alt'),
									'" style="',
									im.data('style'),
									'" />'
								].join('');
							}
							if (!h) {
								K.msg(K.L('请选择需要插入的图片'));
								return false;
							}
							K.editor.commands[id].insert(h);
							K.close(_id);
						},
						complete(_id, _o) {
							table = K.table({
								elem: _o.find('table'),
								data: il,
								checkbox: 1,
								cols: [{
									field: "name",
									align: "left",
									title: [
										K.L('图片'),
										'<a class="pk-text-primary pk-hover-underline _yctp" href="javascript:;" style="margin-left:10px;float:right">',
										K.L('远程图片'),
										'</a>',
										'<a class="pk-text-primary pk-hover-underline _upload" href="javascript:;" style="margin-left:10px;float:right">',
										K.L('上传'),
										'</a>'
									].join(''),
									format(v, r) {
										var h = [
											'<img data-key="',
											r['key'],
											'" src="',
											r['url'],
											'"  data-style="',
											r['style'],
											'" data-width="',
											r['width'],
											'" data-height="',
											r['height'],
											'" data-float="',
											r['float'],
											'" style="float:left;width:48px;height:48px;margin-right:5px;',
											'object-fit:contain;border:solid 1px #eee;border-radius:2px" />',
											'<p style="height:28px;line-height:28px;font-size:14px;color:#333;overflow:hidden">',
											r['name'],
											'</p>',
											'<p style="height:20px;line-height:20px;font-size:12px;color:#777">',
											'<span style="margin-right:10px">',
											r['size'] ? r['size'] : '远程文件',
											'</span>',
											'<a class="pk-text-primary pk-hover-underline _sx" href="javascript:;">',
											K.L('属性'),
											'</a>',
											'<span>&nbsp;</span>',
											'<a class="pk-text-danger pk-hover-underline _sc" href="javascript:;">',
											K.L('删除'),
											'</a>',
											'</p>',
										].join('');
										return h;
									}
								}],
								success(_o, _data) {
									_o.find('._sc').on('click', function () {
										var image = $(this).parents('td:eq(0)').find('img');
										delete K.editor.imagelist[id][image.data('key')];
										table.reload();
									});
									_o.find('._sx').on('click', function () {
										var image = $(this).parents('td:eq(0)').find('img');
										K.P({
											type: 1,
											title: K.L('属性'),
											content: [
												'<div class="pk-row">',
												'<div class="pk-w-sm-6 pk-margin-bottom-10">',
												'<input type="text" class="pk-textbox w" placeholder="',
												K.L('宽度'),
												'" style="border-right:0">',
												'</div>',
												'<div class="pk-w-sm-6 pk-margin-bottom-10" style="border-left:solid 1px #eee">',
												'<input type="text" class="pk-textbox h" placeholder="',
												K.L('高度'),
												'" style="border-left:0">',
												'</div>',
												'<div class="pk-w-sm-6">',
												'<input type="text" class="pk-textbox alt" placeholder="',
												K.L('说明'),
												'" style="border-right:0">',
												'</div>',
												'<div class="pk-w-sm-6" style="border-left:solid 1px #eee">',
												'<select class="pk-textbox float" style="border-left:0">',
												'<option value="">',
												K.L('浮动方式'),
												'</option>',
												'<option value="left">',
												K.L('左'),
												'</option>',
												'<option value="right">',
												K.L('右'),
												'</option>',
												'</select>',
												'</div>',
												'</div>'
											].join(''),
											submit(_id, _v, _o) {
												var w = _o.find('.w').val(),
													h = _o.find('.h').val(),
													alt = _o.find('.alt').val(),
													float = _o.find('.float').val();
												if (!isNaN(w) && K.cnum(w)) {
													w += 'px';
												}
												if (!isNaN(h) && K.cnum(h)) {
													h += 'px';
												}
												var style = [
													w ? ';width:' + w : '',
													h ? ';height:' + h : '',
													float ? ';float:' + float : ''
												].join('');
												image.attr({
													alt
												}).data({
													style,
													width: w,
													height: h,
													float
												});
												var _il = K.editor.imagelist[id];
												for (var i in _il) {
													if (_il[i]['key'] == image.data('key')) {
														K.editor.imagelist[id][i]['alt'] = alt;
														K.editor.imagelist[id][i]['style'] = style;
														K.editor.imagelist[id][i]['width'] = w;
														K.editor.imagelist[id][i]['height'] = h;
														K.editor.imagelist[id][i]['float'] = float;
													}
												}
											},
											complete(_id, _o) {
												_o.find('.w').val(image.data('width') || '');
												_o.find('.h').val(image.data('height') || '');
												_o.find('.alt').val(image.attr('alt') || '');
												_o.find('.float').val(image.data('float') || '');
											}
										});
									});
								}
							});
							_o.find('._yctp').on('click', function () {
								K.P({
									type: 2,
									title: K.L('请输入远程图片地址'),
									submit(_id, _v) {
										if (!_v) {
											return false;
										}
										il.unshift({
											name: _v,
											url: _v,
											size: 0
										});
										K.editor.imagelist[id] = il;
										table.reload();
									}
								});
							});
							_o.find('._upload').on('click', function () {
								K.upload({
									accept: 'image/*',
									multiple: 1,
									success(rd) {
										if (!rd['code']) {
											K.alert(rd['msg'] || K.L('未知错误'), 2);
											return false;
										}
										rd = rd['data'];
										for (var i in rd) {
											var d = rd[i];
											if (!d['code']) {
												K.alert(d['msg'] || K.L('未知错误'), 2);
												console.log(JSON.stringify(d));
												return false;
											}
											d = d['data'];
											il.unshift({
												name: d['filename'] || d['filepath'],
												url: d['filepath'],
												size: d['filesize'] ? K.filesize_format(d['filesize']) : K.L('未知')
											});
										}
										K.editor.imagelist[id] = il;
										table.reload();
									}
								});
							});
							_o.find('.pk-popup-submit').html(K.L('插入'));
						}
					});
				},
				video() {
					K.P({
						type: 1,
						noclose: 1,
						title: K.L('视频'),
						content: [
							'<div class="pk-row">',
							'<div class="pk-w-sm-12" style="color:#777;margin-bottom:10px">',
							'<span class="pk-text-primary pk-cursor-pointer _btn" data-type="upload">',
							K.L('上传视频'),
							'</span>',
							'<span style="padding:0 10px">/</span>',
							'<span class="pk-cursor-pointer _btn" data-type="insert">',
							K.L('插入视频代码'),
							'</span>',
							'</div>',
							'<div class="pk-w-sm-12 _upload">',
							'<div class="pk-w-sm-12 pk-margin-bottom-10">',
							'<input type="text" name="url" class="pk-textbox" placeholder="',
							K.L('上传或远程地址'),
							'" autocomplete="off" />',
							'<button type="button" class="pk-btn pk-btn-primary _upbtn" style="position:absolute;top:0;right:0">',
							K.L('上传'),
							'</button>',
							'</div>',
							'<div class="pk-w-sm-4">',
							'<input type="text" name="width" class="pk-textbox" placeholder="',
							K.L('宽度'),
							'" />',
							'</div>',
							'<div class="pk-w-sm-4">',
							'<input type="text" name="height" class="pk-textbox" placeholder="',
							K.L('高度'),
							'" />',
							'</div>',
							'<div class="pk-w-sm-4">',
							'<select name="autoplay" class="pk-textbox">',
							'<option value="0">',
							K.L('默认'),
							'</option>',
							'<option value="1">',
							K.L('自动播放'),
							'</option>',
							'</select>',
							'</div>',
							'</div>',
							'<div class="pk-w-sm-12 _insert pk-hide">',
							'<textarea class="pk-textarea" name="code" style="resize:none;height:86px"></textarea>',
							'</div>',
							'</div>'
						].join(''),
						area: K.is_small_screen() ? ['100%', '100%'] : ['480px', '238px'],
						submit(_id, _v, _o) {
							var url = _o.find('[name="url"]').val(),
								w = _o.find('[name="width"]').val(),
								h = _o.find('[name="height"]').val(),
								ap = parseInt(_o.find('[name="autoplay"]').val()),
								code = _o.find('[name="code"]').val();
							if (_o.find('span._btn[data-type="upload"]').hasClass('pk-text-primary')) {
								if (!url) {
									K.msg(K.L('请上传或输入视频地址'), 0);
									return false;
								}
								code = [
									'<p><video src="',
									url,
									'" width="',
									w,
									'" height="',
									h,
									'"',
									ap ? ' autoplay' : '',
									' controls></video></p><p><br></p>'
								].join('');
							}
							if (!code) {
								K.msg(K.L('请输入视频代码'), 0);
								return false;
							}
							K.editor.commands[id].insert(code);
							K.close(_id);
						},
						complete(_id, _o) {
							_o.find('span._btn').on('click', function () {
								_o.find('span._btn').removeClass('pk-text-primary');
								$(this).addClass('pk-text-primary');
								_o.find('._insert,._upload').addClass('pk-hide');
								_o.find('._' + $(this).data('type')).removeClass('pk-hide');
							});
							_o.find('._upbtn').on('click', function () {
								K.upload({
									accept: 'video/*',
									// multiple: 1,
									success(rd) {
										if (!rd['code']) {
											K.alert(rd['msg'] || K.L('未知错误'), 2);
											return false;
										}
										rd = rd['data'];
										for (var i in rd) {
											var d = rd[i];
											if (!d['code']) {
												K.alert(d['msg'] || K.L('未知错误'), 2);
												console.log(JSON.stringify(d));
												return false;
											}
											d = d['data'];
										}
										_o.find('[name="url"]').val(d['filepath']);
									}
								});
							});
							_o.find('.pk-popup-submit').html(K.L('插入'));
						}
					});
				},
				music() {
					K.P({
						type: 1,
						noclose: 1,
						title: K.L('音乐'),
						content: [
							'<div class="pk-row">',
							'<div class="pk-w-sm-12" style="color:#777;margin-bottom:10px">',
							'<span class="pk-text-primary pk-cursor-pointer _btn" data-type="upload">',
							K.L('上传音乐'),
							'</span>',
							'<span style="padding:0 10px">/</span>',
							'<span class="pk-cursor-pointer _btn" data-type="insert">',
							K.L('插入音乐代码'),
							'</span>',
							'</div>',
							'<div class="pk-w-sm-12 _upload">',
							'<div class="pk-w-sm-12 pk-margin-bottom-10">',
							'<input type="text" name="url" class="pk-textbox" placeholder="',
							K.L('上传或远程地址'),
							'" autocomplete="off" />',
							'<button type="button" class="pk-btn pk-btn-primary _upbtn" style="position:absolute;top:0;right:0">',
							K.L('上传'),
							'</button>',
							'</div>',
							'<div class="pk-w-sm-4 pk-text-center">',
							'<input type="checkbox" name="loop" title="',
							K.L('循环播放'),
							'" />',
							'</div>',
							'<div class="pk-w-sm-4 pk-text-center">',
							'<input type="checkbox" name="muted" title="',
							K.L('静音播放'),
							'" />',
							'</div>',
							'<div class="pk-w-sm-4 pk-text-center">',
							'<input type="checkbox" name="autoplay" title="',
							K.L('自动播放'),
							'" />',
							'</div>',
							'</div>',
							'<div class="pk-w-sm-12 _insert pk-hide">',
							'<textarea class="pk-textarea" name="code" style="resize:none;height:86px"></textarea>',
							'</div>',
							'</div>'
						].join(''),
						area: K.is_small_screen() ? ['100%', '100%'] : ['480px', '238px'],
						submit(_id, _v, _o) {
							var url = _o.find('[name="url"]').val(),
								m = _o.find('[name="muted"]').prop('checked') ? 1 : 0,
								l = _o.find('[name="loop"]').prop('checked') ? 1 : 0,
								ap = _o.find('[name="autoplay"]').prop('checked') ? 1 : 0,
								code = _o.find('[name="code"]').val();
							if (_o.find('span._btn[data-type="upload"]').hasClass('pk-text-primary')) {
								if (!url) {
									K.msg(K.L('请上传或输入音乐地址'), 0);
									return false;
								}
								code = [
									'<p><audio src="',
									url,
									'"',
									m ? ' muted' : '',
									l ? ' loop' : '',
									ap ? ' autoplay' : '',
									' controls></audio></p><p><br></p>'
								].join('');
							}
							if (!code) {
								K.msg(K.L('请输入音乐代码'), 0);
								return false;
							}
							K.editor.commands[id].insert(code);
							K.close(_id);
						},
						complete(_id, _o) {
							_o.find('span._btn').on('click', function () {
								_o.find('span._btn').removeClass('pk-text-primary');
								$(this).addClass('pk-text-primary');
								_o.find('._insert,._upload').addClass('pk-hide');
								_o.find('._' + $(this).data('type')).removeClass('pk-hide');
							});
							_o.find('._upbtn').on('click', function () {
								K.upload({
									accept: 'audio/*',
									// multiple: 1,
									success(rd) {
										if (!rd['code']) {
											K.alert(rd['msg'] || K.L('未知错误'), 2);
											return false;
										}
										rd = rd['data'];
										for (var i in rd) {
											var d = rd[i];
											if (!d['code']) {
												K.alert(d['msg'] || K.L('未知错误'), 2);
												console.log(JSON.stringify(d));
												return false;
											}
											d = d['data'];
										}
										_o.find('[name="url"]').val(d['filepath']);
									}
								});
							});
							K.input2checkbox(_o.find('input[type="checkbox"]'));
							_o.find('.pk-popup-submit').html(K.L('插入'));
						}
					});
				},
				attachment() {
					K.P({
						type: 2,
						noclose: 1,
						title: K.L('附件'),
						submit(_id, _v, _o) {
							if (!_v) {
								K.msg(K.L('请上传或输入附件地址'), 0);
								return false;
							}
							K.editor.commands[id].link('', _v, '_blank', 1);
							K.close(_id);
						},
						complete(_id, _o) {
							_o.find('.pk-popup-input').attr({
								placeholder: K.L('上传或远程地址')
							}).parent().css({
								position: 'relative'
							}).append([
								'<button type="button" class="pk-btn pk-btn-primary _upbtn" style="position:absolute;top:10px;right:10px;height:36px">',
								K.L('上传'),
								'</button>'
							].join('')).find('._upbtn').on('click', function () {
								K.upload({
									accept: '*.*',
									// multiple: 1,
									success(rd) {
										if (!rd['code']) {
											K.alert(rd['msg'] || K.L('未知错误'), 2);
											return false;
										}
										rd = rd['data'];
										for (var i in rd) {
											var d = rd[i];
											if (!d['code']) {
												K.alert(d['msg'] || K.L('未知错误'), 2);
												console.log(JSON.stringify(d));
												return false;
											}
											d = d['data'];
										}
										_o.find('.pk-popup-input').val(d['filepath']);
									}
								});
							});
							_o.find('.pk-popup-submit').html(K.L('下一步'));
						}
					});
				},
				table() {
					return K.P({
						type: 1,
						noclose: 1,
						title: K.L('表格'),
						area: K.is_small_screen() ? ['100%', '100%'] : ['480px', 'auto'],
						content: [
							'<div class="pk-row">',
							'<div class="pk-w-sm-6 pk-margin-bottom-10" style="padding-left:70px">',
							'<span style="height:38px;width:70px;line-height:38px;text-align:right;position:absolute;top:0;left:0;padding-right:10px">',
							K.L('行数'),
							'</span>',
							'<input type="number" class="pk-textbox" name="hs" value="2" min="1" />',
							'</div>',
							'<div class="pk-w-sm-6 pk-margin-bottom-10" style="padding-left:70px">',
							'<span style="height:38px;width:70px;line-height:38px;text-align:right;position:absolute;top:0;left:0;padding-right:10px">',
							K.L('列数'),
							'</span>',
							'<input type="number" class="pk-textbox" name="ls" value="2" min="1" />',
							'</div>',
							'<div class="pk-w-sm-6" style="padding-left:70px">',
							'<span style="height:38px;width:70px;line-height:38px;text-align:right;position:absolute;top:0;left:0;padding-right:10px">',
							K.L('宽度'),
							'</span>',
							'<input type="text" class="pk-textbox" name="width" value="100%" />',
							'</div>',
							'<div class="pk-w-sm-6" style="padding-left:70px">',
							'<span style="height:38px;width:70px;line-height:38px;text-align:right;position:absolute;top:0;left:0;padding-right:10px">',
							K.L('边框'),
							'</span>',
							'<select class="pk-textbox" name="border">',
							'<option value="1">',
							K.L('有'),
							'</option>',
							'<option value="0">',
							K.L('无'),
							'</option>',
							'</select>',
							'</div>',
							'</div>'
						].join(''),
						submit(_id, _v, _o) {
							var hs = parseInt(_o.find('[name="hs"]').val()),
								ls = parseInt(_o.find('[name="ls"]').val()),
								width = _o.find('[name="width"]').val(),
								border = parseInt(_o.find('[name="border"]').val());
							if (!hs || !ls) {
								K.msg(K.L('行数或列数不能为0'), 0);
								return false;
							}
							var rnd = K.random_string();
							var html = '<p><br></p><table class="_' + rnd + ' pk-table' + (border ? ' pk-table-bordered' : '') + '">';
							for (var i = 0; i < hs; i++) {
								html += '<tr>';
								for (var j = 0; j < ls; j++) {
									html += '<td>' + (border ? '' : (j + 1)) + '</td>';
								}
								html += '</tr>';
							}
							html += '</table><p><br></p>';
							K.editor.commands[id].insert(html);
							K.close(_id);
							eo.find('table._' + rnd).removeClass('_' + rnd).on('dblclick', function (e) {
								if (e.which == 1) {
									var me = $(this);
									K.P({
										type: 1,
										icon: 3,
										content: K.L("是否删除当前表格"),
										submit() {
											me.remove();
										}
									});
								}
							});
						},
						complete(_id, _o) {
							_o.find('.pk-popup-submit').html(K.L('插入'));
						}
					});
				}
			};
			return K.editor.commands[id];
		},
		/**
		 * 初始化编辑器
		 * @param {*} selector 待实例化的对象，一般为textarea控件或标识
		 * @param {*} options {div2p,width,height,css,style,tools}
		 * {
		 * div2p:true, // 将div标签转为p标签，默认开启
		 * width,
		 * height,
		 * css // css文件,
		 * style // style样式代码,
		 * tools: 1/["source","code",]/[{name:"",title:"",image:"",html:"",click:function(editor),class:"",style:""},] // 工具栏
		 * }
		 * @returns {object}
		 */
		init(selector, options = { tools: 1 }) {
			var id = '_' + K.random_string(7);
			var obj = $(selector);
			if (!obj.length) {
				return false;
			}
			var val = $(obj).hide().after([
				'<div id="',
				id,
				'" class="pk-editor">',
				'<div></div>',
				'<iframe></iframe>',
				'<textarea></textarea>',
				'</div>'
			].join('')).val();
			// console.log(val);
			var e_o = $('#' + id),
				c_o_w = e_o.find('iframe')[0].contentWindow;
			if (!c_o_w) {
				return false;
			}
			var c_o_d = c_o_w['contentDocument'] || c_o_w.document,
				height = options.height || 268,
				width = options.width || '100%',
				tools = options.tools || '',
				css_list = options.css || '',
				style_html = options.style || '',
				div2p = options.div2p || true;
			style_html = [
				'body{word-break:break-all;overflow-y:auto;overflow-x:hidden;padding:0;margin:0;width:100%;height:100%;font-size:14px}',
				'a{color:#0374D5}',
				'a:hover{text-decoration:underline}',
				'img{max-width:100%}',
				'pre,code{box-sizing:border-box;display:block;width:100%;border:0;background-color:#f8f8f8;padding:.5em 1em;box-shadow:inset 5px 0 1px #eee;font-size:13px;line-height:1.5;display:block;font-family:"Consolas","Monaco","Bitstream Vera Sans Mono","Courier New","Courier","monospace";white-space:pre-wrap;word-break:break-all;border-radius:1px;color:#222}',
				'table{border-collapse:collapse;border-spacing:0}',
				'.pk-table{width:100%;background-color:#fff;color:#666}',
				'.pk-table thead,.pk-table tbody,.pk-table tfoot{vertical-align:middle;border-color:inherit}',
				'.pk-table tr{display:table-row;transition:all .3s;vertical-align:inherit;border-color:inherit}',
				'.pk-table tr:hover{background-color:#F7F7F7}',
				'.pk-table tr td,.pk-table tr th{position:relative;padding:9px 15px;min-height:20px;line-height:20px;font-size:14px;text-align:left}',
				'.pk-table.pk-table-bordered{border:1px solid #e6e6e6}',
				'.pk-table.pk-table-bordered tr th{border:1px solid #e6e6e6;background-color:#f2f2f2}',
				'.pk-table.pk-table-bordered tr td{border:solid 1px #e6e6e6}'
			].join('') + style_html;
			if (css_list && typeof (css_list) == "string") {
				css_list = css_list.split(',');
			}
			var _c_l = '';
			for (var i in css_list) {
				_c_l += '<link rel="stylesheet" href="' + css_list[i] + '">';
			}
			css_list = _c_l;
			c_o_d.write([
				'<!DOCTYPE html>',
				'<html style="height:100%">',
				'<head>',
				'<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">',
				'<meta name="renderer" content="webkit">',
				'<meta name="viewport" content="width=device-width,initial-scale=1,maximum-scale=1,user-scalable=no">',
				'<title>puyuetianEditor</title>',
				css_list,
				'<style>',
				style_html,
				'</style>',
				'</head>',
				'<body id="',
				id,
				'">',
				val,
				'</body>',
				'</html>'
			].join(''));
			c_o_d.close();
			$(c_o_d).find('body').prop({
				spellcheck: false,
				contenteditable: true
			});

			e_o.find('>textarea').hide();
			e_o.find('>textarea,>iframe').css({
				width,
				height
			});

			// 工具栏初始化
			// [{name:"",title:"",image:"",click:"",class:"",style:"",html:""}]
			K.editor.clicks[id] = {};
			// name 加载哪里工具
			// r 是否返回工具列表，若为true则返回工具列表字符串
			var tools_func = function (name, r = 0) {
				var s = {
					source: K.L('源码'),
					bold: K.L('粗体'),
					italic: K.L('斜体'),
					underline: K.L('下划线'),
					strikethrough: K.L('删除线'),
					fontname: K.L('字体'),
					fontsize: K.L('字体大小'),
					forecolor: K.L('字体颜色'),
					backcolor: K.L('字体背景'),
					justifyleft: K.L('居左'),
					justifycenter: K.L('居中'),
					justifyright: K.L('居右'),
					link: K.L('链接'),
					unlink: K.L('取消链接'),
					table: K.L('表格'),
					image: K.L('图片'),
					attachment: K.L('附件'),
					video: K.L('视频'),
					music: K.L('音乐'),
					code: K.L('代码'),
					undo: K.L('撤销'),
					redo: K.L('重复')
				};
				if (r) {
					var h = [];
					for (var i in s) {
						h.push(i);
					}
					return h;
				}
				if (!s[name]) {
					s[name] = 'notfound';
				}
				var f = {
					name,
					html: s[name]['html'] || '',
					title: s[name]['title'] || s[name],
					click: s[name]['click'] || function (e) {
						if (typeof (e[name]) != "function") {
							console.log("undefined " + name + "() function");
						} else {
							e[name]();
						}
					}
				};
				return f;
			};
			if (!tools) {
				e_o.find('>div').hide();
			} else {
				if (tools === true || tools === 1) {
					tools = tools_func(0, 1);
				}
				for (var k in tools) {
					if (typeof (tools[k]) == "string") {
						tools[k] = tools_func(tools[k]);
					}
					var style = tools[k].style || '';
					if (tools[k].image) {
						style = 'background-image:url(' + tools[k].image + ');' + style;
					}
					var html = tools[k].html || [
						'<span name="',
						tools[k].name,
						'" title="',
						tools[k].title || '',
						'" class="',
						tools[k].class || '',
						'" style="',
						style,
						'"></span>'
					].join('');
					if (tools[k].click) {
						K.editor.clicks[id][tools[k]['name']] = tools[k].click;
					}
					e_o.find('>div').append(html).find('>*:last').on('click', function () {
						var id = $(this).parents('div.pk-editor:eq(0)').attr('id'),
							name = $(this).attr('name') || '';
						K.editor.clicks[id][name](K.editor.commands[id]);
					});
				}
			}

			// 自动更新数据
			var _editor_setInterval = setInterval(function () {
				if (!$('#' + id).length) {
					console.log('K.editor[' + id + ']对象已被移除');
					clearInterval(_editor_setInterval);
					return false;
				} else {
					var editorVal = K.editor.commands[id].val();
					var newEditorVal = editorVal;
					if (div2p) {
						// div转为p
						newEditorVal = K.str_replace(['<div', '</div>'], ['<p', '</p>'], editorVal);
					}
					if ($(selector).val() != editorVal && $(selector).val() != newEditorVal) {
						$(selector).val(newEditorVal);
					}
				}
			}, 200);

			// K.editor.do(id)为首次初始化编辑器方法，每个编辑器只需要调用一次
			return K.editor.do(id, selector);
		}
	},
	/**
	 * keditor 编辑器调用
	 * @param {object|string} selector textarea控件对象或选择器字符串
	 * @param {object} options {image,maxLength,uploadCount,height}
	 * options = {
	 * image,		//是否允许上传图片
	 * maxLength,	//最大允许输入的文字数
	 * uploadCount,	//一次最大上传的图片数
	 * height		//编辑器高度,0为继承textarea控件高度
	 * }
	 * @returns {boolean|object}
	 */
	keditor(selector, options = {}) {
		if (!$(selector).length) {
			return false;
		}
		// 配置初始化
		options.image = options.image || true;
		options.maxLength = options.maxLength || 1000;
		options.uploadCount = options.uploadCount || 9;
		options.height = options.height || 0;
		// 只拿取第一个
		var obj = $($(selector)[0]),
			id = '_' + K.random_string(32),
			html = [
				'<div id="',
				id,
				'" class="pk-keditor">',
				'<div class="pk-keditor-content">',
				'<textarea style="height:',
				options['height'] ? options['height'] : obj.outerHeight(),
				'px"></textarea>',
				'<span><i>0</i>',
				(K.cnum(options['maxLength']) ? ' / ' + options['maxLength'] : ''),
				'</span></div>',
				'<div class="pk-keditor-images ',
				options['image'] ? '' : 'pk-hide',
				'">',
				'<div class="pk-keditor-image-addbtn">',
				'<div style="background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAYAAABXAvmHAAAC8UlEQVRoQ+2aUXLaMBCGdw3itekJSk7Q9ARNTlBu0PQEhQek4SnpEyP5gfQG6QnSnKBwgpITlN4gfcVjb2cZk3EcWzKMDCaDHrE03k//ane1BuHABx64/fC6AMIwvDoARWbD4XC6tvOZAsYYajoAEX1TSl1bAYjoAREfGwbTBYB3lQAQ8SIrUxNAtNbXiHh1BNiXGkcF1js/mUxOoiiaAMBl+huHtIGUcl6nOt4U0FrPEfF9zthHIcTpYDCoLXJ5AdBa9xDxrmin89GhqhrGmDMhxMIF7wtgFcpKAH4opdZuVcn+1B1/AcB3KeWtbZEvAK8KGGN+AsAnALiXUvZqB+AXFJ0BIvrX6XS6LjfIGqi17iMiB4PVEEK8ta33ogC/iGVfLpc3iPg5ffd9HMf90Wi0qOQ3ABCG4TkRsetkxxebG3kDqGpk2bzU7/8AwElujtWNGgNgjOG88bEI0OZGjQAwxtwAwFeLiqVutHcAWw7JAJW6Ue0A7NtlUYSTFQDwoc37/QsxytyoVgA2kIjukiS5yEejTLJiCNeYCSF6RRtRG0B2d4noRTbWWt9mQq4NYPdhtMg1sre5fLIqs74IPD/XuwIWv55LKT+kz3+7fIafx3F86kqEXgFch5IrU0TkcOk8tAAwk1Keu0C9AbiMdxmSf161DPcCYCkDNrX7af7OADYMh5WBdgLg0/i0abYgotUdOgiCabYHtS438r2pNJP3AaCfvX8Xthaziz0aX6nsXhd7VZWxAvgynogGSiku5JzDG0C73Z5HUcT1S5USwGaY87qYXewNYF+90SMAy7mL7jTXSUEQvClIbNya4Vb6FBGfPmSs5yVJ8qCU4m7GajijkPPUbTFhPB53W60W34u3Gc9Kj70AsNWsQFGthIisAH/ImLEKBYTzvStg2/bjId7VIS5TwYsCXG8AQG39/jiO/5ZdYHwBbBMdNlpTFqoPAoCbwUmSnBWpwNUoEV0GQdCrUg28rr8abOQDDZl88Ar8BxoGMV59yr4NAAAAAElFTkSuQmCC);background-repeat:no-repeat;background-position:center center"></div>',
				'<input type="file" class="pk-hide" multiple accept="image/*">',
				'</div>',
				'</div>',
				'</div>'
			].join('');
		obj.addClass('pk-hide').after(html);
		// 绑定相关事件
		var editor = $('#' + id);
		// 图片查看器对象
		var viewer = K.viewer(editor.find('div.pk-keditor-images'));
		// 样式调整
		var height = editor.find('div.pk-keditor-images>div:eq(0)').outerWidth() || 0;
		editor.find('div.pk-keditor-images>div').outerHeight(height);
		// 上传图片按钮
		editor.find('.pk-keditor-image-addbtn>div').on('click', function () {
			$(this).next('input').trigger('click');
		});
		editor.find('.pk-keditor-image-addbtn>input').on('change', function () {
			K.upload({
				file: this,
				multiple: 1,
				success: function (data) {
					if (!data['code']) {
						K.alert(data['msg'] || K.L('未知错误'), 2);
						return false;
					}
					data = data['data'];
					for (var i = 0; i < data.length; i++) {
						if (data[i]['code']) {
							var _id = '_' + K.random_string();
							editor.find('div.pk-keditor-image-addbtn').before([
								'<div id="',
								_id,
								'" style="height:',
								height,
								'px">',
								'<img src="',
								data[i]['data']['filepath'],
								'"><span>&times;</span></div>'
							].join(''));
							// 绑定看图事件
							viewer['destroy']();
							setTimeout(function () {
								viewer = K.viewer(editor.find('div.pk-keditor-images'));
							}, 200);
							// 绑定删除事件
							$('#' + _id).find('span').on('click', function () {
								var This = $(this);
								K.confirm(K.L('确认删除该图片') + '?', function () {
									This.parent().remove();
								});
							});
							// 自动保存一下
							editor.find('.pk-keditor-content textarea').trigger('change');
						}
					}
					//console.log(data);
				}
			});
		});
		// 自动保存
		editor.find('.pk-keditor-content textarea').on({
			'input change propertychange': function () {
				var val = $(this).val() || '',
					ysr = editor.find('.pk-keditor-content>span>i');
				val = val.toString();
				ysr.parent().css('color', '#777');
				if (K.cnum(options['maxLength']) && val.length > options['maxLength']) {
					val = val.substring(0, options['maxLength']);
					$(this).val(val);
					ysr.parent().css('color', '#f00');
				}
				editor.find('.pk-keditor-content>span>i').html('' + val.length);
				val = '<p>' + val + '</p>';
				// 追加图片
				var srcs = editor.find('div.pk-keditor-images>div>img');
				for (var i = 0; i < srcs.length; i++) {
					val += '<img alt="phoneimage" src="' + $(srcs[i]).attr('src') + '" />';
				}
				obj.val(val);
			}
		});
		return editor;
	},
	/**
	 * 文件大小格式化
	 * @param {string|number} filesize 文件大小
	 * @param {string} input_unit
	 * @param {string} output_unit
	 */
	filesize_format(filesize, input_unit = '', output_unit = '') {
		filesize = filesize.toString();
		filesize = filesize.toLowerCase();
		// 将输入转为b
		var filesize2 = K.cnum(filesize);
		if (!input_unit || input_unit == 'auto') {
			if (filesize.indexOf('k') > -1 || filesize.indexOf('kb') > -1) {
				filesize = filesize2 * 1024;
			} else if (filesize.indexOf('m') > -1 || filesize.indexOf('mb') > -1) {
				filesize = filesize2 * 1024 * 1024;
			} else if (filesize.indexOf('g') > -1 || filesize.indexOf('gb') > -1) {
				filesize = filesize2 * 1024 * 1024 * 1024;
			} else if (filesize.indexOf('t') > -1 || filesize.indexOf('tb') > -1) {
				filesize = filesize2 * 1024 * 1024 * 1024 * 1024;
			} else {
				filesize = filesize2;
			}
		} else {
			if (input_unit == 'k' || input_unit == 'kb') {
				filesize = filesize2 * 1024;
			} else if (input_unit == 'm' || input_unit == 'mb') {
				filesize = filesize2 * 1024 * 1024;
			} else if (input_unit == 'g' || input_unit == 'gb') {
				filesize = filesize2 * 1024 * 1024 * 1024;
			} else if (input_unit == 't' || input_unit == 'tb') {
				filesize = filesize2 * 1024 * 1024 * 1024 * 1024;
			} else {
				filesize = filesize2;
			}
		}
		// 转换单位
		var init = 'B';
		if (!output_unit || output_unit == 'auto') {
			if (filesize2 > 1024 * 1024 * 1024 * 1024) {
				init = 'TB';
				filesize = filesize2 / 1024 / 1024 / 1024 / 1024;
			} else if (filesize2 > 1024 * 1024 * 1024) {
				init = 'GB';
				filesize = filesize2 / 1024 / 1024 / 1024;
			} else if (filesize2 > 1024 * 1024) {
				init = 'MB';
				filesize = filesize2 / 1024 / 1024;
			} else if (filesize2 > 1024) {
				init = 'KB';
				filesize = filesize2 / 1024;
			}
		} else {
			if (output_unit == 't' || output_unit == 'tb') {
				init = 'TB';
				filesize = filesize2 / 1024 / 1024 / 1024 / 1024;
			} else if (output_unit == 'g' || output_unit == 'gb') {
				init = 'GB';
				filesize = filesize2 / 1024 / 1024 / 1024;
			} else if (output_unit == 'm' || output_unit == 'mb') {
				init = 'MB';
				filesize = filesize2 / 1024 / 1024;
			} else if (output_unit == 'k' || output_unit == 'kb') {
				init = 'KB';
				filesize = filesize2 / 1024;
			}
		}
		filesize = parseFloat(filesize + '');
		return filesize.toFixed(2) + init;
	},
	/**
	 * 视频播放控件
	 * @param {object|string} options {selector,src,controls,autoplay,preload,width,height,style,class,title} 若为字符串则为src属性，参数对应video标签属性，具体参考video标签用法
	 * selector		// 为视频控件所在的容器，若为空则弹出播放界面
	 * src,			// 视频地址
	 * autoplay,	// 是否自动播放
	 * title,		// 弹窗模式时的标题
	 * ...
	 * @returns {*}
	 */
	playvideo(options = {}) {
		if (typeof (options) == "string") {
			options = {
				src: options
			};
		}
		if (!options.src) {
			console.log('出错：视频地址不能为空');
			return false;
		}
		if (typeof (options.controls) == "undefined") {
			options.controls = true;
		}
		if (!options.controls) {
			delete options.controls;
		}
		if (typeof (options.autoplay) != "undefined" && !options.autoplay) {
			delete options.autoplay;
		}
		var selector = options.selector || false;
		if (!options.width) {
			options.width = $(selector).width() || '100%';
		}
		if (!options.height) {
			options.height = $(selector).height() || '100%';
		}
		options.preload = options.preload || 'metadata';
		options.style = options.style || 'background-color:#333';
		if (!selector) {
			var id = '_' + K.random_string(32),
				_tmpstyle_h = $('html').css('overflow-y'),
				_tmpstyle_b = $('body').css('overflow-y');
			return K.P({
				area: ['100%', '100%'],
				nomove: 1,
				title: options.title || options.src,
				content: [
					'<div class="pk-row" style="height:100%"><div id="',
					id,
					'" class="pk-w-sm-12" style="height:100%"></div></div>'
				].join(''),
				complete: function (_id, o) {
					o.find('.pk-popup-body,body').css('overflow-y', 'hidden');
					var h1 = o.find('.pk-popup-foot').outerHeight(),
						h2 = o.find('.pk-popup-body').outerHeight();
					o.find('.pk-popup-foot').remove();
					o.find('.pk-popup-body').css({
						height: (h1 + h2) + 'px',
						maxHeight: (h1 + h2) + 'px'
					});
					options.preload = 'auto';
					options.selector = '#' + id;
					K.playvideo(options);
				},
				close: function () {
					$('html').css('overflow-y', _tmpstyle_h);
					$('body').css('overflow-y', _tmpstyle_b);
				}
			});
		}
		selector = $(selector);
		var html = '',
			options_html = '',
			error_html = [
				'<table style="width:100%;height:100%;text-align:center;font-size:12px;color:#777">',
				'<tr><td style="width:100%;height:100%;vertical-align:middle;background-color:#f8f8f8">',
				'<p style="margin-bottom:15px;font-size:16px">',
				K.L('出错'),
				'</p>',
				'<p style="margin-bottom:5px">[currentSrc]</p>',
				'<p>[error]</p>',
				'</td></tr>',
				'</table>'
			].join('');
		for (var k in options) {
			if (k == 'selector') {
				continue;
			}
			options_html += ' ' + k + '="' + options[k] + '"';
		}
		html = [
			'<video' + options_html + '>',
			'<source src="' + options.src + '" type="video/mp4">',
			'<source src="' + options.src + '" type="video/ogg">',
			'<source src="' + options.src + '" type="video/webm">',
			'<object data="' + options.src + '" width="' + options.width + '" height="' + options.height + '">',
			'<embed src="' + options.src + '" width="' + options.width + '" height="' + options.height + '">',
			'</object>',
			'</video>'
		].join('');
		return selector.html(html).find('video').on({
			error: function (e) {
				var currentSrc = e.target.currentSrc,
					error = [
						'{code: ',
						e.target.error.code,
						', message: "',
						e.target.error.message,
						'"}'
					].join('');
				selector.html(
					K.str_replace(
						['[currentSrc]', '[error]'],
						[currentSrc, error],
						error_html
					)
				);
			}
		});
	},
	/**
	 * 代码编辑器
	 * @param {object|string} selector 待实例化的对象或标识
	 * @param {object} options {width,height,mode,lineWrapping,lineNumbers,firstLineNumber,indentWithTabs,smartIndent,matchBrackets,autofocus,readOnly,showCursorWhenSelecting,success}
	 * // width						宽度，默认遵从textarea
	 * // height					高度，默认遵从textarea
	 * // mode						代码类型，默认php
	 * // lineWrapping				换行，默认ture
	 * // lineNumbers				显示行号，默认ture
	 * // firstLineNumber			第一个编号开始数字，默认1
	 * // indentWithTabs			tab键为几个空格，默认4
	 * // smartIndent				智能缩进，默认true
	 * // matchBrackets				自动匹配括号，默认true
	 * // autofocus					自动聚焦，默认false
	 * // readOnly					只读，默认false
	 * // showCursorWhenSelecting	显示选中的文本，默认ture
	 * // success					初始化完成后执行
	 * @returns {boolean}
	 */
	codemirror(selector, options = {}) {
		if (!$(selector).length) {
			return false;
		}
		options.width = options.width || false;
		options.height = options.height || false;
		options.mode = options.mode || 'php';
		if (typeof (options.lineWrapping) == "undefined") {
			options.lineWrapping = true;
		}
		if (typeof (options.lineNumbers) == "undefined") {
			options.lineNumbers = true;
		}
		if (typeof (options.smartIndent) == "undefined") {
			options.smartIndent = true;
		}
		if (typeof (options.matchBrackets) == "undefined") {
			options.matchBrackets = true;
		}
		if (typeof (options.showCursorWhenSelecting) == "undefined") {
			options.showCursorWhenSelecting = true;
		}
		options.firstLineNumber = options.firstLineNumber || 1;
		options.indentWithTabs = options.indentWithTabs || 4;
		options.autofocus = options.autofocus || false;
		options.readOnly = options.readOnly || false;
		var _init = function (selector, options) {
			var o = $(selector);
			var editors = [];
			for (var i = 0; i < o.length; i++) {
				if ($(o[i]).data('pk-codemirror-object')) {
					continue;
				}
				if (!window['CodeMirror']) {
					return false;
				}
				$(o[i]).data('pk-codemirror-object', true);
				editors[i] = window['CodeMirror']['fromTextArea'](o[i], options);
				var w = options.width || $(o[i]).outerWidth(),
					h = options.height || $(o[i]).outerHeight();
				editors[i].setSize(w, h);
				if (typeof (options.success) == "function") {
					options.success(editors);
				}
			}
			setInterval(function () {
				for (var i = 0; i < o.length; i++) {
					editors[i] && $(o[i]).val(editors[i].getValue());
				}
			}, 200);
		};
		K.require_once(K.basePath + '../css/codemirror.min.css,' + K.basePath + 'codemirror.min.js', function () {
			_init(selector, options);
		}, window['CodeMirror']);
		return true;
	},
	/**
	 * swiper轮播图控件，具体用法参考swiper官网
	 * @param {object|string} selector 待实例化的对象或标识
	 * @param {object} options {...,success}
	 * // success(myswiper) 成功执行后执行
	 * @returns {boolean}
	 */
	swiper(selector, options) {
		K.require_once(K.basePath + '../css/swiper.min.css,' + K.basePath + 'swiper.min.js', function () {
			var mySwiper = new window['Swiper'](selector, options);
			if (typeof (options.success) == "function") {
				options.success(mySwiper);
			}
		}, window['Swiper']);
		return true;
	},
	/**
	 * 地区选择器3级联动
	 * @param {object|string} selector 要生成的dom对象（在该对象内生成），若不存在弹出选择框
	 * @param {object} options {level,names:{},complete,title,submit}，该值也可在dom option属性处设置
	 * level:1-4(1省，2省，市，3省，市，县，4省市县地址)
	 * names:{province:{name:"",value:""},city:{name,value},county:{name,value},address:{name,value}}
	 * complete(selector)/success(selector):加载完后的回调函数，obj对象
	 * title:仅弹出框下有效，标题
	 * submit(data):仅弹出框下有效，用户点击确认按钮调用
	 * @returns
	 */
	ssx(selector, options) {
		selector = $(selector);
		var option = options || {};
		option.complete = option.success || option.complete;
		if (!selector.length) {
			var id = '_' + K.random_string(32);
			return K.P({
				area: K.is_small_screen() ? ['80%', 'auto'] : ['420px', 'auto'],
				nomove: 1,
				title: option.title || K.L('请选择'),
				content: '<div id="' + id + '"></div>',
				complete: function (_id, _o) {
					K.ssx('#' + id, options);
				},
				submit: function (_id, _v, _o) {
					var data = K.formdata2array(_o);
					if (typeof (option.submit) == "function") {
						option.submit(data);
					}
				}
			});
		}
		if (selector.data('option') || selector.data('options')) {
			option = selector.data('option') || selector.data('options');
		}
		option.level = K.cnum(option.level) || 4;
		option.names = option.names || {};
		option.names['province'] = option.names['province'] || {};
		option.names['city'] = option.names['city'] || {};
		option.names['county'] = option.names['county'] || {};
		option.names['address'] = option.names['address'] || {};
		var _do = function (selector, option) {
			var id = '_' + K.random_string(7),
				names = option.names,
				html = '<div id="' + id + '" class="pk-row"><div class="pk-w-sm-12">',
				i = 0;
			for (var key in names) {
				if (i >= option.level) {
					break;
				}
				if (i < 3) {
					// 写入省，市，县
					html += [
						'<div class="pk-w-sm-4" style="padding:0 5px">',
						'<select class="pk-textbox _',
						key,
						'" name="',
						names[key]['name'] || key,
						'"></select>',
						'</div>'
					].join('');
				} else {
					html += [
						'<div class="pk-w-sm-12" style="padding:0 5px;padding-top:10px">',
						'<input class="pk-textbox _',
						key,
						'" name="',
						names[key]['name'] || key,
						'"',
						' placeholder="',
						K.L('详细地址'),
						'" />',
						'</div>'
					].join('');
				}
				i++;
			}
			html += '</div></div>';
			selector.append(html);
			var ssx = K.SSX,
				obj = $('#' + id),
				province = obj.find('select._province'),
				city = obj.find('select._city'),
				county = obj.find('select._county'),
				address = obj.find('select._address');
			province.append('<option value="">' + K.L('省份') + '</option>');
			city.append('<option value="">' + K.L('城市') + '</option>');
			county.append('<option value=""' + K.L('区县') + '</option>');
			address.val(names['address']['value'] || '');
			for (var k in ssx) {
				province.append([
					'<option value="',
					ssx[k]['name'],
					'" data-data="',
					K.htmlspecialchars(JSON.stringify(ssx[k]['city'])),
					'">',
					ssx[k]['name'],
					'</option>'
				].join(''));
			}
			// 绑定事件选择器
			province.on('change', function () {
				var me = $(this);
				var cityList = me.find('option[value="' + me.val() + '"]').data('data');
				city.html('<option value="">' + K.L('城市') + '</option>').off('change');
				county.html('<option value="">' + K.L('区县') + '</option>');
				for (k in cityList) {
					city.append([
						'<option value="',
						cityList[k]['name'],
						'" data-data="',
						K.htmlspecialchars(JSON.stringify(cityList[k]['area'])),
						'">',
						cityList[k]['name'],
						'</option>'
					].join(''));
				}
				city.on('change', function () {
					var me2 = $(this);
					var countyList = me2.find('option[value="' + me2.val() + '"]').data('data');
					county.html('<option value="">' + K.L('区县') + '</option>');
					for (k in countyList) {
						county.append([
							'<option value="',
							countyList[k],
							'">',
							countyList[k],
							'</option>'
						].join(''));
					}
				});
			});
			// 初始值设置
			for (var key in names) {
				var o = obj.find('select._' + key);
				if (o.length) {
					o.val(names[key]['value']).trigger('change');
				} else {
					obj.find('input._' + key).val(names[key]['value']);
				}
			}
			if (typeof (option['complete']) == "function") {
				option['complete'](obj);
			}
			return selector;
		};
		K.require_once(K.basePath + 'puyuetian.ssx.min.js', function () {
			_do(selector, option);
		}, K.SSX);
		return true;
	},
	/**
	 * K.popup 弹出框
	  var pid = K.P({
		type: false, //alert|0提示框（默认），confirm|1确认框，input|2输入框，tip|3提示框，load|4加载框pk521|5自定义
		title: false, //提示框的标题，默认值为“信息”
		content: '你好世界', //提示框的内容
		area: false, //面积及位置，格式举例["100%","500px","20%","0","0","35%"]，[宽,高,上,右,下,左]，默自适应
		extclass: false, //自定义的class样式，字符串类型，默认无
		shade/mask: false, //是否显示遮挡层，false不显示（默认），true显示
		noclose: false, //点击确认后是否自动关闭提示框，true不关闭，false关闭（默认）
		nomove:false, //是关闭拖动，true关闭（默认），false开启
		nofixedmove:false, //是否关闭限制拖动范围，true关闭，false开启（默认）
		inputtype: false, //input|1单行（默认），textarea|2多行
		hideclose: false, //是否隐藏右上方的关闭按钮，true隐藏，false不隐藏（默认）
		times: false, //提示框显示的时间，毫秒，默认值2000，0为不自动关闭
		icon: false, //提示框和确认框是否显示图标，默认不显示，0信息，1成功，2失败，3疑问
		btnshtml: false, //自定义的按钮，仅在type为自定义时有用，举例：<a href="#">按钮</a>
		nohead: false, // 是否显示弹窗头，包含：标题和关闭按钮，默认显示
		nofoot: false, // 是否显示弹窗脚，包含：确认/取消按钮，默认显示
		submit: function(id, value, obj) {
			//id为弹出框的id编号，为数字，若id=1，则弹出框的id="pkpopup_1"，遮挡层id="pkpopup_1_shade"
			//仅下方type起作用
			//confirm框，确认后回调的函数
			//input框，输入后回调的函数，value为输入的值
		},
		cancel: function(id, obj) {
			//关闭或取消后调用的函数
		},
		close: function(id) {
			//关闭或取消后调用的函数
		},
		complete: function(id, obj) {
			//提示框弹出后调用的函数，一般用于自定义按钮的事件定义
		}
	});
	//关闭已开的弹出框，未指定id则关闭所有
	//K.close(id)
	 *
	 */
	popup: {
		pid: 0,
		speed: 300,
		popup(data) {
			var InArray = function (haystack, needle) {
				return K.in_array(needle, haystack);
			};
			var Cnum = function (int, r, isint, min) {
				return K.cnum(int, r, isint, min);
			};
			this.pid++;
			var _id = "pkpopup_" + this.pid,
				html = '',
				btnshtml = '';
			// 简单的提示框
			if (['string', 'number'].indexOf(typeof (data)) > -1) {
				data = {
					content: data
				};
			}
			// 判断数据是否合法
			if (typeof (data) != "object") {
				return false;
			}
			data.nomove = K.isset(data.nomove) ? data.nomove : 1;
			// 判断提示框的类型
			data['type'] = data['type'] || 0;
			if (InArray('alert,0', data.type)) {
				btnshtml = '<a class="pk-popup-submit" href="javascript:;">' + (data.ok_text || K.L('确定')) + '</a>';
			} else if (InArray('confirm,input,1,2', data.type)) {
				if (InArray('input,2', data.type)) {
					if (typeof (data.content) == "undefined") {
						data['content'] = '';
					}
					if (InArray('textarea,2', data.inputtype)) {
						data.content = [
							'<textarea class="pk-popup-input" style="height:136px;border-radius:4px;resize:none">',
							data.content,
							'</textarea>'
						].join('');
					} else {
						data.content = '<input type="text" class="pk-popup-input" value="' + data.content + '">';
					}
				}
				btnshtml = [
					'<a class="pk-popup-submit" href="javascript:;" style="margin-right:10px">',
					data.ok_text || K.L('确定'),
					'</a><a class="pk-popup-cancel" href="javascript:;">',
					data.no_text || K.L('取消'),
					'</a>'
				].join('');
			} else if (InArray('tip,load,3,4', data.type)) {
				btnshtml = '';
			}
			if (K.isset(data.btnshtml)) {
				btnshtml = data.btnshtml || '';
			}

			// 是否存在遮挡布
			if (data.shade || data.mask) {
				html += '<div id="' + _id + '_shade" class="pk-popup-shade"></div>';
			}
			// 是否存在提交回调函数
			if (typeof (data.submit) == "function") {
				this.func['submit_' + this.pid] = data.submit;
			}
			// 是否存在关闭回调函数
			if (typeof (data.close) == "function") {
				this.func['close_' + this.pid] = data.close;
			}
			// 是否存在取消回调函数
			if (typeof (data.cancel) == "function") {
				this.func['cancel_' + this.pid] = data.cancel;
			}
			// 是否存在加载完成事件函数
			if (typeof (data.complete) == "function") {
				this.func['complete_' + this.pid] = data.complete;
			}
			// 加载弹出层
			html += [
				'<div id="',
				_id,
				'" class="pk-popup ',
				data.class || '',
				'"><div class="pk-popup-head"><span>',
				data.title || K.L('信息'),
				'</span>',
				data.hideclose ? '' : '<i class="pk-popup-close"></i>',
				'</div><div class="pk-popup-body pk-popup-icon-',
				typeof (data.icon) == "undefined" ? 'null' : data.icon,
				'">',
				data.content || '',
				'</div><div class="pk-popup-foot">',
				btnshtml || '',
				'</div></div>'
			].join('');
			$('body').append(html);
			var _pid = this.pid,
				_data = data;
			// 绑定取消事件
			$('#' + _id + ' .pk-popup-cancel').on('click', function () {
				K.popup.cancel(_pid);
			});
			// 绑定关闭事件
			$('#' + _id + ' .pk-popup-close').on('click', function () {
				K.popup.close(_pid);
			});
			// 绑定确认事件，仅确认和输入模式有效
			$('#' + _id + ' .pk-popup-submit').on('click', function () {
				K.popup.submit(_pid, InArray('input,2', _data.type) ? $('#' + _id + ' .pk-popup-input').val() : '', _data.noclose);
			});
			// load tip层处理
			if (InArray('tip,load,3,4', data.type)) {
				$('#' + _id).css({
					paddingTop: '5px',
					paddingBottom: '5px'
				}).find('.pk-popup-head,.pk-popup-foot').addClass('pk-hide');
				if (InArray('load,4', data.type)) {
					$('#' + _id + ' .pk-popup-body').html([
						'<div style="float:left;width:40px;height:40px"><i class="pk-popup-loading"></i></div>',
						'<div style="float:left;height:40px;line-height:40px">',
						data.content || (K.L('正在处理请稍后') + '...'),
						'</div>'
					].join(''));
				} else {
					if (typeof (data.icon) != "number") {
						$('#' + _id + ' .pk-popup-body').css('min-height', '0');
					}
					if (typeof (data.times) != "number") {
						data.times = 2000;
					}
					if (data.times > 0) {
						setTimeout(function () {
							K.popup.close(_pid);
						}, data.times);
					}
				}
			}
			if (data.nohead) {
				$('#' + _id).css({
					paddingTop: 0
				}).find('.pk-popup-head').remove();
			}
			if (data.nofoot) {
				$('#' + _id).css({
					paddingBottom: 0
				}).find('.pk-popup-foot').remove();
			}
			// 自动屏幕中心
			function _area_func(cs) {
				var _id = cs.id;
				if (!$('#' + _id).length) {
					return false;
				}
				var _w = $(window).outerWidth() || 0,
					_h = $(window).outerHeight() || 0,
					_w2 = $('#' + _id).outerWidth() || 0,
					_h2 = $('#' + _id).outerHeight() || 0,
					_head_height = $('#' + _id + ' .pk-popup-head').outerHeight() || 0,
					_foot_height = $('#' + _id + ' .pk-popup-foot').outerHeight() || 0;
				// 内容高度自适应
				var _temp_height = _h2 - _head_height - _foot_height;
				var _temp_height2 = $('#' + _id + ' .pk-popup-body').outerHeight() || 0;
				// console.log(_h2, _temp_height, _temp_height2);
				if (cs.minH) {
					$('#' + _id + ' .pk-popup-body').css({
						minHeight: _temp_height + 'px'
					});
				} else {
					if (_temp_height > _temp_height2) {
						$('#' + _id + ' .pk-popup-body').css({
							maxHeight: _temp_height + 'px',
							height: _temp_height + 'px'
						});
					} else {
						$('#' + _id + ' .pk-popup-body').css({
							maxHeight: (_h - _h2 + _temp_height2) + 'px'
						});
					}
				}
				if (!cs.noAuto) {
					_h2 = $('#' + _id).outerHeight() || 0;
					$('#' + _id).css({
						top: Cnum((_h - _h2) / 2, 0, false, 0) + 'px',
						left: Cnum((_w - _w2) / 2, 0, false, 0) + 'px'
					});
				}
			}
			// 自定义的面积及位置
			var _cs = {
				id: _id
			};
			if (typeof (data.area) == "object") {
				var area_width = data.area.width || data.area[0],
					area_height = data.area.height || data.area[1],
					area_top = data.area.top || data.area[2],
					area_right = data.area.right || data.area[3],
					area_bottom = data.area.bottom || data.area[4],
					area_left = data.area.left || data.area[5];
				// 全屏修正
				if (area_width == '100%') {
					area_left = 0;
				}
				if (area_height == '100%') {
					area_top = 0;
				}

				$('#' + _id).css({
					width: area_width,
					height: area_height,
					top: area_top,
					right: area_right,
					bottom: area_bottom,
					left: area_left
				});
				if (!data.area[2]) {
					_cs['noAuto'] = false;
					_cs['minH'] = true;
				} else {
					_cs['noAuto'] = true;
				}
				if (area_width == '100%' && area_height == '100%') {
					data.move = false;
					_cs['noAuto'] = true;
				}
			}
			_area_func(_cs);
			// 检测窗口变化
			$(window).on('resize', function () {
				_area_func(_cs);
			});
			// 检测popup内容的变化
			var _setInterval_width = $('#' + _id).outerWidth(),
				_setInterval_height = $('#' + _id).outerHeight(),
				_setInterval = setInterval(function () {
					if (!$('#' + _id).attr('id')) {
						clearInterval(_setInterval);
						return false;
					}
					if ($('#' + _id).outerWidth() != _setInterval_width || $('#' + _id).outerHeight() != _setInterval_height) {
						_setInterval_width = $('#' + _id).outerWidth();
						_setInterval_height = $('#' + _id).outerHeight();
						_area_func(_cs);
					}
				}, 200);
			// 拖动事件
			if (!data.nomove && (typeof (data.move) != "undefined" && data.move)) {
				$('#' + _id + ' .pk-popup-head').on('mousedown', function (ev) {
					var This = $(this).parents('div.pk-popup:eq(0)')[0],
						oevent = ev,
						distanceX = oevent.clientX - This.offsetLeft,
						distanceY = oevent.clientY - This.offsetTop;
					$(this).on('mousemove', function (ev) {
						var oevent = ev,
							wh = $(window).outerHeight() || 0,
							mh = $('#' + _id).outerHeight() || 0,
							ww = $(window).outerWidth() || 0,
							mw = $('#' + _id).outerWidth() || 0,
							t = oevent.clientY - distanceY,
							l = oevent.clientX - distanceX,
							mt = wh - mh,
							ml = ww - mw;
						if (!data.nofixedmove) {
							if (t < 0) {
								t = 0;
							}
							if (t > mt) {
								t = mt;
							}
							if (l < 0) {
								l = 0;
							}
							if (l > ml) {
								l = ml;
							}
						}
						$(This).css({
							top: t,
							left: l
						});
					});
					$(this).on('mouseup', function () {
						$(this).off('mousemove mouseup');
					});
				}).css('cursor', 'move');
			}
			// 动画，渐渐显示
			$('#' + _id).animate({
				opacity: 1
			}, this.speed);
			// 如果输入框则获得焦点
			if (InArray('input,2', data.type)) {
				$('#' + _id + ' .pk-popup-body .pk-popup-input').trigger('focus');
			}
			//加载完成调用完成函数
			K.popup.complete(_pid);
			return this.pid;
		},
		cancel(_id) {
			if (typeof (this.func['cancel_' + _id]) == "function") {
				this.func['cancel_' + _id](_id, $('#pkpopup_' + _id));
			}
			return K.popup.close(_id);
		},
		close(_id, _nofunc) {
			if (['string', 'number'].indexOf(typeof (_id)) > -1) {
				if ($('#pkpopup_' + _id + ' .pk-popup-foot .pk-popup-close').hasClass('disabled')) {
					return false;
				}
				$('#pkpopup_' + _id).animate({
					opacity: 0
				}, this.speed);
				var This = this;
				setTimeout(function () {
					$('#pkpopup_' + _id + '_shade,#pkpopup_' + _id).remove();
					if (typeof (This.func['close_' + _id]) == "function" && !_nofunc) {
						This.func['close_' + _id](_id);
					}
				}, this.speed);
			} else if (typeof (_id) == "object") {
				var _t = $(_id).parents('.pk-popup:eq(0)').attr('id');
				if (_t) {
					K.popup.close(_t.split('_')[1]);
				} else {
					K.popup.close();
				}
			} else {
				$('.pk-popup,.pk-popup-shade').remove();
			}
			return true;
		},
		submit(_id, _value, _noclose) {
			if ($('#pkpopup_' + _id + ' .pk-popup-foot .pk-popup-submit').hasClass('disabled')) {
				return false;
			}
			if (this.func['submit_' + _id]) {
				this.func['submit_' + _id](_id, _value, $('#pkpopup_' + _id));
			}
			if (!_noclose) {
				K.popup.close(_id);
			}
			return true;
		},
		complete(_id) {
			if (['string', 'number'].indexOf(typeof (_id)) > -1) {
				if (typeof (this.func['complete_' + _id]) == "function") {
					this.func['complete_' + _id](_id, $('#pkpopup_' + _id));
				}
			}
			return true;
		},
		func: []
	},
	P(data) {
		return K.popup.popup(data);
	},
	alert(msg, icon, yes) {
		if (typeof (icon) == "undefined") {
			icon = 0;
		}
		if (typeof (icon) == "function") {
			yes = icon;
			icon = false;
		}
		return K.P({
			type: 0,
			icon,
			content: msg,
			submit: function (id) {
				if (typeof (yes) == "function") {
					yes(id);
				}
			}
		});
	},
	confirm(msg, yes) {
		return K.P({
			type: 1,
			icon: 3,
			content: msg,
			submit: function (id) {
				if (typeof (yes) == "function") {
					yes(id);
				}
			}
		});
	},
	prompt(msg, yes) {
		return K.P({
			type: 2,
			title: msg,
			submit: function (id, value) {
				if (typeof (yes) == "function") {
					yes(value);
				}
			}
		});
	},
	msg(msg, icon, times) {
		if (typeof (icon) == "undefined") {
			icon = 0;
		}
		if (typeof (times) == "undefined") {
			times = 2000;
		}
		if (typeof (times) == "function") {
			var func = times;
			times = 2000;
			setTimeout(function () {
				func();
			}, 2000);
		}
		return K.P({
			type: 3,
			icon,
			content: msg,
			times
		});
	},
	loading(msg, shade = 0) {
		return K.P({
			type: 4,
			content: msg,
			shade
		});
	},
	iframe(url, title = null) {
		var _tmpstyle_h = $('html').css('overflow-y'),
			_tmpstyle_b = $('body').css('overflow-y');
		return K.P({
			title: title || url,
			nomove: 1,
			content: [
				'<iframe src="',
				url,
				'" style="width:100%;height:100%;border:0;overflow-y:scroll"></iframe>'
			].join(''),
			area: ['100%', '100%'],
			complete: function (id) {
				$('#pkpopup_' + id + ' .pk-popup-body,body').css('overflow-y', 'hidden');
				var h1 = $('#pkpopup_' + id + ' .pk-popup-foot').outerHeight() || 0;
				var h2 = $('#pkpopup_' + id + ' .pk-popup-body').outerHeight() || 0;
				$('#pkpopup_' + id + ' .pk-popup-foot').remove();
				$('#pkpopup_' + id + ' .pk-popup-body').css({
					height: (h1 + h2) + 'px',
					maxHeight: (h1 + h2) + 'px'
				});
			},
			close: function () {
				$('html').css('overflow-y', _tmpstyle_h);
				$('body').css('overflow-y', _tmpstyle_b);
			}
		});
	},
	// pkpopup快速获取助手
	p_o(id) {
		if (typeof (id) == "object") {
			return id;
		}
		return $('#pkpopup_' + id);
	},
	// pkpopup关闭助手
	close(id = false) {
		return K.popup.close(id);
	}
};

// 初始化获得加载puyuetian.js的基本路径
(function () {
	if (!K.basePath) {
		return false;
	}
	var tags = document.getElementsByTagName("script");
	for (var i = 0; i < tags.length; i++) {
		var src = tags[i].src;
		if (src.indexOf('puyuetian.js') != -1 || src.indexOf('puyuetian.min.js') != -1) {
			K.basePath = src.substring(0, src.lastIndexOf('/')) + '/';
			return true;
		}
	}
}());
