<?php

// 输出内容
echo (function () {
    // 加载前置脚本
    (function () {
        if (is_file(k::appInfo('preloadpath'))) {
            require k::appInfo('preloadpath');
        }
    })();

    // 初始化输出内容
    k::g('output_content', (function () {
        return include k::appinfo('php_path');
    })());
    if (k::g('output_content') === 1) {
        k::g('output_content', '');
    }

    // 加载后置脚本
    (function () {
        if (is_file(k::appInfo('afterloadpath'))) {
            require k::appInfo('afterloadpath');
        }
    })();

    // 返回待输出的内容
    return (function () {
        $r = k::g('output_content');
        if (!is_string($r) && !is_numeric($r)) {
            $r = json_encode($r, 320);
        }

        // 根据内容确定header
        $header = '';
        if (k::config('http_header_auto')) {
            if (strpos(trim($r), '<!DOCTYPE html>') === 0) {
                $header = 'text/html';
                // 开了调试模式
                if (k::config('debug')) {
                    $r .= "\n<!-- runtime:" . k::runtime(3) . 's -->';
                }
            } elseif (in_array(substr(trim($r), 0, 1), ['[', '{'])) {
                $header = 'application/json';
            } elseif (strpos(trim($r), '<?xml') === 0) {
                $header = 'text/xml';
            } else {
                $header = k::config('http_header_default_content-type');
            }
            if ($header) {
                header("Content-type:{$header};charset=" . k::config('default_charset'));
            }
        }
        return $r;
    })();
})();
