<?php
return (function () {
    $rules           = k::g('route');
    $s               = k::appinfo('route_s');
    $route_file_path = function ($path) {
        //带参数的路由
        if (strpos($path, '?')) {
            $a    = explode('?', $path);
            $path = $a[0];
            $a    = explode('&', $a[1]);
            foreach ($a as $v) {
                $b = explode('=', $v);
                if (count($b) == 2) {
                    $_GET[$b[0]]     = $b[1];
                    $_REQUEST[$b[0]] = $b[1];
                }
            }
        }
        $paths = explode('/', $path);
        $path  = PK_APP_PATH . k::cstr($paths[0]) . PK_DS;
        $file  = 'index';
        if (count($paths) > 1) {
            // 自动补全index
            $filepath = $path . k::cstr($paths[1]) . '.php';
            if (!file_exists($filepath)) {
                // 入口文件不存在
                if (k::config('debug')) {
                    k::error('NOT FOUND FILE[' . $filepath . ']');
                }
                http_response_code(404);
                exit;
            }
            $n = 0;
            foreach ($paths as $k => $v) {
                if (!$k || 1 == $k) {
                    $file = $v;
                    continue;
                }
                if (!$n) {
                    if (!isset($paths[$k + 1])) {
                        // get数据不完整404
                        http_response_code(404);
                        exit;
                    }
                    $v2           = $paths[$k + 1];
                    $_GET[$v]     = $v2;
                    $_REQUEST[$v] = $v2;
                    $n            = 1;
                } else {
                    $n = 0;
                }
            }
        }
        if (k::in_arrays($file, 'preload,function,config,common')) {
            http_response_code(403);
            exit;
        }
        $filepath = $path . $file . '.php';
        if (file_exists($filepath)) {
            return $filepath;
        }
        if (k::config('debug')) {
            k::error('NOT FOUND FILE[' . $filepath . ']');
        }
        http_response_code(404);
        exit;
    };

    if (!$s) {
        // 返回默认应用
        $s = k::config('default_appname');
    }

    if ($rules) {
        foreach ($rules as $k => $v) {
            if (!$v) {
                continue;
            }
            $k = str_replace('/', '\\/', $k);
            if (preg_match("/{$k}/i", $s, $matches)) {
                // echo $k;
                // echo ' ';
                // echo $s;
                foreach ($matches as $_k => $_v) {
                    if (!$_k) {
                        continue;
                    }
                    $v = str_replace("\${$_k}", $_v, $v);
                }
                return $route_file_path($v);
            }
        }
    }
    // 自然判断,最后路径请求文件优先于目录,目录默认index.php文件
    return $route_file_path($s);

})();
