<?php
(function () {
    //初始化数据库信息
    $type     = k::g('db.type');
    $hostname = k::g('db.hostname');
    $database = k::g('db.database');
    $username = k::g('db.username');
    $password = k::g('db.password');
    $hostport = k::g('db.hostport');
    $prefix   = k::g('db.prefix');
    $charset  = k::g('db.charset');
    $dsn      = k::g('db.dsn');

    if (!$type) {
        return false;
    }
    $drive_path = PK_LIB_PATH . 'db' . PK_DS . $type . '.php';
    if (!file_exists($drive_path)) {
        k:error('not support db type of ' . $type);
    }
    require $drive_path;

    //设置全局pdo对象
    k::g('db.pdo', $pdo);

    //写入数据库配置
    if (k::config('load_user_config')) {
        $cons = k::db('set')->field('name,value')->select();
        foreach ($cons as $con) {
            k::config($con['name'], $con['value']);
        }
    }

})();
