<?php

//系统及框架所有信息
//时区设置
date_default_timezone_set(k::config('default_timezone'));
//请求的s参数,路由地址
if (k::config('debug')) {
    ini_set('display_errors', 'On');
    error_reporting(E_ALL);
} else {
    // 如果你不想显示所致命错误,请去掉下面的注释并注释后2句
    //ini_set('display_errors', 'Off');
    //error_reporting(0);
    ini_set('display_errors', 'On');
    error_reporting(E_ALL ^ E_WARNING ^ E_NOTICE);
}

//是否开启了session
if (k::config('session_on')) {
    session_start();
}

//站点的域名
$domains = explode(':', $_SERVER['HTTP_HOST']);
if (count($domains) > 1) {
    $port = $domains[1];
} else {
    $port = '';
}
$domain = strtolower($domains[0]);
k::g('sys.config.domain', $domain);
//域名端口
k::g('sys.config.domain_port', $port);
// 客户端ip
k::g('sys.config.client_ip', (function () {
    if (isset($_SERVER)) {
        if (isset($_SERVER["HTTP_X_FORWARDED_FOR"])) {
            $IPaddress = $_SERVER["HTTP_X_FORWARDED_FOR"];
        } elseif (isset($_SERVER["HTTP_CLIENT_IP"])) {
            $IPaddress = $_SERVER["HTTP_CLIENT_IP"];
        } else {
            $IPaddress = $_SERVER["REMOTE_ADDR"];
        }
    } else {
        if (getenv("HTTP_X_FORWARDED_FOR")) {
            $IPaddress = getenv("HTTP_X_FORWARDED_FOR");
        } elseif (getenv("HTTP_CLIENT_IP")) {
            $IPaddress = getenv("HTTP_CLIENT_IP");
        } else {
            $IPaddress = getenv("REMOTE_ADDR");
        }
    }
    if (strpos($IPaddress, ',') !== false) {
        $IPaddress = explode(',', $IPaddress);
        $IPaddress = $IPaddress[0];
    }
    return $IPaddress;
})());
// 客户端agent
k::g('sys.config.client_agent', isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : 'unknown');
// 客户端系统
k::g('sys.config.client_os', (function () {
    $os = 'unknown';
    if (!isset($_SERVER['HTTP_USER_AGENT'])) {
        return $os;
    }
    $a = strtolower($_SERVER['HTTP_USER_AGENT']);
    if (strpos($a, 'win')) {
        $os = 'windows';
        if (strpos($a, 'nt 6.1')) {
            $os .= ' 7';
        } elseif (strpos($a, 'nt 6.2')) {
            $os .= ' 8';
        } elseif (strpos($a, 'nt 10.0')) {
            $os .= ' 10';
        } elseif (strpos($a, 'nt 5.1')) {
            $os .= ' xp';
        } elseif (strpos($a, 'phone')) {
            $os .= ' phone';
        }
    } elseif (strpos($a, 'linux')) {
        $os = 'linux';
        if (strpos($a, 'android')) {
            $os = 'android';
        }
    } elseif (strpos($a, 'iphone')) {
        $os = 'iphone';
    } elseif (strpos($a, 'ipad')) {
        $os = 'ipad';
    } elseif (strpos($a, 'unix')) {
        $os = 'unix';
    } elseif (strpos($a, 'mac')) {
        $os = 'mac';
    } elseif (strpos($a, 'android')) {
        $os = 'android';
    }
    return $os;
})());
// 服务器ip
k::g('sys.config.server_ip', $_SERVER['SERVER_ADDR']);
// 来源地址
k::g('sys.config.referer', isset($_SERVER['HTTP_REFERER']) ? $_SERVER['HTTP_REFERER'] : '');
// 当前url地址
k::g('sys.config.location', (function () {
    $request_scheme = '';
    if (isset($_SERVER['REQUEST_SCHEME'])) {
        $request_scheme = $_SERVER['REQUEST_SCHEME'];
    } else {
        if (isset($_SERVER['HTTPS']) && 'on' == $_SERVER['HTTPS']) {
            $request_scheme = 'https';
        } else {
            $request_scheme = 'http';
        }
    }
    $server_name = $_SERVER['SERVER_NAME'];
    $server_port = ($_SERVER['SERVER_PORT'] && 80 != $_SERVER['SERVER_PORT'] && 443 != $_SERVER['SERVER_PORT']) ? ":{$_SERVER['SERVER_PORT']}" : '';
    $request_uri = $_SERVER['REQUEST_URI'];
    return $request_scheme . '://' . $server_name . $server_port . $request_uri;
})());

// 请求的应用的路由地址s
k::appinfo('route_s', str_replace(['\\', '//'], '/', K::input('get.s/s')));
// 请求的应用文件绝对路径
k::appinfo('php_path', include (PK_STA_PATH . 'route.php'));
// 请求的应用脚本所在目录
k::appinfo('dir_path', dirname(k::appinfo('php_path')) . PK_DS);
// 请求的应用目录名称,任何平台皆以/分割
k::appinfo('dir_name', trim(str_replace(['\\', '//'], '/', substr(k::appinfo('dir_path'), strlen(PK_APP_PATH))), '/'));
// 请求的应用名称
k::appinfo('app_name', current(explode('/', k::appinfo('dir_name'))));
// 请求的应用所执行的脚本名称,不包含包含.php
k::appinfo('php_name', basename(k::appinfo('php_path'), '.php'));
// 请求的应用命名空间名称
k::appinfo('namespace', str_replace('/', '\\', k::appinfo('dir_name')));
// 应用前置脚本路径
k::appInfo('preloadpath', k::appinfo('dir_path') . 'preload.php');
// 应用后置脚本路径
k::appInfo('afterloadpath', k::appinfo('dir_path') . 'afterload.php');
