<?php
return (function () {
    $cache_filepath = (function () {
        $route_path = k::appinfo('php_path');
        if (!k::config('html_cache_timeout')) {
            //未开启html缓存功能
            return false;
        }
        $paths = k::config('html_cache_routes');
        if (!$paths) {
            //未设置缓存路径
            return false;
        }

        if (is_string($paths)) {
            $paths = explode(',', $paths);
        }

        $route_path = str_replace(['\\', '//'], '/', $route_path);
        foreach ($paths as $path) {
            $path           = str_replace(['\\', '//'], '/', PK_APP_PATH . $path);
            $route_path_len = strlen($route_path);
            $path_len       = strlen($path);
            //路径不匹配
            if ($route_path_len < $path_len) {
                continue;
            }
            //该路由请求没有缓存文件
            if (substr($route_path, 0, $path_len) != $path) {
                continue;
            }
            $route_path_end = '';
            if ($route_path_len > $path_len) {
                $route_path_end = substr($route_path, $path_len);
            }
            //该路由请求包含子目录,放弃
            if (strpos($route_path_end, '/')) {
                continue;
            }
            //生成缓存文件路径
            $cache_filename = md5($route_path);
            $cache_filepath = PK_CACHE_PATH . 'html' . PK_DS . $cache_filename . '.html';
            return $cache_filepath;
        }
        return false;
    })();

    if (!$cache_filepath) {
        return false;
    }

    if (!file_exists($cache_filepath)) {
        //无缓存
        return false;
    }
    //缓存是否过期
    if (filemtime($cache_filepath) < time() - k::config('html_cache_timeout')) {
        //过期
        return false;
    }
    //输出缓存
    $cache_content = file_get_contents($cache_filepath);
    if (!$cache_content) {
        //无内容
        return false;
    }
    echo $cache_content;
    exit;
})();
