<?php
//判断PHP版本是否支持本框架
if (version_compare(PHP_VERSION, '7.0.0', '<')) {
    exit('Current PHP = ' . PHP_VERSION . ' and require PHP >= 7.0');
}

// 程序开始运行的时间
define('PK_START_MICROTIME', microtime(true));
// 定义环境常量
define('PK', 'puyuetian');
define('PK_V', '5.0.0');
define('PK_DS', DIRECTORY_SEPARATOR);
define('PK_WWWROOT', realpath(__DIR__ . '/../') . PK_DS);
define('PK_APP_PATH', PK_WWWROOT . 'app' . PK_DS);
define('PK_PYT_PATH', PK_WWWROOT . 'puyuetian' . PK_DS);
define('PK_CON_PATH', PK_WWWROOT . 'config' . PK_DS);
define('PK_LANG_PATH', PK_CON_PATH . 'language' . PK_DS);
define('PK_DB_PATH', PK_WWWROOT . 'database' . PK_DS);
define('PK_LIB_PATH', PK_PYT_PATH . 'library' . PK_DS);
define('PK_STA_PATH', PK_PYT_PATH . 'startup' . PK_DS);
define('PK_OTH_PATH', PK_WWWROOT . 'other' . PK_DS);
define('PK_CACHE_PATH', PK_OTH_PATH . 'cache' . PK_DS);
define('PK_LOG_PATH', PK_OTH_PATH . 'log' . PK_DS);
define('PK_TMP_PATH', PK_OTH_PATH . 'temp' . PK_DS);

//引入系统基础库
require PK_LIB_PATH . 'k.php';
require PK_LIB_PATH . 'db.php';
require PK_LIB_PATH . 'image.php';
require PK_LIB_PATH . 'upload.php';
require PK_LIB_PATH . 'helper.php';

//定义框架内全局变量及加载配置文件信息
$_G = include PK_STA_PATH . 'config.php';
//初始化信息
require PK_STA_PATH . 'init.php';
require PK_STA_PATH . 'cache.php';
require PK_STA_PATH . 'initdb.php';

// 加载用户自定义的文件
require PK_APP_PATH . 'function.php';
require PK_APP_PATH . 'preload.php';

//运行应用
require PK_STA_PATH . 'run.php';
