<?php

//全局助手函数
//全局k类调用
function k()
{
    $args = func_get_args();
    if (!$args) {
        return k::getSelf();
    }
    $method = $args[0];
    unset($args[0]);
    return call_user_func_array([k(), $method], $args);
}

/**
 * 全局变量调用
 * @param string $key 共用变量name
 * @param mixed $value 为null是获取该key值，或不为null则为设置该key
 * @param string $key_prefix key值前缀
 */
function g(string $key = null, $value = null, string $key_prefix = '')
{
    return k::g($key, $value, $key_prefix);
}

/**
 * 读写配置
 * @param string $key 配置名称
 * @param mixed $value 为null是获取该配置值，或不为null则为设置该配置
 */
function config(string $key = null, $value = null)
{
    return g($key, $value, 'config');
}

/**
 * 读写系统配置
 * @param string $key 配置名称
 * @param mixed $value 为null是获取该配置值，或不为null则为设置该配置
 */
function sysConfig(string $key = null, $value = null)
{
    return g($key, $value, 'sys.config');
}

/**
 * 读写我的配置，该为临时配置，只在相关应用下生效
 * @param string $key 配置名称
 * @param mixed $value 为null是获取该配置值，或不为null则为设置该配置
 */
function myConfig($key = null, $value = null)
{
    return g($key, $value, '_myconfig._' . md5(k::appinfo('dir_path')));
}

/**
 * 快捷获取和设置当前应用信息
 * @param string $key 配置名称
 * @param mixed $value 若不为null则为设置该配置
 */
function appInfo(string $key = null, $value = null)
{
    return g($key, $value, 'appinfo');
}
/**
 * 调用输入（get、post、request）
 * 举例input('a'); 获取_REQUEST内的a参数,默认被过滤处理
 * input('get.a'); 获取_GET内的a参数
 * input('get.a/s'); 获取a参数并转为字符串,目前仅支持字符串/s及数字/d
 * input('get.a/s,get.b/d') 获取get方法a参数及b参数，返回数组
 * input()，input('get.') input('post.') 获取所有被输入的参数
 * @param mixed $keys 参数集合或字符串，若为字符串多个用,分开
 * @param boolean $filter 是否对获取的数据安全过滤
 */
function input($keys = null, $filter = true)
{
    return k::input($keys, $filter);
}

/**
 * 快速调用数据库
 * @param string $table 表名称
 * @param mixed $pdo_name 数据库信息/pdo标识
 * @param mixed $prefix 表前缀，null为默认前缀
 */
function db(string $table = '', $pdo_name = '', $prefix = null)
{
    return k::db($table, $pdo_name, $prefix);
}

/**
 * mysql数据库转义
 * @param string $str 待转义字符串
 * @param boolean $quto 是否添加''字符
 * @param string $bwf 字符串两边添加的字符
 * @param boolean $must 是否强制添加''，若为false则数字不添加
 */
function quote(string $str, $quto = true, string $bwf = '', $must = true)
{
    return k::quote($str, $quto, $bwf, $must);
}

/**
 * 解析模板方法
 * @param string $path 模板路径或模板代码，若为代码则$type='code'
 * @param array $vars 模板初始化的变量
 * @param string $type 加载类型：file/code
 * @param boolean $parse 是否解析模板
 */
function template(string $path, array $vars = [], string $type = 'file', $parse = true)
{
    return k::template($path, $vars, $type, $parse);
}

/**
 * 强制返回整数或小数数字
 * @param mixed $str 待处理的字符
 * @param mixed $return 若$str不符合要求返回的值
 * @param boolean $int 是否强制整数
 * @param mixed $min 最小值
 * @param mixed $max 最大值
 * @param boolean $minormax 当$str小于最小值时取最小值，当大于最大值时取最大值
 */
function cNum($str, $return = 0, $int = true, $min = false, $max = false, $minormax = false)
{
    return k::cNum($str, $return, $int, $min, $max, $minormax);
}

/**
 * 返回符合条件的字符串
 * @param mixed $str 待处理字符串
 * @param mixed $return 若不符合条件返回的值
 * @param mixed $cstr 字符串处理白名单
 * @param mixed $minlen 字符串最小长度
 * @param mixed $maxlen 字符串最大长度
 */
function cStr($str, $return = false, $cstr = true, $minlen = false, $maxlen = false)
{
    return k::cStr($str, $return, $cstr, $minlen, $maxlen);
}

/**
 * 成功 返回json数据
 * {"code":1,"time":1655182540,"msg":"","data":null}
 * @param mixed $msg msg消息
 * @param mixed $data data数据
 * @param boolean $r 返回字符串而非终止程序
 */
function success($msg = null, $data = null, $r = false)
{
    return k::success($msg, $data, $r);
}
/**
 * 失败 返回json数据
 * {"code":0,"time":1655182540,"msg":"","data":null}
 * @param mixed $msg msg消息
 * @param mixed $data data数据
 * @param boolean $r 返回字符串而非终止程序
 */
function error($msg = null, $data = null, $r = false)
{
    return k::error($msg, $data, $r);
}

/**
 * 前端静态资源加载
 * @param mixed $urls 资源相对框架的路径，多个地址用,分割或输入字符串，当输入一个文件时auto可设置，多个文件auto自动为ture
 * @param boolean $auto 是否自动生成html标签，若遇到无法识别则原字符串输出
 */
function webUrl($urls, $auto = false)
{
    return k::webUrl($urls, $auto);
}

/**
 * 上传文件对象
 * @param array $config 上传配置
 * $config = [
 * // 是否允许上传文件
 * 'open' => 1,
 * // 一次最多上传的文件数,0为不限制
 * 'count' => 0,
 * // 文件允许的最大大小,b,0为不限制
 * 'size' => 0,
 * // 文件存储的路径,相对于www目录
 * 'savepath' => 'upload/',
 * // 存储的文件名,不存在则随机
 * 'filename' => '',
 * // 允许上传的文件后缀,为空为不限制
 * 'suffix' => '',
 * // 若存在相同文件返回已上传的同文件
 * 'no_repeat' => 1
 * ];
 */
function upload($config = [])
{
    return k::upload($config);
}
/**
 * 图片处理快捷函数，验证码请使用code对象
 * @param $file 要处理的图片文件路径
 */
function image($file = null)
{
    return k::image($file);
}
/**
 * 创建随机数
 * @param int $len 随机数的长度
 * @param string $str 生成随机数的因子
 */
function randomString(int $len = 7, string $str = '')
{
    return k::randomString($len, $str);
}

/**
 * curl
 * @param string $url 远程地址
 * @param mixed $data 发送的数据，字符串或数组，字符串需要urlencode
 * @param string $method get/post
 * @param int $timeout 超时时间，秒
 * @param array $headers header信息
 */
function cUrl(string $url, $data = [], string $method = 'get', int $timeout = 10, $headers = [])
{
    return k::cUrl($url, $data, $method, $timeout, $headers);
}

/**
 * 该函数的设置方法及参数同setcookie，仅传入$name将会取值
 * 该函数会自动带前缀
 * @param int $expire 为多少秒后过期，负数或0为马上过期
 */
function cookie($name, $value = null, $expire = null, $path = '/', $domain = null)
{
    return k::cookie($name, $value, $expire, $path, $domain);
}

/**
 * session，仅传入$name将会取值
 */
function session($name, $value = null)
{
    return k::session($name, $value);
}

/**
 * 强制返回字符串，若不为字符串类型，无论如何都返回''
 * @param $str 待处理的对象
 */
function returnString($str)
{
    return k::returnString($str);
}

/**
 * @param $url http地址
 * @param $param get参数
 * @param $return 是否返回不退出
 */
function gourl($url, $param = false, $return = false)
{
    return k::gourl($url, $param, $return);
}
/**
 * 返回变量值，模板变量输出调用，默认html转义
 * @param string $var 变量名
 * @param boolean $htmlspecialchars 是否转义，默认转义
 */
function t($var, $htmlspecialchars = true)
{
    return k::t($var, $htmlspecialchars);
}

/**
 * 获取html里面的img对象
 * @param $html 待处理的html
 * @param $maxN 最多获取img的个数，0为全部获取
 * @param $noAlt 为不获取的alt属性内容
 * @param $noKeywords 为不获取的路径关键词
 * @param $nobase64 是否获取base64的值
 * @return array [["src"=>"","alt"=>""]]
 */
function getHtmlImgs($html, $maxN = 0, $noAlt = 'emotion,emoticon', $noKeywords = 'emotion,emoticon', $nobase64 = false)
{
    return k::getHtmlImgs($html, $maxN, $noAlt, $noKeywords, $nobase64);
}

/**
 * 获取html里面指定对象
 * @param $html 待处理的html
 * @param $mark 待获取的mark字符串
 * @param $maxN 最多获取$mark的个数，0为全部获取
 * @return array [[attr=>value,]]
 */
function getHtmlMarks($html, $mark, $maxN = 0)
{
    return k::getHtmlMarks($html, $mark, $maxN);
}

/**
 * in_array函数
 * @param string $needle 搜索的字符串或数组
 * @param mixed $array 被搜索的字符串或数组
 * @param boolean $allin 多个搜索对象，为true时所有都存在返回true，为false只要一个存在返回true
 * @param string $delimiter 如果对象是字符串用什么把他分割成数组
 */
function in_arrays($needle, $array, $allin = true, $delimiter = ',')
{
    return k::in_arrays($needle, $array, $allin, $delimiter);
}
function inArray($needle, $array, $allin = true, $delimiter = ',')
{
    return k::inArray($needle, $array, $allin, $delimiter);
}

/**
 * html标签安全化处理
 * @param string $html 输入的html
 * @param string $marks html标签白名单,留空为保留所有，格式：<b><div>
 * @param string $attrs html标签属性白名单,留空为保留所有，格式：class,href
 */
function html2safeHtml($html, $marks = '', $attrs = '')
{
    return k::html2safeHtml($html, $marks, $attrs);
}

/**
 * 伪静态地址生成
 * @param string $www_dir 应用的名称
 * @param string $filename 访问的应用文件
 * @param string $querystring 访问的get参数
 */
function reWriteUrl($www_dir = '', $filename = '', $querystring = '')
{
    return k::reWriteUrl($www_dir, $filename, $querystring);
}
