<?php

//这里可以根据情况自行添加,也可以数据库里添加
//如果数据库里面有相同key的配置则会被覆盖
return [
    // 应用调试模式
    'debug'                            => true,
    // 框架所在目录,若在网站根目录请填/,若在子目录下,请填写子目录名称,必须以/开头和结尾
    'www_dir'                          => '/',
    // 开启session
    'session_on'                       => true,
    // 加载数据库自定义配置
    'load_user_config'                 => 1,
    // 是否开启伪静态
    'url_rewrite_on'                   => true,
    // 是否开启路由
    'url_route_on'                     => true,
    // URL伪静态后缀
    'url_html_suffix'                  => '',
    // 默认首页的应用
    'default_appname'                  => 'index',
    // 默认时区
    'default_timezone'                 => 'PRC',
    // 默认全局过滤方法 多个用,分开,将影响input方法获取的数据
    'default_filter'                   => 'trim',
    // 全局编码
    'default_charset'                  => 'utf-8',
    // 数据默认limit数,每页显示的数据数
    'default_limit'                    => 10,
    // 小写字母
    'string_lowercase'                 => 'abcdefghijklmnopqrstuvwxyz',
    // 大写字母
    'string_uppercase'                 => 'ABCDEFGHIJKLMNOPQRSTUVWXYZ',
    // 数字
    'string_numerical'                 => '1234567890',
    // 安全字符串
    'string_safestrs'                  => 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890_',
    // get安全字符串
    'string_safestrs'                  => 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890_-./',
    // html缓存功能,过期时间,0为关闭
    'html_cache_timeout'               => 0,
    // html缓存的路由及文件,需要填入目录或精确到文件路径,多个用,分开
    'html_cache_routes'                => 'index',
    'upload_config'                    => [
        // 是否允许上传文件
        'open'      => 1,
        // 一次最多上传的文件数,0为不限制
        'count'     => 9,
        // 文件允许的最大大小,b,默认10m
        'size'      => 10 * 1024 * 1024,
        // 文件存储的路径
        'savepath'  => 'upload/',
        // 存储的文件名,不存在则随机
        'filename'  => '',
        // 允许上传的文件后缀,为空为不限制,小写
        'suffix'    => 'jpg,png,jpeg,bmp,gif',
        // 若存在相同文件返回已上传的同文件
        'no_repeat' => 1,
    ],
    // 自动根据输出内容添加header
    'http_header_auto'                 => 1,
    // header默认类型，当找不到对应类型时使用该类型
    'http_header_default_content-type' => 'text/plain',
    // cookie前缀
    'cookie_prefix'                    => 'PK_',
    // 全局加密密钥
    'safekey'                          => '',
];
