﻿DROP TABLE IF EXISTS `pk_bill`;
CREATE TABLE `pk_bill` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0' COMMENT '用户uid',
  `p` int(11) NOT NULL DEFAULT '0' COMMENT '交易前金钱数',
  `v` int(11) NOT NULL DEFAULT '0' COMMENT '交易金钱数',
  `n` int(11) NOT NULL DEFAULT '0' COMMENT '交易后金钱数',
  `content` text COMMENT '交易说明',
  `tradetime` bigint(20) NOT NULL DEFAULT '0' COMMENT '交易时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;
DROP TABLE IF EXISTS `pk_group`;
CREATE TABLE `pk_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `qx` text,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4;
INSERT INTO `pk_group` VALUES (0,'游客','nodelreply,noeditreply,nodelread,noeditread,nopostreply,nopostread'),(1,'普通用户','nologin,nodel,noedit'),(2,'VIP','nodelread,noeditread'),(7,'站长','admin');
DROP TABLE IF EXISTS `pk_msg`;
CREATE TABLE `pk_msg` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fuid` bigint(20) NOT NULL DEFAULT '0' COMMENT '发信人uid',
  `tuid` bigint(20) NOT NULL DEFAULT '0' COMMENT '收信人uid',
  `content` text COMMENT '内容',
  `islook` int(11) NOT NULL DEFAULT '0' COMMENT '是否已读',
  `posttime` bigint(20) NOT NULL DEFAULT '0' COMMENT '发信时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;
DROP TABLE IF EXISTS `pk_read`;
CREATE TABLE `pk_read` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sid` int(11) NOT NULL DEFAULT '0' COMMENT '分类id',
  `uid` int(11) NOT NULL DEFAULT '0',
  `title` varchar(250) NOT NULL DEFAULT '',
  `content` longtext,
  `jinqian` int(11) NOT NULL DEFAULT '0',
  `showmedia` int(11) NOT NULL DEFAULT '0',
  `video` text,
  `image` text,
  `audio` text,
  `attachment` text,
  `posttime` bigint(20) NOT NULL DEFAULT '0',
  `replycount` int(11) NOT NULL DEFAULT '0',
  `ip` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `title` (`title`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;
DROP TABLE IF EXISTS `pk_readpayrecord`;
CREATE TABLE `pk_readpayrecord` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `rid` int(11) NOT NULL DEFAULT '0',
  `jinqian` int(11) NOT NULL DEFAULT '0',
  `paytime` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;
DROP TABLE IF EXISTS `pk_recharge`;
CREATE TABLE `pk_recharge` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` bigint(20) NOT NULL DEFAULT '0',
  `rmb` float(11,2) NOT NULL DEFAULT '0.00',
  `jinqian` int(11) NOT NULL DEFAULT '0',
  `paytype` varchar(255) NOT NULL DEFAULT '',
  `createtime` bigint(20) NOT NULL DEFAULT '0',
  `finishtime` bigint(20) NOT NULL DEFAULT '0',
  `status` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;
DROP TABLE IF EXISTS `pk_recycle`;
CREATE TABLE `pk_recycle` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tn` varchar(255) NOT NULL DEFAULT '',
  `data` longtext NOT NULL,
  `deltime` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4;
DROP TABLE IF EXISTS `pk_reply`;
CREATE TABLE `pk_reply` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rid` int(11) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  `content` text,
  `replytime` bigint(20) NOT NULL DEFAULT '0',
  `ip` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4;
DROP TABLE IF EXISTS `pk_set`;
CREATE TABLE `pk_set` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `value` text,
  `title` text,
  `content` text,
  `type` text,
  `required` int(11) NOT NULL DEFAULT '0',
  `attr` text,
  `p` varchar(255) NOT NULL DEFAULT '',
  `rank` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=49 DEFAULT CHARSET=utf8mb4;
INSERT INTO `pk_set` VALUES (1,'webname','puyuetian轻博客','网站名称','','text',1,NULL,'set',99),(2,'webtitle','puyuetian轻博客_轻快简的个人博客系统','网站标题','该参数显示在HTML的title标签内，一般显示在首页','text',1,NULL,'set',0),(3,'webkeywords','','网站关键词','该参数显示在HTML的META标签内，为keywords属性，一般显示在首页','textarea',0,NULL,'set',0),(4,'webdescription','','网站说明','该参数显示在HTML的META标签内，为description属性，一般显示在首页','textarea',0,NULL,'set',0),(5,'webicon','/favicon.png','网站图标','显示在浏览器标签页','upload',0,'accept=\"image/*\" autocomplete=\"off\"','set',0),(6,'upload_config_open','1','允许上传文件',NULL,'toggle',0,NULL,'upload',0),(7,'upload_config_count','9','一次最多上传文件数','超过该值将无法上传，0为不限制','number',0,NULL,'upload',0),(8,'upload_config_size','10485760','单个文件最大大小(b)','允许上传的最大文件大小，0为不限制，单位：b','number',0,NULL,'upload',0),(9,'upload_config_savepath','/upload/{type}/{date}/{uid}/','上传文件保存的路径','这里支持变量设置，可用变量：{Y}{m}{d}{H}{i}{s}{date}{time}{uid}','text',0,NULL,'upload',0),(10,'upload_config_suffix','jpg,png,jpeg,bmp,gif','允许上传的文件后缀','直接添加后缀即可，举例：png','label',0,NULL,'upload',0),(11,'upload_config_no_repeat','1','智能上传','存在相同文件返回已上传的同文件','toggle',0,NULL,'upload',0),(12,'htmlsafemarks','<b><i><u><strong><font><pre><code><p><span><table><thead><tbody><tfoot><tr><td><th><a><em><h1><h2><h3><h4><h5><h6><img><label><ul><ol><li><br><audio><embed><video>','HTML标签','发帖被允许的安全HTML标签，若不清楚默认就行','label',0,'data-labelbox-delimiter=\"><\" data-labelbox-start=\"<\" data-labelbox-end=\">\"','post',0),(13,'htmlsafeattrs','class,style,href,target,src,width,height,title,alt,border,align,valign,color,size,controls,autoplay,loop,type,face,id,lang,cellpadding,cellspacing','HTML安全属性','发帖被允许的HTML标签的属性，若不清楚默认就行','label',0,NULL,'post',0),(14,'readtitlemin','1','文章标题最少字数','低于该值的文章无法发出，0为不限制','number',0,NULL,'post',0),(15,'readtitlemax','100','文章标题最多字数','高于该值的文章无法发出，0为不限制','number',0,NULL,'post',0),(16,'readcontentmin','10','文章内容最少字数','低于该值的文章无法发出，0为不限制','number',0,'','post',0),(17,'readcontentmax','1048576','文章内容最多字数','高于该值的文章无法发出，0为不限制','number',0,'','post',0),(18,'jingyan_name','经验','经验的别名','该值必须设置，默认：经验','text',1,'','integral',0),(19,'jinqian_name','金钱','金钱的别名','该值必须设置，默认：金钱','text',1,'','integral',0),(20,'jingyan_level','0|萌新驾到,10|一级会员,20|二级会员,50|三级会员,100|四级会员,200|五级会员,500|六级会员,1000|七级会员,2000|八级会员,5000|九级会员,10000|一级元老,20000|二级元老,50000|三级元老,100000|左护法,200000|右护法,500000|教主','用户等级对应的经验数','从小到大依次填写，大于或等于该经验值将获得对应称号，格式：经验值|称号','label',0,'','integral',0),(21,'postread_jingyan','5','用户发布新文章获得的经验','可以为负值，若为负值在用户经验低于0时将无法发布文章','number',0,'','integral',0),(22,'postread_jinqian','0','用户发布新文章获得的金钱','可以为负值，若为负值在用户金钱低于0时将无法发布文章','number',0,'','integral',0),(23,'cloudpay_open','0','云支付','<a href=\"javascript:;\" onclick=\"cloudpaySetup()\" class=\"pk-text-danger pk-hover-underline\">一键配置</a>即开即用，简单高效的支付方式。','toggle',0,'','pay',0),(24,'rmb2jinqian','10','1元可充值多少金钱','用户充值时1元可以兑换多少金钱，只能设置整数，不可设置小数及小于1的数字','number',1,'','pay',9),(25,'reg_open','1','开启注册',NULL,'toggle',0,NULL,'reg',0),(26,'reg_groupid','1','新用户用户组',NULL,'text',0,NULL,'reg',0),(27,'api_url','','接口地址','请输入完整域名地址，例如：https://www.puyuetian.com/','text',0,NULL,'api',0),(28,'reg_jingyan','0','新注册用户初始经验数',NULL,'number',0,NULL,'reg',0),(29,'reg_jinqian','0','新注册用户初始金钱数',NULL,'number',0,NULL,'reg',0),(30,'editor_tools','source,bold,italic,underline,strikethrough,fontname,fontsize,forecolor,justifyleft,justifycenter,justifyright,link,unlink,table,image,attachment,code','前端编辑器工具栏','仅影响前端（H5、APP、小程序）编辑器工具栏，后台默认全部显示，可用值：source,bold,italic,underline,strikethrough,fontname,fontsize,forecolor,backcolor,justifyleft,justifycenter,justifyright,link,unlink,table,image,attachment,video,music,code,undo,redo\n','label',1,'','post',0),(31,'api_navsortids','','首页分类ID','输入分类id即可，这里决定调用api的首页的分类列表','label',0,'','api',0),(32,'api_replyorder','replytime desc','评论排序方式','','<select class=\"pk-textbox\" name=\"{$name}\" data-value=\"{$value}\"><option value=\"replytime asc\">按时间从早到晚</option><option value=\"replytime desc\">按时间从晚到早</option></select>',1,'','api',0),(33,'replycontentmin','1','评论内容最少字数','','number',1,'','post',0),(34,'replycontentmax','10000','评论内容最多字数','','number',1,'','post',0),(35,'postreply_jingyan','2','用户发布新评论获得的经验','可以为负值，若为负值在用户经验低于0时将无法发布评论','number',0,'','integral',0),(36,'postreply_jinqian','0','用户发布新评论获得的金钱','可以为负值，若为负值在用户金钱低于0时将无法发布评论','number',0,'','integral',0),(37,'cloudpay_domain','','云支付接口域名','请填写完整的域名，例如：www.puyuetian.com','text',0,'','pay',0),(38,'cloudpay_notify_url','','云支付异步通知地址','请填写http://你的域名/general/cloudpay_notify','text',0,'','pay',0),(39,'cloudpay_return_url','','云支付支付完成跳转地址','请填写http://你的域名/general/cloudpay_return','text',0,'','pay',0),(40,'cloudpay_sitekey','','云支付sitekey','请在https://www.hadsky.net/zhanzhang处获取','text',0,'','pay',0),(41,'cloudpay_timeout','3600','云支付超时时间','单位：秒，自订单创建起计时，超时后将无法继续通讯，建议：1800','number',0,'','pay',0),(42,'adminids','1','后台管理员ID','输入用户ID','label',0,'','admin',0),(43,'cloudpay_setupinfo','','云支付一键配置信息','','text',0,'','hidden',0),(45,'api_showrecharge','0','显示充值系统','开启会显示充值按钮和账单按钮，收藏会改为已购','toggle',0,NULL,'api',0),(46,'beianhao','','备案号','已备案网站必须填写','text',0,NULL,'set',0),(47,'api_autoh5','0','自动切换H5','移动设备访问自动切换到H5','toggle',0,NULL,'api',0),(48,'showreplylist','1','显示评论列表','若关闭网页端和APP将不会显示评论列表和评论框','toggle',0,NULL,'post',0),(49,'useragreement','<p><code>《用户服务协议》（以下简称“协议”）及其条款，系您下载、安装及使用“puyuetian轻博客”软件（以下简称“本软件”）所订立的、描述您与本软件之间权利义务的协议。\n\n在注册前务必认真阅读本协议的内容、充分理解各条款内容，如有异议，您可选择不进入本软件。一旦您确认本用户注册协议后，本协议即在您和本软件之间产生法律效力，意味着您完全同意并接受协议的全部条款。请您审慎阅读并选择接受或不接受协议（未成年人应在法定监护人陪同下阅读）。\n\n\n用户使用：\n用户按照页面给与的提示完成全部注册步骤后，即成为本软件的用户，用户应自行保管账号及密码，并准确、安全地使用其账号及密码。本软件可通过用户自行设定，向用户提供个性化信息服务。\n\n用户充分了解并同意，本软件为用户提供个性化信息服务，用户须为自己注册账号下的行为负责，包括用户所导入、上载、传送的任何内容以及由此产生的任何后果，用户应对本软件中的内容自行加以判断，并承担因使用内容而引起的所有风险。本软件不对因用户行为而导致的损失承担责任。\n\n用户须对在本软件上所传送信息的真实性、合法性、有效性等负责，与用户所传播的信息相关的任何法律责任由用户自行承担，与本软件无关。用户在本软件中记录的或通过本软件服务所传送的任何内容并不反映本软件的观点或政策，本软件对此不承担责任。\n\n用户提供的个人信息或发布的信息不真实、不准确、不合法；发表内容不符合本协议或发表内容不符合法律法规的，本软件有权暂停或终止用户使用本平台的服务。用户如果对本软件的暂停或者终止或收回其账号行为有异议，客户可向平台提出意见，要求其继续提供服务。本软件收到客户此类信息的投诉与意见，会审核相关信息，并及时对用户给予反馈。若信息确实不真实或不准确或不合法有效，本软件平台要求用户提供符合要求的信息。\n\n为避免用户终端数据丢失、更好服务用户之目的，本软件将向注册用户提供数据备份服务，经注册用户授权，本软件将存储于注册用户终端的本软件数据库中的数据资料上载至本软件服务器，并且提供恢复到终端设备服务。\n\n用户不得利用本软件服务制作、上载、复制、发布、传播或者转载如下内容：\n\n反对宪法所确定的基本原则的；\n\n危害国家安全，泄露国家秘密，颠覆国家政权，破坏国家统一的；\n\n损害国家荣誉和利益的；\n\n煽动民族仇恨、民族歧视，破坏民族团结的；\n\n破坏国家宗教政策，宣扬邪教和封建迷信的；\n\n散布谣言，扰乱社会秩序，破坏社会稳定的；\n\n散布淫秽、色情、赌博、暴力、凶杀、恐怖或者教唆犯罪的；\n\n侮辱或者诽谤他人，侵害他人合法权益的；\n\n法律、行政法规禁止的其他内容。\n本软件有权针对用户发表的内容进行审核，若用户实施违反本条所述使用规则及法律法规的行为，本软件平台有权视行为严重程度，根据《侵权责任法》《信息网络传播权保护条例》等法律法规要求用户立即采取纠正、改正、恢复原状、消除影响等行为，且本软件有权自行采取合法有效且必要的措施（包括但不限于更改或删除相关侵权信息、暂停或终止用户使用本网络服务等），同时本软件保留进一步追究用户法律责任的权利。\n\n同时，论坛社区版块发起者、管理者应当履行与本协议权利、法律法规相适应的义务，对违反法律规定和协议约定、履行责任义务不到位的服务提供者应当依法依约限制（更改或删除相关侵权信息、暂停使用）或取消其管理权限，直至封禁或者关闭有关账号、版块。\n\n用户禁止以文字、语音、图片等任何形式刻意宣传其他竞争平台；也禁止以相同的方式宣传非本软件联系方式，如果有聊天需求，可告知听众使用本软件私信联系。\n\n本软件的部分功能将产生资讯费用，具体资费标准以用户使用的电信运营商公布的价格为准，该部分费用应由用户自行承担。\n\n本软件提供的服务中可能包含广告，用户同意在使用过程中显示本软件和第三方供应商、合作伙伴提供的广告。用户因就第三方提供的服务、产品与第三方产生争议的，由用户与第三方自行解决，本软件不承担责任。\n\n本软件保留因业务发展需要，单方面对其服务器所提供的全部或部分服务内容在任何时候不经任何通知的情况下变更、暂停、限制、终止或撤销服务的权利。\n\n直播播主应尽量促进来访者的成长、自强自立；应避免负面结论而对用户造成消极的暗示， 或使用户在其未来的生活中对主播产生依赖。\n\n主播可通过听众送礼物获得星票。\n\n直播会消耗通讯设备电力，缩短设备使用时长；在直播过程中应做好充电准备，避免直播突然掉线影响直播效果。\n\n未成年人个人信息：\n若您是未成年人，建议您的监护人仔细阅读本隐私保护条例的条款，并在征得您的监护人同意的前提下使用我们的产品和服务或向我们提供信息。\n\n如您的监护人不同意您使用我们的服务或向我们提供信息，请您立即终止使用我们的服务并及时通知我们，以便我们采取相应的措施。\n\n如果监护人发现我们在未获监护人同意的情况下收集了未成年人的个人信息，请监护人反馈联系我们，我们在核准相关情况后尽快删除您的个人数据。\n\n法律责任与免责：\n本软件平台对平台进行停机维护、定期检查、更新软硬件、针对突发事件、不可抗力、电脑病毒、系统故障等因素导致的正常服务中断、中止，本软件不承担责任，本软件平台将尽力避免服务中断并将中断时间限制在最短时间内。\n\n用户因第三方如电信部门的通讯线路故障、技术问题、网络、电脑故障、系统不稳定性及其他各种不可抗力原因而遭受的一切损失，本软件不承担责任。\n\n因用户违反本协议或相关的服务条款的规定，导致或产生的任何第三方向本软件主张的索赔，由用户自行承担。\n\n用户在本软件平台发表的观点及立场，并不代表本软件的立场，用户应自行对发表内容负责。\n\n请客户自行妥善保管个人资料，将个人信息提供足够保障及备份，并采取适当的预防措施降低电脑病毒或其他恶意破坏性举动的风险。\n\n由于您的隐私权对本网站相当重要，除非有权机关依法调取或者第三条约定，本软件平台不会无故把您的个人信息提供给无关的第三方，但不对第三人恶意侵权导致信息泄露而产生的后果负责。\n\n知识产权：\n本软件的一切知识产权，以及与软件相关的所有信息内容，包括但不限于：文字表述及其组合、图标、图饰、图像、图表、色彩、界面设计、版面框架、有关数据、附加程序、印刷材料或电子文档等均归本软件所有，受著作权法和国际著作权条约以及其他知识产权法律法规的保护。\n\n未经本软件书面同意，用户不得为任何营利性或非营利性的目的自行实施、利用、转让或许可任何三方实施、利用、转让上述知识产权。出现上述未经许可之行为时，本软件保留追究相关责任人法律责任之权利。\n\n修改与解释权：\n根据互联网的发展和有关法律、法规及规范性文件的变化，或者因业务发展需要，本软件有权对本协议的条款作出修改或变更，一旦本协议的内容发生变动，您可在本软件官方网站查阅最新版协议条款，该公布行为视为本软件已经通知用户修改内容，而不另行对用户进行个别通知。在本软件修改协议条款后，如果您不接受修改后的条款，请立即停止使用本软件提供的服务，您继续使用本软件提供的服务将被视为已接受了修改后的协议。\n\n通知\n您在注册成为本软件用户，并接受本软件服务时，您应该本软件提供真实有效的联系方式（包括您的电子邮件地址、联系电话、联系地址等），对于联系方式发生变更的，您有义务及时更新有关信息，并保持可被联系的状态。\n\n本软件将向您的上述联系方式的其中之一或其中若干向您送达各类通知。平台信息发送成功后即视为送达；以纸质载体发出的书面通知，按照提供联系地址交邮后的第五个自然日即视为送达。\n\n法律适用、管辖与其他：\n本软件郑重提醒用户注意本协议中可能存在的免除本软件责任和加重用户义务的条款，请用户仔细阅读，自主考虑风险。\n\n本协议之订立、生效、解释、修订、补充、终止、执行与争议解决均适用中华人民共和国法律；如法律无相关规定的，参照商业惯例或行业惯例。\n\n与本协议、使用本软件发生的任何争议或纠纷，双方应尽量友好协商解决；协商不成时，任何一方均有权将纠纷交由北京市海淀区人民法院管辖。\n\n本协议任一条款被视为废止、无效或不可执行，该条应视为可分的且并不影响本协议其余条款的有效性及可执行性。</code></p><p><br></p>','用户服务协议及隐私政策','将会显示在登录及注册界面','editor',0,NULL,'reg',0),(50,'version','1.0.0','','','text',0,NULL,'hidden',0);
DROP TABLE IF EXISTS `pk_sort`;
CREATE TABLE `pk_sort` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL DEFAULT '0' COMMENT '父分类id',
  `name` varchar(250) NOT NULL DEFAULT '',
  `content` text,
  `image` varchar(255) NOT NULL DEFAULT '',
  `rank` int(11) NOT NULL DEFAULT '0',
  `topreadids` text,
  `readcount` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4;
INSERT INTO `pk_sort` VALUES (0,0,'默认','系统默认分类，文章列表页置顶文章在此设置','/favicon.png',0,'',0),(8,0,'分类1','','/favicon.png',0,'',0);
DROP TABLE IF EXISTS `pk_upload`;
CREATE TABLE `pk_upload` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `filetype` varchar(255) NOT NULL DEFAULT '',
  `filesize` varchar(255) NOT NULL DEFAULT '',
  `filepath` varchar(255) NOT NULL DEFAULT '',
  `filename` varchar(255) NOT NULL DEFAULT '',
  `dir_path` varchar(255) NOT NULL DEFAULT '',
  `md5_file` varchar(32) NOT NULL DEFAULT '',
  `uploadtime` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4;
DROP TABLE IF EXISTS `pk_user`;
CREATE TABLE `pk_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(200) NOT NULL DEFAULT '',
  `phone` varchar(100) NOT NULL DEFAULT '',
  `email` varchar(100) NOT NULL DEFAULT '',
  `groupid` int(11) NOT NULL DEFAULT '0',
  `password` varchar(32) NOT NULL DEFAULT '',
  `jinqian` int(11) NOT NULL DEFAULT '0' COMMENT '金钱',
  `jingyan` int(11) NOT NULL DEFAULT '0' COMMENT '经验',
  `regtime` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`),
  KEY `phone` (`phone`),
  KEY `email` (`email`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4;
INSERT INTO `pk_user` VALUES (0,'guest','','',0,'',0,0,0),(1,'admin','1','1',7,'dc65cab30cfe422c4f22e75d8a51e2e1',0,0,0);
UPDATE `pk_group` SET `id`=0 WHERE `name`='游客';
UPDATE `pk_sort` SET `id`=0 WHERE `name`='默认';
UPDATE `pk_user` SET `id`=0 WHERE `username`='guest';