<?php
namespace app\install;

// 检测是否安装
if (is_file(PK_APP_PATH . 'install/install.locked')) {
    \error('已安装程序');
}

// 安装程序
if (\input('get.submit/d')) {
    $post = \input('post.');
    foreach ($post as $key => $value) {
        $$key = $value;
    }
    // 链接数据库
    require PK_LIB_PATH . 'db/' . $sqltype . '.php';
    $r = $pdo->query('SELECT VERSION()');
    while ($v = $r->fetch(\PDO::FETCH_ASSOC)) {
        $sqlv = \current($v);
    }
    //判断MySQL版本是否支持本框架
    if (\version_compare($sqlv, '5.5.3', '<')) {
        \error('MySQL数据库版本不能低于5.5.3');
    }
    // 读取数据文件
    $sql = \file_get_contents(PK_APP_PATH . 'install/sql/data.sql');
    //去除bom
    if (\ord(\substr($sql, 0, 1)) == 239 && \ord(\substr($sql, 1, 1)) == 187 && \ord(\substr($sql, 2, 1)) == 191) {
        $sql = \substr($sql, 3);
    }
    //数据表前缀替换
    $sql  = \str_replace('`pk_', "`{$prefix}", $sql);
    $sql  = \str_replace("\r", '', $sql);
    $sqls = \explode(";\n", $sql);
    foreach ($sqls as $sql) {
        if (!\trim($sql, "\x00..\x1F")) {
            continue;
        }
        $r = $pdo->query($sql);
        if (!$r) {
            \error("出错语句：" . $sql . "，出错原因：" . $pdo->errorInfo()[2]);
        }
    }
    $pdo->query("UPDATE `{$prefix}user` SET `username`='{$user}',`password`='" . \md5($pass) . "' WHERE `id`='1'");
    \file_put_contents(PK_APP_PATH . 'install/install.locked', 1);

    // 写入配置文件
    $dbconfig = <<<EOF
<?php

return [
    // 数据库类型,此处也是是否链接数据库的关键,为空则为不链接数据库
    'type' => '{$sqltype}',
    // 服务器地址
    'hostname' => '{$hostname}',
    // 数据库名
    'database' => '{$database}',
    // 用户名
    'username' => '{$username}',
    // 密码
    'password' => '{$password}',
    // 端口
    'hostport' => '{$hostport}',
    // 连接dsn
    'dsn' => '',
    // 数据库编码默认采用utf8
    'charset' => '{$charset}',
    // 数据库表前缀
    'prefix' => '{$prefix}',
    // 数据库调试模式
    'debug' => true,
    // 开启数据库缓存，数字格式，0为关闭,其他为缓存时长
    'cache_timeout' => 0,
    // 被缓存的表列表，多个用,分开，不建议缓存重要数据表,例如:用户信息及支付记录表
    'cache_tables' => 'set',
    // 缓存文件是否base64编码
    'cache_base64' => true,
    // 回收站功能
    'recycle_on' => 1
];
EOF;
    \file_put_contents(PK_CON_PATH . 'db.php', $dbconfig);

    \success('安装成功');
}

return \template('index');
