$(function () {
    $('#read').find('.showUserQrcode').after([
        '<div class="userqrcode pk-hide pk-hide-sm">',
        '<div><i></i><i></i></div>',
        '<div><div></div><p>扫码查看用户资料</p></div>',
        '</div>'
    ].join('')).on("mouseenter", function () {
        $(this).next().removeClass('pk-hide');
    }).on("mouseleave", function () {
        $(this).next().addClass('pk-hide');
    });
    var url = location.protocol + '//' + location.hostname + '/m#/pages/',
        readurl = url + 'read/index?id=' + $('#read').data('id'),
        userurl = url + 'read/user?id=' + $('#read').data('uid');
    K.qrcode(userurl, {
        selector: '.userqrcode>div:eq(1)>div:eq(0)',
        width: 120,
        height: 120
    });
    if ($('.loginTip>div:eq(0)').length) {
        K.qrcode(readurl, {
            selector: '.loginTip>div:eq(0)',
            width: 200,
            height: 200
        });
    }
    K.viewer('.content');

    // 评论处理
    var template = $('#replyTemplate').html(),
        replyList = $('#replyTemplate').data('data'),
        page = 1;
    $('#loadReplyBtn').on('click', function () {
        if ($(this).hasClass('active')) {
            return false;
        }
        $('#loadReplyBtn').addClass('active').html([
            '<img src="',
            K.URL('app/index/web/img/replylistloading.gif'),
            '" class="loading" />',
            '<span>加载中</span>'
        ].join(''));
        $.getJSON(K.URL('index/index/t/reply/type/list'), {
            rid: $('#read').data('id'),
            page
        }, function (rd) {
            if (!rd['code']) {
                K.alert(rd['msg'], 2);
                return false;
            }
            var list = rd['data'];
            if (!list.length) {
                if (page > 1) {
                    $('#loadReplyBtn').html('已无更多评论');
                } else {
                    $('#loadReplyBtn').addClass('null').html('快来抢沙发啦~');
                }
                return false;
            }
            $('#loadReplyBtn').removeClass('active').html('加载更多');
            page++;
            for (var i = 0; i < list.length; i++) {
                list[i]['datetime'] = K.date('Y-m-d H:i', list.posttime);
            }
            $('#reply .replyContent').append(K.templates(template, list));
            var ul = location.protocol + '//' + location.hostname + '/m#/pages/read/user?id=',
                a = $('#reply').find('.showUserQrcode:not(.loaded)');
            for (var i = 0; i < a.length; i++) {
                var uid = $(a[i]).addClass('loaded').after([
                    '<div class="userqrcode pk-hide pk-hide-sm">',
                    '<div><i></i><i></i></div>',
                    '<div><div></div><p>扫码查看用户资料</p></div>',
                    '</div>'
                ].join('')).on("mouseenter", function () {
                    $(this).next().removeClass('pk-hide');
                }).on("mouseleave", function () {
                    $(this).next().addClass('pk-hide');
                }).data('uid');
                K.qrcode(ul + uid, {
                    selector: $(a[i]).next().find('>div:eq(1)>div:eq(0)'),
                    width: 120,
                    height: 120
                });
            }
        });
    }).trigger('click');
    $('#replyBtn').on('click', function () {
        K.P({
            type: 2,
            inputtype: 'textarea',
            title: '写评论',
            noclose: 1,
            submit(id, value) {
                value = K.trim(value);
                if (!value) {
                    K.msg('评论内容不能为空', 2);
                    return false;
                }
                $.post(K.URL('index/index/t/reply/type/post'), {
                    rid: $('#read').data('id'),
                    content: value
                }, function (rd) {
                    if (!rd['code']) {
                        K.alert(rd['msg'], 2);
                        return false;
                    }
                    K.close(id);
                    var data = {
                        id: rd['data']['id'],
                        content: value,
                        user: {
                            headpic: $('#logoutBtn .headpic').attr('src'),
                            username: $('#logoutBtn').text(),

                        },
                        datetime: '刚刚'
                    };
                    $('#reply .replyContent').prepend(K.template(template, data));
                    if ($('#loadReplyBtn').hasClass('null')) {
                        $('#loadReplyBtn').removeClass('null').html('已无更多评论');
                    }
                });
            },
            complete(id, o) {
                o.find('.pk-popup-submit').html('评论');
            }
        });
    });
});