function delrr(type, id, me) {
    K.confirm('确认删除该' + (type == 'read' ? '文章' : '评论') + '吗？', function () {
        $.getJSON(K.URL('index/index/t/del/type/' + type + '/id/' + id), function (rd) {
            if (!rd['code']) {
                K.alert(rd['msg'], 2);
                return false;
            }
            K.msg('删除成功', 1);
            if (typeof (me) == "object") {
                $(me).remove();
            } else {
                setTimeout(function () {
                    location.href = K.URL('/');
                }, 1500);
            }
        });
    });
}
$(function () {
    var _get = $('body').data('_get'),
        url = location.protocol + '//' + location.hostname + '/m',
        h5url = url;
    switch (_get.t) {
        case 'list':
            if (parseInt(_get.sid)) {
                url += '#/pages/sort/list?sid=' + _get.sid + '&title=' + encodeURIComponent($('#list').data('sortname'));
            }
            break;
        case 'read':
            url += '#/pages/read/index?id=' + _get.id;
            break;
        default:
            break;
    }
    if (K.is_small_screen() && parseInt($('body').data('autoh5'))) {
        // 手机来访
        location.href = url;
    }
    $('#page').append([
        $('#template').html()
    ].join(''));
    $('#ma').attr('href', url);
    K.qrcode(url, {
        selector: '.qrcode>div',
        width: 102,
        height: 102
    });
    $('#logoutBtn').on('click', function () {
        var url = $(this).data('href');
        var content = [
            '<div class="pk-text-center">',
            '<a class="pk-btn pk-btn-danger" href="',
            h5url + '#/pages/my/index',
            '">访问H5修改个人资料</a>',
            '</div>'
        ].join('');
        if (!K.is_small_screen()) {
            content = [
                '<div class="pk-text-center pk-text-sm pk-text-danger">',
                '<div class="_qrcode" style="width:100%;height:150px"></div>',
                '<p class="pk-padding-5">手机扫码登录修改个人资料</p>',
                '</div>'
            ].join('');
        }
        K.P({
            title: '提示',
            content,
            type: 1,
            submit() {
                $.getJSON(url, function (rd) {
                    if (!rd['code']) {
                        K.alert(rd['msg'], 2);
                        return false;
                    }
                    K.msg('成功退出登录', 1);
                    setTimeout(function () {
                        location.reload();
                    }, 1500);
                });
            }, complete(id, o) {
                if (!K.is_small_screen()) {
                    K.qrcode(h5url, {
                        selector: o.find('._qrcode'),
                        width: 150,
                        height: 150
                    });
                }
                o.find('.pk-popup-submit').html('退出登录');
            }
        });
    });
});