<?php

namespace app\general;

// 文件保存的格式，upload/类型/日期/文件
$savepath = \str_replace('{uid}', config('cud.id'), \config('upload_config_savepath'));
$upload   = \upload([
    // 是否允许上传文件
    'open'      => config('upload_config_open'),
    // 一次最多上传的文件数,0为不限制
    'count'     => config('upload_config_count'),
    // 文件允许的最大大小,b,默认10m
    'size'      => config('upload_config_size'),
    // 文件存储的路径
    'savepath'  => $savepath,
    // 允许上传的文件后缀,为空为不限制,小写
    'suffix'    => config('upload_config_suffix'),
    // 若存在相同文件返回已上传的同文件
    'no_repeat' => config('upload_config_no_repeat'),
]);
$r = $upload->file(\input('upload_input_name/s'));
if (!$r) {
    \error($upload->error());
}
\success('ok', $upload->moves($savepath, [
    'uid' => config('cud.id'),
]));
