<?php
// 用户共用函数模块

// 验证码校验
function checkVerifycode($t, $verifycode)
{
    $vc = strtolower(session("code.$t"));
    session("code.$t", '');
    if (!$verifycode) {
        return false;
    }
    if (strtolower($verifycode) != $vc) {
        return false;
    }
    return true;
}

// 接口数据添加接口地址
function apiUrlAdd($str, $isContent = false, $apiurl = false)
{
    if (!$str) {
        return '';
    }
    if (!$apiurl) {
        $apiurl = config('api_url');
    }
    if (!$isContent) {
        $a = explode(',', $str);
        foreach ($a as $k => $b) {
            if (substr($b, 0, 7) == 'http://' || substr($b, 0, 8) == 'https://' || substr($b, 0, 2) == '//') {
                continue;
            }
            $a[$k] = rtrim($apiurl, '/') . '/' . ltrim($b, '/');
        }
        return implode(',', $a);
    }
    $marks = [
        'a'     => 'href',
        'img'   => 'src',
        'video' => 'src',
        'audio' => 'src',
    ];
    foreach ($marks as $mark => $url) {
        $htmls = getHtmlMarks($str, $mark);
        foreach ($htmls as $v) {
            $src = isset($v[$url]) ? $v[$url] : '';
            if (substr($src, 0, 7) == 'http://' || substr($src, 0, 8) == 'https://' || substr($src, 0, 2) == '//') {
                continue;
            }
            $str = str_replace($src, rtrim($apiurl, '/') . '/' . ltrim($src, '/'), $str);
        }
    }
    return $str;
}

/**
 * 获取用户头像
 * @param number $uid 用户id
 */
function userHeadPic($uid)
{
    $uid   = cnum($uid);
    $tpath = PK_WWWROOT . "upload/headpic/{$uid}.png";
    if (file_exists($tpath)) {
        return apiUrlAdd("upload/headpic/{$uid}.png");
    }
    return apiUrlAdd('upload/headpic/0.png');
}

/**
 * 转换用户等级称号
 * @param number $jingyan 用户jingyan值
 */
function userLevelName($jingyan)
{
    $name           = '';
    $jingyan_levels = \explode(',', config('jingyan_level'));
    foreach ($jingyan_levels as $level) {
        $level = explode('|', $level);
        if ($jingyan >= $level[0]) {
            $name = $level[1];
        }
    }
    return $name;
}

/**
 * 发布文章
 * @param array $post 待发布文章的数据
 * @return string 成功返回文章id，失败返回失败的原因字符串
 */
function postRead($post)
{
    $savefields = ['id', 'uid', 'sid', 'title', 'content', 'jinqian', 'showmedia'];
    $data       = [];
    $cjf        = true;
    foreach ($savefields as $field) {
        if (!isset($post[$field])) {
            $post[$field] = '';
        }
        $data[$field] = $post[$field];
        if (!in_arrays($field, 'title,content')) {
            // 数字类型数据
            $data[$field] = cnum($data[$field]);
        }
    }
    // uid初始化
    if (!$data['uid']) {
        $data['uid'] = config('cud.id');
    }
    // 如果发布人id与当前用户不符则为管理员发布，积分不变动
    if (config('cud.id') != $data['uid']) {
        $cjf = false;
    }
    // 判断当前用户是否有权限更改发布人
    if (config('cud.id') != $data['uid'] && !isAdmin()) {
        return '您无权该操作';
    }
    // sid
    if (!$data['sid']) {
        return '分类不能为空';
    }
    if ($data['id']) {
        // 编辑 & 校验
        $readdata = db('read')->where($data['id'])->find();
        if (!$readdata) {
            return '不存在的文章';
        }
        if (config('cud.id') != $readdata['uid'] && !userQx('admin')) {
            return '无权限编辑该文章';
        }
        if (userQx('noeditread')) {
            return '您被禁止编辑文章';
        }
        if (!isAdmin()) {
            // 只有超级管理员可以更改文章的发布人
            $data['uid'] = $readdata['uid'];
        }
    } else {
        // 发布 & 检验
        if (userQx('nopostread')) {
            return '您被禁止发布文章';
        }
        // 积分校验
        if ($cjf) {
            $cjq = cnum(config('postread_jinqian'));
            if ($cjq < 0 && config('cud.jinqian') + $cjq < 0) {
                return config('jinqian_name') . '不足无法发布文章';
            }
            $cjy = cnum(config('postread_jingyan'));
            if ($cjy < 0 && config('cud.jingyan') + $cjy < 0) {
                return config('jingyan_name') . '不足无法发布文章';
            }
        }
        // 发布时间
        $data['posttime'] = time();
        // 发布ip
        $data['ip'] = sysConfig('client_ip');
    }
    // 标题检验
    $data['title'] = strip_tags($data['title']);
    if (!cstr($data['title'], false, false, config('readtitlemin'), config('readtitlemax'))) {
        return '文章标题字数限制：' . config('readtitlemin') . '到' . config('readtitlemax') . '个字';
    }
    // 内容检验
    if (!isAdmin()) {
        $data['content'] = html2safehtml($data['content'], config('htmlsafemarks'), config('htmlsafeattrs'));
    }
    if (!cstr($data['content'], false, false, config('readcontentmin'), config('readcontentmax'))) {
        return '文章内容字数限制：' . config('readcontentmin') . '-' . config('readcontentmax') . '个字';
    }
    // 图片base64转为文件
    $savepath        = str_replace('{uid}', config('cud.id'), \config('upload_config_savepath'));
    $savepath        = str_replace(['{Y}', '{m}', '{d}', '{H}', '{i}', '{s}', '{date}', '{time}', '{type}'], [date('Y'), date('m'), date('d'), date('H'), date('i'), date('s'), date('Y/m/d'), time(), 'image/base64'], $savepath);
    $data['content'] = k::imgsBase64ToFile($data['content'], $savepath, [
        'upload' => [
            'uid'        => config('cud.id'),
            'filetype'   => 'image/base64',
            'filesize'   => '{filesize}',
            'filepath'   => '{filepath}',
            'filename'   => '{filename}',
            'dir_path'   => '{dir_path}',
            'md5_file'   => '{md5_file}',
            'uploadtime' => time(),
        ],
    ], config('upload_config_no_repeat'));
    // 媒体文件更新
    // 获取图片
    $a = [];
    $d = getHtmlImgs($data['content']);
    foreach ($d as $v) {
        $a[] = $v['src'];
    }
    $data['image'] = implode(',', $a);
    // 获取视频
    $a = [];
    $d = getHtmlMarks($data['content'], 'video');
    foreach ($d as $v) {
        $a[] = $v['src'];
    }
    $data['video'] = implode(',', $a);
    // 获取音频
    $a = [];
    $d = getHtmlMarks($data['content'], 'audio');
    foreach ($d as $v) {
        $a[] = $v['src'];
    }
    $data['audio'] = implode(',', $a);
    // 获取附件
    $a = [];
    $d = getHtmlMarks($data['content'], 'a');
    foreach ($d as $v) {
        if (isset($v['class']) && strpos($v['class'], 'pk-attachment-link') !== false) {
            $a[] = $v['href'];
        }
    }
    $data['attachment'] = implode(',', $a);

    // 发布/更新
    $id = $data['id'];
    $db = db('read')->allowFields(true);
    if ($data['id']) {
        // 更新
        $r = $db->update($data);
    } else {
        // 发布
        unset($data['id']);
        $r = $db->insertGetId($data);
        if ($r) {
            // 分类数量增加
            sortReadChange($data['sid'], 1);
            // 积分变动
            if ($cjf) {
                $cjq = cnum(config('postread_jinqian'));
                if ($cjq) {
                    trade($cjq, '发布文章[{$value}]', $data['uid']);
                }
                $cjy = cnum(config('postread_jingyan'));
                db('user')->update([
                    'id'      => $data['uid'],
                    'jingyan' => ['+', $cjy],
                ]);
            }
        }
        $id = $r;
    }
    if (!$r) {
        return db()->error();
    }
    return $id;
}

/**
 * 发布评论
 * @param array $post 待发布评论的数据
 * @return string 成功返回评论id，失败返回失败的原因字符串
 */
function postReply($post)
{
    $savefields = ['id', 'uid', 'rid', 'content'];
    $data       = [];
    // 积分是否变动
    $cjf = true;
    foreach ($savefields as $field) {
        if (!isset($post[$field])) {
            $post[$field] = '';
        }
        $data[$field] = $post[$field];
        if (!in_arrays($field, 'title,content')) {
            // 数字类型数据
            $data[$field] = cnum($data[$field]);
        }
    }
    // uid初始化
    if (!$data['uid']) {
        $data['uid'] = config('cud.id');
    }
    // 如果发布人与当前用户id不符，则为管理员发布，积分不变动
    if (config('cud.id') != $data['uid']) {
        $cjf = false;
    }
    // 判断当前用户是否有权限更改发布人
    if (config('cud.id') != $data['uid'] && !isAdmin()) {
        return '您无权该操作';
    }
    // rid
    if (!$data['rid']) {
        return '评论对象不能为空';
    }
    if ($data['id']) {
        // 编辑 & 校验
        $replydata = db('reply')->where($data['id'])->find();
        if (!$replydata) {
            return '不存在的评论';
        }
        if (config('cud.id') != $replydata['uid'] && !userQx('admin')) {
            return '无权限编辑该评论';
        }
        if (userQx('noeditreply')) {
            return '您被禁止编辑评论';
        }
        if (!isAdmin()) {
            // 只有超级管理员可以更改文章的发布人
            $data['uid'] = $replydata['uid'];
        }
    } else {
        // 发布 & 检验
        if (userQx('nopostreply')) {
            return '您被禁止发布评论';
        }
        // 积分校验
        if ($cjf) {
            $cjq = cnum(config('postreply_jinqian'));
            if ($cjq < 0 && config('cud.jinqian') + $cjq < 0) {
                return config('jinqian_name') . '不足无法发布评论';
            }
            $cjy = cnum(config('postreply_jingyan'));
            if ($cjy < 0 && config('cud.jingyan') + $cjy < 0) {
                return config('jingyan_name') . '不足无法发布评论';
            }
        }
        // 发布时间
        $data['replytime'] = time();
        // 发布ip
        $data['ip'] = sysConfig('client_ip');
    }
    // 内容检验
    if (!isAdmin()) {
        $data['content'] = html2safehtml($data['content'], config('htmlsafemarks'), config('htmlsafeattrs'));
    }
    if (!cstr($data['content'], false, false, config('replycontentmin'), config('replycontentmax'))) {
        return '评论内容字数限制：' . config('replycontentmin') . '-' . config('replycontentmax') . '个字';
    }

    // 图片base64转为文件
    $savepath        = str_replace('{uid}', config('cud.id'), \config('upload_config_savepath'));
    $savepath        = str_replace(['{Y}', '{m}', '{d}', '{H}', '{i}', '{s}', '{date}', '{time}', '{type}'], [date('Y'), date('m'), date('d'), date('H'), date('i'), date('s'), date('Y/m/d'), time(), 'image/base64'], $savepath);
    $data['content'] = k::imgsBase64ToFile($data['content'], $savepath, [
        'upload' => [
            'uid'        => config('cud.id'),
            'filetype'   => 'image/base64',
            'filesize'   => '{filesize}',
            'filepath'   => '{filepath}',
            'filename'   => '{filename}',
            'dir_path'   => '{dir_path}',
            'md5_file'   => '{md5_file}',
            'uploadtime' => time(),
        ],
    ], config('upload_config_no_repeat'));

    // 发布/更新
    $id = $data['id'];
    $db = db('reply')->allowFields(true);
    if ($data['id']) {
        // 更新
        $r = $db->update($data);
    } else {
        // 发布
        unset($data['id']);
        $r = $db->insertGetId($data);
        if ($r) {
            // 评论数量增加
            readReplyCount($data['rid'], 1);
            // 积分变动
            if ($cjf) {
                if ($cjq) {
                    trade($cjq, '发布评论[{$value}]');
                }
                db('user')->update([
                    'id'      => $data['uid'],
                    'jingyan' => ['+', $cjy],
                ]);
            }
        }
        $id = $r;
    }
    if (!$r) {
        return db()->error();
    }
    return $id;
}

/**
 * 删除文章
 * @param number $where 待删除文章的where
 */
function delRead($where)
{
    $reads = db('read')->field('id,sid')->where($where)->select();
    foreach ($reads as $read) {
        // 分类数量减少
        sortReadChange($read['sid'], -1);
    }
    db('read')->where($where)->delete();
    return true;
}

/**
 * 删除评论
 * @param number $where 待删除评论的where
 */
function delReply($where)
{
    $reads = db('reply')->field('id,rid')->where($where)->select();
    foreach ($reads as $read) {
        // 评论数量减少
        readReplyCount($read['rid'], -1);
    }
    db('reply')->where($where)->delete();
    return true;
}

/**
 * 删除合集，带权限判断
 * @param string $type read/reply
 * @param number $where 待删除文章/评论的where
 */
function delRr($type, $where)
{
    if (!\userQx('admin')) {
        // 判断文章或回复是否自己的
        if (!\db($type)->where($where)->where([
            'uid' => \config('cud.id'),
        ])->find()) {
            return '无权操作';
        }
    }
    // 判断是否有权限删除
    if (\userQx('nodel' . $type)) {
        return '无权删除';
    }
    if ('read' == $type) {
        delRead($where);
    } else {
        delReply($where);
    }
    return true;
}

/**
 * 交易方法
 * @param int $jinqian 交易金钱数
 * @param string $content 交易说明
 * @param int $uid 交易用户id
 */

function trade($jinqian, $content, $uid = 0)
{
    if (!$uid) {
        $user = config('cud');
    } else {
        $user = db('user')->where($uid)->find();
    }
    if (!$user) {
        return '未登录或不存在的用户[TRADE]';
    }
    if ($jinqian < 0 && $user['jinqian'] + $jinqian < 0) {
        return '账户余额不足[TRADE]';
    }
    if (!db('user')->where($user['id'])->update([
        'jinqian' => ['+', $jinqian],
    ])) {
        return db()->error();
    }
    $cjq = ($jinqian < 0 ? '-' : '+') . config('jinqian_name');
    if (!db('bill')->insert([
        'uid'       => $user['id'],
        'p'         => $user['jinqian'],
        'v'         => $jinqian,
        'n'         => $user['jinqian'] + $jinqian,
        'content'   => str_replace('{$value}', $cjq, $content),
        'tradetime' => time(),
    ])) {
        $err = db()->error();
        // 失败回退
        db('user')->where($user['id'])->update([
            'jinqian' => ['-', $jinqian],
        ]);
        return $err;
    }
    postMsg($content, $user['id']);
    return true;
}

/**
 * 发信方法
 * @param string $content 消息内容
 * @param int $tuid 收信人id
 * @param int $fuid 发信人id
 */
function postMsg($content, $tuid = 0, $fuid = 0)
{
    if (!cnum($tuid)) {
        $tuid = config('cud.id');
    }
    if (!$tuid) {
        return '收信人不存在';
    }
    if (!db('msg')->insert([
        'tuid'     => $tuid,
        'fuid'     => cnum($fuid),
        'content'  => $content,
        'islook'   => 0,
        'posttime' => time(),
    ])) {
        return db()->error();
    }
    return true;
}

/**
 * 文章购买方法
 * @param int $rid 文章id
 * @param int $uid 购买人id，默认当前登录用户
 */

function payRead($rid, $uid = 0)
{
    if (!$uid) {
        $user = config('cud');
    } else {
        $user = db('user')->where($uid)->find();
    }
    if (!$user) {
        return '未登录或不存在的用户[PAYREAD]';
    }
    if (db('readpayrecord')->where([
        'uid' => ['=', $user['id']],
        'rid' => $rid,
    ])->find()) {
        return '已购买无需重复重买';
    }
    $read = db('read')->where($rid)->find();
    if (!$read) {
        return '待购买的文章不存在';
    }
    //$jq = $read['jinqian'] . config('jinqian_name');
    // 文章发布人
    $content = "您的文章已被用户[{$user['username']}]花费[{\$value}]成功购买";
    $trade   = trade($read['jinqian'], $content, $read['uid']);
    if (true !== $trade) {
        return $trade;
    }
    // 文章购买人
    $content = "您已花费[{\$value}]成功购买文章[{$read['title']}]";
    $trade   = trade(-$read['jinqian'], $content, $user['id']);
    if (true !== $trade) {
        return $trade;
    }
    // 记录购买
    if (!db('readpayrecord')->insert([
        'uid'     => $user['id'],
        'rid'     => $read['id'],
        'jinqian' => $read['jinqian'],
        'paytime' => time(),
    ])) {
        $err = db()->error();
        postMsg("文章[ID:{$read['id']}]购买失败，但已扣费，请联系管理员处理", $user['id']);
        return $err;
    }
    return true;
}

function readReplyCount($rid, $count = 1)
{
    db('read')->where($rid)->update([
        'replycount' => ['+', $count],
    ]);
    return true;
}

/**
 * 分类文章数计数
 * @param int $sid 分类id
 * @param int $count 改变的数量
 */
function sortReadChange($sid, $count = 1, $n = 0)
{
    // if ($n > 99) {
    //     return false;
    // }
    // $db = db('sort')->where($sid)->find();
    // if (!$db) {
    //     return false;
    // }
    // db('sort')->where($sid)->update([
    //     'readcount' => ['+', $count],
    // ]);
    // if (!$sid) {
    //     return false;
    // }
    // sortReadChange($db['pid'], $count, $n + 1);
    // return true;

    // 暂时每个版块只统计自己的文章数
    db('sort')->where($sid)->update([
        'readcount' => ['+', $count],
    ]);
    return true;
}

/**
 * 分类文章数量统计
 * 不好算，先放着
 */
function sortReadCount()
{
    $sorts = db('sort')->where('id', '>', 0)->select();
    foreach ($sorts as $sort) {
        $count = db('read')->where('sid', $sort['id'])->count();
        db('sort')->where('id', $sort['id'])->update([
            'readcount' => $count,
        ]);
    }
    $pss = db('sort')->where('id', '>', 0)->where('pid', 0)->select();
    // $tj = function($sid){
    //     $
    // };
}

/*
 * 获取分类列表数据，排序从父版块开始，从小到大
 * @param $pid
 * @param $only_field 需要获取的字段列表，默认为全取
 */
function sort_list($pid, $only_field = false)
{
    myconfig('forum_data', []);
    myconfig('forum_cnum', 0);
    myconfig('_bbs_forum_list_cnum', function ($n, $last = false) {
        $str = '';
        for ($i = 0; $i < $n; $i++) {
            if ($i == $n - 1) {
                $str .= '&nbsp;' . ($last ? '└' : '├') . '&nbsp;';
            } else {
                $str .= '&nbsp;│';
            }
        }
        return $str;
    });
    myconfig('_bbs_forum_list_list', function ($pid, $r = false) {
        $data = db('sort')->where('pid', $pid)->where('id', '>', 0)->order('rank asc')->select();
        if (!$data) {
            return false;
        }
        if ($r) {
            return true;
        }
        foreach ($data as $k => $v) {
            $forum_data   = myconfig('forum_data');
            $v['_level']  = myconfig('forum_cnum');
            $v['_name']   = myconfig('_bbs_forum_list_cnum')(myconfig('forum_cnum'), count($data) - 1 == $k) . $v['name'];
            $forum_data[] = $v;
            myconfig('forum_data', $forum_data);
            if (myconfig('_bbs_forum_list_list')($v['id'], true)) {
                myconfig('forum_cnum', myconfig('forum_cnum') + 1);
                myconfig('_bbs_forum_list_list')($v['id']);
            } elseif (count($data) - 1 == $k) {
                myconfig('forum_cnum', myconfig('forum_cnum') - 1);
            }
            if (!$v['pid']) {
                myconfig('forum_cnum', 0);
            }
        }
        return myconfig('forum_data');
    });
    $data = myconfig('_bbs_forum_list_list')($pid);
    if ($only_field && $data) {
        $_data = [];
        foreach ($data as $k => $v) {
            $_data[] = $v[$only_field];
        }
        $data = $_data;
    }
    if (!$data) {
        return [];
    }
    return $data;
}

/**
 * 用户权限检测
 */
function userQx($qx, $uid = false)
{
    if (false === $uid) {
        $user = config('cud');
    } else {
        $user = db('user')->where($uid)->find();
        if (!$user) {
            return false;
        }
        $group = db('group')->where($user['groupid'])->find();
        if (!$group) {
            return false;
        }
        $user['qx'] = $group['qx'];
    }
    return in_arrays($qx, $user['qx']);
}

/**
 * 是否是后台管理员
 */
function isAdmin($uid = 0)
{
    if (!$uid) {
        $user = config('cud');
    } else {
        $user = db('user')->where($uid)->find();
    }
    if (!$user || !$user['id']) {
        return false;
    }
    if (!\in_arrays($user['id'], \config('adminids'))) {
        return false;
    }
    return true;
}
