$(function () {
    var sortdata = $('#editorBox').data('sd'),
        readdata = $('#editorBox').data('rd'),
        userCookie = $('#editorBox').data('uc'),
        submitUrl = $('#editorBox').data('url'),
        editor_tools = $('#editorBox').data('et');
    editor_tools = editor_tools.split(',');
    var sorthtml = '<select name="sid" class="pk-textbox">';
    for (var i in sortdata) {
        sorthtml += '<option value="' + sortdata[i]['id'] + '">' + sortdata[i]['_name'] + '</option>';
    }
    sorthtml += '</select>';
    var data = [{
        "name": "id"
    }, {
        "name": "sid",
        "title": "文章分类",
        "content": "",
        "type": sorthtml,
        "value": "",
        "required": 1
    }, {
        "name": "title",
        "title": "文章标题",
        "content": "",
        "type": "text",
        "value": "",
        "required": 1
    }, {
        "name": "content",
        "title": "文章内容",
        "content": "",
        "type": "textarea",
        "value": "",
        "required": 1
    }, {
        "name": "jinqian",
        "title": "全文售价（金钱）",
        "content": "如果设置了该参数，用户阅读该文章需要先付费",
        "type": "number",
        "value": "",
        "required": 1
    }, {
        "name": "showmedia",
        "title": "是否在列表页展示媒体文件",
        "content": "如果设置了该参数，所有用户在文章列表页会看到文章内的媒体文件（图片/视频）",
        "type": "toggle",
        "value": "",
        "required": 0
    }, {
        "name": "userCookie",
        "type": "hidden",
        "value": userCookie
    }];
    K.create_form({
        selector: '#editorBox',
        data,
        submit: function (formdata) {
            $.post(submitUrl, formdata, function (rd) {
                if (!rd['code']) {
                    K.alert(rd['msg'], 2);
                    return false;
                }
                var msg = '发布成功';
                if (K.cnum(formdata['id'])) {
                    msg = '更新成功';
                }
                K.msg(msg, 1);
                setTimeout(() => {
                    var pcurl = K._get('pcurl') || false;
                    if (pcurl) {
                        parent.location.href = pcurl.replace('[id]', rd['data']['id']);
                        return true;
                    }
                    uni.redirectTo({
                        url: "/pages/read/index?id=" + rd['data']['id'] + "&title=" + encodeURIComponent(formdata.title)
                    });
                }, 1500);
            });
        },
        submit_text: '发布',
        complete(o) {
            o.find('.submit-btn').addClass('pk-btn-block');
            for (var i in readdata) {
                o.find('[name="' + i + '"]').val(readdata[i]);
            }
            // 加载编辑器
            K.editor.init('textarea[name="content"]', {
                tools: editor_tools
            });
        }
    });
});