<?php

namespace app\api\common;

class replylist
{
    protected $rid   = 0;
    protected $page  = 1;
    protected $limit = 10;
    protected $order = 'id desc';
    protected $where = '';

    public function pageCount()
    {
        $count = \db('reply')->where($this->where)->count();
        $pagec = \cnum(\ceil($count / $this->limit), 1, true, 1);
        return $pagec;
    }

    public function get($get)
    {
        $getfields = ['rid', 'page', 'limit', 'order'];
        $data      = [];
        foreach ($getfields as $field) {
            if (!isset($get[$field])) {
                $get[$field] = '';
            }
            $data[$field] = $get[$field];
            // 数字类型数据
            $data[$field] = cnum($data[$field]);
        }
        if (!$data['limit']) {
            $data['limit'] = $this->limit;
        }
        if (!$data['order']) {
            $data['order'] = $this->order;
        }
        $rid   = $data['rid'];
        $page  = $data['page'];
        $limit = $data['limit'];
        $order = $data['order'];
        $where = [
            'rid' => ['=', $rid],
        ];
        $this->where = $where;
        $this->limit = $limit;

        $datas = \db('reply')->where($where)->order($order)->page($page, $limit)->select();
        foreach ($datas as $key => $data) {
            // 发布人用户信息
            $user = \db('user')->where($data['uid'])->find();
            if (!$user) {
                $user = \db('user')->where(0)->find();
            }
            $group               = \db('group')->where($user['groupid'])->find();
            $datas[$key]['user'] = [
                'id'        => $user['id'],
                'username'  => $user['username'],
                'groupname' => isset($group['name']) ? $group['name'] : '',
                'levelname' => \userLevelName($user['jingyan']),
                'headpic'   => \userHeadPic($data['uid']),
            ];
            $datas[$key]['content'] = \apiUrlAdd($data['content'], true);
            // 是否可以编辑和删除
            $datas[$key]['canedit'] = false;
            $datas[$key]['candel']  = false;
            if (\userQx('admin')) {
                $datas[$key]['canedit'] = true;
                $datas[$key]['candel']  = true;
            } else {
                if (\config('cud.id') == $data['uid']) {
                    if (!\userQx('noeditread')) {
                        $datas[$key]['canedit'] = true;
                    }
                    if (!\userQx('nodelread')) {
                        $datas[$key]['candel'] = true;
                    }
                }
            }
        }
        return $datas;
    }
}
