<?php

namespace app\api\common;

class recharge
{
    protected $id       = 0;
    protected $data     = [];
    protected $error    = '';
    protected $paytypes = 'cloudpay,alipay,weixinpay';

    protected function db()
    {
        return \db('recharge');
    }
    public function create($paytype, $rmb)
    {
        if (!\in_arrays($paytype, $this->paytypes)) {
            $this->error = '充值方式有误';
            return false;
        }
        if ($rmb < 1) {
            $this->error = '充值金额有误';
            return false;
        }
        $jinqian = $rmb * \cnum(\config('rmb2jinqian'));
        if ($jinqian < 1) {
            $this->error = '系统设置有误';
            return false;
        }
        $data = [
            'uid'        => \config('cud.id'),
            'rmb'        => $rmb,
            'paytype'    => $paytype,
            'jinqian'    => $jinqian,
            'createtime' => \time(),
            'finishtime' => 0,
            'status'     => 0,
        ];
        $id = $this->db()->insertGetId($data);
        if (!$id) {
            $this->error = $this->db()->error();
            return false;
        }
        $this->id   = $id;
        $this->data = $data;
        return true;
        // return $this->{$paytype}($id, $data);
    }
    public function cloudpay()
    {
        $data = $this->data;
        // 云支付绑定的域名
        $domain = \config('cloudpay_domain');
        // 异步通知地址
        $notify_url = \config('cloudpay_notify_url');
        // 同步跳转地址
        $return_url = \config('cloudpay_return_url');
        // 请求数据
        $data['tiandou']      = $data['jinqian'];
        $data['pay_way']      = 'alipay';
        $data['domain']       = $domain;
        $data['notify_url']   = $notify_url;
        $data['return_url']   = $return_url;
        $data['out_trade_id'] = $this->id;
        $param                = urlencode(\json_encode($data));
        // 云支付跳转地址
        $apiurl = "https://www.hadsky.net/zhanzhang/cloudpay/index?param={$param}";
        return $apiurl;
    }
    public function error()
    {
        return $this->error;
    }
}
