<?php

namespace app\api\common;

class readlist
{
    protected $where = '';
    protected $limit = 0;
    public function pageCount()
    {
        $count = \db('read')->where($this->where)->count();
        $pagec = \cnum(\ceil($count / $this->limit), 1, true, 1);
        return $pagec;
    }

    public function get($param = [])
    {
        $params = ['sid', 'uid', 'page', 'type', 'limit', 'keyword'];
        foreach ($params as $key) {
            if (!isset($param[$key])) {
                $param[$key] = '';
            }
            $$key = $param[$key];
        }
        // 参数
        $sid  = \cstr($sid, 0, \config('string_numerical') . ',');
        $uid  = \cnum($uid);
        $page = \cnum($page, 1, true, 1);
        // $type    = \input('get.type/s');
        $limit = \cnum($limit, 1, true, 1, 500, true);
        // $keyword = \input('get.keyword/s');

        $loadTopRead = false;
        if (1 == $page && !$keyword && !$type) {
            $loadTopRead = true;
        }

        $allData = [];
        // 第一次加载置顶文章，第二次加载正常文章
        $n = $loadTopRead ? 0 : 1;
        for ($n; $n < 2; $n++) {
            $where = [];
            if (!$n) {
                // 置顶
                $topreadids = '';
                $sorts      = \db('sort')->where('id', 'in', $sid)->select();
                foreach ($sorts as $sort) {
                    $topreadids .= ',' . $sort['topreadids'];
                }
                $topreadids = \trim($topreadids, ',');
                if (!$topreadids) {
                    continue;
                }
                $where['id'] = ['in', $topreadids];
            } else {
                // 普通
                if ($sid) {
                    $where['sid'] = ['in', $sid];
                }
                if ($keyword) {
                    $where['title'] = ['like', "%$keyword%"];
                }
                // 已购买/我的/用户
                switch ($type) {
                    case 'purchased':
                        $ids  = \db('readpayrecord')->where('uid', \config('cud.id'))->field('rid')->select();
                        $ids2 = [];
                        foreach ($ids as $v) {
                            $ids2[] = $v['rid'];
                        }
                        $ids2        = implode(',', $ids2);
                        $where['id'] = ['in', $ids2];
                        break;
                    case 'user':
                        $where['uid'] = $uid;
                        break;
                    default:
                        # code...
                        break;
                }
            }
            $this->limit = $limit;
            $this->where = $where;
            $datas       = \db('read')->where($where)->page($page, $limit)->order('id desc')->select();
            foreach ($datas as $key => $data) {
                // 发布人用户信息
                $user = \db('user')->where($data['uid'])->find();
                if (!$user) {
                    $user = \db('user')->where(0)->find();
                }
                $group               = \db('group')->where($user['groupid'])->find();
                $datas[$key]['user'] = [
                    'id'        => $user['id'],
                    'username'  => $user['username'],
                    'groupname' => isset($group['name']) ? $group['name'] : '',
                    'levelname' => \userLevelName($user['jingyan']),
                    'headpic'   => \userHeadPic($data['uid']),
                ];

                // 是否付费，如果是自己发布的文章，默认已付费
                if (\config('cud.id') == $data['uid']) {
                    $ff = true;
                } else {
                    $ff = \db('readpayrecord')->where([
                        'rid' => $data['id'],
                        'uid' => \config('cud.id'),
                    ])->find('id');
                }
                $datas[$key]['purchased'] = $ff ? true : false;
                // 分类
                $datas[$key]['sortname'] = \returnString(\db('sort')->where($data['sid'])->find('name'));
                // 内容格式化
                $datas[$key]['content'] = strip_tags($data['content']);
                if (!$ff && $data['jinqian']) {
                    if (!$data['showmedia']) {
                        $datas[$key]['image']      = '';
                        $datas[$key]['video']      = '';
                        $datas[$key]['audio']      = '';
                        $datas[$key]['attachment'] = '';
                    }
                    $datas[$key]['content'] = '';
                }
                $datas[$key]['image'] = \apiUrlAdd($data['image']);
                $datas[$key]['top']   = !$n ? true : false;
                // 是否可以编辑和删除
                $datas[$key]['canedit'] = false;
                $datas[$key]['candel']  = false;
                if (\userQx('admin')) {
                    $datas[$key]['canedit'] = true;
                    $datas[$key]['candel']  = true;
                } else {
                    if (\config('cud.id') == $data['uid']) {
                        if (!\userQx('noeditread')) {
                            $datas[$key]['canedit'] = true;
                        }
                        if (!\userQx('nodelread')) {
                            $datas[$key]['candel'] = true;
                        }
                    }
                }
            }
            $allData = \array_merge($allData, $datas);
        }
        return $allData;
    }
}
