<?php

namespace app\api\common;

class read
{
    protected $id  = 0;
    protected $err = '';

    public function __construct()
    {
    }

    public function error()
    {
        return $this->err;
    }
    public function get($id)
    {
        $id = \cnum($id);
        if (!$id) {
            $this->err = 'ID参数非法';
            return false;
        }
        $data = \db('read')->where($id)->find();
        if (!$data) {
            $this->err = '文章不存在';
            return false;
        }
        $data['username'] = \db('user')->where($data['uid'])->find('username');
        $data['datetime'] = \date('Y-m-d H:i:s', $data['posttime']);
        $data['showjq']   = $data['jinqian'] . \config('jinqian_name');
        // 发布人用户信息
        $user = \db('user')->where($data['uid'])->find();
        if (!$user) {
            $user = \db('user')->where(0)->find();
        }
        $group        = \db('group')->where($user['groupid'])->find();
        $data['user'] = [
            'id'        => $user['id'],
            'username'  => $user['username'],
            'groupname' => isset($group['name']) ? $group['name'] : '',
            'levelname' => \userLevelName($user['jingyan']),
            'headpic'   => \userHeadPic($data['uid']),
        ];
        // 分类
        $data['sortname'] = \returnString(\db('sort')->where($data['sid'])->find('name'));
        // 是否付费，如果是自己发布的文章，默认已付费
        if (\config('cud.id') == $data['uid']) {
            $ff = true;
        } else {
            $ff = \db('readpayrecord')->where([
                'rid' => $data['id'],
                'uid' => \config('cud.id'),
            ])->find('id');
        }
        $data['purchased'] = $ff ? true : false;
        if (!$ff && $data['jinqian']) {
            $data['content']    = '';
            $data['image']      = '';
            $data['video']      = '';
            $data['audio']      = '';
            $data['attachment'] = '';
        }
        $data['image1'] = '';
        $image          = explode(',', $data['image']);
        if (isset($image[0]) && $image[0]) {
            $data['image1'] = $image[0];
        }
        $data['content'] = \apiUrlAdd($data['content'], true);
        $data['image']   = \apiUrlAdd($data['image']);
        $data['image1']  = \apiUrlAdd($data['image1']);
        $data['video']   = \apiUrlAdd($data['video']);
        $data['audio']   = \apiUrlAdd($data['audio']);
        // 是否可以编辑和删除
        $data['canedit'] = false;
        $data['candel']  = false;
        if (\userQx('admin')) {
            $data['canedit'] = true;
            $data['candel']  = true;
        } else {
            if (\config('cud.id') == $data['uid']) {
                if (!\userQx('noeditread')) {
                    $data['canedit'] = true;
                }
                if (!\userQx('nodelread')) {
                    $data['candel'] = true;
                }
            }
        }
        return $data;
    }
}
