var _tn = $('#adddata').data('tn'),
    _tc = $('#adddata').data('tc'),
    _where = $('#adddata').data('where') || '',
    _order = $('#adddata').data('order') || 'id desc';
var _table = {},
    // 添加/编辑的后台地址
    _saveurl = K.URL('/admin/index/t/save/table/' + _tn),
    // 数据获取的后台地址
    _geturl = K.URL('/admin/index/t/table/table/' + _tn),
    // 数据删除的后台地址
    _delurl = K.URL('/admin/index/t/del/table/' + _tn),
    // 添加数据结构
    _adddata = $('#adddata').data('data') || false;
$(function () {
    $('body').append([
        '<div class="pk-row" style="padding:15px">',
        '<div class="pk-w-sm-12" style="padding-bottom:15px">',
        '<button id="addbtn" class="pk-btn pk-btn-primary pk-btn-sm" title="添加">+</button>',
        '<button id="searchbtn" class="pk-btn pk-btn-primary pk-btn-sm" type="button" style="float:right">搜索</button>',
        '<input type="text" class="pk-textbox pk-textbox-sm" id="value" style="float:right;width:100px;border-right:0;" />',
        '<select class="pk-textbox pk-textbox-sm" id="op" style="float:right;width:70px;border-left:0;border-right:0;">',
        '<option value="=">精确</option>',
        '<option value="like">模糊</option>',
        '</select>',
        '<select class="pk-textbox pk-textbox-sm" id="field" style="float:right;width:80px;"></select>',
        '</div>',
        '<div class="pk-w-sm-12">',
        '<table id="table"></table>',
        '</div>',
        '</div>',
        '<div class="pk-hide">',
        '<div id="tool" width="120" align="center">',
        _adddata ? '<button type="button" class="pk-btn pk-btn-success pk-btn-xs _tedit" data-type="edit">编辑</button> ' : '',
        '<button type="button" class="pk-btn pk-btn-danger pk-btn-xs _tdel" data-type="del">删除</button>',
        '</div>',
        '</div>',
    ].join(''));
    if (!_adddata) {
        $('#addbtn').remove();
    }
    for (var i in _tc) {
        $('#field').append('<option value="' + _tc[i]['field'] + '">' + _tc[i]['title'] + '</option>');
    }
    $('#addbtn').on('click', function () {
        for (var i in _adddata) {
            _adddata[i]['value'] = '';
        }
        K.setup_window({
            title: '添加',
            data: _adddata,
            submit: _saveurl,
            submit_ok() {
                window._table.reload(1, false, _where);
            },
            complete(o) {
                if (typeof (_editbox_complete) == "function") {
                    _editbox_complete(o);
                }
            }
        });
    });
    $('#searchbtn').on({
        click: function () {
            var field = $('#field').val(),
                type = $('#op').val(),
                value = $('#value').val(),
                where = {};
            if (value) {
                if (type == 'like') {
                    value = '%' + value + '%';
                }
                where['' + field] = [type, value];
            }
            window._table.reload(1, false, where);
        }
    });
    $('#value').on({
        keydown: function (e) {
            if (e.key == 'Enter') {
                $('#searchbtn').trigger('click');
            }
        }
    });
    // console.log($('#adddata').data('tool'))
    _table = K.table({
        elem: '#table',
        data: _geturl,
        page: {
            page: 1,
            limit: 50
        },
        order: _order,
        where: _where,
        checkbox: 0,
        cols: _tc,
        tool: $('#adddata').data('tool') == 'no' ? false : '#tool',
        tool_event: function (me, data) {
            if (me.data('type') == 'edit') {
                var edit_data = _adddata;
                for (var i in edit_data) {
                    for (var j in data) {
                        if (edit_data[i]['name'] == j) {
                            edit_data[i]['value'] = data[j];
                        }
                    }
                }
                K.setup_window({
                    title: '编辑[ID:' + data['id'] + ']',
                    data: edit_data,
                    submit: _saveurl + '?id=' + data['id'],
                    submit_ok() {
                        window._table.reload(1, false, _where);
                    },
                    complete(o) {
                        if (typeof (_editbox_complete) == "function") {
                            _editbox_complete(o);
                        }
                    }
                });
                return true;
            }
            if (me.data('type') == 'del') {
                K.confirm('确认删除该对象?[ID:' + data['id'] + ']', function () {
                    $.getJSON(_delurl + '?id=' + data['id'], function (rd) {
                        if (!rd['code']) {
                            K.alert(rd['msg'], 2);
                            return false;
                        }
                        me.parents('tr:eq(0)').remove();
                    });
                });
            }
        }
    });
});