<?php
namespace app\admin\php;

$cloudpaySetup = \json_decode(\config('cloudpay_setupinfo'), true);
$canSetup      = (function () {
    $a = ['domain', 'notify_url', 'return_url', 'sitekey'];
    foreach ($a as $b) {
        if (\config("cloudpay_$b")) {
            return false;
        }
    }
    return true;
})();

if (\input('get.submit/d')) {
    if (!$canSetup) {
        \error('无法进行一键配置，请先清空已配置的云支付设置（接口域名、异步通知地址、支付完成跳转地址和sitekey）');
    }
    $apiurl          = 'https://www.hadsky.net/zhanzhang/cloudpay/setup';
    $domain          = \g('sys.config.domain');
    $random_filename = \md5(\randomString());
    $path            = "verification/{$random_filename}.txt";
    if (!file_exists(PK_WWWROOT . 'verification') && !\mkdir(PK_WWWROOT . 'verification', 0777)) {
        \error('验证目录创建失败');
    }
    if (!file_put_contents(PK_WWWROOT . $path, \md5($domain))) {
        \error('验证文件创建失败');
    }
    $chkurl = $_SERVER['REQUEST_SCHEME'] . '://' . $domain . \weburl($path);
    $time   = \time();
    $sign   = \md5($domain . $chkurl . $time);
    $data   = [
        'domain' => $domain,
        'chkurl' => $chkurl,
        'time'   => $time,
        'sign'   => $sign,
    ];
    // \error('', $data);
    $curl = \curl($apiurl, $data, 'post');
    $r    = \json_decode($curl, true);
    if (!$r) {
        \error('通讯失败' . $curl);
    }
    if (!$r['code']) {
        \error($r['msg']);
    }
    $value = $r['data'];
    // 保存配置
    \db('set')->where('name', 'cloudpay_setupinfo')->update([
        'value' => json_encode($value, 320),
    ]);
    $set = \db('set');
    $set->where('name', 'cloudpay_open')->update([
        'value' => 1,
    ]);
    $set->where('name', 'cloudpay_domain')->update([
        'value' => $value['domain'],
    ]);
    $set->where('name', 'cloudpay_notify_url')->update([
        'value' => $_SERVER['REQUEST_SCHEME'] . '://' . $domain . \weburl('general/cloudpay_notify'),
    ]);
    $set->where('name', 'cloudpay_return_url')->update([
        'value' => $_SERVER['REQUEST_SCHEME'] . '://' . $domain . \weburl('general/cloudpay_return'),
    ]);
    $set->where('name', 'cloudpay_sitekey')->update([
        'value' => $value['sitekey'],
    ]);
    \success('配置成功', $r['data']);
}
