
# ChatGPT Prompt Engineering for Developers

Welcome to the **ChatGPT Prompt Engineering for Developers** repository! This repository contains Jupyter notebooks from the free course by DeepLearning.AI and OpenAI, co-taught by Isa Fulford and Andrew Ng. The course provides a practical guide to using Large Language Models (LLMs) like ChatGPT through prompt engineering techniques to build powerful applications.

## Course Content

The following Jupyter notebooks are included, each demonstrating a key aspect of prompt engineering:

### 1. **Guidelines for Prompting** (`1-guidelines.ipynb`)
   This notebook introduces the foundational guidelines for creating effective prompts that help the LLM produce desired outputs. It covers two essential principles for prompt engineering.

### 2. **Iterative Prompt Development** (`2-iterative.ipynb`)
   Learn the iterative process of refining prompts through experimentation and adjustment, leading to improved and more accurate responses from the model.

### 3. **Summarizing** (`3-summarizing.ipynb`)
   This notebook shows how to use LLMs for summarization tasks, such as condensing long pieces of text like user reviews into shorter, more digestible summaries.

### 4. **Inferring** (`4-inferring.ipynb`)
   Explore how to use LLMs to infer insights from text, including sentiment analysis and topic extraction from user input.

### 5. **Transforming** (`5-transforming.ipynb`)
   Learn how to leverage LLMs to transform text, such as translating languages, correcting grammar, or adjusting text style.

### 6. **Expanding** (`6-expanding.ipynb`)
   In this notebook, you'll see how LLMs can automatically generate content, such as composing emails or generating creative text based on minimal input.

### 7. **The Chat Format** (`7-chatbot.ipynb`)
   Explore how to use the chat-based format effectively in applications, building chatbots that maintain context and handle multi-turn conversations.

## License

This repository is distributed under the MIT License. Feel free to use and modify the materials for your own projects.

## Disclaimer

This repository is based on the "ChatGPT Prompt Engineering for Developers" course. The content is subject to updates as the field of prompt engineering evolves.
