# 7.4 Changelog

## [7.4.6] - 2024-10-22

### Build and Packaging Improvements

<details>

<summary>

<p>Bump .NET SDK to 8.0.403</p>

</summary>

<ul>
<li>Copy to static site instead of making blob public (#24269) (#24473)</li>
<li>Add ability to capture MSBuild Binary logs when restore fails (#24128)</li>
<li>Keep the roff file when gzipping it. (#24450)</li>
<li>Update <code>PowerShell-Coordinated_Packages-Official.yml</code> (#24449)</li>
<li>Update and add new NuGet package sources for different environments. (#24440)</li>
<li>Add PMC mapping for Debian 12 (bookworm) (#24413)</li>
<li>Fixes to Azure Public feed usage (#24429)</li>
<li>Delete <code>assets/AppImageThirdPartyNotices.txt</code> (#24256)</li>
<li>Delete <code>demos</code> directory (#24258)</li>
<li>Add specific path for issues in tsaconfig (#24244)</li>
<li>Checkin generated manpage (#24423)</li>
<li>Add updated libicu dependency for Debian packages (#24301)</li>
<li>Add mapping to azurelinux repo (#24290)</li>
<li>Update vpack pipeline (#24281)</li>
<li>Add <code>BaseUrl</code> to <code>buildinfo</code> json file (#24376)</li>
<li>Delete the msix blob if it's already there (#24353)</li>
<li>Make some release tests run in a hosted pools (#24270)</li>
<li>Create new pipeline for compliance (#24252)</li>
<li>Use Managed Identity for <code>APIScan</code> authentication (#24243)</li>
<li>Check <code>Create and Submit</code> in vPack build by default (#24181)</li>
<li>Capture environment better (#24148)</li>
<li>Refactor Nuget package source creation to use <code>New-NugetPackageSource</code> function (#24104)</li>
<li>Make Microsoft feeds the default (#24426)</li>
<li>Bump to .NET 8.0.403 and update dependencies (#24405)</li>
</ul>

</details>

[7.4.6]: https://github.com/PowerShell/PowerShell/compare/v7.4.5...v7.4.6

## [7.4.5] - 2024-08-20

### General Cmdlet Updates and Fixes

- Fix WebCmdlets when `-Body` is specified but `ContentType` is not (#24145)

### Tests

- Rewrite the mac syslog tests to make them less flaky (#24152)

### Build and Packaging Improvements

<details>

<summary>

<p>Bump .NET SDK to 8.0.400</p>

</summary>

<ul>
<li>Add feature flags for removing network isolation (Internal 32126)</li>
<li>Update <code>ThirdPartyNotices.txt</code> for v7.4.5 (#24160)</li>
<li>Update <code>cgmanifest.json</code> for v7.4.5 (#24159)</li>
<li>Update .NET SDK to 8.0.400 (#24151)</li>
<li>Cleanup unused csproj (#24146)</li>
<li>Remember installation options and used them to initialize options for the next installation (#24143)</li>
<li>Fix failures in GitHub action <code>markdown-link-check</code> (#24142)</li>
<li>Use correct signing certificates for RPM and DEBs (#21522)</li>
</ul>

</details>

### Documentation and Help Content

- Update docs sample nuget.config (#24147)
- Fix up broken links in Markdown files (#24144)

[7.4.5]: https://github.com/PowerShell/PowerShell/compare/v7.4.4...v7.4.5

## [7.4.4] - 2024-07-18

### Engine Updates and Fixes

- Resolve paths correctly when importing files or files referenced in the module manifest (Internal 31780)

### Build and Packaging Improvements

<details>

<summary>

<p>Bump .NET to 8.0.303</p>

</summary>

<ul>
<li>Enumerate over all signed zip packages in macos signing</li>
<li>Update TPN for the v7.4.4 release (Internal 31793)</li>
<li>Add update cgmanifest (Internal 31789)</li>
<li>Add macos signing for package files (#24015) (#24059)</li>
<li>Update .NET SDK to 8.0.303 (#24038)</li>
</ul>

</details>

[7.4.4]: https://github.com/PowerShell/PowerShell/compare/v7.4.3...v7.4.4

## [7.4.3] - 2024-06-18

### General Cmdlet Updates and Fixes

- Fix the error when using `Start-Process -Credential` without the admin privilege (#21393) (Thanks @jborean93!)
- Fix `Test-Path -IsValid` to check for invalid path and filename characters (#21358)

### Engine Updates and Fixes

- Fix generating `OutputType` when running in Constrained Language Mode (#21605)
- Expand `~` to `$home` on Windows with tab completion (#21529)
- Make sure both stdout and stderr can be redirected from a native executable (#20997)

### Build and Packaging Improvements

<details>

<summary>

<p>Update to .NET 8.0.6</p>
<p>We thank the following contributors!</p>
<p>@ForNeVeR!</p>

</summary>

<ul>
<li>Fixes for change to new Engineering System.</li>
<li>Fix argument passing in <code>GlobalToolShim</code> (#21333) (Thanks @ForNeVeR!)</li>
<li>Create <code>powershell.config.json</code> for <code>PowerShell.Windows.x64</code> global tool (#23941)</li>
<li>Remove markdown link check on release branches (#23937)</li>
<li>Update to .NET 8.0.6 (#23936)</li>
<li>Fix error in the vPack release, debug script that blocked release (#23904)</li>
<li>Add branch counter variables for daily package builds (#21523)</li>
<li>Updates to package and release pipelines (#23800)</li>
<li>Fix exe signing with third party signing for WiX engine (#23878)</li>
<li>Use PSScriptRoot to find path to Wix module (#21611)</li>
<li>[StepSecurity] Apply security best practices (#21480)</li>
<li>Fix build failure due to missing reference in <code>GlobalToolShim.cs</code> (#21388)</li>
<li>Update installation on Wix module (#23808)</li>
<li>Use feed with Microsoft Wix toolset (#21651)</li>
<li>Create the Windows.x64 global tool with shim for signing (#21559)</li>
<li>Generate MSI for <code>win-arm64</code> installer (#20516)</li>
<li>update wix package install (#21537)</li>
<li>Add a PAT for fetching PMC cli (#21503)</li>
<li>Official PowerShell Package pipeline (#21504)</li>
</ul>

</details>

[7.4.3]: https://github.com/PowerShell/PowerShell/compare/v7.4.2...v7.4.3

## [7.4.2] - 2024-04-11

### General Cmdlet Updates and Fixes

- Revert "Adjust PUT method behavior to POST one for default content type in WebCmdlets" (#21049)
- Fix regression with `Get-Content` when `-Tail 0` and `-Wait` are both used (#20734) (Thanks @CarloToso!)
- Fix `Get-Error` serialization of array values (#21085) (Thanks @jborean93!)
- Fix a regression in `Format-Table` when header label is empty (#21156)

### Engine Updates and Fixes

- Revert the PR #17856 (Do not preserve temporary results when no need to do so) (#21368)
- Make sure the assembly/library resolvers are registered at early stage (#21361)
- Handle the case that `Runspace.DefaultRunspace` is `null` when logging for WDAC Audit (#21344)
- Fix PowerShell class to support deriving from an abstract class with abstract properties (#21331)
- Fix the regression when doing type inference for `$_` (#21223) (Thanks @MartinGC94!)

### Build and Packaging Improvements

<details>

<summary>

<p>Bump to .NET 8.0.4</p>

</summary>

<ul>
<li>Revert analyzer package back to stable</li>
<li>Update SDK, deps and <code>cgmanifest</code> for <code>7.4.2</code></li>
<li>Revert changes to <code>packaging.psm1</code></li>
<li>Update <code>PSResourceGet</code> version from <code>1.0.2</code> to <code>1.0.4.1</code> (#21439)</li>
<li>Verify environment variable for OneBranch before we try to copy (#21441)</li>
<li>Remove <code>surrogateFile</code> setting of <code>APIScan</code> (#21238)</li>
<li>Add <code>dotenv</code> install as latest version does not work with current Ruby version (#21239)</li>
<li>Multiple fixes in official build pipeline (#21408)</li>
<li>Add back 2 transitive dependency packages (#21415)</li>
<li>Update <code>PSReadLine</code> to <code>v2.3.5</code> for the next <code>v7.4.x</code> servicing release (#21414)</li>
<li>PowerShell co-ordinated build OneBranch pipeline (#21364)</li>
</ul>

</details>

[7.4.2]: https://github.com/PowerShell/PowerShell/compare/v7.4.1...v7.4.2

## [7.4.1] - 2024-01-11

### General Cmdlet Updates and Fixes

- Fix `Group-Object` output using interpolated strings (#20745) (Thanks @mawosoft!)
- Fix `Start-Process -PassThru` to make sure the `ExitCode` property is accessible for the returned `Process` object (#20749) (#20866) (Thanks @CodeCyclone!)
- Fix rendering of DisplayRoot for network PSDrive (#20793) (#20863)

### Engine Updates and Fixes

- Ensure filename is not null when logging WDAC ETW events (#20910) (Thanks @jborean93!)
- Fix four regressions introduced by WDAC audit logging feature (#20913)

### Build and Packaging Improvements

<details>

<summary>

Bump .NET 8 to version 8.0.101

</summary>

<ul>
<li>Update .NET SDK and dependencies for v7.4.1 (Internal 29142)</li>
<li>Update cgmanifest for v7.4.1 (#20874)</li>
<li>Update package dependencies for v7.4.1 (#20871)</li>
<li>Set the <code>rollForwardOnNoCandidateFx</code> in <code>runtimeconfig.json</code> to roll forward only on minor and patch versions (#20689) (#20865)</li>
<li>Remove RHEL7 publishing to packages.microsoft.com as it's no longer supported (#20849) (#20864)</li>
<li>Fix the tab completion tests (#20867)</li>
</ul>

</details>

[7.4.1]: https://github.com/PowerShell/PowerShell/compare/v7.4.0...v7.4.1

## [7.4.0] - 2023-11-16

### General Cmdlet Updates and Fixes

- Added a missing `ConfigureAwait(false)` call to webcmdlets so they don't block (#20622)
- Fix `Group-Object` so output uses current culture (#20623)
- Block getting help from network locations in restricted remoting sessions (#20615)

### Build and Packaging Improvements

<details>

<summary>

<p>Bump .NET 8 to 8.0.0 RTM build</p>

</summary>

<ul>
<li>Add internal .NET SDK URL parameter to release pipeline (Internal 28474)</li>
<li>Update the CGManifest file for v7.4.0 release (Internal 28457)</li>
<li>Fix repository root for the nuget.config (Internal 28456)</li>
<li>Add internal nuget feed to compliance build (Internal 28449)</li>
<li>Copy azure blob with PowerShell global tool to private blob and move to CDN during release (Internal 28438)</li>
<li>Fix release build by making the internal SDK parameter optional (#20658) (Internal 28440)</li>
<li>Make internal .NET SDK URL as a parameter for release builld (#20655) (Internal 28428)</li>
<li>Update <code>PSResourceGet</code> version for <code>1.0.1</code> release (#20652) (Internal 28427)</li>
<li>Bump .NET 8 to 8.0.0 RTM build (Internal 28360)</li>
<li>Remove Auth header content from ErrorRecord (Internal 28409)</li>
<li>Fix setting of variable to consume internal SDK source (Internal 28354)</li>
<li>Bump Microsoft.Management.Infrastructure to v3.0.0 (Internal 28352)</li>
<li>Bump <code>Microsoft.PowerShell.Native</code> to <code>v7.4.0</code> (#20617) (#20624)</li>
</ul>

</details>

[7.4.0]: https://github.com/PowerShell/PowerShell/compare/v7.4.0-rc.1...v7.4.0

## [7.4.0-rc.1] - 2023-10-24

### General Cmdlet Updates and Fixes

- Fix `Test-Connection` due to .NET 8 changes (#20369) (#20531)
- Add telemetry to check for specific tags when importing a module (#20371) (#20540)
- Fix `Copy-Item` progress to only show completed when all files are copied (#20517) (#20544)
- Fix `unixmode` to handle `setuid` and `sticky` when file is not an executable (#20366) (#20537)
- Fix UNC path completion regression (#20419) (#20541)
- Fix implicit remoting proxy cmdlets to act on common parameters (#20367) (#20530)
- Fix `Get-Service` non-terminating error message to include category (#20276) (#20529)
- Fixing regression in DSC (#20268) (#20528)

### Build and Packaging Improvements

<details>

<summary>

<p>We thank the following contributors!</p>

</summary>

<ul>
<li>Update ThirdPartyNotices.txt file (Internal 28110)</li>
<li>Update CGManifest for release</li>
<li>Fix package version for .NET nuget packages (#20551) (#20552)</li>
<li>Only registry App Path for release package (#20478) (#20549)</li>
<li>Bump PSReadLine from 2.2.6 to 2.3.4 (#20305) (#20533)</li>
<li>Bump Microsoft.Management.Infrastructure (#20511) (#20512) (#20433) (#20434) (#20534) (#20535) (#20545) (#20547)</li>
<li>Bump to .NET 8 RC2 (#20510) (#20543)</li>

<li>Add SBOM for release pipeline (#20519) (#20548)</li>
<li>Bump version of <code>Microsoft.PowerShell.PSResourceGet</code> to <code>v1.0.0</code> (#20485) (#20538)</li>
<li>Bump xunit.runner.visualstudio from 2.5.1 to 2.5.3 (#20486) (#20542)</li>
<li>Bump JsonSchema.Net from 5.2.5 to 5.2.6 (#20421) (#20532)</li>
<li>Fix alpine tar package name and do not crossgen alpine fxdependent package (#20459) (#20536)</li>
<li>Increase timeout when publishing packages to <code>packages.microsoft.com</code> (#20470) (#20539)</li>
<li>Block any preview vPack release (#20243) (#20526)</li>
<li>Add surrogate file for compliance scanning (#20423)</li>
</ul>

</details>

[7.4.0-rc.1]: https://github.com/PowerShell/PowerShell/compare/v7.4.0-preview.6...v7.4.0-rc.1

## [7.4.0-preview.6] - 2023-09-28

### General Cmdlet Updates and Fixes

- Set approved experimental features to stable for 7.4 release (#20362)
- Revert changes to continue using `BinaryFormatter` for `Out-GridView` (#20360)
- Remove the comment trigger from feedback provider (#20346)

### Tests

- Continued improvement to tests for release automation (#20259)
- Skip the test on x86 as `InstallDate` is not visible on `Wow64` (#20255)
- Harden some problematic release tests (#20254)

### Build and Packaging Improvements

<details>

<summary>

<p>Move to .NET 8.0.100-rc.1.23463.5</p>

</summary>

<ul>
<li>Update the regex for package name validation (Internal 27783, 27795)</li>
<li>Update ThirdPartyNotices.txt (Internal 27772)</li>
<li>Remove the <code>ref</code> folder before running compliance (#20375)</li>
<li>Updates RIDs used to generate component Inventory (#20372)</li>
<li>Bump <code>Microsoft.CodeAnalysis.CSharp</code> from 4.7.0 to 4.8.0-2.final (#20368)</li>
<li>Fix the release build by moving to the official .NET 8-rc.1 release build version (#20365)</li>
<li>Update the experimental feature JSON files (#20363)</li>
<li>Bump <code>XunitXml.TestLogger</code> from 3.1.11 to 3.1.17 (#20364)</li>
<li>Update <code>Microsoft.PowerShell.PSResourceGet</code> to 0.9.0-rc1 (#20361)</li>
<li>Update .NET SDK to version 8.0.100-rc.1.23455.8 (#20358)</li>
<li>Use <code>fxdependent-win-desktop</code> runtime for compliance runs (#20359)</li>
<li>Add mapping for mariner arm64 stable (#20348)</li>
<li>Bump <code>xunit.runner.visualstudio</code> from <code>2.5.0</code> to <code>2.5.1</code> (#20357)</li>
<li>Bump <code>JsonSchema.Net</code> from 5.2.1 to 5.2.5 (#20356)</li>
<li>Bump <code>Microsoft.NET.Test.Sdk</code> from 17.7.1 to 17.7.2 (#20355)</li>
<li>Bump Markdig.Signed from 0.32.0 to 0.33.0 (#20354)</li>
<li>Bump JsonSchema.Net from 5.1.3 to 5.2.1 (#20353)</li>
<li>Bump actions/checkout from 3 to 4 (#20352)</li>
<li>Bump <code>Microsoft.NET.Test.Sdk</code> from 17.7.0 to 17.7.1 (#20351)</li>
<li>Bump <code>Microsoft.CodeAnalysis.CSharp</code> from 4.7.0-2.final to 4.7.0 (#20350)</li>
<li>Release build: Change the names of the PATs (#20349)</li>
<li>Put the calls to <code>Set-AzDoProjectInfo</code> and Set-AzDoAuthToken` in the right order (#20347)</li>
<li>Bump Microsoft.Management.Infrastructure (continued) (#20262)</li>
<li>Bump <code>Microsoft.Management.Infrastructure</code> to 3.0.0-preview.2 (#20261)</li>
<li>Enable <code>vPack</code> provenance data (#20260)</li>
<li>Start using new packages.microsoft.com cli (#20258)</li>
<li>Add mariner arm64 to PMC release (#20257)</li>
<li>Fix typo <code>donet</code> to <code>dotnet</code> in build scripts and pipelines (#20256)</li>
</ul>

</details>

[7.4.0-preview.6]: https://github.com/PowerShell/PowerShell/compare/v7.4.0-preview.5...v7.4.0-preview.6

## [7.4.0-preview.5] - 2023-08-21

### Breaking Changes

- Change how relative paths in `Resolve-Path` are handled when using the `RelativeBasePath` parameter (#19755) (Thanks @MartinGC94!)

### Engine Updates and Fixes

- Fix dynamic parameter completion (#19510) (Thanks @MartinGC94!)
- Use `OrdinalIgnoreCase` to lookup script breakpoints (#20046) (Thanks @fflaten!)
- Guard against `null` or blank path components when adding to module path (#19922) (Thanks @stevenebutler!)
- Fix deadlock when piping to shell associated file extension (#19940)
- Fix completion regression for filesystem paths with custom `PSDrive` names (#19921) (Thanks @MartinGC94!)
- Add completion for variables assigned by the `Data` statement (#19831) (Thanks @MartinGC94!)
- Fix a null reference crash in completion code (#19916) (Thanks @MartinGC94!)

### General Cmdlet Updates and Fixes

- Fix `Out-GridView` by implementing `Clone()` method to replace old use of binary format serialization (#20050)
- Support Unix domain socket in WebCmdlets (#19343) (Thanks @CarloToso!)
- Wait-Process: add `-Any` and `-PassThru` parameters (#19423) (Thanks @dwtaber!)
- Added the switch parameter `-CaseInsensitive` to `Select-Object` and `Get-Unique` cmdlets (#19683) (Thanks @ArmaanMcleod!)
- `Restore-Computer` and `Stop-Computer` should fail with error when not running via `sudo` on Unix (#19824)
- Add Help proxy function for non-Windows platforms (#19972)
- Remove input text from the error message resulted by `SecureString` and `PSCredential` conversion failure (#19977) (Thanks @ArmaanMcleod!)
- Add `Microsoft.PowerShell.PSResourceGet` to the telemetry module list (#19926)

### Code Cleanup

<details>

<summary>

<p>We thank the following contributors!</p>
<p>@eltociear, @Molkree, @MartinGC94</p>

</summary>

<ul>
<li>Fix use of <code>ThrowIf</code> where the arguments were reversed (#20052)</li>
<li>Fix typo in <code>Logging.Tests.ps1</code> (#20048) (Thanks @eltociear!)</li>
<li>Apply the <code>InlineAsTypeCheck</code> in the engine code - 2nd pass (#19694) (Thanks @Molkree!)</li>
<li>Apply the <code>InlineAsTypeCheck</code> rule in the engine code - 1st pass (#19692) (Thanks @Molkree!)</li>
<li>Remove unused string completion code (#19879) (Thanks @MartinGC94!)</li>
</ul>

</details>

### Tools

- Give the `assignPRs` workflow write permissions (#20021)

### Tests

- Additional test hardening for tests which fail in release pass. (#20093)
- Don't use a completion which has a space in it (#20064)
- Fixes for release tests (#20028)
- Remove spelling CI in favor of GitHub Action (#19973)
- Hide expected error for negative test on windows for script extension (#19929)
- Add more debugging to try to determine why these test fail in release build. (#19829)

### Build and Packaging Improvements

<ul>
<li>Update ThirdPartyNotices for 7.4.0-preview.5</li>
<li>Update <code>PSResourceGet</code> to <code>0.5.24-beta24</code> (#20118)</li>
<li>Fix build after the change to remove win-arm32 (#20102)</li>
<li>Add comment about pinned packages (#20096)</li>
<li>Bump to .NET 8 Preview 7 (#20092)</li>
<li>Remove <code>Win-Arm32</code> from release build. (#20095)</li>
<li>Add alpine framework dependent package (#19995)</li>
<li>Bump JsonSchema.Net from 4.1.8 to 5.1.3 (#20089)</li>
<li>Bump Microsoft.NET.Test.Sdk from 17.6.3 to 17.7.0 (#20088)</li>
<li>Move build to .NET 8 preview 6 (#19991)</li>
<li>Bump <code>Microsoft.Management.Infrastructure</code> from <code>2.0.0</code> to <code>3.0.0-preview.1</code> (#20081)</li>
<li>Bump <code>Markdig.Signed</code> from <code>0.31.0</code> to <code>0.32.0</code> (#20076)</li>
<li>Auto assign PR Maintainer (#20020)</li>
<li>Delete rule that was supposed to round-robin assign a maintainer (#20019)</li>
<li>Update the cgmanifest (#20012)</li>
<li>Update the cgmanifest (#20008)</li>
<li>Bump JsonSchema.Net from 4.1.7 to 4.1.8 (#20006)</li>
<li>Bump JsonSchema.Net from 4.1.6 to 4.1.7 (#20000)</li>
<li>Add mariner arm64 package build to release build (#19946)</li>
<li>Check for pre-release packages when it's a stable release (#19939)</li>
<li>Make PR creation tool use <code>--web</code> because it is more reliable (#19944)</li>
<li>Update to the latest NOTICES file (#19971)</li>
<li>Update variable used to bypass the blocking check for multiple NuGet feeds for release pipeline (#19963)</li>
<li>Update variable used to bypass the blocking check for multiple NuGet feeds (#19967)</li>
<li>Update README.md and metadata.json for release v7.2.13 and v7.3.6 (#19964)</li>
<li>Don't publish notice on failure because it prevent retry (#19955)</li>
<li>Change variable used to bypass nuget security scanning (#19954)</li>
<li>Update the cgmanifest (#19924)</li>
<li>Publish rpm package for rhel9 (#19750)</li>
<li>Bump XunitXml.TestLogger from 3.0.78 to 3.1.11 (#19900)</li>
<li>Bump JsonSchema.Net from 4.1.5 to 4.1.6 (#19885)</li>
<li>Bump xunit from 2.4.2 to 2.5.0 (#19902)</li>
<li>Remove <code>HostArchitecture</code> dynamic parameter for <code>osxpkg</code> (#19917)</li>
<li>FabricBot: Onboarding to GitOps.ResourceManagement because of FabricBot decommissioning (#19905)</li>
<li>Change variable used to bypass nuget security scanning (#19907)</li>
<li>Checkout history for markdown lint check (#19908)</li>
<li>Switch to GitHub Action for linting markdown (#19899)</li>
<li>Bump xunit.runner.visualstudio from 2.4.5 to 2.5.0 (#19901)</li>
<li>Add runtime and packaging type info for mariner2 arm64 (#19450)</li>
<li>Update to the latest NOTICES file (#19856)</li>
</ul>

</details>

### Documentation and Help Content

- Update `README.md` and `metadata.json` for `7.4.0-preview.4` release (#19872)
- Fix grammatical issue in `ADOPTERS.md` (#20037) (Thanks @nikohoffren!)
- Replace docs.microsoft.com URLs in code with FWLinks (#19996)
- Change `docs.microsoft.com` to `learn.microsoft.com` (#19994)
- Update man page to match current help for pwsh (#19993)
- Merge `7.3.5`, `7.3.6`, `7.2.12` and `7.2.13` changelogs (#19968)
- Fix ///-comments that violate the docs schema (#19957)
- Update the link for getting started in `README.md` (#19932)
- Migrate user docs to the PowerShell-Docs repository (#19871)

[7.4.0-preview.5]: https://github.com/PowerShell/PowerShell/compare/v7.4.0-preview.4...v7.4.0-preview.5

## [7.4.0-preview.4] - 2023-06-29

### Breaking Changes

- `Test-Json`: Use `JsonSchema.Net` (`System.Text.Json`) instead of `NJsonSchema` (`Newtonsoft.Json`) (#18141) (Thanks @gregsdennis!)
- `Test-Connection`: Increase output detail when performing a TCP test (#11452) (Thanks @jackdcasey!)

### Engine Updates and Fixes

- Fix native executables not redirecting to file (#19842)
- Add a new experimental feature to control native argument passing style on Windows (#18706)
- Fix `TabExpansion2` variable leak when completing variables (#18763) (Thanks @MartinGC94!)
- Enable completion of variables across ScriptBlock scopes (#19819) (Thanks @MartinGC94!)
- Fix completion of the `foreach` statement variable (#19814) (Thanks @MartinGC94!)
- Fix variable type inference precedence (#18691) (Thanks @MartinGC94!)
- Fix member completion for PowerShell Enum class (#19740) (Thanks @MartinGC94!)
- Fix parsing for array literals in index expressions in method calls (#19224) (Thanks @MartinGC94!)
- Fix incorrect string to type conversion (#19560) (Thanks @MartinGC94!)
- Fix slow execution when many breakpoints are used (#14953) (Thanks @nohwnd!)
- Add a public API for getting locations of `PSModulePath` elements (#19422)
- Add WDAC Audit logging (#19641)
- Improve path completion (#19489) (Thanks @MartinGC94!)
- Fix an indexing out of bound error in `CompleteInput` for empty script input (#19501) (Thanks @MartinGC94!)
- Improve variable completion performance (#19595) (Thanks @MartinGC94!)
- Allow partial culture matching in `Update-Help` (#18037) (Thanks @dkaszews!)
- Fix the check when reading input in `NativeCommandProcessor` (#19614)
- Add support of respecting `$PSStyle.OutputRendering` on the remote host (#19601)
- Support byte stream piping between native commands and file redirection (#17857)

### General Cmdlet Updates and Fixes

- Disallow negative values for `Get-Content` cmdlet parameters `-Head` and `-Tail` (#19715) (Thanks @CarloToso!)
- Make `Update-Help` throw proper error when current culture is not associated with a language (#19765) (Thanks @josea!)
- Do not require activity when creating a completed progress record (#18474) (Thanks @MartinGC94!)
- WebCmdlets: Add alias for `-TimeoutSec` to `-ConnectionTimeoutSeconds` and add `-OperationTimeoutSeconds` (#19558) (Thanks @stevenebutler!)
- Avoid checking screen scraping on non-Windows platforms before launching native app (#19812)
- Add reference to PSResourceGet (#19597)
- Add `FileNameStar` to `MultipartFileContent` in WebCmdlets (#19467) (Thanks @CarloToso!)
- Add `ParameterSetName` for the `-Detailed` parameter of `Test-Connection` (#19727)
- Remove the property disabling optimization (#19701)
- Filter completion for enum parameter against `ValidateRange` attributes (#17750) (Thanks @fflaten!)
- Small cleanup `Invoke-RestMethod` (#19490) (Thanks @CarloToso!)
- Fix wildcard globbing in root of device paths (#19442) (Thanks @MartinGC94!)
- Add specific error message that creating Junctions requires absolute path (#19409)
- Fix array type parsing in generic types (#19205) (Thanks @MartinGC94!)
- Improve the verbose message of WebCmdlets to show correct HTTP version (#19616) (Thanks @CarloToso!)
- Fix HTTP status from 409 to 429 for WebCmdlets to get retry interval from Retry-After header. (#19622) (Thanks @mkht!)
- Remove minor versions from `PSCompatibleVersions` (#18635) (Thanks @xtqqczze!)
- Update `JsonSchema.Net` version to 4.1.0 (#19610) (Thanks @gregsdennis!)
- Allow combining of `-Skip` and `-SkipLast` parameters in `Select-Object` cmdlet. (#18849) (Thanks @ArmaanMcleod!)
- Fix constructing `PSModulePath` if a sub-path has trailing separator (#13147)
- Add `Get-SecureRandom` cmdlet (#19587)
- Fix `New-Item` to re-create `Junction` when `-Force` is specified (#18311) (Thanks @GigaScratch!)
- Improve Hashtable key completion for type constrained variable assignments, nested Hashtables and more (#17660) (Thanks @MartinGC94!)
- `Set-Clipboard -AsOSC52` for remote usage (#18222) (Thanks @dkaszews!)
- Refactor `MUIFileSearcher.AddFiles` in the help related code (#18825) (Thanks @xtqqczze!)
- Set `SetLastError` to `true` for symbolic and hard link native APIs (#19566)
- Fix `Get-AuthenticodeSignature -Content` to not roundtrip the bytes to a Unicode string and then back to bytes (#18774) (Thanks @jborean93!)
- WebCmdlets: Rename `-TimeoutSec` to `-ConnectionTimeoutSeconds` (with alias) and add `-OperationTimeoutSeconds` (#19558) (Thanks @stevenebutler!)

### Code Cleanup

<details>

<summary>

<p>We thank the following contributors!</p>
<p>@eltociear, @ArmaanMcleod, @turbedi, @CarloToso, @Molkree, @xtqqczze</p>

</summary>

<ul>
<li>Fix typo in <code>NativeCommandProcessor.cs</code> (#19846) (Thanks @eltociear!)</li>
<li>Rename file from <code>PingPathCommand.cs</code> to <code>TestPathCommand.cs</code> (#19782) (Thanks @ArmaanMcleod!)</li>
<li>Make use of the new <code>Random.Shared</code> property (#18417) (Thanks @turbedi!)</li>
<li>six files (#19695) (Thanks @CarloToso!)</li>
<li>Apply IDE0019: <code>InlineAsTypeCheck</code> in Microsoft.PowerShell.Commands (#19688)(#19690)(#19687)(#19689) (Thanks @Molkree!)</li>
<li>Remove <code>PSv2CompletionCompleter</code> as part of the PowerShell v2 code cleanup (#18337) (Thanks @xtqqczze!)</li>
<li>Enable more nullable annotations in WebCmdlets (#19359) (Thanks @CarloToso!)</li>
</ul>

</details>

### Tools

- Add Git mailmap for Andy Jordan (#19469)
- Add backport function to release tools (#19568)

### Tests

- Improve reliability of the `Ctrl+c` tests for WebCmdlets (#19532) (Thanks @stevenebutler!)
- Fix logic for `Import-CliXml` test (#19805)
- Add some debugging to the transcript test for `SilentlyContinue` (#19770)
- Re-enable `Get-ComputerInfo` pending tests (#19746)
- Update syslog parser to handle modern formats. (#19737)
- Pass `-UserScope` as required by `RunUpdateHelpTests` (#13400) (Thanks @yecril71pl!)
- Change how `isPreview` is determined for default cmdlets tests (#19650)
- Skip file signature tests on 2012R2 where PKI cmdlet do not work (#19643)
- Change logic for testing missing or extra cmdlets. (#19635)
- Fix incorrect test cases in `ExecutionPolicy.Tests.ps1` (#19485) (Thanks @xtqqczze!)
- Fixing structure typo in test setup (#17458) (Thanks @powercode!)
- Fix test failures on Windows for time zone and remoting (#19466)
- Harden 'All approved Cmdlets present' test (#19530)

### Build and Packaging Improvements

<details>

<summary>
<p>Updated to .NET 8 Preview 4
<p>We thank the following contributors!</p>
<p>@krishnayalavarthi</p>

</summary>

<ul>
<li>Update to the latest NOTICES file (#19537)(#19820)(#19784)(#19720)(#19644)(#19620)(#19605)(#19546)</li>
<li>Bump Microsoft.NET.Test.Sdk from 17.5.0 to 17.6.3 (#19867)(#19762)(#19733)(#19668)(#19613)</li>
<li>Update the cgmanifest (#19847)(#19800)(#19792)(#19776)(#19763)(#19697)(#19631)</li>
<li>Bump StyleCop.Analyzers from 1.2.0-beta.406 to 1.2.0-beta.507 (#19837)</li>
<li>Bump Microsoft.CodeAnalysis.CSharp from 4.6.0-1.final to 4.7.0-2.final (#19838)(#19667)</li>
<li>Update to .NET 8 Preview 4 (#19696)</li>
<li>Update experimental-feature json files (#19828)</li>
<li>Bump JsonSchema.Net from 4.1.1 to 4.1.5 (#19790)(#19768)(#19788)</li>
<li>Update group to assign PRs in <code>fabricbot.json</code> (#19759)</li>
<li>Add retry on failure for all upload tasks in Azure Pipelines (#19761)</li>
<li>Bump Microsoft.PowerShell.MarkdownRender from 7.2.0 to 7.2.1 (#19751)(#19752)</li>
<li>Delete symbols on Linux as well (#19735)</li>
<li>Update <code>windows.json</code> packaging BOM (#19728)</li>
<li>Disable SBOM signing for CI and add extra files for packaging tests (#19729)</li>
<li>Update experimental-feature json files (#19698(#19588))</li>
<li>Add ProductCode in registry for MSI install (#19590)</li>
<li>Runas format changed (#15434) (Thanks @krishnayalavarthi!)</li>
<li>For Preview releases, add <code>pwsh-preview.exe</code> alias to MSIX package (#19602)</li>
<li>Add prompt to fix conflict during backport (#19583)</li>
<li>Add comment in wix detailing use of <code>UseMU</code> (#19371)</li>
<li>Verify that packages have license data (#19543)</li>
<li>Add an explicit manual stage for changelog update (#19551)</li>
<li>Update the team member list in <code>releaseTools.psm1</code> (#19544)</li>
</ul>

</details>

### Documentation and Help Content

- Update `metadata.json` and `README.md` for upcoming releases (#19863)(#19542)
- Update message to use the actual parameter name (#19851)
- Update `CONTRIBUTING.md` to include Code of Conduct enforcement (#19810)
- Update `working-group-definitions.md` (#19809)(#19561)
- Update `working-group.md` to add section about reporting working group members (#19758)
- Correct capitalization in readme (#19666) (Thanks @Aishat452!)
- Updated the public dashboard link (#19634)
- Fix a typo in `serialization.cs` (#19598) (Thanks @eltociear!)

[7.4.0-preview.4]: https://github.com/PowerShell/PowerShell/compare/v7.4.0-preview.3...v7.4.0-preview.4

## [7.4.0-preview.3] - 2023-04-20

### Breaking Changes

- Remove code related to `#requires -pssnapin` (#19320)

### Engine Updates and Fixes

- Change the arrow used in feedback suggestion to a more common Unicode character (#19534)
- Support trigger registration in feedback provider (#19525)
- Update the `ICommandPredictor` interface to reduce boilerplate code from predictor implementation (#19414)
- Fix a crash in the type inference code (#19400) (Thanks @MartinGC94!)

### Performance

- Speed up `Resolve-Path` relative path resolution (#19171) (Thanks @MartinGC94!)

### General Cmdlet Updates and Fixes

- Infer external application output as strings (#19193) (Thanks @MartinGC94!)
- Fix a race condition in `Add-Type` (#19471)
- Detect insecure `https-to-http` redirect only if both URIs are absolute (#19468) (Thanks @CarloToso!)
- Support `Ctrl+c` when connection hangs while reading data in WebCmdlets (#19330) (Thanks @stevenebutler!)
- Enable type conversion of `AutomationNull` to `$null` for assignment (#19415)
- Add the parameter `-Environment` to `Start-Process` (#19374)
- Add the parameter `-RelativeBasePath` to `Resolve-Path` (#19358) (Thanks @MartinGC94!)
- Exclude redundant parameter aliases from completion results (#19382) (Thanks @MartinGC94!)
- Allow using a folder path in WebCmdlets' `-OutFile` parameter (#19007) (Thanks @CarloToso!)

### Code Cleanup

<details>

<summary>

<p>We thank the following contributors!</p>
<p>@eltociear, @CarloToso</p>

</summary>

<ul>
<li>Fix typo in <code>typeDataXmlLoader.cs</code> (#19319) (Thanks @eltociear!)</li>
<li>Fix typo in <code>Compiler.cs</code> (#19491) (Thanks @eltociear!)</li>
<li>Inline the <code>GetResponseObject</code> method (#19380) (Thanks @CarloToso!)</li>
<li>Simplify <code>ContentHelper</code> methods (#19367) (Thanks @CarloToso!)</li>
<li>Initialize regex lazily in <code>BasicHtmlWebResponseObject</code> (#19361) (Thanks @CarloToso!)</li>
<li>Fix codefactor issue in if-statement (part 5) (#19286) (Thanks @CarloToso!)</li>
<li>Add nullable annotations in <code>WebRequestSession.cs</code> (#19291) (Thanks @CarloToso!)</li>
</ul>

</details>

### Tests

- Harden the default command test (#19416)
- Skip VT100 tests on Windows Server 2012R2 as console does not support it (#19413)
- Improve package management acceptance tests by not going to the gallery (#19412)

### Build and Packaging Improvements

<details>

<summary>

<p>We thank the following contributors!</p>
<p>@dkattan</p>

</summary>

<ul>
<li>Fixing MSI checkbox (#19325)</li>
<li>Update the experimental feature JSON files (#19297)</li>
<li>Update the cgmanifest (#19459, #19465)</li>
<li>Update .NET SDK version to <code>8.0.100-preview.3.23178.7</code> (#19381)</li>
<li>Force updating the transitive dependency on <code>Microsoft.CSharp</code> (#19514)</li>
<li>Update <code>DotnetRuntimeMetadata.json</code> to consume the .NET 8.0.0-preview.3 release (#19529)</li>
<li>Move PSGallery sync to a pool (#19523)</li>
<li>Fix the regex used for package name check in vPack build (#19511)</li>
<li>Make the vPack PAT library more obvious (#19505)</li>
<li>Change <code>Microsoft.CodeAnalysis.CSharp</code> back to 4.5.0 (#19464) (Thanks @dkattan!)</li>
<li>Update to the latest NOTICES file (#19332)</li>
<li>Add <code>PoolNames</code> variable group to compliance pipeline (#19408)</li>
<li>Fix stage dependencies and typo in release build (#19353)</li>
<li>Fix issues in release build and release pipeline (#19338)</li>
</ul>

</details>

[7.4.0-preview.3]: https://github.com/PowerShell/PowerShell/compare/v7.4.0-preview.2...v7.4.0-preview.3

## [7.4.0-preview.2] - 2023-03-14

### Breaking Changes

- Update some PowerShell APIs to throw `ArgumentException` instead of `ArgumentNullException` when the argument is an empty string (#19215) (Thanks @xtqqczze!)
- Add the parameter `-ProgressAction` to the common parameters (#18887)

### Engine Updates and Fixes

- Fix `PlainText` output to correctly remove the `Reset` VT sequence without number (#19283)
- Fix `ConciseView` to handle custom `ParserError` error records (#19239)
- Fix `VtSubstring` helper method to correctly check characters copied (#19240)
- Update the `FeedbackProvider` interface to return structured data (#19133)
- Make the exception error in PowerShell able to associate with the right history entry (#19095)
- Fix for JEA session leaking functions (#19024)
- Add WDAC events and system lockdown notification (#18893)
- Fix support for nanoserver due to lack of AMSI (#18882)

### Performance

- Use interpolated strings (#19002)(#19003)(#18977)(#18980)(#18996)(#18979)(#18997)(#18978)(#18983)(#18992)(#18993)(#18985)(#18988) (Thanks @CarloToso!)

### General Cmdlet Updates and Fixes

- Fix completion for `PSCustomObject` variable properties (#18682) (Thanks @MartinGC94!)
- Improve type inference for `Get-Random` (#18972) (Thanks @MartinGC94!)
- Make `-Encoding` parameter able to take `ANSI` encoding in PowerShell (#19298) (Thanks @CarloToso!)
- Telemetry improvements for tracking experimental feature opt out (#18762)
- Support HTTP persistent connections in Web Cmdlets (#19249) (Thanks @stevenebutler!)
- Fix using XML `-Body` in webcmdlets without an encoding (#19281) (Thanks @CarloToso!)
- Add the `Statement` property to `$MyInvocation` (#19027) (Thanks @IISResetMe!)
- Fix `Start-Process` `-Wait` with `-Credential` (#19096) (Thanks @jborean93!)
- Adjust `PUT` method behavior to `POST` one for default content type in WebCmdlets (#19152) (Thanks @CarloToso!)
- Improve verbose message in web cmdlets when content length is unknown (#19252) (Thanks @CarloToso!)
- Preserve `WebSession.MaximumRedirection` from changes (#19190) (Thanks @CarloToso!)
- Take into account `ContentType` from Headers in WebCmdlets (#19227) (Thanks @CarloToso!)
- Use C# 11 UTF-8 string literals (#19243) (Thanks @turbedi!)
- Add property assignment completion for enums (#19178) (Thanks @MartinGC94!)
- Fix class member completion for classes with base types (#19179) (Thanks @MartinGC94!)
- Add `-Path` and `-LiteralPath` parameters to `Test-Json` cmdlet (#19042) (Thanks @ArmaanMcleod!)
- Allow to preserve the original HTTP method by adding `-PreserveHttpMethodOnRedirect` to Web cmdlets (#18894) (Thanks @CarloToso!)
- Webcmdlets display an error on HTTPS to http redirect (#18595) (Thanks @CarloToso!)
- Build the relative URI for links from the response in `Invoke-WebRequest` (#19092) (Thanks @CarloToso!)
- Fix redirection for `-CustomMethod` `POST` in WebCmdlets (#19111) (Thanks @CarloToso!)
- Dispose previous response in Webcmdlets (#19117) (Thanks @CarloToso!)
- Improve `Invoke-WebRequest` XML and json errors format (#18837) (Thanks @CarloToso!)
- Fix error formatting to remove the unneeded leading newline for concise view (#19080)
- Add `-NoHeader` parameter to `ConvertTo-Csv` and `Export-Csv` cmdlets (#19108) (Thanks @ArmaanMcleod!)
- Fix `Start-Process -Credential -Wait` to work on Windows (#19082)
- Add `ValidateNotNullOrEmpty` to `OutFile` and `InFile` parameters of WebCmdlets (#19044) (Thanks @CarloToso!)
- Correct spelling of "custom" in event (#19059) (Thanks @spaette!)
- Ignore expected error for file systems not supporting alternate streams (#19065)
- Adding missing guard for telemetry opt out to avoid `NullReferenceException` when importing modules (#18949) (Thanks @powercode!)
- Fix progress calculation divide by zero in Copy-Item (#19038)
- Add progress to `Copy-Item` (#18735)
- WebCmdlets parse XML declaration to get encoding value, if present. (#18748) (Thanks @CarloToso!)
- `HttpKnownHeaderNames` update headers list (#18947) (Thanks @CarloToso!)
- Fix bug with managing redirection and `KeepAuthorization` in Web cmdlets (#18902) (Thanks @CarloToso!)
- Fix `Get-Error` to work with strict mode (#18895)
- Add `AllowInsecureRedirect` switch to Web cmdlets (#18546) (Thanks @CarloToso!)
- `Invoke-RestMethod` `-FollowRelLink` fix links containing commas (#18829) (Thanks @CarloToso!)
- Prioritize the default parameter set when completing positional arguments (#18755) (Thanks @MartinGC94!)
- Add `-CommandWithArgs` parameter to pwsh (#18726)
- Enable creating composite subsystem implementation in modules (#18888)
- Fix `Format-Table -RepeatHeader` for property derived tables (#18870)
- Add `StatusCode` to `HttpResponseException` (#18842) (Thanks @CarloToso!)
- Fix type inference for all scope variables (#18758) (Thanks @MartinGC94!)
- Add completion for Using keywords (#16514) (Thanks @MartinGC94!)

### Code Cleanup

<details>

<summary>

<p>We thank the following contributors!</p>
<p>@CarloToso, @iSazonov, @xtqqczze, @turbedi, @syntax-tm, @eltociear, @ArmaanMcleod</p>

</summary>

<ul>
<li>Small cleanup in the WebCmdlet code (#19299) (Thanks @CarloToso!)</li>
<li>Remove unused GUID detection code from console host (#18871) (Thanks @iSazonov!)</li>
<li>Fix <code>CodeFactor</code> issues in the code base - part 4 (#19270) (Thanks @CarloToso!)</li>
<li>Fix codefactor if part 3 (#19269) (Thanks @CarloToso!)</li>
<li>Fix codefactor if part 2 (#19267) (Thanks @CarloToso!)</li>
<li>Fix codefactor if part 1 (#19266) (Thanks @CarloToso!)</li>
<li>Remove comment and simplify condition in WebCmdlets (#19251) (Thanks @CarloToso!)</li>
<li>Small style changes (#19241) (Thanks @CarloToso!)</li>
<li>Use <code>ArgumentException.ThrowIfNullOrEmpty</code> as appropriate [part 1] (#19215) (Thanks @xtqqczze!)</li>
<li>Use <code>using</code> variable to reduce the nested level (#19229) (Thanks @CarloToso!)</li>
<li>Use <code>ArgumentException.ThrowIfNullOrEmpty()</code> in more places (#19213) (Thanks @CarloToso!)</li>
<li>Replace <code>BitConverter.ToString</code> with <code>Convert.ToHexString</code> where appropriate (#19216) (Thanks @turbedi!)</li>
<li>Replace <code>Requires.NotNullOrEmpty(string)</code> with <code>ArgumentException.ThrowIfNullOrEmpty</code> (#19197) (Thanks @xtqqczze!)</li>
<li>Use <code>ArgumentOutOfRangeException.ThrowIfNegativeOrZero</code> when applicable (#19201) (Thanks @xtqqczze!)</li>
<li>Use <code>CallerArgumentExpression</code> on <code>Requires.NotNull</code> (#19200) (Thanks @xtqqczze!)</li>
<li>Revert a few change to not use 'ArgumentNullException.ThrowIfNull' (#19151)</li>
<li>Corrected some minor spelling mistakes (#19176) (Thanks @syntax-tm!)</li>
<li>Fix a typo in <code>InitialSessionState.cs</code> (#19177) (Thanks @eltociear!)</li>
<li>Fix a typo in <code>pwsh</code> help content (#19153)</li>
<li>Revert comment changes in <code>WebRequestPSCmdlet.Common.cs</code> (#19136) (Thanks @CarloToso!)</li>
<li>Small cleanup webcmdlets (#19128) (Thanks @CarloToso!)</li>
<li>Merge partials in <code>WebRequestPSCmdlet.Common.cs</code> (#19126) (Thanks @CarloToso!)</li>
<li>Cleanup WebCmdlets comments (#19124) (Thanks @CarloToso!)</li>
<li>Added minor readability and refactoring fixes to <code>Process.cs</code> (#19123) (Thanks @ArmaanMcleod!)</li>
<li>Small changes in Webcmdlets (#19109) (Thanks @CarloToso!)</li>
<li>Rework <code>SetRequestContent</code> in WebCmdlets (#18964) (Thanks @CarloToso!)</li>
<li>Small cleanup WebCmdlets (#19030) (Thanks @CarloToso!)</li>
<li>Update additional interpolated string changes (#19029)</li>
<li>Revert some of the interpolated string changes (#19018)</li>
<li>Cleanup <code>StreamHelper.cs</code>, <code>WebRequestPSCmdlet.Common.cs</code> and <code>InvokeRestMethodCommand.Common.cs</code> (#18950) (Thanks @CarloToso!)</li>
<li>Small cleanup common code of webcmdlets (#18946) (Thanks @CarloToso!)</li>
<li>Simplification of <code>GetHttpMethod</code> and <code>HttpMethod</code> in WebCmdlets (#18846) (Thanks @CarloToso!)</li>
<li>Fix typo in <code>ModuleCmdletBase.cs</code> (#18933) (Thanks @eltociear!)</li>
<li>Fix regression in <code>RemoveNulls</code> (#18881) (Thanks @iSazonov!)</li>
<li>Replace all <code>NotNull</code> with <code>ArgumentNullException.ThrowIfNull</code> (#18820) (Thanks @CarloToso!)</li>
<li>Cleanup <code>InvokeRestMethodCommand.Common.cs</code> (#18861) (Thanks @CarloToso!)</li>
</ul>

</details>

### Tools

- Add a Mariner install script (#19294)
- Add tool to trigger license information gathering for NuGet modules (#18827)

### Tests

- Update and enable the test for the type of `$input` (#18968) (Thanks @MartinGC94!)
- Increase the timeout for creating the `WebListener` (#19268)
- Increase the timeout when waiting for the event log (#19264)
- Add Windows ARM64 CI (#19040)
- Change test so output does not include newline (#19026)
- Allow system lock down test debug hook to work with new WLDP API (#18962)
- Add tests for `Allowinsecureredirect` parameter in Web cmdlets (#18939) (Thanks @CarloToso!)
- Enable `get-help` pattern tests on Unix (#18855) (Thanks @xtqqczze!)
- Create test to check if WebCmdlets decompress brotli-encoded data (#18905) (Thanks @CarloToso!)

### Build and Packaging Improvements

<details>

<summary>

<p>We thank the following contributors!</p>
<p>@bergmeister, @xtqqczze</p>

</summary>

<ul>
<li>Restructure the package build to simplify signing and packaging stages (#19321)</li>
<li>Bump <code>Microsoft.CodeAnalysis.CSharp</code> from <code>4.4.0</code> to <code>4.6.0-2.23152.6</code> (#19306)(#19233)</li>
<li>Test fixes for stabilizing tests (#19068)</li>
<li>Bump <code>Newtonsoft.Json</code> from <code>13.0.2</code> to <code>13.0.3</code> (#19290)(#19289)</li>
<li>Fix mariner sudo detection (#19304)</li>
<li>Add stage for symbols job in Release build (#18937)</li>
<li>Bump .NET to Preview 2 version (#19305)</li>
<li>Move workflows that create PRs to private repo (#19276)</li>
<li>Use reference assemblies generated by dotnet (#19302)</li>
<li>Update the cgmanifest (#18814)(#19165)(#19296)</li>
<li>Always regenerate files WXS fragment (#19196)</li>
<li>MSI installer: Add checkbox and MSI property DISABLE_TELEMETRY to optionally disable telemetry. (#10725) (Thanks @bergmeister!)</li>
<li>Add <code>-Force</code> to <code>Move-Item</code> to fix the GitHub workflow (#19262)</li>
<li>Update and remove outdated docs to fix the URL link checks (#19261)</li>
<li>Bump <code>Markdig.Signed</code> from <code>0.30.4</code> to <code>0.31.0</code> (#19232)</li>
<li>Add pattern to replace for reference API generation (#19214)</li>
<li>Split test artifact build into windows and non-windows (#19199)</li>
<li>Set <code>LangVersion</code> compiler option to <code>11.0</code> (#18877) (Thanks @xtqqczze!)</li>
<li>Update to .NET 8 preview 1 build (#19194)</li>
<li>Simplify Windows Packaging CI Trigger YAML (#19160)</li>
<li>Bump <code>Microsoft.NET.Test.Sdk</code> from <code>17.4.0</code> to <code>17.5.0</code> (#18823)(#19191)</li>
<li>Add URL for all distributions (#19159)</li>
<li>Bump <code>Microsoft.Extensions.ObjectPool</code> from <code>7.0.1</code> to <code>7.0.3</code> (#18925)(#19155)</li>
<li>Add verification of R2R at packaging (#19129)</li>
<li>Allow cross compiling windows (#19119)</li>
<li>Update CodeQL build agent (#19113)</li>
<li>Bump <code>XunitXml.TestLogger</code> from <code>3.0.70</code> to <code>3.0.78</code> (#19066)</li>
<li>Bump <code>Microsoft.CodeAnalysis.Analyzers</code> from <code>3.3.3</code> to <code>3.3.4</code> (#18975)</li>
<li>Bump <code>BenchmarkDotNet</code> to <code>0.13.3</code> (#18878) (Thanks @xtqqczze!)</li>
<li>Bump <code>Microsoft.PowerShell.Native</code> from <code>7.4.0-preview.1</code> to <code>7.4.0-preview.2</code> (#18910)</li>
<li>Add checks for Windows 8.1 and Server 2012 in the MSI installer (#18904)</li>
<li>Update build to include <code>WinForms</code> / <code>WPF</code> in all Windows builds (#18859)</li>
</ul>

</details>

### Documentation and Help Content

- Update to the latest NOTICES file (#19169)(#19309)(#19086)(#19077)
- Update supported distros in readme (#18667) (Thanks @techguy16!)
- Remove the 'Code Coverage Status' badge (#19265)
- Pull in changelogs for `v7.2.10` and `v7.3.3` releases (#19219)
- Update tools `metadata` and `README` (#18831)(#19204)(#19014)
- Update a broken link in the `README.md` (#19187)
- Fix typos in comments (#19064) (Thanks @spaette!)
- Add `7.2` and `7.3` changelogs (#19025)
- typos (#19058) (Thanks @spaette!)
- Fix typo in `dotnet-tools/README.md` (#19021) (Thanks @spaette!)
- Fix up all comments to be in the proper order with proper spacing (#18619)
- Changelog for `v7.4.0-preview.1` release (#18835)

[7.4.0-preview.2]: https://github.com/PowerShell/PowerShell/compare/v7.4.0-preview.1...v7.4.0-preview.2

## [7.4.0-preview.1] - 2022-12-20

### Engine Updates and Fixes

- Add Instrumentation to `AmsiUtil` and make the init variable readonly (#18727)
- Fix typo in `OutOfProcTransportManager.cs` (#18766) (Thanks @eltociear!)
- Allow non-default encodings to be used in user's script/code (#18605)
- Add `Dim` and `DimOff` to `$PSStyle` (#18653)
- Change `exec` from alias to function to handle arbitrary arguments (#18567)
- The command prefix should also be in the error color for `NormalView` (#18555)
- Skip cloud files marked as "not on disk" during command discovery (#18152)
- Replace `UTF8Encoding(false)` with `Encoding.Default` (#18356) (Thanks @xtqqczze!)
- Fix `Switch-Process` to set `termios` appropriate for child process (#18467)
- On Unix, only explicitly terminate the native process if not in background (#18215)
- Treat `[NullString]::Value` as the string type when resolving methods (#18080)
- Improve pseudo binding for dynamic parameters (#18030) (Thanks @MartinGC94!)
- Make experimental feature `PSAnsiRenderingFileInfo` stable (#18042)
- Update to use version `2.21.0` of Application Insights. (#17903)
- Do not preserve temporary results when no need to do so (#17856)

### Performance

- Remove some static constants from `Utils.Separators` (#18154) (Thanks @iSazonov!)
- Avoid using regular expression when unnecessary in `ScriptWriter` (#18348)
- Use source generator for `PSVersionInfo` to improve startup time (#15603) (Thanks @iSazonov!)
- Skip evaluating suggestions at startup (#18232)
- Avoid using `Regex` when not necessary (#18210)

### General Cmdlet Updates and Fixes

- Update to use `ComputeCore.dll` for PowerShell Direct (#18194)
- Replace `ArgumentNullException(nameof())` with `ArgumentNullException.ThrowIfNull()` (#18792)(#18784) (Thanks @CarloToso!)
- Remove `TabExpansion` from remote session configuration (#18795) (Internal 23331)
- WebCmdlets get Retry-After from headers if status code is 429 (#18717) (Thanks @CarloToso!)
- Implement `SupportsShouldProcess` in `Stop-Transcript` (#18731) (Thanks @JohnLBevan!)
- Fix `New-Item -ItemType Hardlink` to resolve target to absolute path and not allow link to itself (#18634)
- Add output types to Format commands (#18746) (Thanks @MartinGC94!)
- Fix the process `CommandLine` on Linux (#18710) (Thanks @jborean93!)
- Fix `SuspiciousContentChecker.Match` to detect a predefined string when the text starts with it (#18693)
- Switch `$PSNativeCommandUseErrorActionPreference` to `$true` when feature is enabled (#18695)
- Fix `Start-Job` to check the existence of working directory using the PowerShell way (#18675)
- Webcmdlets add 308 to redirect codes and small cleanup (#18536) (Thanks @CarloToso!)
- Ensure `HelpInfo.Category` is consistently a string (#18254)
- Remove `gcloud` from the legacy list because it's resolved to a .ps1 script (#18575)
- Add `gcloud` and `sqlcmd` to list to use legacy argument passing (#18559)
- Fix native access violation (#18545) (#18547) (Thanks @chrullrich!)
- Fix issue when completing the first command in a script with an empty array expression (#18355) (Thanks @MartinGC94!)
- Improve type inference of hashtable keys (#17907) (Thanks @MartinGC94!)
- Fix `Switch-Process` to copy the current env to the new process (#18452)
- Fix `Switch-Process` error to include the command that is not found (#18443)
- Update `Out-Printer` to remove all decorating ANSI escape sequences from PowerShell formatting (#18425)
- Web cmdlets set default charset encoding to `UTF8` (#18219) (Thanks @CarloToso!)
- Fix incorrect cmdlet name in the script used by `Restart-Computer` (#18374) (Thanks @urizen-source!)
- Add the function `cd~` (#18308) (Thanks @GigaScratch!)
- Fix type inference error for empty return statements (#18351) (Thanks @MartinGC94!)
- Fix the exception reporting in `ConvertFrom-StringData` (#18336) (Thanks @GigaScratch!)
- Implement `IDisposable` in `NamedPipeClient` (#18341) (Thanks @xtqqczze!)
- Replace command-error suggestion with new implementation based on subsystem plugin (#18252)
- Remove the `ProcessorArchitecture` portion from the full name as it's obsolete (#18320)
- Make the fuzzy searching flexible by passing in the fuzzy matcher (#18270)
- Add `-FuzzyMinimumDistance` parameter to `Get-Command` (#18261)
- Improve startup time by triggering initialization of additional types on background thread (#18195)
- Fix decompression in web cmdlets (#17955) (Thanks @iSazonov!)
- Add `CustomTableHeaderLabel` formatting to differentiate table header labels that are not property names (#17346)
- Remove the extra new line form List formatting (#18185)
- Minor update to the `FileInfo` table formatting on Unix to make it more concise (#18183)
- Fix Parent property on processes with complex name (#17545) (Thanks @jborean93!)
- Make PowerShell class not affiliate with `Runspace` when declaring the `NoRunspaceAffinity` attribute (#18138)
- Complete the progress bar rendering in `Invoke-WebRequest` when downloading is complete or cancelled (#18130)
- Display download progress in human readable format for `Invoke-WebRequest` (#14611) (Thanks @bergmeister!)
- Update `WriteConsole` to not use `stackalloc` for buffer with too large size (#18084)
- Filter out compiler generated types for `Add-Type -PassThru` (#18095)
- Fixing `CA2014` warnings and removing the warning suppression (#17982) (Thanks @creative-cloud!)
- Make experimental feature `PSNativeCommandArgumentPassing` stable (#18044)
- Make experimental feature `PSAMSIMethodInvocationLogging` stable (#18041)
- Handle `PSObject` argument specially in method invocation logging (#18060)
- Fix typos in `EventResource.resx` (#18063) (Thanks @eltociear!)
- Make experimental feature `PSRemotingSSHTransportErrorHandling` stable (#18046)
- Make experimental feature `PSExec` stable (#18045)
- Make experimental feature `PSCleanBlock` stable (#18043)
- Fix error formatting to use color defined in `$PSStyle.Formatting` (#17987)
- Remove unneeded use of `chmod 777` (#17974)
- Support mapping foreground/background `ConsoleColor` values to VT escape sequences (#17938)
- Make `pwsh` server modes implicitly not show banner (#17921)
- Add output type attributes for `Get-WinEvent` (#17948) (Thanks @MartinGC94!)
- Remove 1 second minimum delay in `Invoke-WebRequest` for small files, and prevent file-download-error suppression. (#17896) (Thanks @AAATechGuy!)
- Add completion for values in comparisons when comparing Enums (#17654) (Thanks @MartinGC94!)
- Fix positional argument completion (#17796) (Thanks @MartinGC94!)
- Fix member completion in attribute argument (#17902) (Thanks @MartinGC94!)
- Throw when too many parameter sets are defined (#17881) (Thanks @fflaten!)
- Limit searching of `charset` attribute in `meta` tag for HTML to first 1024 characters in webcmdlets (#17813)
- Fix `Update-Help` failing silently with implicit non-US culture. (#17780) (Thanks @dkaszews!)
- Add the `ValidateNotNullOrWhiteSpace` attribute (#17191) (Thanks @wmentha!)
- Improve enumeration of inferred types in pipeline (#17799) (Thanks @MartinGC94!)

### Code Cleanup

<details>

<summary>

<p>We thank the following contributors!</p>
<p>@MartinGC94, @CarloToso, @iSazonov, @xtqqczze, @turbedi, @trossr32, @eltociear, @AtariDreams, @jborean93</p>

</summary>

<ul>
<li>Add TSAUpload for APIScan (#18446)</li>
<li>Use Pattern matching in <code>ast.cs</code> (#18794) (Thanks @MartinGC94!)</li>
<li>Cleanup <code>webrequestpscmdlet.common.cs</code> (#18596) (Thanks @CarloToso!)</li>
<li>Unify <code>CreateFile</code> <code>pinvoke</code> in SMA (#18751) (Thanks @iSazonov!)</li>
<li>Cleanup <code>webresponseobject.common</code> (#18785) (Thanks @CarloToso!)</li>
<li><code>InvokeRestMethodCommand.Common</code> cleanup and merge partials (#18736) (Thanks @CarloToso!)</li>
<li>Replace <code>GetDirectories</code> in <code>CimDscParser</code> (#14319) (Thanks @xtqqczze!)</li>
<li>WebResponseObject.Common merge partials atomic commits (#18703) (Thanks @CarloToso!)</li>
<li>Enable pending test for <code>Start-Process</code> (#18724) (Thanks @iSazonov!)</li>
<li>Remove one CreateFileW (#18732) (Thanks @iSazonov!)</li>
<li>Replace <code>DllImport</code> with <code>LibraryImport</code> for WNetAddConnection2 (#18721) (Thanks @iSazonov!)</li>
<li>Use File.OpenHandle() instead CreateFileW pinvoke (#18722) (Thanks @iSazonov!)</li>
<li>Replace DllImport with LibraryImport for WNetGetConnection (#18690) (Thanks @iSazonov!)</li>
<li>Replace <code>DllImport</code> with <code>LibraryImport</code> - 1 (#18603) (Thanks @iSazonov!)</li>
<li>Replace DllImport with LibraryImport in SMA 3 (#18564) (Thanks @iSazonov!)</li>
<li>Replace <code>DllImport</code> with <code>LibraryImport</code> in SMA - 7 (#18594) (Thanks @iSazonov!)</li>
<li>Use static <code>DateTime.UnixEpoch</code> and <code>RandomNumberGenerator.Fill()</code> (#18621) (Thanks @turbedi!)</li>
<li>Rewrite Get-FileHash to use static HashData methods (#18471) (Thanks @turbedi!)</li>
<li>Replace DllImport with LibraryImport in SMA 8 (#18599) (Thanks @iSazonov!)</li>
<li>Replace DllImport with LibraryImport in SMA 4 (#18579) (Thanks @iSazonov!)</li>
<li>Remove NativeCultureResolver as dead code (#18582) (Thanks @iSazonov!)</li>
<li>Replace DllImport with LibraryImport in SMA 6 (#18581) (Thanks @iSazonov!)</li>
<li>Replace DllImport with LibraryImport in SMA 2 (#18543) (Thanks @iSazonov!)</li>
<li>Use standard SBCS detection (#18593) (Thanks @iSazonov!)</li>
<li>Remove unused pinvokes in RemoteSessionNamedPipe (#18583) (Thanks @iSazonov!)</li>
<li>Replace DllImport with LibraryImport in SMA 5 (#18580) (Thanks @iSazonov!)</li>
<li>Remove SafeRegistryHandle (#18597) (Thanks @iSazonov!)</li>
<li>Remove <code>ArchitectureSensitiveAttribute</code> from the code base (#18598) (Thanks @iSazonov!)</li>
<li>Build COM adapter only on Windows (#18590)</li>
<li>Include timer instantiation for legacy telemetry in conditional compiler statements in Get-Help (#18475) (Thanks @trossr32!)</li>
<li>Convert <code>DllImport</code> to <code>LibraryImport</code> for recycle bin, clipboard, and computerinfo cmdlets (#18526)</li>
<li>Replace DllImport with LibraryImport in SMA 1 (#18520) (Thanks @iSazonov!)</li>
<li>Replace DllImport with LibraryImport in engine (#18496)</li>
<li>Fix typo in InitialSessionState.cs (#18435) (Thanks @eltociear!)</li>
<li>Remove remaining unused strings from resx files (#18448)</li>
<li>Use new LINQ Order() methods instead of OrderBy(static x =&gt; x) (#18395) (Thanks @turbedi!)</li>
<li>Make use of StringSplitOptions.TrimEntries when possible (#18412) (Thanks @turbedi!)</li>
<li>Replace some <code>string.Join(string)</code> calls with <code>string.Join(char)</code> (#18411) (Thanks @turbedi!)</li>
<li>Remove unused strings from FileSystem and Registry providers (#18403)</li>
<li>Use generic <code>GetValues&lt;T&gt;</code>, <code>GetNames&lt;T&gt;</code> enum methods (#18391) (Thanks @xtqqczze!)</li>
<li>Remove unused resource strings from <code>SessionStateStrings</code> (#18394)</li>
<li>Remove unused resource strings in <code>System.Management.Automation</code> (#18388)</li>
<li>Use <code>Enum.HasFlags</code> part 1 (#18386) (Thanks @xtqqczze!)</li>
<li>Remove unused strings from parser (#18383)</li>
<li>Remove unused strings from Utility module (#18370)</li>
<li>Remove unused console strings (#18369)</li>
<li>Remove unused strings from <code>ConsoleInfoErrorStrings.resx</code> (#18367)</li>
<li>Code cleanup in <code>ContentHelper.Common.cs</code> (#18288) (Thanks @CarloToso!)</li>
<li>Remove <code>FusionAssemblyIdentity</code> and <code>GlobalAssemblyCache</code> as they are not used (#18334) (Thanks @iSazonov!)</li>
<li>Remove some static initializations in <code>StringManipulationHelper</code> (#18243) (Thanks @xtqqczze!)</li>
<li>Use <code>MemoryExtensions.IndexOfAny</code> in <code>PSv2CompletionCompleter</code> (#18245) (Thanks @xtqqczze!)</li>
<li>Use <code>MemoryExtensions.IndexOfAny</code> in <code>WildcardPattern</code> (#18242) (Thanks @xtqqczze!)</li>
<li>Small cleanup of the stub code (#18301) (Thanks @CarloToso!)</li>
<li>Fix typo in <code>RemoteRunspacePoolInternal.cs</code> (#18263) (Thanks @eltociear!)</li>
<li>Some more code cleanup related to the use of <code>PSVersionInfo</code> (#18231)</li>
<li>Use <code>MemoryExtensions.IndexOfAny</code> in <code>SessionStateInternal</code> (#18244) (Thanks @xtqqczze!)</li>
<li>Use overload APIs that take <code>char</code> instead of <code>string</code> when it's possible (#18179) (Thanks @iSazonov!)</li>
<li>Replace <code>UTF8Encoding(false)</code> with <code>Encoding.Default</code> (#18144) (Thanks @xtqqczze!)</li>
<li>Remove unused variables (#18058) (Thanks @AtariDreams!)</li>
<li>Fix typo in PowerShell.Core.Instrumentation.man (#17963) (Thanks @eltociear!)</li>
<li>Migrate <code>WinTrust</code> functions to a common location (#17598) (Thanks @jborean93!)</li>
</ul>

</details>

### Tools

- Add a function to get the PR Back-port report (#18299)
- Add a workaround in automatic rebase workflow to continue on error (#18176)
- Update list of PowerShell team members in release tools (#17909)
- Don't block if we fail to create the comment (#17869)

### Tests

- Add `testexe.exe -echocmdline` to output raw command-line received by the process on Windows (#18591)
- Mark charset test as pending (#18511)
- Skip output rendering tests on Windows Server 2012 R2 (#18382)
- Increase timeout to make subsystem tests more reliable (#18380)
- Add missing -Tag 'CI' to describe blocks. (#18316)
- Use short path instead of multiple quotes in `Get-Item` test relying on node (#18250)
- Replace the CIM class used for `-Amended` parameter test (#17884) (Thanks @sethvs!)
- Stop ongoing progress-bar in `Write-Progress` test (#17880) (Thanks @fflaten!)

### Build and Packaging Improvements

<details>

<summary>

<p>We thank the following contributors!</p>

</summary>

<ul>
<li>Fix reference assembly generation logic for <code>Microsoft.PowerShell.Commands.Utility</code> (#18818)</li>
<li>Update the cgmanifest (#18676)(#18521)(#18415)(#18408)(#18197)(#18111)(#18051)(#17913)(#17867)(#17934)(#18088)</li>
<li>Bump <code>Microsoft.PowerShell.Native</code> to the latest preview version <code>v7.4.0-preview.1</code> (#18805)</li>
<li>Remove unnecessary reference to <code>System.Runtime.CompilerServices.Unsafe</code> (#18806)</li>
<li>Update the release tag in <code>metadata.json</code> for next preview (#18799)</li>
<li>Bump Microsoft.CodeAnalysis.NetAnalyzers (#18750)</li>
<li>Bump .NET SDK to version <code>7.0.101</code> (#18786)</li>
<li>Bump <code>cirrus-actions/rebase</code> from 1.7 to 1.8 (#18788)</li>
<li>Bump <code>decode-uri-component</code> from 0.2.0 to 0.2.2 (#18712)</li>
<li>Bump Microsoft.CodeAnalysis.CSharp from 4.4.0-4.final to 4.4.0 (#18562)</li>
<li>Bump Newtonsoft.Json from 13.0.1 to 13.0.2 (#18657)</li>
<li>Apply expected file permissions to Linux files after Authenticode signing (#18643)</li>
<li>Remove extra quotes after agent moves to pwsh 7.3 (#18577)</li>
<li>Don't install based on build-id for RPM (#18560)</li>
<li>Bump Microsoft.NET.Test.Sdk from 17.3.2 to 17.4.0 (#18487)</li>
<li>Bump <code>minimatch</code> from 3.0.4 to 3.1.2 (#18514)</li>
<li>Avoid depending on the pre-generated experimental feature list in private and CI builds (#18484)</li>
<li>Update <code>release-MsixBundle.yml</code> to add retries (#18465)</li>
<li>Bump System.Data.SqlClient from 4.8.4 to 4.8.5 in /src/Microsoft.PowerShell.SDK (#18515)</li>
<li>Bump to use internal .NET 7 GA build (#18508)</li>
<li>Insert the pre-release nuget feed before building test artifacts (#18507)</li>
<li>Add test for framework dependent package in release pipeline (#18506) (Internal 23139)</li>
<li>Update to azCopy 10 (#18509)</li>
<li>Fix issues with uploading changelog to GitHub release draft (#18504)</li>
<li>Bump Microsoft.CodeAnalysis.NetAnalyzers (#18442)</li>
<li>Add authenticode signing for assemblies on linux builds (#18440)</li>
<li>Do not remove <code>penimc_cor3.dll</code> from build (#18438)</li>
<li>Bump <code>Microsoft.PowerShell.Native</code> from 7.3.0-rc.1 to 7.3.0 (#18405)</li>
<li>Allow two-digit revisions in <code>vPack</code> package validation pattern (#18392)</li>
<li>Bump <code>Microsoft.CodeAnalysis.NetAnalyzers</code> (#18363)</li>
<li>Bump to .NET 7 RC2 official version (#18328)</li>
<li>Bump to .NET 7 to version <code>7.0.100-rc.2.22477.20</code> (#18286)</li>
<li>Replace win7 runtime with win8 and remove APISets (#18304)</li>
<li>Bump Microsoft.CodeAnalysis.NetAnalyzers (#18312)</li>
<li>Recurse the file listing. (#18277)</li>
<li>Create tasks to collect and publish hashes for build files. (#18276)</li>
<li>Bump Microsoft.CodeAnalysis.NetAnalyzers (#18262)</li>
<li>Remove ETW trace collection and uploading for CLR CAP (#18253)</li>
<li>Do not cleanup <code>pwsh.deps.json</code> for framework dependent packages (#18226)</li>
<li>Add branch counter to APIScan build (#18214)</li>
<li>Remove unnecessary native dependencies from the package (#18213)</li>
<li>Remove XML files for min-size package (#18189)</li>
<li>Bump Microsoft.CodeAnalysis.NetAnalyzers (#18216)</li>
<li>Bump <code>Microsoft.PowerShell.Native</code> from <code>7.3.0-preview.1</code> to <code>7.3.0-rc.1</code> (#18217)</li>
<li>Bump Microsoft.CodeAnalysis.NetAnalyzers (#18201)</li>
<li>Move ApiScan to compliance build (#18191)</li>
<li>Fix the verbose message when using <code>dotnet-install.sh</code> (#18184)</li>
<li>Bump Microsoft.NET.Test.Sdk from 17.3.1 to 17.3.2 (#18163)</li>
<li>Bump Microsoft.CodeAnalysis.NetAnalyzers (#18164)</li>
<li>Make the link to minimal package blob public during release (#18158)</li>
<li>Bump <code>Microsoft.CodeAnalysis.NetAnalyzers</code> (#18147)</li>
<li>Update MSI exit message (#18137)</li>
<li>Bump Microsoft.CodeAnalysis.CSharp from 4.4.0-1.final to 4.4.0-2.final (#18132)</li>
<li>Re-enable building with Ready-to-Run (#18105)</li>
<li>Update <code>DotnetRuntimeMetadata.json</code> for .NET 7 RC1 build (#18091)</li>
<li>Bump <code>Microsoft.CodeAnalysis.NetAnalyzers</code> (#18096)</li>
<li>Add schema for cgmanifest.json (#18036)</li>
<li>Bump <code>Microsoft.CodeAnalysis.CSharp</code> from 4.3.0-3.final to 4.3.0 (#18012)</li>
<li>Add XML reference documents to NuPkg files for SDK (#17997)</li>
<li>Bump Microsoft.NET.Test.Sdk from 17.3.0 to 17.3.1 (#18000)</li>
<li>Bump <code>Microsoft.CodeAnalysis.NetAnalyzers</code> (#17988)</li>
<li>Bump Microsoft.CodeAnalysis.NetAnalyzers (#17983)</li>
<li>Bump Microsoft.CodeAnalysis.NetAnalyzers (#17945)</li>
<li>Make sure <code>Security.types.ps1xml</code> gets signed in release build (#17916)</li>
<li>Make Register Microsoft Update timeout (#17910)</li>
<li>Merge changes from v7.0.12 v7.2.6 and v7.3.0-preview.7</li>
<li>Bump Microsoft.NET.Test.Sdk from 17.2.0 to 17.3.0 (#17871)</li>
</ul>

</details>

### Documentation and Help Content

- Update readme and metadata for releases (#18780)(#18493)(#18393)(#18332)(#18128)(#17870)
- Remove 'please' and 'Core' from README.md per MS style guide (#18578) (Thanks @Rick-Anderson!)
- Change unsupported XML documentation tag (#18608)
- Change public API mention of `monad` to PowerShell (#18491)
- Update security reporting policy to recommend security portal for more streamlined reporting (#18437)
- Changelog for v7.3.0 (#18505) (Internal 23161)
- Replace `msh` in public API comment based documentation with PowerShell equivalent (#18483)
- Add missing XML doc elements for methods in `RunspaceFactory` (#18450)
- Changelog for `v7.3.0-rc.1` (#18400)
- Update changelogs for `v7.2.7` and `v7.0.13` (#18342)
- Update the changelog for v7.3.0-preview.8 (#18136)
- Add the `ConfigurationFile` option to the PowerShell help content (#18093)
- Update help content about the PowerShell flag `-NonInteractive` (#17952)

[7.4.0-preview.1]: https://github.com/PowerShell/PowerShell/compare/v7.3.0-preview.8...v7.4.0-preview.1
