from django.db import models, migrations


class Migration(migrations.Migration):
    # replaces = [(b'pokemon_v2', '0001_squashed_0006_pokemonformsprites'), (b'pokemon_v2', '0002_auto_20160301_1408')]

    # dependencies = [
    # ]

    operations = [
        migrations.CreateModel(
            name="Language",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("iso639", models.CharField(max_length=2)),
                ("iso3166", models.CharField(max_length=2)),
                ("name", models.CharField(max_length=10)),
                ("official", models.BooleanField()),
                ("order", models.IntegerField()),
            ],
            options={},
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="LanguageName",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="languagename_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="Generation",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("main_region_id", models.IntegerField()),
                ("name", models.CharField(max_length=30)),
            ],
            options={},
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="GenerationName",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=30)),
                (
                    "generation",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.Generation",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="Ability",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=30)),
                ("is_main_series", models.BooleanField(default=False)),
                (
                    "generation",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.Generation",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="AbilityFlavorText",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("flavor_text", models.CharField(max_length=100)),
                (
                    "ability",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.Ability",
                        null=True,
                    ),
                ),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="AbilityName",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                (
                    "ability",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="abilityname",
                        blank=True,
                        to="pokemon_v2.Ability",
                        null=True,
                    ),
                ),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="abilityname_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="Version",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=30)),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="VersionGroup",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=30)),
                ("order", models.IntegerField()),
                (
                    "generation",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.Generation",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="VersionGroupRegion",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                (
                    "version_group",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.VersionGroup",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="VersionName",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="versionname_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
                (
                    "version",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="versionname",
                        blank=True,
                        to="pokemon_v2.Version",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.AddField(
            model_name="version",
            name="version_group",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                blank=True,
                to="pokemon_v2.VersionGroup",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="abilityflavortext",
            name="version_group",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="abilityflavortext",
                blank=True,
                to="pokemon_v2.VersionGroup",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="generationname",
            name="language",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="generationname_language",
                blank=True,
                to="pokemon_v2.Language",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="language",
            name="name",
            field=models.CharField(max_length=30),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="language",
            name="official",
            field=models.BooleanField(default=False),
            preserve_default=True,
        ),
        migrations.CreateModel(
            name="Type",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=30)),
                ("damage_class_id", models.IntegerField()),
                (
                    "generation",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.Generation",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="TypeGameIndex",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("game_index", models.IntegerField()),
                (
                    "generation",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="typegameindex",
                        blank=True,
                        to="pokemon_v2.Generation",
                        null=True,
                    ),
                ),
                (
                    "type",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="typegameindex",
                        blank=True,
                        to="pokemon_v2.Type",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="TypeName",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="typename_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
                (
                    "type",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="typename",
                        blank=True,
                        to="pokemon_v2.Type",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="TypeEfficacy",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("damage_factor", models.IntegerField()),
            ],
            options={},
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="Nature",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=30)),
                ("hates_flavor_id", models.IntegerField()),
                ("likes_flavor_id", models.IntegerField()),
                ("game_index", models.IntegerField()),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="NatureBattleStylePreference",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("low_hp_preference", models.IntegerField()),
                ("high_hp_preference", models.IntegerField()),
                (
                    "nature",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="naturebattlestylepreference",
                        blank=True,
                        to="pokemon_v2.Nature",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="Stat",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("damage_class_id", models.IntegerField(null=True, blank=True)),
                ("name", models.CharField(max_length=30)),
                ("is_battle_only", models.BooleanField(default=False)),
                ("game_index", models.IntegerField()),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="StatName",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="statname_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
                (
                    "stat",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="statname",
                        blank=True,
                        to="pokemon_v2.Stat",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.AddField(
            model_name="nature",
            name="decreased_stat",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="decreased",
                blank=True,
                to="pokemon_v2.Stat",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="nature",
            name="increased_stat",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="increased",
                blank=True,
                to="pokemon_v2.Stat",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.RemoveField(
            model_name="type",
            name="damage_class_id",
        ),
        migrations.CreateModel(
            name="NatureName",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="naturename_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
                (
                    "nature",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="naturename",
                        blank=True,
                        to="pokemon_v2.Nature",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="NaturePokeathlonStat",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("max_change", models.IntegerField()),
                (
                    "nature",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.Nature",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="Characteristic",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("gene_mod_5", models.IntegerField()),
                (
                    "stat",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.Stat",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="CharacteristicDescription",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("description", models.CharField(default="", max_length=1000)),
                (
                    "characteristic",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="characteristicdescription",
                        blank=True,
                        to="pokemon_v2.Characteristic",
                        null=True,
                    ),
                ),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="characteristicdescription_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="EggGroup",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=30)),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="EggGroupName",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                (
                    "egg_group",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="egggroupname",
                        blank=True,
                        to="pokemon_v2.EggGroup",
                        null=True,
                    ),
                ),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="egggroupname_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="GrowthRate",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=30)),
                ("formula", models.CharField(max_length=500)),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="GrowthRateDescription",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                (
                    "growth_rate",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="growthratedescription",
                        blank=True,
                        to="pokemon_v2.GrowthRate",
                        null=True,
                    ),
                ),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="growthratedescription_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
                ("description", models.CharField(default="", max_length=1000)),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="Move",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=30)),
                ("power", models.IntegerField()),
                ("pp", models.IntegerField()),
                ("accuracy", models.IntegerField()),
                ("priority", models.IntegerField()),
                ("move_effect_chance", models.IntegerField()),
                ("contest_type_id", models.IntegerField()),
                ("contest_effect_id", models.IntegerField()),
                ("super_contest_effect_id", models.IntegerField()),
                (
                    "generation",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.Generation",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="MoveBattleStyle",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=30)),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="MoveBattleStyleName",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="movebattlestylename_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
                (
                    "move_battle_style",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="movebattlestylename",
                        blank=True,
                        to="pokemon_v2.MoveBattleStyle",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="MoveChange",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("power", models.IntegerField()),
                ("pp", models.IntegerField()),
                ("accuracy", models.IntegerField()),
                ("move_effect_chance", models.IntegerField()),
                (
                    "move",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.Move",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="MoveDamageClass",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=30)),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="MoveDamageClassDescription",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("description", models.CharField(default="", max_length=1000)),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="movedamageclassdescription_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
                (
                    "move_damage_class",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="movedamageclassdescription",
                        blank=True,
                        to="pokemon_v2.MoveDamageClass",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="MoveEffect",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
            ],
            options={},
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="MoveEffectChange",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                (
                    "move_effect",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.MoveEffect",
                        null=True,
                    ),
                ),
                (
                    "version_group",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="moveeffectchange",
                        blank=True,
                        to="pokemon_v2.VersionGroup",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="MoveAttribute",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="MoveFlavorText",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("flavor_text", models.CharField(max_length=500)),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="moveflavortext_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
                (
                    "move",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="moveflavortext",
                        blank=True,
                        to="pokemon_v2.Move",
                        null=True,
                    ),
                ),
                (
                    "version_group",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="moveflavortext",
                        blank=True,
                        to="pokemon_v2.VersionGroup",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="MoveMeta",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("min_hits", models.IntegerField()),
                ("max_hits", models.IntegerField()),
                ("min_turns", models.IntegerField()),
                ("max_turns", models.IntegerField()),
                ("drain", models.BooleanField(default=False)),
                ("healing", models.BooleanField(default=False)),
                ("crit_rate", models.IntegerField()),
                ("ailment_chance", models.IntegerField()),
                ("flinch_chance", models.IntegerField()),
                ("stat_chance", models.IntegerField()),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="MoveMetaAilment",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=30)),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="MoveMetaAilmentName",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="movemetaailmentname_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
                (
                    "move_meta_ailment",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="movemetaailmentname",
                        blank=True,
                        to="pokemon_v2.MoveMetaAilment",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="MoveMetaCategory",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=30)),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="MoveMetaCategoryDescription",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("description", models.CharField(default="", max_length=1000)),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="movemetacategorydescription_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
                (
                    "move_meta_category",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="movemetacategorydescription",
                        blank=True,
                        to="pokemon_v2.MoveMetaCategory",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="MoveMetaStatChange",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("change", models.IntegerField()),
                (
                    "move",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="movemetastatchange",
                        blank=True,
                        to="pokemon_v2.Move",
                        null=True,
                    ),
                ),
                (
                    "stat",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="movemetastatchange",
                        blank=True,
                        to="pokemon_v2.Stat",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="MoveName",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="movename_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
                (
                    "move",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="movename",
                        blank=True,
                        to="pokemon_v2.Move",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="MoveTarget",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=30)),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="MoveTargetDescription",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("description", models.CharField(default="", max_length=1000)),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="movetargetdescription_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
                (
                    "move_target",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="movetargetdescription",
                        blank=True,
                        to="pokemon_v2.MoveTarget",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.AddField(
            model_name="movemeta",
            name="move_meta_category",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="movemeta",
                blank=True,
                to="pokemon_v2.MoveMetaCategory",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="movemeta",
            name="move",
            field=models.OneToOneField(
                on_delete=models.CASCADE, related_name="movemeta", to="pokemon_v2.Move"
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="movemeta",
            name="move_meta_ailment",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="movemeta",
                blank=True,
                to="pokemon_v2.MoveMetaAilment",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="movechange",
            name="move_effect",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                blank=True,
                to="pokemon_v2.MoveEffect",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="movechange",
            name="type",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="movechange",
                blank=True,
                to="pokemon_v2.Type",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="movechange",
            name="version_group",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="movechange",
                blank=True,
                to="pokemon_v2.VersionGroup",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="move",
            name="move_damage_class",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                blank=True,
                to="pokemon_v2.MoveDamageClass",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="move",
            name="move_effect",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                blank=True,
                to="pokemon_v2.MoveEffect",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="move",
            name="move_target",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                blank=True,
                to="pokemon_v2.MoveTarget",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="move",
            name="type",
            field=models.ForeignKey(
                on_delete=models.CASCADE, blank=True, to="pokemon_v2.Type", null=True
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="move",
            name="accuracy",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="move",
            name="move_effect_chance",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="move",
            name="power",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="move",
            name="pp",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="move",
            name="priority",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="move",
            name="contest_effect_id",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="move",
            name="contest_type_id",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="move",
            name="super_contest_effect_id",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="abilityflavortext",
            name="flavor_text",
            field=models.CharField(max_length=200),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="movechange",
            name="accuracy",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="movechange",
            name="move_effect_chance",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="movechange",
            name="power",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="movechange",
            name="pp",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="ability",
            name="name",
            field=models.CharField(max_length=40),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="egggroup",
            name="name",
            field=models.CharField(max_length=40),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="generation",
            name="name",
            field=models.CharField(max_length=40),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="generationname",
            name="name",
            field=models.CharField(max_length=40),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="growthrate",
            name="name",
            field=models.CharField(max_length=40),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="language",
            name="name",
            field=models.CharField(max_length=40),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="move",
            name="name",
            field=models.CharField(max_length=40),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="movebattlestyle",
            name="name",
            field=models.CharField(max_length=40),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="movedamageclass",
            name="name",
            field=models.CharField(max_length=40),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="movemetaailment",
            name="name",
            field=models.CharField(max_length=40),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="movemetacategory",
            name="name",
            field=models.CharField(max_length=40),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="movetarget",
            name="name",
            field=models.CharField(max_length=40),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="nature",
            name="name",
            field=models.CharField(max_length=40),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="stat",
            name="name",
            field=models.CharField(max_length=40),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="type",
            name="name",
            field=models.CharField(max_length=40),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="version",
            name="name",
            field=models.CharField(max_length=40),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="versiongroup",
            name="name",
            field=models.CharField(max_length=40),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="ability",
            name="name",
            field=models.CharField(max_length=100),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="egggroup",
            name="name",
            field=models.CharField(max_length=100),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="generation",
            name="name",
            field=models.CharField(max_length=100),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="generationname",
            name="name",
            field=models.CharField(max_length=100),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="growthrate",
            name="name",
            field=models.CharField(max_length=100),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="language",
            name="name",
            field=models.CharField(max_length=100),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="move",
            name="name",
            field=models.CharField(max_length=100),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="movebattlestyle",
            name="name",
            field=models.CharField(max_length=100),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="movedamageclass",
            name="name",
            field=models.CharField(max_length=100),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="movemetaailment",
            name="name",
            field=models.CharField(max_length=100),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="movemetacategory",
            name="name",
            field=models.CharField(max_length=100),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="movetarget",
            name="name",
            field=models.CharField(max_length=100),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="nature",
            name="name",
            field=models.CharField(max_length=100),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="stat",
            name="name",
            field=models.CharField(max_length=100),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="type",
            name="name",
            field=models.CharField(max_length=100),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="version",
            name="name",
            field=models.CharField(max_length=100),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="versiongroup",
            name="name",
            field=models.CharField(max_length=100),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="movemeta",
            name="ailment_chance",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="movemeta",
            name="crit_rate",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="movemeta",
            name="flinch_chance",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="movemeta",
            name="max_hits",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="movemeta",
            name="max_turns",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="movemeta",
            name="min_hits",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="movemeta",
            name="min_turns",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="movemeta",
            name="stat_chance",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.RemoveField(
            model_name="movemeta",
            name="drain",
        ),
        migrations.RemoveField(
            model_name="movemeta",
            name="healing",
        ),
        migrations.AlterField(
            model_name="movemeta",
            name="ailment_chance",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="movemeta",
            name="crit_rate",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="movemeta",
            name="flinch_chance",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="movemeta",
            name="max_hits",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="movemeta",
            name="max_turns",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="movemeta",
            name="min_hits",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="movemeta",
            name="min_turns",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="movemeta",
            name="stat_chance",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="movemeta",
            name="drain",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="movemeta",
            name="healing",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.RemoveField(
            model_name="stat",
            name="damage_class_id",
        ),
        migrations.AddField(
            model_name="stat",
            name="move_damage_class",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                blank=True,
                to="pokemon_v2.MoveDamageClass",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="type",
            name="move_damage_class",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                blank=True,
                to="pokemon_v2.MoveDamageClass",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.CreateModel(
            name="AbilityChange",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                (
                    "ability",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="abilitychange",
                        blank=True,
                        to="pokemon_v2.Ability",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="EvolutionChain",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("baby_evolution_item", models.IntegerField()),
            ],
            options={},
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="EvolutionTrigger",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="EvolutionTriggerName",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                (
                    "evolution_trigger",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="evolutiontriggername",
                        blank=True,
                        to="pokemon_v2.EvolutionTrigger",
                        null=True,
                    ),
                ),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="evolutiontriggername_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="Experience",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("level", models.IntegerField()),
                ("experience", models.IntegerField()),
                (
                    "growth_rate",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="experience",
                        blank=True,
                        to="pokemon_v2.GrowthRate",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="Gender",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="Pokedex",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                ("region_id", models.IntegerField(null=True, blank=True)),
                ("is_main_series", models.BooleanField(default=False)),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="PokedexDescription",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("description", models.CharField(default="", max_length=1000)),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="pokedexdescription_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
                (
                    "pokedex",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="pokedexdescription",
                        blank=True,
                        to="pokemon_v2.Pokedex",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="PokedexVersionGroup",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                (
                    "pokedex",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="pokedexversiongroup",
                        blank=True,
                        to="pokemon_v2.Pokedex",
                        null=True,
                    ),
                ),
                (
                    "version_group",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="pokedexversiongroup",
                        blank=True,
                        to="pokemon_v2.VersionGroup",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="Pokemon",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                ("order", models.IntegerField()),
                ("height", models.IntegerField()),
                ("weight", models.IntegerField()),
                ("base_experience", models.IntegerField()),
                ("is_default", models.BooleanField(default=False)),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="PokemonAbility",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("is_hidden", models.BooleanField(default=False)),
                ("slot", models.IntegerField()),
                (
                    "ability",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="pokemonability",
                        blank=True,
                        to="pokemon_v2.Ability",
                        null=True,
                    ),
                ),
                (
                    "pokemon",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="pokemonability",
                        blank=True,
                        to="pokemon_v2.Pokemon",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="PokemonColor",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="PokemonColorName",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="pokemoncolorname_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
                (
                    "pokemon_color",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="pokemoncolorname",
                        blank=True,
                        to="pokemon_v2.PokemonColor",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="PokemonDexNumber",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("pokedex_number", models.IntegerField()),
                (
                    "pokedex",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.Pokedex",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="PokemonEggGroup",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                (
                    "egg_group",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.EggGroup",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="PokemonEvolution",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("item", models.IntegerField()),
                ("min_level", models.IntegerField()),
                ("location_id", models.IntegerField()),
                ("held_item", models.IntegerField()),
                ("time_of_day", models.CharField(max_length=10)),
                ("min_happiness", models.IntegerField()),
                ("minimum_beauty", models.IntegerField()),
                ("min_affection", models.IntegerField()),
                ("relative_physical_stats", models.IntegerField()),
                ("needs_overworld_rain", models.BooleanField(default=False)),
                ("turn_upside_down", models.BooleanField(default=False)),
                (
                    "evolution_trigger",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.EvolutionTrigger",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="PokemonForm",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                ("order", models.IntegerField()),
                ("form_identifier", models.CharField(max_length=30)),
                ("is_default", models.BooleanField(default=False)),
                ("is_battle_only", models.BooleanField(default=False)),
                ("is_mega_form_order", models.BooleanField(default=False)),
                (
                    "version_group",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.VersionGroup",
                        null=True,
                    ),
                ),
                (
                    "pokemon",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.Pokemon",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="PokemonFormGeneration",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("game_index", models.IntegerField()),
                (
                    "generation",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="pokemonformgeneration",
                        blank=True,
                        to="pokemon_v2.Generation",
                        null=True,
                    ),
                ),
                (
                    "pokemon_form",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="pokemonformgeneration",
                        blank=True,
                        to="pokemon_v2.PokemonForm",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="PokemonFormName",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                ("pokemon_name", models.CharField(max_length=30)),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="pokemonformname_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
                (
                    "pokemon_form",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="pokemonformname",
                        blank=True,
                        to="pokemon_v2.PokemonForm",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="PokemonGameIndex",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("game_index", models.IntegerField()),
                (
                    "pokemon",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="pokemongameindex",
                        blank=True,
                        to="pokemon_v2.Pokemon",
                        null=True,
                    ),
                ),
                (
                    "version",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="pokemongameindex",
                        blank=True,
                        to="pokemon_v2.Version",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="PokemonHabitat",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="PokemonHabitatName",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="pokemonhabitatname_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
                (
                    "pokemon_habitat",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="pokemonhabitatname",
                        blank=True,
                        to="pokemon_v2.PokemonHabitat",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="PokemonItem",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("rarity", models.IntegerField()),
                (
                    "pokemon",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.Pokemon",
                        null=True,
                    ),
                ),
                (
                    "version",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.Version",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="PokemonMove",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("order", models.IntegerField(null=True, blank=True)),
                ("level", models.IntegerField()),
                (
                    "move",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="pokemonmove",
                        blank=True,
                        to="pokemon_v2.Move",
                        null=True,
                    ),
                ),
                (
                    "pokemon",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="pokemonmove",
                        blank=True,
                        to="pokemon_v2.Pokemon",
                        null=True,
                    ),
                ),
                (
                    "version_group",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="pokemonmove",
                        blank=True,
                        to="pokemon_v2.VersionGroup",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="MoveLearnMethod",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="MoveLearnMethodName",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="movelearnmethodname_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
                (
                    "move_learn_method",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="movelearnmethodname",
                        blank=True,
                        to="pokemon_v2.MoveLearnMethod",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="PokemonShape",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="PokemonShapeName",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                ("awesome_name", models.CharField(max_length=30)),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="pokemonshapename_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
                (
                    "pokemon_shape",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="pokemonshapename",
                        blank=True,
                        to="pokemon_v2.PokemonShape",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="PokemonSpecies",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                ("order", models.IntegerField()),
                ("gender_rate", models.IntegerField()),
                ("capture_rate", models.IntegerField()),
                ("base_happiness", models.IntegerField()),
                ("is_baby", models.BooleanField()),
                ("hatch_counter", models.IntegerField()),
                ("has_gender_differences", models.BooleanField()),
                ("forms_switchable", models.BooleanField()),
                (
                    "evolution_chain",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.EvolutionChain",
                        null=True,
                    ),
                ),
                (
                    "evolves_from_species",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.PokemonSpecies",
                        null=True,
                    ),
                ),
                (
                    "generation",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.Generation",
                        null=True,
                    ),
                ),
                (
                    "growth_rate",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.GrowthRate",
                        null=True,
                    ),
                ),
                (
                    "pokemon_color",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.PokemonColor",
                        null=True,
                    ),
                ),
                (
                    "pokemon_habitat",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.PokemonHabitat",
                        null=True,
                    ),
                ),
                (
                    "pokemon_shape",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.PokemonShape",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="PokemonSpeciesDescription",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("description", models.CharField(default="", max_length=1000)),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="pokemonspeciesdescription_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
                (
                    "pokemon_species",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="pokemonspeciesdescription",
                        blank=True,
                        to="pokemon_v2.PokemonSpecies",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="PokemonSpeciesFlavorText",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("flavor_text", models.CharField(max_length=500)),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="pokemonspeciesflavortext_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
                (
                    "pokemon_species",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="pokemonspeciesflavortext",
                        blank=True,
                        to="pokemon_v2.PokemonSpecies",
                        null=True,
                    ),
                ),
                (
                    "version",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="pokemonspeciesflavortext",
                        blank=True,
                        to="pokemon_v2.Version",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="PokemonSpeciesName",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                ("genus", models.CharField(max_length=30)),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="pokemonspeciesname_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
                (
                    "pokemon_species",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="pokemonspeciesname",
                        blank=True,
                        to="pokemon_v2.PokemonSpecies",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="PokemonStat",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("base_stat", models.IntegerField()),
                ("effort", models.IntegerField()),
                (
                    "pokemon",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="pokemonstat",
                        blank=True,
                        to="pokemon_v2.Pokemon",
                        null=True,
                    ),
                ),
                (
                    "stat",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="pokemonstat",
                        blank=True,
                        to="pokemon_v2.Stat",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="PokemonType",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("slot", models.IntegerField()),
                (
                    "pokemon",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="pokemontype",
                        blank=True,
                        to="pokemon_v2.Pokemon",
                        null=True,
                    ),
                ),
                (
                    "type",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="pokemontype",
                        blank=True,
                        to="pokemon_v2.Type",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.AddField(
            model_name="pokemonevolution",
            name="evolved_species",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="evolved_species",
                blank=True,
                to="pokemon_v2.PokemonSpecies",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="pokemonevolution",
            name="gender",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="pokemonevolution",
                blank=True,
                to="pokemon_v2.Gender",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="pokemonevolution",
            name="known_move",
            field=models.ForeignKey(
                on_delete=models.CASCADE, blank=True, to="pokemon_v2.Move", null=True
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="pokemonevolution",
            name="known_move_type",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="known_move",
                blank=True,
                to="pokemon_v2.Type",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="pokemonevolution",
            name="party_species",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="party_species",
                blank=True,
                to="pokemon_v2.PokemonSpecies",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="pokemonevolution",
            name="party_type",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="party_type",
                blank=True,
                to="pokemon_v2.Type",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="pokemonevolution",
            name="trade_species",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="trade_species",
                blank=True,
                to="pokemon_v2.PokemonSpecies",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="pokemonegggroup",
            name="pokemon_species",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="pokemonegggroup",
                blank=True,
                to="pokemon_v2.PokemonSpecies",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="pokemondexnumber",
            name="pokemon_species",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="pokemondexnumber",
                blank=True,
                to="pokemon_v2.PokemonSpecies",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="pokemon",
            name="pokemon_species",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                blank=True,
                to="pokemon_v2.PokemonSpecies",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="pokemonspecies",
            name="forms_switchable",
            field=models.BooleanField(default=False),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="pokemonspecies",
            name="has_gender_differences",
            field=models.BooleanField(default=False),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="pokemonspecies",
            name="is_baby",
            field=models.BooleanField(default=False),
            preserve_default=True,
        ),
        migrations.RenameField(
            model_name="evolutionchain",
            old_name="baby_evolution_item",
            new_name="baby_evolution_item_id",
        ),
        migrations.RemoveField(
            model_name="evolutionchain",
            name="baby_evolution_item_id",
        ),
        migrations.AlterField(
            model_name="abilityflavortext",
            name="flavor_text",
            field=models.CharField(max_length=500),
            preserve_default=True,
        ),
        migrations.RenameField(
            model_name="pokemonevolution",
            old_name="minimum_beauty",
            new_name="min_beauty",
        ),
        migrations.RenameField(
            model_name="pokemonevolution",
            old_name="item",
            new_name="evolution_item_id",
        ),
        migrations.RenameField(
            model_name="pokemonevolution",
            old_name="held_item",
            new_name="held_item_id",
        ),
        migrations.RemoveField(
            model_name="pokemonevolution",
            name="evolution_item_id",
        ),
        migrations.RemoveField(
            model_name="pokemonevolution",
            name="held_item_id",
        ),
        migrations.RemoveField(
            model_name="pokemonevolution",
            name="location_id",
        ),
        migrations.AlterField(
            model_name="pokemonevolution",
            name="min_affection",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="pokemonevolution",
            name="min_beauty",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="pokemonevolution",
            name="min_happiness",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="pokemonevolution",
            name="relative_physical_stats",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="pokemonevolution",
            name="min_level",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="pokemonevolution",
            name="time_of_day",
            field=models.CharField(max_length=10, null=True, blank=True),
            preserve_default=True,
        ),
        migrations.RenameField(
            model_name="pokemonform",
            old_name="is_mega_form_order",
            new_name="is_mega",
        ),
        migrations.AddField(
            model_name="pokemonform",
            name="form_order",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="language",
            name="order",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="pokemon",
            name="order",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="pokemonform",
            name="order",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="pokemonspecies",
            name="order",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="versiongroup",
            name="order",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.CreateModel(
            name="Machine",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("machine_number", models.IntegerField()),
                (
                    "growth_rate",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.GrowthRate",
                        null=True,
                    ),
                ),
                (
                    "move",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.Move",
                        null=True,
                    ),
                ),
                (
                    "version_group",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.VersionGroup",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="Item",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                ("cost", models.IntegerField(null=True, blank=True)),
                ("fling_power", models.IntegerField(null=True, blank=True)),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="ItemCategory",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="ItemCategoryName",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                (
                    "item_category",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="itemcategoryname",
                        blank=True,
                        to="pokemon_v2.ItemCategory",
                        null=True,
                    ),
                ),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="itemcategoryname_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="ItemAttribute",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="ItemFlavorText",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("flavor_text", models.CharField(max_length=500)),
                (
                    "item",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="itemflavortext",
                        blank=True,
                        to="pokemon_v2.Item",
                        null=True,
                    ),
                ),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="itemflavortext_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
                (
                    "version_group",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="itemflavortext",
                        blank=True,
                        to="pokemon_v2.VersionGroup",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="ItemFlingEffect",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(default="name", max_length=100)),
            ],
            options={},
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="ItemGameIndex",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("game_index", models.IntegerField()),
                (
                    "generation",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="itemgameindex",
                        blank=True,
                        to="pokemon_v2.Generation",
                        null=True,
                    ),
                ),
                (
                    "item",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="itemgameindex",
                        blank=True,
                        to="pokemon_v2.Item",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="ItemName",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                (
                    "item",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="itemname",
                        blank=True,
                        to="pokemon_v2.Item",
                        null=True,
                    ),
                ),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="itemname_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="ItemPocket",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="ItemPocketName",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                (
                    "item_pocket",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="itempocketname",
                        blank=True,
                        to="pokemon_v2.ItemPocket",
                        null=True,
                    ),
                ),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="itempocketname_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.AddField(
            model_name="itemcategory",
            name="item_pocket",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="itemcategory",
                blank=True,
                to="pokemon_v2.ItemPocket",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="item",
            name="item_category",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="item",
                blank=True,
                to="pokemon_v2.ItemCategory",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="item",
            name="item_fling_effect",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="item",
                blank=True,
                to="pokemon_v2.ItemFlingEffect",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="evolutionchain",
            name="baby_trigger_item",
            field=models.ForeignKey(
                on_delete=models.CASCADE, blank=True, to="pokemon_v2.Item", null=True
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="machine",
            name="item",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="machine",
                blank=True,
                to="pokemon_v2.Item",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="pokemonevolution",
            name="evolution_item",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="evolution_item",
                blank=True,
                to="pokemon_v2.Item",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="pokemonevolution",
            name="held_item",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="held_item",
                blank=True,
                to="pokemon_v2.Item",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="pokemonitem",
            name="item",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="pokemonitem",
                blank=True,
                to="pokemon_v2.Item",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.CreateModel(
            name="Berry",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("natural_gift_power", models.IntegerField()),
                ("size", models.IntegerField()),
                ("max_harvest", models.IntegerField()),
                ("growth_time", models.IntegerField()),
                ("soil_dryness", models.IntegerField()),
                ("smoothness", models.IntegerField()),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="BerryFirmness",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="BerryFirmnessName",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                (
                    "berry_firmness",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="berryfirmnessname",
                        blank=True,
                        to="pokemon_v2.BerryFirmness",
                        null=True,
                    ),
                ),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="berryfirmnessname_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="BerryFlavor",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("flavor", models.IntegerField()),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="ContestCombo",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                (
                    "first_move",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="first_move",
                        blank=True,
                        to="pokemon_v2.Move",
                        null=True,
                    ),
                ),
                (
                    "second_move",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="second_move",
                        blank=True,
                        to="pokemon_v2.Move",
                        null=True,
                    ),
                ),
            ],
            options={},
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="ContestEffect",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("appeal", models.IntegerField()),
                ("jam", models.IntegerField()),
            ],
            options={},
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="ContestType",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="ContestTypeName",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                ("flavor", models.CharField(max_length=10)),
                ("color", models.CharField(max_length=10)),
                (
                    "contest_type",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="contesttypename",
                        blank=True,
                        to="pokemon_v2.ContestType",
                        null=True,
                    ),
                ),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="contesttypename_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.AddField(
            model_name="berryflavor",
            name="contest_type",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="berryflavor",
                blank=True,
                to="pokemon_v2.ContestType",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="berry",
            name="berry_firmness",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                blank=True,
                to="pokemon_v2.BerryFirmness",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="berry",
            name="item",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="berry",
                blank=True,
                to="pokemon_v2.Item",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.RenameField(
            model_name="nature",
            old_name="hates_flavor_id",
            new_name="hates_flavor",
        ),
        migrations.AlterField(
            model_name="nature",
            name="hates_flavor",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="hates_flavor",
                blank=True,
                to="pokemon_v2.BerryFlavor",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.RenameField(
            model_name="nature",
            old_name="likes_flavor_id",
            new_name="likes_flavor",
        ),
        migrations.AlterField(
            model_name="nature",
            name="likes_flavor",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="likes_flavor",
                blank=True,
                to="pokemon_v2.BerryFlavor",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.CreateModel(
            name="Region",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="RegionName",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="regionname_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
                (
                    "region",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="regionname",
                        blank=True,
                        to="pokemon_v2.Region",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.RemoveField(
            model_name="generation",
            name="main_region_id",
        ),
        migrations.RemoveField(
            model_name="pokedex",
            name="region_id",
        ),
        migrations.AddField(
            model_name="generation",
            name="region",
            field=models.ForeignKey(
                on_delete=models.CASCADE, blank=True, to="pokemon_v2.Region", null=True
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="pokedex",
            name="region",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="pokedex",
                blank=True,
                to="pokemon_v2.Region",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="versiongroupregion",
            name="region",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="versiongroupregion",
                blank=True,
                to="pokemon_v2.Region",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.CreateModel(
            name="Location",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                (
                    "region",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.Region",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="LocationArea",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("game_index", models.IntegerField()),
                ("name", models.CharField(max_length=100)),
                (
                    "location",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.Location",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="LocationAreaEncounterRate",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("rate", models.IntegerField()),
                (
                    "location_area",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.LocationArea",
                        null=True,
                    ),
                ),
                (
                    "version",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.Version",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="LocationAreaName",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="locationareaname_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
                (
                    "location_area",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="locationareaname",
                        blank=True,
                        to="pokemon_v2.LocationArea",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="LocationGameIndex",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("game_index", models.IntegerField()),
                (
                    "generation",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="locationgameindex",
                        blank=True,
                        to="pokemon_v2.Generation",
                        null=True,
                    ),
                ),
                (
                    "location",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="locationgameindex",
                        blank=True,
                        to="pokemon_v2.Location",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="LocationName",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="locationname_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
                (
                    "location",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="locationname",
                        blank=True,
                        to="pokemon_v2.Location",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="Encounter",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("min_level", models.IntegerField()),
                ("max_level", models.IntegerField()),
                (
                    "location_area",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.LocationArea",
                        null=True,
                    ),
                ),
                (
                    "pokemon",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.Pokemon",
                        null=True,
                    ),
                ),
                (
                    "version",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.Version",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="EncounterCondition",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="EncounterConditionName",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                (
                    "encounter_condition",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="encounterconditionname",
                        blank=True,
                        to="pokemon_v2.EncounterCondition",
                        null=True,
                    ),
                ),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="encounterconditionname_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="EncounterConditionValue",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                ("is_default", models.BooleanField(default=False)),
                (
                    "encounter_condition",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.EncounterCondition",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="EncounterConditionValueMap",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                (
                    "encounter",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.Encounter",
                        null=True,
                    ),
                ),
                (
                    "encounter_condition_value",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.EncounterConditionValue",
                        null=True,
                    ),
                ),
            ],
            options={},
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="EncounterConditionValueName",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                (
                    "encounter_condition_value",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="encounterconditionvaluename",
                        blank=True,
                        to="pokemon_v2.EncounterConditionValue",
                        null=True,
                    ),
                ),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="encounterconditionvaluename_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="EncounterMethod",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                ("order", models.IntegerField(null=True, blank=True)),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="EncounterMethodName",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                (
                    "encounter_method",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="encountermethodname",
                        blank=True,
                        to="pokemon_v2.EncounterMethod",
                        null=True,
                    ),
                ),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="encountermethodname_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="EncounterSlot",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("slot", models.IntegerField(null=True, blank=True)),
                ("rarity", models.IntegerField()),
                (
                    "encounter_method",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="encounterslot",
                        blank=True,
                        to="pokemon_v2.EncounterMethod",
                        null=True,
                    ),
                ),
                (
                    "version_group",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="encounterslot",
                        blank=True,
                        to="pokemon_v2.VersionGroup",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.AddField(
            model_name="locationareaencounterrate",
            name="encounter_method",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="locationareaencounterrate",
                blank=True,
                to="pokemon_v2.EncounterMethod",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="encounter",
            name="encounter_slot",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                blank=True,
                to="pokemon_v2.EncounterSlot",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.CreateModel(
            name="PalPark",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("base_score", models.IntegerField()),
                ("rate", models.IntegerField()),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="PalParkArea",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="PalParkAreaName",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="palparkareaname_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
                (
                    "pal_park_area",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="palparkareaname",
                        blank=True,
                        to="pokemon_v2.PalParkArea",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="PokeathlonStat",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="PokeathlonStatName",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="pokeathlonstatname_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
                (
                    "pokeathlon_stat",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="pokeathlonstatname",
                        blank=True,
                        to="pokemon_v2.PokeathlonStat",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="SuperContestCombo",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                (
                    "first_move",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="first",
                        blank=True,
                        to="pokemon_v2.Move",
                        null=True,
                    ),
                ),
                (
                    "second_move",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="second",
                        blank=True,
                        to="pokemon_v2.Move",
                        null=True,
                    ),
                ),
            ],
            options={},
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="SuperContestEffect",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("appeal", models.IntegerField()),
            ],
            options={},
            bases=(models.Model,),
        ),
        migrations.AddField(
            model_name="palpark",
            name="pal_park_area",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="palpark",
                blank=True,
                to="pokemon_v2.PalParkArea",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="palpark",
            name="pokemon_species",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="palpark",
                blank=True,
                to="pokemon_v2.PokemonSpecies",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="naturepokeathlonstat",
            name="pokeathlon_stat",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="naturepokeathlonstat",
                blank=True,
                to="pokemon_v2.PokeathlonStat",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="palpark",
            name="base_score",
            field=models.IntegerField(null=True, blank=True),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="abilityflavortext",
            name="ability",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="abilityflavortext_descriptions",
                blank=True,
                to="pokemon_v2.Ability",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="abilityflavortext",
            name="ability",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="abilityflavortext",
                blank=True,
                to="pokemon_v2.Ability",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="abilityflavortext",
            name="language",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="abilityflavortext",
                blank=True,
                to="pokemon_v2.Language",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="abilityflavortext",
            name="language",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="abilityflavortextlanguage",
                blank=True,
                to="pokemon_v2.Language",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="ability",
            name="generation",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="ability",
                blank=True,
                to="pokemon_v2.Generation",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="abilityflavortext",
            name="language",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="abilityflavortext_language",
                blank=True,
                to="pokemon_v2.Language",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="encounter",
            name="version",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="encounter",
                blank=True,
                to="pokemon_v2.Version",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="generation",
            name="region",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="generation",
                blank=True,
                to="pokemon_v2.Region",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="generationname",
            name="generation",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="generationname",
                blank=True,
                to="pokemon_v2.Generation",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="location",
            name="region",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="location",
                blank=True,
                to="pokemon_v2.Region",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="locationareaencounterrate",
            name="version",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="locationareaencounterrate",
                blank=True,
                to="pokemon_v2.Version",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="move",
            name="generation",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="move",
                blank=True,
                to="pokemon_v2.Generation",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="move",
            name="type",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="move",
                blank=True,
                to="pokemon_v2.Type",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="pokemonitem",
            name="version",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="pokemonitem",
                blank=True,
                to="pokemon_v2.Version",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="pokemonspecies",
            name="generation",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="pokemonspecies",
                blank=True,
                to="pokemon_v2.Generation",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="type",
            name="generation",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="type",
                blank=True,
                to="pokemon_v2.Generation",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="version",
            name="version_group",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="version",
                blank=True,
                to="pokemon_v2.VersionGroup",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="versiongroup",
            name="generation",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="versiongroup",
                blank=True,
                to="pokemon_v2.Generation",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="versiongroupregion",
            name="version_group",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="versiongroupregion",
                blank=True,
                to="pokemon_v2.VersionGroup",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="typeefficacy",
            name="damage_type",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="damage_type",
                blank=True,
                to="pokemon_v2.Type",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="typeefficacy",
            name="target_type",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="target_type",
                blank=True,
                to="pokemon_v2.Type",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="pokemon",
            name="pokemon_species",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="pokemon",
                blank=True,
                to="pokemon_v2.PokemonSpecies",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="pokemondexnumber",
            name="pokedex",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="pokemondexnumber",
                blank=True,
                to="pokemon_v2.Pokedex",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="encounter",
            name="location_area",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="encounter",
                blank=True,
                to="pokemon_v2.LocationArea",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="encounter",
            name="pokemon",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="encounter",
                blank=True,
                to="pokemon_v2.Pokemon",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="encounterconditionvalue",
            name="encounter_condition",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="encounterconditionvalue",
                blank=True,
                to="pokemon_v2.EncounterCondition",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="locationarea",
            name="location",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="locationarea",
                blank=True,
                to="pokemon_v2.Location",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="locationareaencounterrate",
            name="location_area",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="locationareaencounterrate",
                blank=True,
                to="pokemon_v2.LocationArea",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="machine",
            name="growth_rate",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="machine",
                blank=True,
                to="pokemon_v2.GrowthRate",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="movechange",
            name="move",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="movechange",
                blank=True,
                to="pokemon_v2.Move",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="pokemonegggroup",
            name="egg_group",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="pokemonegggroup",
                blank=True,
                to="pokemon_v2.EggGroup",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="pokemonevolution",
            name="evolution_trigger",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="pokemonevolution",
                blank=True,
                to="pokemon_v2.EvolutionTrigger",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="pokemonform",
            name="pokemon",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="pokemonform",
                blank=True,
                to="pokemon_v2.Pokemon",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="pokemonitem",
            name="pokemon",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="pokemonitem",
                blank=True,
                to="pokemon_v2.Pokemon",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="pokemonspecies",
            name="growth_rate",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="pokemonspecies",
                blank=True,
                to="pokemon_v2.GrowthRate",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.RenameField(
            model_name="pokemonform",
            old_name="form_identifier",
            new_name="form_name",
        ),
        migrations.AddField(
            model_name="pokemonmove",
            name="move_learn_method",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="pokemonmove",
                blank=True,
                to="pokemon_v2.MoveLearnMethod",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.CreateModel(
            name="VersionGroupMoveLearnMethod",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                (
                    "move_learn_method",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="versiongroupmovelearnmethod",
                        blank=True,
                        to="pokemon_v2.MoveLearnMethod",
                        null=True,
                    ),
                ),
                (
                    "version_group",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="versiongroupmovelearnmethod",
                        blank=True,
                        to="pokemon_v2.VersionGroup",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="ItemAttributeDescription",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("description", models.CharField(default="", max_length=1000)),
                (
                    "item_attribute",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="itemattributedescription",
                        blank=True,
                        to="pokemon_v2.ItemAttribute",
                        null=True,
                    ),
                ),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="itemattributedescription_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="ItemAttributeMap",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                (
                    "item",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="itemattributemap",
                        blank=True,
                        to="pokemon_v2.Item",
                        null=True,
                    ),
                ),
                (
                    "item_attribute",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="itemattributemap",
                        blank=True,
                        to="pokemon_v2.ItemAttribute",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.AddField(
            model_name="berry",
            name="name",
            field=models.CharField(default="name", max_length=100),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="languagename",
            name="local_language",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="locallanguage",
                blank=True,
                to="pokemon_v2.Language",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="naturepokeathlonstat",
            name="nature",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="naturepokeathlonstat",
                blank=True,
                to="pokemon_v2.Nature",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.CreateModel(
            name="ItemAttributeName",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                (
                    "item_attribute",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="itemattributename",
                        blank=True,
                        to="pokemon_v2.ItemAttribute",
                        null=True,
                    ),
                ),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="itemattributename_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="MoveAttributeDescription",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("description", models.CharField(default="", max_length=1000)),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="moveattributedescription_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
                (
                    "move_attribute",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.MoveAttribute",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="MoveAttributeMap",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                (
                    "move",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="moveattributemap",
                        blank=True,
                        to="pokemon_v2.Move",
                        null=True,
                    ),
                ),
                (
                    "move_attribute",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.MoveAttribute",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="MoveAttributeName",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="moveattributename_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
                (
                    "move_attribute",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.MoveAttribute",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="MoveDamageClassName",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="movedamageclassname_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
                (
                    "move_damage_class",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="movedamageclassname",
                        blank=True,
                        to="pokemon_v2.MoveDamageClass",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="MoveTargetName",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="movetargetname_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
                (
                    "move_target",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="movetargetname",
                        blank=True,
                        to="pokemon_v2.MoveTarget",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="PokedexName",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="pokedexname_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
                (
                    "pokedex",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="pokedexname",
                        blank=True,
                        to="pokemon_v2.Pokedex",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="MoveLearnMethodDescription",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("description", models.CharField(default="", max_length=1000)),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="movelearnmethoddescription_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
                (
                    "move_learn_method",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="movelearnmethoddescription",
                        blank=True,
                        to="pokemon_v2.MoveLearnMethod",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.AlterField(
            model_name="move",
            name="move_damage_class",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="move",
                blank=True,
                to="pokemon_v2.MoveDamageClass",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="stat",
            name="move_damage_class",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="stat",
                blank=True,
                to="pokemon_v2.MoveDamageClass",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="type",
            name="move_damage_class",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="type",
                blank=True,
                to="pokemon_v2.MoveDamageClass",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="move",
            name="move_target",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="move",
                blank=True,
                to="pokemon_v2.MoveTarget",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.CreateModel(
            name="AbilityChangeEffectText",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("effect", models.CharField(max_length=6000)),
                (
                    "ability_change",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="abilitychangeeffecttext",
                        blank=True,
                        to="pokemon_v2.AbilityChange",
                        null=True,
                    ),
                ),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="abilitychangeeffecttext_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="AbilityEffectText",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("effect", models.CharField(max_length=6000)),
                ("short_effect", models.CharField(max_length=300)),
                (
                    "ability",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="abilityeffecttext",
                        blank=True,
                        to="pokemon_v2.Ability",
                        null=True,
                    ),
                ),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="abilityeffecttext_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="ItemEffectText",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("effect", models.CharField(max_length=6000)),
                ("short_effect", models.CharField(max_length=300)),
                (
                    "item",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="itemeffecttext",
                        blank=True,
                        to="pokemon_v2.Item",
                        null=True,
                    ),
                ),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="itemeffecttext_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="ContestEffectEffectText",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("effect", models.CharField(max_length=6000)),
                (
                    "contest_effect",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="contesteffecteffecttext",
                        blank=True,
                        to="pokemon_v2.ContestEffect",
                        null=True,
                    ),
                ),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="contesteffecteffecttext_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="MoveEffectChangeEffectText",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("effect", models.CharField(max_length=6000)),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="moveeffectchangeeffecttext_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
                (
                    "move_effect_change",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="moveeffectchangeeffecttext",
                        blank=True,
                        to="pokemon_v2.MoveEffectChange",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="MoveEffectEffectText",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("effect", models.CharField(max_length=6000)),
                ("short_effect", models.CharField(max_length=300)),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="moveeffecteffecttext_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
                (
                    "move_effect",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        blank=True,
                        to="pokemon_v2.MoveEffect",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="SuperContestEffectFlavorText",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("flavor_text", models.CharField(max_length=500)),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="supercontesteffectflavortext_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
                (
                    "super_contest_effect",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="supercontesteffectflavortext",
                        blank=True,
                        to="pokemon_v2.SuperContestEffect",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="ContestEffectFlavorText",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("flavor_text", models.CharField(max_length=500)),
                (
                    "contest_effect",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="contesteffectflavortext",
                        blank=True,
                        to="pokemon_v2.ContestEffect",
                        null=True,
                    ),
                ),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="contesteffectflavortext_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.AlterField(
            model_name="characteristic",
            name="stat",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="characteristic",
                blank=True,
                to="pokemon_v2.Stat",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="pokemonspecies",
            name="pokemon_color",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="pokemonspecies",
                blank=True,
                to="pokemon_v2.PokemonColor",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="pokemonspecies",
            name="pokemon_shape",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="pokemonspecies",
                blank=True,
                to="pokemon_v2.PokemonShape",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="pokemonevolution",
            name="location",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="location",
                blank=True,
                to="pokemon_v2.Location",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="pokemonspecies",
            name="pokemon_shape",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                blank=True,
                to="pokemon_v2.PokemonShape",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="naturebattlestylepreference",
            name="move_battle_style",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="naturebattlestylepreference",
                blank=True,
                to="pokemon_v2.MoveBattleStyle",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="abilitychange",
            name="version_group",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="abilitychange",
                blank=True,
                to="pokemon_v2.VersionGroup",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.CreateModel(
            name="BerryFlavorName",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                (
                    "berry_flavor",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="berryflavorname",
                        blank=True,
                        to="pokemon_v2.BerryFlavor",
                        null=True,
                    ),
                ),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="berryflavorname_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.RemoveField(
            model_name="berryflavor",
            name="flavor",
        ),
        migrations.AddField(
            model_name="berryflavor",
            name="name",
            field=models.CharField(default="name", max_length=100),
            preserve_default=False,
        ),
        migrations.CreateModel(
            name="BerryFlavorMap",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                ("potency", models.IntegerField()),
                (
                    "berry",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="berryflavormap",
                        blank=True,
                        to="pokemon_v2.Berry",
                        null=True,
                    ),
                ),
                (
                    "berry_flavor",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="berryflavormap",
                        blank=True,
                        to="pokemon_v2.BerryFlavor",
                        null=True,
                    ),
                ),
            ],
            options={},
            bases=(models.Model,),
        ),
        migrations.CreateModel(
            name="ItemFlingEffectEffectText",
            fields=[
                (
                    "id",
                    models.AutoField(
                        verbose_name="ID",
                        serialize=False,
                        auto_created=True,
                        primary_key=True,
                    ),
                ),
                (
                    "item_fling_effect",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="itemflingeffecteffecttext",
                        blank=True,
                        to="pokemon_v2.ItemFlingEffect",
                        null=True,
                    ),
                ),
                (
                    "language",
                    models.ForeignKey(
                        on_delete=models.CASCADE,
                        related_name="itemflingeffecteffecttext_language",
                        blank=True,
                        to="pokemon_v2.Language",
                        null=True,
                    ),
                ),
                ("effect", models.CharField(max_length=6000)),
            ],
            options={
                "abstract": False,
            },
            bases=(models.Model,),
        ),
        migrations.AlterField(
            model_name="berry",
            name="berry_firmness",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="berry",
                blank=True,
                to="pokemon_v2.BerryFirmness",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="berryflavor",
            name="contest_type",
            field=models.OneToOneField(
                on_delete=models.CASCADE,
                related_name="berryflavor",
                null=True,
                blank=True,
                to="pokemon_v2.ContestType",
            ),
            preserve_default=True,
        ),
        migrations.RemoveField(
            model_name="move",
            name="contest_effect_id",
        ),
        migrations.RemoveField(
            model_name="move",
            name="contest_type_id",
        ),
        migrations.RemoveField(
            model_name="move",
            name="super_contest_effect_id",
        ),
        migrations.AddField(
            model_name="move",
            name="contest_effect",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="move",
                blank=True,
                to="pokemon_v2.ContestEffect",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="move",
            name="contest_type",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="move",
                blank=True,
                to="pokemon_v2.ContestType",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="move",
            name="super_contest_effect",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="move",
                blank=True,
                to="pokemon_v2.SuperContestEffect",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="pokemonspecies",
            name="pokemon_habitat",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="pokemonspecies",
                blank=True,
                to="pokemon_v2.PokemonHabitat",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="pokemonspecies",
            name="pokemon_shape",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="pokemonspecies",
                blank=True,
                to="pokemon_v2.PokemonShape",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="generation",
            name="region",
            field=models.OneToOneField(
                on_delete=models.CASCADE,
                related_name="generation",
                null=True,
                blank=True,
                to="pokemon_v2.Region",
            ),
            preserve_default=True,
        ),
        migrations.AddField(
            model_name="berry",
            name="natural_gift_type",
            field=models.ForeignKey(
                on_delete=models.CASCADE,
                related_name="berry",
                blank=True,
                to="pokemon_v2.Type",
                null=True,
            ),
            preserve_default=True,
        ),
        migrations.AlterField(
            model_name="itemflingeffect",
            name="name",
            field=models.CharField(max_length=100),
            preserve_default=True,
        ),
    ]
