# Contribute

All contributions are welcome: bug fixes, data contributions, recommendations.

Please see the [issues on GitHub](https://github.com/PokeAPI/pokeapi/issues) before you submit a pull request or raise an issue, someone else might have beat you to it.

To contribute to this repository:

- [Fork the project to your own GitHub profile](https://help.github.com/articles/fork-a-repo/)

- Download the project using git clone:
```
git clone git@github.com:<YOUR_USERNAME>/pokeapi.git
```
- Create a new branch with a descriptive name:
```
git checkout -b my_new_branch
```
- Write some code, fix something, and add a test to prove that it works. **No pull request will be accepted without tests passing, or without new tests if new features are added.**

- Commit your code and push it to GitHub

- [Open a new pull request](https://help.github.com/articles/creating-a-pull-request/) and describe the changes you have made.

- We'll accept your changes after review.

Simple!

## Financial contributions

We also welcome financial contributions in full transparency on our [open collective](https://opencollective.com/pokeapi).
Anyone can file an expense. If the expense makes sense for the development of the community, it will be "merged" in the ledger of our open collective by the core contributors and the person who filed the expense will be reimbursed.

## Questions

If you have any questions, create an [issue](issue) (protip: do a quick search first to see if someone else didn't ask the same question before!).
You can also reach us at hello@pokeapi.opencollective.com.

## Credits

### Contributors

Thank you to all the people who have already contributed to pokeapi!
<a href="graphs/contributors"><img src="https://opencollective.com/pokeapi/contributors.svg?width=890" /></a>


### Backers

Thank you to all our backers! [[Become a backer](https://opencollective.com/pokeapi#backer)]

<a href="https://opencollective.com/pokeapi#backers" target="_blank"><img src="https://opencollective.com/pokeapi/backers.svg?width=890"></a>


### Sponsors

Thank you to all our sponsors! (please ask your company to also support this open source project by [becoming a sponsor](https://opencollective.com/pokeapi#sponsor))

<a href="https://opencollective.com/pokeapi/sponsor/0/website" target="_blank"><img src="https://opencollective.com/pokeapi/sponsor/0/avatar.svg"></a>
<a href="https://opencollective.com/pokeapi/sponsor/1/website" target="_blank"><img src="https://opencollective.com/pokeapi/sponsor/1/avatar.svg"></a>
<a href="https://opencollective.com/pokeapi/sponsor/2/website" target="_blank"><img src="https://opencollective.com/pokeapi/sponsor/2/avatar.svg"></a>
<a href="https://opencollective.com/pokeapi/sponsor/3/website" target="_blank"><img src="https://opencollective.com/pokeapi/sponsor/3/avatar.svg"></a>
<a href="https://opencollective.com/pokeapi/sponsor/4/website" target="_blank"><img src="https://opencollective.com/pokeapi/sponsor/4/avatar.svg"></a>
<a href="https://opencollective.com/pokeapi/sponsor/5/website" target="_blank"><img src="https://opencollective.com/pokeapi/sponsor/5/avatar.svg"></a>
<a href="https://opencollective.com/pokeapi/sponsor/6/website" target="_blank"><img src="https://opencollective.com/pokeapi/sponsor/6/avatar.svg"></a>
<a href="https://opencollective.com/pokeapi/sponsor/7/website" target="_blank"><img src="https://opencollective.com/pokeapi/sponsor/7/avatar.svg"></a>
<a href="https://opencollective.com/pokeapi/sponsor/8/website" target="_blank"><img src="https://opencollective.com/pokeapi/sponsor/8/avatar.svg"></a>
<a href="https://opencollective.com/pokeapi/sponsor/9/website" target="_blank"><img src="https://opencollective.com/pokeapi/sponsor/9/avatar.svg"></a>

<!-- This `CONTRIBUTING.md` is based on @nayafia's template https://github.com/nayafia/contributing-template -->
