import React from 'react';
import {Root, Routes, useSiteData, Head} from 'react-static';
import {Route as ReactRouterRoute} from 'react-router-dom';
import 'sanitize.css';

import './global.scss';

import logo from './images/pokeapi_256.png';
import Alert from './components/Alert';
import Header from './components/Header';
import Footer from './components/Footer';

export default function AppLoader() {
    return (
        <React.Suspense fallback={<p>Loading...</p>}>
            <App />
        </React.Suspense>
    );
}

function App() {
    const {alerts} = useSiteData();

    return (
        <Root>
            <Head>
                <script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-9300109033485921" crossorigin="anonymous"></script>                
                <script async src="https://www.googletagmanager.com/gtag/js?id=G-X3X3FV0WED"></script>
                <script>
                {
                    `window.dataLayer = window.dataLayer || [];
                    function gtag() {
                        dataLayer.push(arguments)
                    }
                    gtag('js', new Date());
                    gtag('config', 'G-X3X3FV0WED');`
                }
                </script>

                <html lang="en" />
                <title>PokéAPI</title>
                <link
                    rel="stylesheet"
                    href="https://fonts.googleapis.com/css?family=Lato:400,700"
                />
                <meta property="og:type" content="website" />
                <meta name="Description" content="An open RESTful API for Pokémon data"></meta>
                <meta
                    property="keywords"
                    content="pokemon pokémon API REST free"
                />
                <meta property="og:image" content={logo} />
                <meta
                    property="description"
                    content="An open RESTful API for Pokémon data"
                />
                <link rel="icon" href="/pokeapi_192_square.png" />
            </Head>

            <Header id="site-header" />

            {alerts.map(alert => (
                <Alert key={alert.id} {...alert} />
            ))}

            <main id="site-content">
                <React.Suspense fallback={<p>Loading...</p>}>
                    <ReactRouterRoute render={() => <Routes />} />
                </React.Suspense>
            </main>

            <Footer id="site-footer" />
        </Root>
    );
}
