# PaddleNLP Examples

PaddleNLP旨在提供覆盖从研究到产业应用的丰富示例，助力开发者加速文本任务开发效率。

PaddleNLP provides rich application examples covering mainstream NLP task to help developers accelerate problem solving.

## NLP 基础技术 (NLP Basic Technique)

| 目录 Folder  | 任务 Task    |
| :--------------- | ------- |
| word_embedding | [词向量 (Word Embedding)](./word_embedding/) |
| lexical_analysis | [词法分析 (Lexical Analysis)](./lexical_analysis/) |
| dependency_parsing | [句法依存分析 (Dependency Parsing)](./dependency_parsing/) |
| language_model | [预训练语言模型 (Pretrained Language Model)](./language_model/) |
| text_to_sql | [语义解析 (Semantic Parsing/Text to SQL)](./text_to_sql):star: |
| text_classification | [文本分类 (Text Classification)](./text_classification/) |
| text_matching | [文本匹配 (Text Matching)](./text_matching/) |
| text_generation | [文本生成 (Text Generation)](./text_generation/) |
| text_summarization | [文本摘要 (Text Summarization)](./text_summarization/) |
| text_correction  |[文本纠错 (Text Correction)](./text_correction/):star: |
| semantic_indexing | [语义索引 (Semantic Indexing)](./semantic_indexing/)|
| information_extraction | [信息抽取 (Information Extraction)](./information_extraction/) |
| question_generation | [问题生成 (Question Generation)](./question_generation/) |

## NLP 系统应用 (NLP System Applications)

| 目录 Folder  | 任务 Task    |
| :--------------- | ------- |
| sentiment_analysis|[情感分析 (Sentiment Analysis)](./sentiment_analysis/):star2: |
| dialogue |[通用对话 (General Dialogue System)](./dialogue/) |
| machine_translation |[文本翻译 (Machine Translation)](./machine_translation/) |
| simultaneous_translation|[同声翻译 (Simultaneous Translation)](./simultaneous_translation/) |
| machine_reading_comprehension | [阅读理解 (Machine Reading Comprehension)](./machine_reading_comprehension/) |

## NLP 拓展应用 (NLP Extented Applications)

| 目录 Folder  | 任务 Task    |
| :--------------- | ------- |
| few_shot |[小样本学习 (Few-shot Learning)](./few_shot/):star2: |
| text_to_knowledge |[解语知识关联框架 (Text Knowledge Mining)](./text_to_knowledge/):star2: |
| model_compression |[模型压缩 (Model Compression）](./model_compression/) |
| text_graph |[文本图学习 (Text Graph Learning)](./text_graph/erniesage/) |
| time_series |[时间序列预测 (Time Series Prediction)](./time_series/) |
