# Mastering Delphi [Video]
This is the code repository for [Mastering Delphi [Video]](https://www.packtpub.com/application-development/mastering-delphi-video?utm_source=github&utm_medium=repository&utm_campaign=9781788624312), published by [Packt](https://www.packtpub.com/?utm_source=github). It contains all the supporting project files necessary to work through the video course from start to finish.
## About the Video Course
Delphi is a cross-platform Integrated Development Environment (IDE) that supports rapid application development for Microsoft Windows, Apple MacOS X, Google Android, iOS, and now Linux. This course will be your guide to building efficient, high-performance applications with Delphi.
The video begins by explaining the fundamentals of Delphi programming. It will teach you how to improve your development skills and GUI programming with FireMonkey. After that, you'll delve into web development with Intraweb and uniGUI. Finally, we'll integrate with cloud services and interact with IoT.
Towards the end, you will learn to integrate your app with various web services and deploy them. By the end of the video, you will be able to build powerful, cross-platform, native apps for Windows and Android with a single code base. You will also have enormous experience with Full Stack Development.

<H2>What You Will Learn</H2>
<DIV class=book-info-will-learn-text>
<UL>
<LI>Learn the fundamentals of the Delphi programming language 
<LI>Write VCL Applications – Windows Development 
<LI>Start making amazing apps with FireMonkey – Cross-Platform Development 
<LI>Work with data sources, embedded SQL Databases – FireDAC, dbExpress 
<LI>Become a front-end engineer via Web Development using IntraWeb and uniGUI 
<LI>Become a backend engineer by integrating with cloud services 
<LI>Build server-side data and application services with DataSnap 
<LI>Start learning future technologies with Delphi and IoT </LI></UL></DIV>

## Instructions and Navigation
### Assumed Knowledge
To fully benefit from the coverage included in this course, you will need:<br/>
<LI>Delphi Berlin or newer version
<LI>Delphi programming basics
<LI>Basics of Delphi IDE
### Technical Requirements
This course has the following software requirements:<br/>
For an optimal experience with hands-on labs and other practical activities, we recommend the following configuration:

●        Processor: 1.6 GHz or faster processor.

●        Memory: 4GB of RAM.

●        Storage: 10GB and 60GB available of disk space

●        DirectX 11 capable video card that runs at 1024x768 or higher resolution.

Software Requirements

●      Operating system: Windows 10, 8 and 8.1, 7

 

●     .NET Framework 3.5 Installed

●      Java Runtime Environment Installed

## Related Products
* [Working with Delphi [Video]](https://www.packtpub.com/application-development/working-delphi-video?utm_source=github&utm_medium=repository&utm_campaign=9781788621090)

* [Delphi Solutions - Part 1 [Video] ](https://www.packtpub.com/application-development/delphi-solutions-part-1-video?utm_source=github&utm_medium=repository&utm_campaign=9781787288652)

* [Delphi Solutions - Part 2 [Video]](https://www.packtpub.com/application-development/delphi-solutions-part-2-video?utm_source=github&utm_medium=repository&utm_campaign=9781788299206)

