/*
 * Decompiled with CFR 0.152.
 */
package component.view;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Hashtable;
import navigation.Navigation;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;

public class DiagramNavigation
extends Applet {
    private JSObject appletWindow;
    private Hashtable images = new Hashtable();
    private Image myImage = null;
    private int myWidth = 0;
    private int myHeight = 0;
    private int maxWidth = 1;
    private int maxHeight = 1;
    private int imgW = 0;
    private int imgH = 0;
    private double rate = 1.0;
    private int xs = 0;
    private int ys = 0;
    private Rectangle spotRect = new Rectangle();
    private Point dragPoint = new Point();
    private boolean onSpot = false;
    private boolean isDragged = false;

    public void init() {
        this.setBackground(Color.white);
        try {
            this.appletWindow = JSObject.getWindow((Applet)this);
        }
        catch (JSException jSException) {
            jSException.printStackTrace();
        }
        this.maxWidth = this.getSize().width - 2;
        this.maxHeight = this.getSize().height - 2;
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (DiagramNavigation.this.onSpot) {
                    DiagramNavigation.this.dragPoint = mouseEvent.getPoint();
                    DiagramNavigation.this.xs = ((DiagramNavigation)DiagramNavigation.this).dragPoint.x - ((DiagramNavigation)DiagramNavigation.this).spotRect.x;
                    DiagramNavigation.this.ys = ((DiagramNavigation)DiagramNavigation.this).dragPoint.y - ((DiagramNavigation)DiagramNavigation.this).spotRect.y;
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                DiagramNavigation.this.isDragged = false;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                if (DiagramNavigation.this.spotRect.contains(mouseEvent.getPoint())) {
                    DiagramNavigation.this.setCursor(new Cursor(13));
                    DiagramNavigation.this.onSpot = true;
                } else {
                    DiagramNavigation.this.setCursor(new Cursor(0));
                    DiagramNavigation.this.onSpot = false;
                }
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                if (DiagramNavigation.this.onSpot) {
                    DiagramNavigation.this.isDragged = true;
                    Graphics graphics = DiagramNavigation.this.getGraphics();
                    graphics.setXORMode(Color.white);
                    DiagramNavigation.this.drawSpot(graphics);
                    DiagramNavigation.this.dragPoint = mouseEvent.getPoint();
                    DiagramNavigation.this.setSpotLocation(mouseEvent.getX() - DiagramNavigation.this.xs, mouseEvent.getY() - DiagramNavigation.this.ys);
                    DiagramNavigation.this.drawSpot(graphics);
                    graphics.dispose();
                    try {
                        if (DiagramNavigation.this.appletWindow != null) {
                            DiagramNavigation.this.appletWindow.eval("parent.imageFrame.scroll(" + String.valueOf((double)Math.round((double)((DiagramNavigation)DiagramNavigation.this).spotRect.x - 1.0) * DiagramNavigation.this.rate) + ", " + String.valueOf((double)Math.round((double)((DiagramNavigation)DiagramNavigation.this).spotRect.y - 1.0) * DiagramNavigation.this.rate) + ")");
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        try {
            this.appletWindow.eval("parent.imageFrame.loadImage()");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void paint(Graphics graphics) {
        graphics.setPaintMode();
        if (this.myImage != null) {
            graphics.drawImage(this.myImage, 1, 1, this.myWidth, this.myHeight, this);
        }
        this.drawSpot(graphics);
        graphics.setColor(Color.blue);
        graphics.drawRect(0, 0, this.myWidth + 2, this.myHeight + 2);
    }

    private void drawSpot(Graphics graphics) {
        graphics.setXORMode(Color.white);
        graphics.setColor(Color.black);
        graphics.fillRect(this.spotRect.x, this.spotRect.y, this.spotRect.width, this.spotRect.height);
    }

    public void loadView(String string, int n, int n2) {
        if (this.images.containsKey(string)) {
            ImageInfo imageInfo = (ImageInfo)this.images.get(string);
            this.myImage = imageInfo.getImage();
            this.myWidth = imageInfo.getWidth();
            this.myHeight = imageInfo.getHeight();
            this.rate = imageInfo.getRate();
            this.imgW = imageInfo.getImageWidth();
            this.imgH = imageInfo.getImageHeight();
        } else {
            Image image = this.getImage(Navigation.fixUrlForOpera(this.getDocumentBase()), string);
            if (image == null) {
                return;
            }
            try {
                double d;
                this.imgW = n;
                this.imgH = n2;
                double d2 = (double)this.imgW / (double)this.maxWidth;
                if (d2 < 1.0) {
                    d2 = 1.0;
                }
                if ((d = (double)this.imgH / (double)this.maxHeight) < 1.0) {
                    d = 1.0;
                }
                this.rate = Math.max(d2, d);
                this.myHeight = (int)Math.round((double)this.imgH / this.rate) - 1;
                this.myWidth = (int)Math.round((double)this.imgW / this.rate) - 1;
                this.myImage = image.getScaledInstance(this.myWidth, this.myHeight, 4);
                image.flush();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                outOfMemoryError.printStackTrace();
            }
            if (this.myHeight > 1 && this.myWidth > 1) {
                ImageInfo imageInfo = new ImageInfo(this.myImage, this.myWidth, this.myHeight, this.rate, this.imgW, this.imgH);
                this.images.put(string, imageInfo);
            }
        }
    }

    public void setSpotSize(int n, int n2) {
        double d = (double)this.imgW / (double)n;
        double d2 = (double)this.imgH / (double)n2;
        int n3 = (int)Math.round((double)this.myWidth / d);
        int n4 = (int)Math.round((double)this.myHeight / d2);
        n3 = Math.min(n3, this.myWidth);
        n4 = Math.min(n4, this.myHeight);
        if (n3 <= 1) {
            n3 = 1;
        }
        if (n4 <= 1) {
            n4 = 1;
        }
        this.spotRect.setSize(n3, n4);
        int n5 = this.myWidth + 2 - this.spotRect.x - this.spotRect.width;
        int n6 = this.myHeight + 2 - this.spotRect.y - this.spotRect.height;
        if (n5 >= 0) {
            n5 = 0;
        }
        if (n6 >= 0) {
            n6 = 0;
        }
        if (n5 < 0 || n6 < 0) {
            this.moveSpotRelative(n5, n6);
        }
    }

    public void moveSpot(int n, int n2) {
        if (!this.isDragged) {
            Graphics graphics = this.getGraphics();
            graphics.setXORMode(Color.white);
            this.drawSpot(graphics);
            int n3 = (int)Math.round((double)n / this.rate) + 1;
            int n4 = (int)Math.round((double)n2 / this.rate) + 1;
            this.setSpotLocation(n3, n4);
            this.drawSpot(graphics);
            graphics.dispose();
        }
    }

    private void moveSpotRelative(int n, int n2) {
        if (!this.isDragged) {
            Graphics graphics = this.getGraphics();
            graphics.setXORMode(Color.white);
            this.drawSpot(graphics);
            int n3 = this.spotRect.x + n;
            int n4 = this.spotRect.y + n2;
            this.setSpotLocation(n3, n4);
            this.drawSpot(graphics);
            graphics.dispose();
        }
    }

    private void setSpotLocation(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        if (n < 1) {
            n3 = 1;
        } else if (n + this.spotRect.width > this.myWidth + 2) {
            n3 = this.myWidth + 2 - this.spotRect.width;
        }
        if (n2 < 1) {
            n4 = 1;
        } else if (n2 + this.spotRect.height > this.myHeight + 2) {
            n4 = this.myHeight + 2 - this.spotRect.height;
        }
        this.spotRect.setLocation(n3, n4);
    }

    private class ImageInfo {
        private int width = 0;
        private int height = 0;
        private int imgW = 0;
        private int imgH = 0;
        private Image image = null;
        private double rate = 1.0;

        int getWidth() {
            return this.width;
        }

        int getHeight() {
            return this.height;
        }

        double getRate() {
            return this.rate;
        }

        Image getImage() {
            return this.image;
        }

        int getImageWidth() {
            return this.imgW;
        }

        int getImageHeight() {
            return this.imgH;
        }

        ImageInfo(Image image, int n, int n2, double d, int n3, int n4) {
            this.image = image;
            this.width = n;
            this.height = n2;
            this.rate = d;
            this.imgW = n3;
            this.imgH = n4;
        }
    }
}

