import frontend from './frontend';
import backend from './backend';
import fullstack from './fullstack';
import css from './css';
import go from './go';
import android from './android';
import php from './php';
import ruby from './ruby';
import python from './python';
import ios from './ios';
import nodejs from './nodejs';
import reactjs from './reactjs';
import vue from './vue';
import javascript from './javascript';
import java from './java';
import html from './html';
import angular from './angular';
import mobile from './mobile';
import desktop from './desktop';
import devops from './devops';
import machineLearning from './machineLearning';
import augmentedReality from './augmentedReality';
import virtualReality from './virtualReality';
import artificialIntelligence from './artificialIntelligence';
import webScraping from './webScraping';
import csharp from './csharp';
import elixir from './elixir';
import scala from './scala';
import gameDeveloper from './gameDeveloper';
import kotlin from './kotlin';

const RoadMap = {
	fullstack,
	css,
	go,
	html,
	javascript,
	mobile,
	ruby,
	csharp,
	elixir,
	python,
	scala,
	kotlin,
	vue,
	desktop,
	ios,
	php,
	java,
	android,
	angular,
	reactjs,
	nodejs,
	devops,
	'front-end': frontend,
	'back-end': backend,
	'machine-learning': machineLearning,
	'artificial-intelligence': artificialIntelligence,
	'augmented-reality': augmentedReality,
	'virtual-reality': virtualReality,
	'web-scraping': webScraping,
	'game-developer': gameDeveloper
};
export default RoadMap;
