import Vue from 'vue';
import Vuex from 'vuex';

Vue.use(Vuex);

export default new Vuex.Store({
  state: {
    activities: [],
    errorMessage: '',
  },
  mutations: {
    LOAD_DATA(state, activities) {
      state.activities = activities;
    },

    addActivity(state, activity) {
      state.activities.push(activity);
      localStorage.setItem('activities', JSON.stringify(state.activities));
    },

    deleteActivity(state, activity) {
      state.activities = state.activities.filter((val) => val.id !== activity.id);
      localStorage.setItem('activities', JSON.stringify(state.activities));
    },

    changeActivityState(state, activity) {
      state.activities.map((val) => {
        if (val.id === activity.id) {
          const aux = !val.completed;
          val.completed = aux;
        }

        return val;
      });

      localStorage.setItem('activities', JSON.stringify(state.activities));
    },

    setErrorMessage(state, message) {
      state.errorMessage = message;
    },
  },
  actions: {
    addActivity({ commit }, { activity }) {
      commit('addActivity', activity);
    },
    deleteActivity({ commit }, { activity }) {
      commit('deleteActivity', activity);
    },
    changeActivityState({ commit }, { activity }) {
      commit('changeActivityState', activity);
    },
    setErrorMessageAction({ commit }, { message }) {
      commit('setErrorMessage', message);
    },
    initData({ commit }) {
      const activities = JSON.parse(localStorage.getItem('activities'));
      if (activities && activities.length > 0) {
        commit('LOAD_DATA', activities);
      }
    },
  },
});
