module.exports = {
  head: {
    title: process.env.npm_package_name || '',
    meta: [
      { charset: 'utf-8' },
      { name: 'viewport', content: 'width=device-width, initial-scale=1' },
      { hid: 'description', name: 'description', content: process.env.npm_package_description || '' }
    ],
    link: [
      { rel: 'icon', type: 'image/x-icon', href: '/icon.png' },
      {
        rel: 'stylesheet',
        href: 'https://cdn.bootcss.com/material-design-icons/3.0.1/iconfont/material-icons.css'
      }
    ]
  },
  loading: { color: '#409EFF' },
  css: [
    '@/assets/css/main.css',
    'element-ui/lib/theme-chalk/index.css'
  ],
  plugins: [
    '@/plugins/element-ui.js',
    '@/plugins/muse-ui.js',
    '@/plugins/filters.js'
  ],
  buildModules: [
    '@nuxtjs/eslint-module'
  ],
  modules: [
    '@nuxtjs/axios',
    '@nuxtjs/proxy',
    '@nuxtjs/pwa'
  ],
  router: {
    middleware: 'redirect'
  },
  axios: {
    proxy: true
  },
  proxy: {
    '/api': {
      target: 'https://www.v2ex.com'
    }
  },
  build: {
    transpile: [/^element-ui/]
  }
}
