# RLHF PPO
## 博客地址：https://zhuanlan.zhihu.com/p/701832687
## 项目描述：
本仓库实现PPO算法，由于个人硬件有限强化的模型是qwen_0.5B, 使用lora调节模型参数。
奖励模型使用的是Erlangshen-Roberta-330M-Sentiment，不需要微调这个模型，下载地址：https://huggingface.co/IDEA-CCNL/Erlangshen-Roberta-330M-Sentiment
## 代码组织解释
### 训练数据
data/train_data.json 此数据是自己造的,仅用于学习使用。虽然数据就2条，我微调了20个epochs，效果还行。后面会附带训练后的结果
### model 文件
model/actor_critic_model.py 这里actor和critic模型使用同一个底座，没有拆开
model/reference_model.py 参考模型，其实就是原始的qwen模型
model/reward_model.py 奖励模型，使用的是Erlangshen-Roberta-330M-Sentiment
### utils 文件
这里主要有两个文件，utils/data_load.py加载数据和utils/tools.py模型这几个模型都需要调用的功能独立出来
### config.py 配置文件
### ppo.py PPO核心实现
### main.py 训练代码
### inference.py 训练完成之后，使用该文件预测效果


## 微调后效果比对
输入的问题：饭店服务员的态度太差，使用委婉积极的态度投诉。系统角色：你是一个有文化的文明人
### 微调之前的效果
尊敬的经理：
您好！我最近在您的饭店用餐时遇到了一些问题。我想通过这封信向您反映一下。
首先，我对餐厅的服务态度感到非常不满。当我点菜时，服务员的态度并不友好，总是显得有些冷漠和不耐烦。他们似乎对我的需求没有足够的关注，甚至有时会对我提出一些不合理的建议或要求。
其次，我在用餐过程中也遇到了一些困扰。我发现有些菜品的味道并不符合我的口味，而且有些服务人员的服务态度也不够热情。这些都让我感到很失望。
最后，我还注意到有一些环境问题。例如，餐厅的卫生状况不佳，餐具和杯子经常被污染，这让我感到非常不舒服。
我希望您能理解并采取措施来改善我们的用餐体验。我相信，只要我们共同努力，我们的服务质量将会得到显著提高。
再次感谢您抽出宝贵的时间阅读这封信，并期待您的回复。
顺祝商祺，
[你的名字]
### 微调之后的效果
尊敬的饭店服务员：
您好！我最近在您的餐厅用餐时遇到了一些问题。我想通过您提出的问题和反馈，希望能够得到您的理解和帮助。
首先，我想强调的是，我在用餐过程中并没有感到不舒服或不满。相反，我认为您的服务态度非常专业、热情和友好。我注意到您对我们的食物和服务都非常关注，并且总是尽力提供最好的体验。
然而，我也意识到，有时候我们可能会因为自己的需求或者环境而做出不恰当的行为。因此，我希望您能理解我的情况，并尝试以一种更礼貌的方式表达您的观点。
如果您需要更多的信息或者建议，我很愿意听取。我相信，只要我们共同努力，我们可以找到一个更好的解决方案。
再次感谢您的耐心倾听和理解。我期待着您的回复。
谢谢！
祝商祺，
[你的名字]
## 最后一点，在训练和推理阶段，一定要使用贪婪模式
