# Expose package vulnerability information in the Package Manager UI - Technical Spec

- Author(s): [Jean-Pierre Briedé](https://github.com/jebriede)
- Issue: [10981](https://github.com/NuGet/Home/issues/10981) Expose package vulnerabilities information in the PMUI
- Type: Feature
- Status: Implemented

## Problem Background

Developers that install NuGet packages through Visual Studio may be installing packages that have known vulnerabilities or they may have a project that is depending on a vulnerable version of a NuGet package. There is currently no information in the Package Manager UI that indicates that a package version is vulnerable so developers may continue to use a vulnerable package in their project. Users should be able to see a warning about a package version they are browsing or one they have installed so they can be informed of the vulnerability and hopefully update to a different version of the package that is not vulnerable or use a different package.

## Who are the customers

* All users that install a NuGet packages using the Package Manager in Visual Studio.
* All users that manage their installed NuGet packages using the Package Manager in Visual Studio.

## Requirements

* A warning icon will be shown in the Installed tab and in the package list if the project has any vulnerable packages installed. These icons will be the same ones that are used when deprecated packages are installed. In the case where a package version is both vulnerable and deprecated, only one icon will still be shown, but the tooltip on the icon will reflect the vulnerability and deprecation.
* Maintain the functionality of the deprecated warning icon in the package list as well as the installed tab. The icon will be used to indicate vulnerabilities, but will need to still indicate deprecated packages.
* There can be one or more vulnerabilities for a package version so the details pane will need to be able to display a list of vulnerabilities, the severity levels, and the advisory links for each.
* When multiple package sources have the same package and All package sources is selected, the vulnerability data will need to be merged to ensure vulnerability information is shown for a package if any of the packages sources provides vulnerability information for the given package.

## Goals

* Show the existing warning icon, used for deprecation, in the Installed tab with a tooltip that indicates how many vulnerable packages are installed.
* Show the existing warning icon, used for deprecation, next to the package version of a vulnerable package in the package list.
* Show detailed information about the package vulnerabilities in the package details pane when the user clicks on a package.
* Track via telemetry when an action (installed, update, uninstall) is performed on a package with a vulnerability from within the Package Manager UI.

## Non-Goals

* Improve the performance of querying package vulnerability information. Changing how vulnerability data is queried is being tracked by a separate effort: https://github.com/NuGet/Home/issues/10865
* Change the architecture of the PMUI to not require querying information for the Installed tab to know if there is a deprecated package or vulnerability for the warning icon, and once again for the packages list. The existing architecture of the PMUI will be used and existing patterns will be followed.
* Change the way packages in the Browse and Updates tabs lists represent the latest package version and its metadata, including deprecation and vulnerability information.
* Make any improvements to the package deprecation experience.
* Change the registration API to pull in more details about a package vulnerability. This will be considered in a future iteration.
* Show a warning icon in the Solution Explorer when packages with vulnerabilities are installed. This will be considered in a future iteration.

## Solution

A list of vulnerabilities for a package is read from the server, along with other data, whenever a package version is selected (`DetailControlModel.SetCurrentPackageAsync`) or when the selection version changes (`DetailControlModel.SelectedVersionChangedAsync`). This data is stored in the `DetailedPackageMetadata` and is used by the Details Pane. The vulnerabilities information exposed in the `PackageSolutionDetailControlModel` which implements `DetailControlModel` is currently limited to whether a vulnerability exists and what the maximum severity of the vulnerability is. This will be changed to expose instead a list of vulnerabilities, their severity, and their advisory links.

The Details Pane will have a new section in the view called "Vulnerabilities" that will be visible when a package has one or more vulnerabilities, otherwise will have a visibility value of `Collapsed`. The Vulnerabilities section will display the highest severity of the vulnerabilities and show a list of vulnerabilities, their severity, and a link to the advisory. To stay consistent with the current design of the details pane, the vulnerabilities section will be created as its own UserControl that will be used by the DetailControl.

The `PackageManagerTopPanel` will be modified to handle showing a warning icon when there are either deprecated or vulnerable packages, or both. A new method will be added to this class to handle getting the count of the vulnerable packages installed which will be used in the tooltip and also to determine whether or not to show the warning icon for vulnerabilities.

The `PackageItemViewModel` will have a new method to query the Vulnerability status of a given package asynchronously, much like it currently reads package deprecation status. This information will be used, along with the deprecation status, to determine if the warning icon should appear by the package in the package list. The tooltip for the icon will be updated to display information about the vulnerabilities and/or deprecated packages.

The `NuGetPackageSearchService` will be updated to query the Vulnerability information for a given package so it can be used to by the `PackageItemViewModel` to know about vulnerabilities. Some code may need to be refactored here so the deprecation data and the vulnerability data is pulled in by the same query as package metadata and then separated into deprecation and vulnerability data by the caller rather than duplicating the call to the service for each chunk of data.

## Considerations

* Combined vulnerability and deprecation information will be shown in all warning icon tooltips, when applicable.