
# PMUI Display vulnerability information in the package graph

* Status: [In Review] / Reviewed / Implementing / Implemented
* Author(s): [drewgillies](https://github.com/drewgillies)
* Issues: 
[1](https://github.com/NuGet/Home/issues/9850) Surface basic vulnerability metadata in PM UI view models
[2](https://github.com/NuGet/Home/issues/8755) Display vulnerability info on Installed tab of PMUI

## Problem Background

The [Flag Vulnerable Packages spec](https://github.com/NuGet/Home/wiki/Flag-vulnerable-packages) covers a number of MVP initiatives of which this is one. The problem being solved is feature parity with existing package services (npm) couples with a need to service our customers' security needs.

## Who are the customers

All publishers of NuGet.org packages, all consumers of NuGet.org packages.

## Goals

When a customer browses their installed packages in the PMUI, the MVP is for them to see notifications on their installed tab for vulnerable packages. 

## Non-Goals

Notifications on the Browse tab
Restore warnings

## Solution

The package vulnerability data is now available in registration metadata, alongside data for deprecations which is currently in use.

The plan is the extend the design used for surfacing deprecation notifications in the past, to also include vulnerability information. This includes models, view models and views. The work is likely to be very similar in all areas. The strengths of this approach are a reasonably fast time to market, and low risk.

## Future Work

Next steps are also to show transitive vulnerabilities, and beyond that we can continue to extend functionality into the Browse tab and other locations as customer engagement and general strategy determines.

## Open Questions

There is an open question on the design employed by deprecations, which is well described in the thread on [this PR](https://github.com/NuGet/NuGet.Client/pull/3540), and the main points are:
- a data model should be properties only, not properties and async fetch methods
- this approach is opaque and could be a lot cleaner
- there are performance concerns in the case where a user has disabled http caching because of repeated calls to NuGet.Protocol
These are critiques of the design employed by the deprecation work (also pre-existing it) and this work extends that design.

## Considerations

An approach consistent with answering the above concern is under consideration but is likely to be rejected at this stage due to:
- the work amounts to large refactoring in the codebase--cost and risk 
- it will mean a subtractive and therefore breaking change to the public API on existing functionality, and if existing APIs are preserved and added to only, the original design is largely preserved as well
- it may be worth returning to this question and refactoring the client codebase in favor of a deprecation approach to the outgoing APIs at some stage, but this is likely to delay the feature work beyond that which is desired

### References

[Epic](https://github.com/NuGet/Home/issues/8087)
[UX spec](https://www.figma.com/file/8gCQx9iAQfPXTtxoks6Qd7/%F0%9F%9B%A1%EF%B8%8F-NuGet-Vulnerable-Packages----Maryanne)
