# NuGet.org Vulnerabilities - Phase 1:

* Status: Reviewed
* Author(s): [Jon Douglas](https://github.com/JonDouglas)
* Issue: [7650](https://github.com/NuGet/Home/issues/7650)

## Package Details Page

NuGet.org should show a banner on a package with regards to the vulnerability and these 5 details:
1. The Advisory Title
2. The Affected Package Name
3. The Severity of the Vulnerability
4. The Date of the Advisory
5. The Status of the Advisory

...or with a link to the advisory URL either on nuget.org/advisories or directly to github.com/advisories:

![](../../resources//PackageVulnerability/NuGet.orgVulnerabilitiesPhase1/DetailViewBanner.png)

The banner for package vulnerability will only show the specific version of the package. If the package contains the current version that is affected by the advisory, it will display the banner as well.

When an author who is signed in views their package, they will see a different banner on what actions they should take:

![](../../resources//PackageVulnerability/NuGet.orgVulnerabilitiesPhase1/DetailViewAuthorBanner.png)

In the event that the package version contains multiple vulnerabilities, the same banner will remain, however the “learn more” link will turn into individual links for each CVE listed against the package version.

A package author might be able to see that a package they manage is vulnerable with a severity & instructions on what courses of action they might take via a documentation piece.

![](../../resources//PackageVulnerability/NuGet.orgVulnerabilitiesPhase1/ManagePackagesViewIcon.png)

Like the author screen, any version with a vulnerability will show an icon indicating the vulnerability for users to see at a glance.

![](../../resources//PackageVulnerability/NuGet.orgVulnerabilitiesPhase1/VersionListIcon.png)

## Goals and Non-Goals
### Goals
- Reduce exposure to discovered vulnerabilities within packages & dependencies.
- Increase adoption of fixed upstream packages & dependencies.
- Increase awareness of the importance of package quality & best practices for authoring packages to reduce potential for vulnerabilities.
	- Semantic Versioning
	- Encouraging frequent package updatesPhase 1 Spec:
	- Better usage of dependency constraints
	- Improved versioning & security policies
- An output format that has a standard format for third-party monitoring tools to import.
### Non-Goals
- Creation of insourced vulnerability dataset / system.
- Required actions to take on vulnerabilities.

## Alternatives Considered
- https://ossindex.sonatype.org/

## Cross-cutting Concerns
### Policy
NuGet currently has three policy documents:
- https://docs.microsoft.com/en-us/nuget/policies/governance
- https://docs.microsoft.com/en-us/nuget/policies/ecosystem
- https://docs.microsoft.com/en-us/nuget/nuget-org/policies/data-requests

NuGet.org currently has four policy documents:
- https://docs.microsoft.com/en-us/nuget/nuget-org/policies/data-requests
- https://docs.microsoft.com/en-us/nuget/nuget-org/policies/dispute-resolution
- https://docs.microsoft.com/en-us/nuget/nuget-org/policies/deleting-packages
- https://docs.microsoft.com/en-us/nuget/nuget-org/policies/export-control

For the concern around policy, NuGet should be more upfront with what the policy around security is. There are small blurbs regarding Prohibited use, but nothing surrounding the idea of a Security Policy.

NuGet should strive to provide a cohesive security policy documentation in which covers:
- Reporting security problems to NuGet
- NuGet’s security point of contact.
- Critical Updates / Security Notices from NuGet Systems
- Responding to Security Threats and Critical Updates by NuGet
- Vulnerability Scanning within NuGet
- Password & 2FA Policies

### Advisory
NuGet currently does not provide a location of a security advisory for the public to read through. Any known security advisory should be made aware on a page such as NuGet.org/advisories. These advisories should show when the vulnerability was published and reported, additionally the advisory should include an overview of the advisory, a fix/remediation to the vulnerability, and any links to advisories upstream such as GitHub Advisory / National Vulnerability Database. Users should be able to see the versions of the package that are affected by the vulnerability, and the versions that are unaffected by the vulnerability.