# Flag vulnerable packages - Stage 1

* Status: **Reviewing**
* Author(s): [Anand Gaurav](https://github.com/anangaur) ([@adgrv](https://twitter.com/adgrv)), [Xavier Decoster](https://github.com/xavierdecoster) ([@xavierdecoster](https://twitter.com/xavierdecoster))

## Issue

Flag vulnerable packages [#8087](https://github.com/NuGet/Home/issues/8087)

## Problem

Today developers take dependency on a set of packages directly or indirectly (through transitive dependencies) and have no way to understand if any of their dependencies bring in any known vulnerabilities.

## Goals

This is a security feature aiming to fill a gap in the .NET package management ecosystem known as *package vulnerability auditing*.

NuGet should be able to flag vulnerable packages used in projects/solutions.

The ultimate goal is to *reduce exposure to known vulnerabilities* in NuGet packages, and *increase adoption rate of fixes* for those known vulnerabilities.

## Non-Goals

* At this point, NuGet.org won't have a way for users to input vulnerability data into the system. All vulnerability data will be sourced from external systems. (no self-reporting)
* This feature is an enhancement to the NuGet v3 protocol. We won't surface this in earlier versions of the NuGet protocol.
* `NuGet.Server` is out-of-scope for this feature at this point.

## Scope

There are multiple scenarios for flagging and reporting vulnerabilities. This feature will be implemented in several stages which will enable a subset of those as discussed below.

### Stage 1 - MVP

For the [MVP](https://en.wikipedia.org/wiki/Minimum_viable_product) of this feature, we'll focus on:

* Enabling ***consumers** to be informed about known vulnerabilities before installation* of a package.
* Enabling ***authors** to be informed about known vulnerabilities in their packages*.
* Leveraging **existing, curated, and publicly available known vulnerabilities** affecting NuGet packages.

This should help prevent *new* installs of packages that are known to be vulnerable, and trigger authors into providing a fix through a new package version on nuget.org.

NuGet will not support self-reporting of vulnerabilities at this time and instead rely on an existing data provider of curated vulnerability information. For the MVP of this feature, all vulnerability data will be sourced from external systems. The initial focus is on leveraging [GitHub's Security Workflow](https://github.com/features/security) and integration with [GitHub's GraphQL API](https://developer.github.com/v4/). This allows us to build an initial end-to-end experience without having to deal with the complexities of curating vulnerability reports.

#### ✔️ In scope (Stage 1)

* For CLI:
  * A CLI command to **list vulnerabilities** in a project/solution project graph

* For Visual Studio:
  * **Display vulnerability information** in the package graph on `Installed` tab of Package Manager Dialog (PMUI)
  * **Display vulnerability information** for *transitive packages* in PMUI (additional UX complexity) - note that this is dependent on transitive packages being displayed in general, which is to be specced separately

* For nuget.org:
  * **Automatically ingest and refresh NuGet package vulnerability data from GitHub**
  * **Surface package vulnerability information on-demand**:
    * as part of package metadata in `v3` registration blobs (`JSON`)
    * by showing vulnerability information on package details page and version history

#### ❌ Out of scope (Stage 1)

Some enhancements to this feature are out of scope for the initial implementation of this feature because there are several unknowns still to be clarified. See also the *Open Questions* section below.

* Enable `restore` to Inform or Warn
* Expose vulnerability metadata in nuget.org *Search* service (not required for MVP)

## Solution (Stage 1)

### Protocol

To be able to show vulnerability information for phase 1 in PMUI and CLI clients, we need to update the protocol.

To this end, the following changes will happen to the package registration JSON blobs (to each *version-specific* blob, not the *index.json*):

| Name | Type | Required | Description |
|---|---|---|---|
| vulnerabilities | Array of Objects | No | Describes the vulnerabilities information associated with a package |
| vulnerabilities[x].severity | String | Yes | "Low", "Moderate", "High", or "Critical" |
| vulnerabilities[x].advisoryUrl | String | Yes | URL to discover additional information about the security advisory for this vulnerability |

#### Forward Compatibility

Clients should just not display the severity if they don't understand the value that is returned. The `severity` element values can be treated *case-insensitive*.

### List Vulnerabilities using a CLI command

[See client spec for `dotnet list package --vulnerable`.](https://github.com/NuGet/Home/blob/dev/proposed/2020/PackageVulnerability/DotnetListPackageVulnerable.md)

### Display Vulnerabilities in Visual Studio PMUI

* `Installed` tab shows a warning icon that leads to vulnerable package, when the package has **High** or **Critical** vulnerabilities
* `Installed` tab also shows transitive packages as an accordion - collapsed, by default. It has a warning icon too when any of the transitive packages have vulnerabilities (**High** or **Critical**)

   ![image](https://user-images.githubusercontent.com/14800916/65348883-057af680-db97-11e9-8a2a-b02be76c9668.png)

   Showing vulnerability in transitive package:
   ![image](https://user-images.githubusercontent.com/14800916/65349163-9f42a380-db97-11e9-8de5-c81613e47d5d.png)

> **Note**: Irrespective of the criticality of the vulnerability, the details pane will always show the vulnerability information - with warning icon for Critical/High vulnerabilities and info for others. Just that Installed tab won't warn in those cases.
