The NuGet project tracks issues and feature requests using the [GitHub issue tracker](https://github.com/NuGet/Home/issues) for the various [NuGet repositories](https://github.com/NuGet/Home#repos-and-projects).

## Before Submitting an Issue
First, please do a search in [open issues](https://github.com/NuGet/Home/issues) to see if the issue or feature request has already been filed. Use this [query](https://github.com/NuGet/Home/issues?q=is%3Aissue+is%3Aopen+sort%3Areactions-%2B1-desc) to search for the most popular feature requests.

If you find your issue already exists, make relevant comments and add your [reaction](https://github.com/blog/2119-add-reactions-to-pull-requests-issues-and-comments). Use a reaction in place of a "+1" comment.

👍 - upvote

👎 - downvote

The NuGet project is distributed across multiple repositories, try to file the issue against the correct repository [Related Projects](https://github.com/NuGet/Home#repos-and-projects).

If your issue is a question then please ask the question on [Stack Overflow](https://stackoverflow.com/questions/tagged/nuget) using the tag `nuget`. Additionally, you can ask a question using [Microsoft Q&A](https://docs.microsoft.com/en-us/answers/topics/dotnet-package-management.html) under the `package management` section.

If you cannot find an existing issue that describes your bug or feature, submit an issue using the guidelines below.

## Bug Reports
A bug is a demonstrable problem that is caused by code in the repository. Good bug reports are extremely helpful for our developers who maintain this project.

Guidelines for bug reports:

1. Validate your code - Ensure that your problem isn’t caused by an error in your code.
1. Use the GitHub issue search - Check if the issue has already been reported.
1. Check if the issue has been fixed - Try to reproduce the issue using the latest [Preview](https://www.visualstudio.com/vs/preview/) or `dev` Build.
1. Isolate the problem - Create a [minimal, complete, and verifiable example](https://stackoverflow.com/help/mcve) to demonstrate the problem.

A good bug report shouldn’t leave others needing to ask you constantly for more information. Please try to be as detailed as possible in your report. Here are some tips that will help when filing an issue:

* Reproducible steps (1. 2. 3.) and what you expected versus what you actually saw.
* Images, animations, or a link to a video. **Note: Images and animations illustrate repro-steps but do not replace them.**
* A code snippet that demonstrates the issue or a link to a code repository we can easily pull down onto our machine to recreate the issue.
* Any respective build & deployment logs such as Diagnostic Build Output and NuGet Package Manager Console logs.
* Your environment's version information. You can find this through a command like `Help -> About Visual Studio`

## Suggestions and Feature requests

Suggestions and feature requests are welcomed. Before opening a suggestion or feature request, please take a moment to find out whether your idea fits with the scope and goals of the project. It’s up to you to make a strong case to convince the project maintainers and community the merits of the suggestion or feature. Please provide as much detail and context as possible.

Additionally, do check the existing [Issues](https://github.com/NuGet/Home/issues), [Pull Requests](https://github.com/NuGet/Home/pulls), and [NuGet Designs](https://github.com/NuGet/Home/tree/dev/designs) to see if your idea is already captured. If it is, consider adding feedback to the existing issue, pull request, or contribute directly to the design.

## Pull requests
Good pull requests of patches, improvements, new features, etc are great contributions. They should however remain focused in scope and avoid unrelated commits.

Before embarking on any significant pull request, please ask a maintainer in a GitHub issue if the scope of the pull request would be reasonable to merge into the project. Otherwise you can potentially waste a lot of time working on something that might not be relevant to the project’s goals.

While creating a pull request, please also include the intent for which you'd like the changes to land. By default, we ask that you pull against the `dev` branch. However if you'd like to see a change in the next service release or preview release of Visual Studio, please communicate with a maintainer of this project to understand if the changes will be able to make the intended release.

## Issue Triage Policy

The NuGet team receives a significant amount of bugs and feature requests and while we'd love to address everyone's concern, this isn't practical.
[Read more about our issue triage policy.](Issue-Triage-Policy.md)

## Contributing Fixes
If you are interested in fixing issues and contributing directly to the code base, please see the document [Contribute To NuGet](https://github.com/NuGet/Home/wiki/Contribute-to-NuGet).

## Thank You!

Your contributions to open source, large or small, make great projects like this possible. Thank you for taking the time to contribute to this project.
