/* Copyright 2023-2024 Norconex Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.norconex.importer.handler.condition.impl;

import java.time.ZoneId;
import java.time.ZonedDateTime;

/**
 * Provides a date time value which may be the same on each invocation, or
 * change each time, based on implementation.
 */
public interface DateProvider {

    /**
     * Static or dynamic date-time.
     * @return date time.
     */
    ZonedDateTime getDateTime();

    /**
     * The zone ID, which should always be the same for this instance,
     * regardless whether the date-time is dynamic or static. Invoking this
     * method should not impact the date-time generated by
     * {@link #getDateTime()}.
     * @return zone id
     */
    ZoneId getZoneId();
}
