/* Copyright 2022-2023 Norconex Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.norconex.crawler.web.fetch.impl;

import com.norconex.crawler.core.doc.CrawlDocState;
import com.norconex.crawler.web.fetch.HttpFetchResponse;

import lombok.Builder;
import lombok.Data;

/**
 * HTTP response information obtained from fetching a document.
 * @since 4.0.0
 */
@Builder
@Data
public class GenericHttpFetchResponse implements HttpFetchResponse {
    private CrawlDocState crawlDocState;
    private int statusCode;
    private String reasonPhrase;
    private Exception exception;
    private String userAgent;
    private String redirectTarget;
}
