# Contributing

We welcome contributions from the community to help improve this project.  
Your input is valuable to us.

You can contribute to the project in the following ways:

### **Create Issues**  
Feel free to create issues for:
- feature requests,
- bug fixes,
- documentation improvements,
- test cases,
- general questions,
- or any recommendations you may have.
### **Merge Requests**  
Please avoid multiple different changes in one merge request.
1. **Fork** the repository,
2. **commit and push** your changes,
3. and submit your **merge request**:
    - with a clear explanation of the changes you've made,
    - and a note with your thoughts about your tests.

There are many reasons for submitting a merge request:
- Fixing bugs,
- implement new features,
- improve documentation,
- and adding tests.

## Rules for Contributions

To ensure a smooth contribution process, please follow the rules below:

- **License Awareness**: Be aware of and check the LICENSE file before contributing to understand the project's licence terms.
- **Respect the Licence Terms**: Ensure that your contributions comply with the project's license terms.
- **Avoid Plagiarism**: Do not plagiarise code or content from other sources. All contributions should be original work or properly attributed.
- **Platform Rules** Also be sure to follow the rules of the provider and the platform.

## Thank you
A big thank you, for considering a contribution.
If anything is unclear, please contact us via a issue with your question.
