# DogFoodie Mobile App

DogFoodie is a mobile application developed for dog owners to manage their pets' nutrition and food preferences. It allows users to track food consumption, access nutritional information, and receive recommended food options based on their dog's needs. In addition, admin users have the ability to manage products, orders, sales, users, and articles through an enhanced admin panel.

## Features

- **Food Tracking**: Keep track of your dog's food consumption.
- **Nutritional Information**: Access detailed nutritional information about various dog foods.
- **Personalized Recommendations**: Get food recommendations based on your dog's breed, age, and health condition.
- **Admin Product Management**: Admin users can manage product data with full CRUD (Create, Read, Update, Delete) functionality.
- **Order Management**: Admins can view and manage customer orders.
- **Sales Tracking**: Admin users can view sales data.
- **Article Management**: Admins can create, read, and delete articles related to dog care and nutrition.
- **User Profile**: Users can update and manage their profile information.
- **SQLite Database**: Utilizes SQLite for efficient local data storage.

## Installation

To run the DogFoodie app locally, follow these steps:

1. **Clone the repository**:
   ```bash
   git clone https://github.com/NimsaraC/DogFoodie-Mobile-App.git
   ```

2. **Open the project in Android Studio**:
   - Launch Android Studio.
   - Select `Open an existing Android Studio project`.
   - Navigate to the cloned `DogFoodie-Mobile-App` directory and open it.

3. **Build the project**:
   - Click on `Build` in the top menu and then select `Rebuild Project`.

4. **Run the app**:
   - Connect your Android device or start an emulator.
   - Click the `Run` button in Android Studio to deploy the app.

## Usage

1. Open the app on your Android device or emulator.
2. Create an account or log in.
3. Start tracking your dog's food and accessing nutritional information.
4. If you are an admin, you can manage products, orders, sales, users, and articles through the admin panel.

## Technologies Used

- **Programming Language**: Java
- **IDE**: Android Studio
- **Database**: SQLite

## Contributing

Contributions are welcome! Please follow these steps to contribute:

1. Fork the repository.
2. Create a new branch (`git checkout -b feature/YourFeature`).
3. Make your changes and commit them (`git commit -m 'Add some feature'`).
4. Push to the branch (`git push origin feature/YourFeature`).
5. Create a new Pull Request.

## License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.

## Contact

For any inquiries, please reach out to [c.t.nimsara@gmail.com](mailto:c.t.nimsara@gmail.com).
