# .Prompts

This repository contains a collection of AI-assisted development prompts designed to improve code quality, consistency, and efficiency in your projects via [Nice Prompt Extension](https://marketplace.visualstudio.com/items?itemName=Niceprompt.nice-prompt)

![image](https://github.com/user-attachments/assets/f2c283fc-d759-4fb1-9f74-f756f8fb417e)


## Purpose

The main goals of this repository are to provide a boilerplate for any project and to provide a bank of prompts for any future projects.

1. Provide standardized prompts for common development tasks
2. Ensure consistent implementation of common patterns
3. Store and update your prompts for future use via [Nice Prompt Extension](https://marketplace.visualstudio.com/items?itemName=Niceprompt.nice-prompt)

## Available Prompts

This repository includes the following types of prompts:

| Use Case                                 |
|------------------------------------------|
| [Supabase](https://supabase.com)         |
| [Next.js](https://nextjs.org)            |
| [React Native](https://reactnative.dev)  |
| [Tailwind CSS](https://tailwindcss.com)  |
| [React](https://reactjs.org)             |
| [Express](https://expressjs.com)         |
| [Tanstack Query](https://tanstack.com/)   |

## How to Use

1. Clone this repository or copy the desired prompt files into your project's `.prompts` folder.
2. Call the prompt file with @mention the prompt file name in the ai-chat.
3. Use the generated code as a starting point, and adjust as needed for your specific use case.

Tip: Copy your prompt in [Nice Prompt Extension](https://marketplace.visualstudio.com/items?itemName=Niceprompt.nice-prompt) after you connected the folder to the repository. Your local markdown file will be automatically updated.

## Contributing

Contributions to this repository are welcome! If you have ideas for new prompts or improvements to existing ones, please submit a pull request or open an issue.

How to send new prompts:

1. Fork the repository
2. Login to Nice Prompt via [Extension](https://marketplace.visualstudio.com/items?itemName=Niceprompt.nice-prompt).
3. Create a new prompt folder and connect the folder to the repository you forked. Pay attention to the naming convention.
4. Add your prompts for the use case you want to add.
5. Create a pull request.

Tip: Write your prompt in [Nice Prompt Extension](https://marketplace.visualstudio.com/items?itemName=Niceprompt.nice-prompt) after you connected the folder to the repository. Your local markdown file will be automatically updated.

## How to use Nice Prompt Extension

https://github.com/user-attachments/assets/3a8547db-59a2-4187-9fd1-54d9b5472001


## Follow Nice Prompt

[LinkedIn](https://www.linkedin.com/company/nice-prompt)
[X](https://x.com/niceprompt)
[GitHub](https://github.com/nice-prompt)
[Website](https://niceprompt.app)
