# 以下均为需要开发的库的基本想法

## Uploader

文件上传库需要实现的功能：

1.大文件分片上传

2.断点重传

3.监控文件切片上传进度和上传预估时间的显示

4.文件上传暂停

5.文件上传取消

是否需要基于视图层 + 逻辑层 相分离的逻辑？？

new Uploader({

​ api:"",

​ target:"#app | .sss"

})

Uploader 自定义事件的实现本质上是发布订阅模式

自定义事件：

chunkSend: 当前分片开始上传的时候触发

fileSend: 整个文件开始上传的时候触发

chunkProgress: 当前分片传输途中触发

fileProgress:整个文件上传途中触发

chunkComplete:分片传输完成触发（注意，这里的传输完成可能成功也可能失败也可能传输暂停/中断）

fileComplete:整个文件传输完成触发

chunkAbort:分片传输中断

fileAbort:整个文件传输中断

chunkError:分片传输发生错误

fileError:整个文件传输发生错误

chunkSuccess:分片传输成功

fileSuccess:整个文件传输成功

## Editor:

### Node(编辑器节点类型)

1. Text

```js
	{
		text:"demo",
		props:{
			color:"red",
			bold:true,
			italic:true
		}
	}
```

2. Element

```js
// This is a test demo
const editor = { //Editor类型的节点
	children: [
        { // Path = [0]
            type:"h2",
            children:[
                { // Path = [0,1]
                    text:"First"
                }
            ]
        },
		{ //Element类型的节点 Path = [1]
			type:"titleOne",
			props:{
				textAlign:"center"
			}
            children:[
            	{ // Path = [1,0]
            		type:"h1",
            		children:[
            			{ //Path = [1,0,0],Point = {offset:1,path:[1,0,0]}
							text:"1111"
        				}
           	 		]
				},
            	{ // Element类型节点 Path = [1,1]
					type:"paragraphy",
            		children:[
            			{ //Text Path = [1,1,0],Point = {offset:3,path:[1,1,0]}
            				text:"12345"
        				},
        				{ //Text Path = [1,1,1]
            				text:"abcderf"
        				}
            		]
        		},
            	{ //Text类型的节点 Path = [1,2]
            		text:"This is a first level title",
            		props:{
            			color:"pink",
            			bold:true
            		}
				}
            ]
		},
        { //Element类型的节点 Path=[2]
            type: 'paragraphy',
            children:[
                { //Text类型的节点  Path = [2,0]
                    text:"This is ",
                    props:{ //文本节点的具体显示属性
                        color:"red",
                        bold:true,
                        backgroudColor:"blue",
                        borderRadius:5
                    }
                },
                {//Text类型的节点 Path = [2,1]
                    text:"a",
                    props:{
                        color:"blue"
                        italic:true
                    }
                },
                {//Text类型的节点 Path = [2,2]
                    text:" test demo",
                    props:{
                        backgroundColor:"green"
                    }
                }
            ]
        },
        { //Element类型的节点
            type:"paragraphy",
            props:{
                lineHeight: 10,
            },
            children:[
				{ //Text类型的节点
					text:"hello world"
                }
            ]
        }
	]
}
```

3. Editor

### Location(编辑器位置类型)

1. Range
2. Point
3. Path

### Operation(对编辑器的操作类型)

#### NodeOperation (对编辑器的节点进行操作，包括 Element 和 Text 类型的节点，更加关注节点的整体，比如分割节点只会考虑分割节点整体，而不会考虑将节点的内部也进行分割)

1. insert_node
2. remove_node
3. merge_node
4. split_node
5. move_node

#### TextOperation （单纯对 Text 节点中的文本进行修改，不涉及节点的拆分，合并移除等）

1. instert_text
2. remove_text

#### SelectionOperation( 对选区中包含的节点或者节点的部分进行操作，相比 NodeOperation 更加关注节点的部分信息，比如从 Text 节点内部的文本的某个偏移量为基准划分整个 Text 节点)

## VideoPlayer

### 尝试写一个基于视频流的媒体播放器（流媒体播放器）

常见的流媒体协议：![流媒体协议](D:\桌面\前端开发\流媒体协议.jpg)
所谓的流可以理解为前端通过分片向后端请求数据，获得一个个 chunk 接着添加到 video 的缓冲区中进行播放，也就是说基于 Range 的 HTTP 协议；传统的方式是直接加载整个视频到前端接着再进行播放，现代的做法是边加载边播放

### 关于 MP4 文件基本格式的调研

![image-20230113173201686](C:\Users\ASUS\AppData\Roaming\Typora\typora-user-images\image-20230113173201686.png)
**MP4 文件由众多 box 组成，因此 box 是 MP4 文件的基本组成单位**

#### Box 列举

1. **ftyp** -- File Type Box，一般在文件的开始位置，描述的文件的版本、兼容协议等。
   ![image-20230113172056424](C:\Users\ASUS\AppData\Roaming\Typora\typora-user-images\image-20230113172056424.png)

2. **moov** -- Movie Box，包含本文件中所有媒体数据的宏观描述信息以及每路媒体轨道的具体信息。一般位于 ftyp 之后，也有的视频放在文件末尾。
   ![image-20230113172301303](C:\Users\ASUS\AppData\Roaming\Typora\typora-user-images\image-20230113172301303.png)

-   **mvhd** -- Movie Header Box，记录整个媒体文件的描述信息，如创建时间、修改时间、时间度量标尺、可播放时长等。下图示例中，可以获取文件信息如时长为 3.637 秒。

    ![image-20230113173942750](C:\Users\ASUS\AppData\Roaming\Typora\typora-user-images\image-20230113173942750.png)

-   **udta** -- User Data Box，用户自定义数据。
-   **track** -- Track Box，记录媒体流信息，文件中可以存在一个或多个 track，它们之间是相互独立的。例如视频和音频就属于两个不同的 track。
    1. **tkhd** -- Track Header Box，包含关于媒体流的头信息。此处的媒体流可以是视频流，音频流，文本字幕流等等。
    2.

3. **mdat** -- Media Data Box，存放具体的媒体数据。
   ![image-20230113173418443](C:\Users\ASUS\AppData\Roaming\Typora\typora-user-images\image-20230113173418443.png)
