/* Hello World Example

   This example code is in the Public Domain (or CC0 licensed, at your option.)

   Unless required by applicable law or agreed to in writing, this
   software is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
   CONDITIONS OF ANY KIND, either express or implied.
*/
#include <stdio.h>
#include "sdkconfig.h"
#include "freertos/FreeRTOS.h"
#include "freertos/task.h"
#include "esp_system.h"
#include "esp_spi_flash.h"

#include "hx711.h"

#define BUFF_PWR (9U)
#define BUFF_SIZE (1 << BUFF_PWR)
#define BUFF_SIZE_MASK (BUFF_SIZE - 1U)
typedef struct{
	int32_t buff[BUFF_SIZE];
	uint8_t writeIndex;
}buffer_t;
buffer_t weight_buffer={0}; //FIFO holding past 2^BUFF_PWR values

void writeBuff(buffer_t *buffer, int32_t value) //write to buffer
{
	buffer->buff[(++buffer->writeIndex) & BUFF_SIZE_MASK] = value;
}

int32_t readn(buffer_t *buffer, size_t Xn) //read from buffer Xn=0 will read last written value
{
	return buffer->buff[(buffer->writeIndex - Xn) & BUFF_SIZE_MASK];
}

bool is_diff(int32_t a, int32_t b, int32_t range)
{
	return (a / range) != (b / range);
}

int32_t get_mean(struct buffer *buffer)
{
	int32_t sum_up = 0;
	for (size_t i = 0; i < BUFF_SIZE; ++i)
	{
		sum_up += readn(buffer, i);
	}

	sum_up = sum_up >> BUFF_PWR; // divide by 2^BUFF_PWR for average
	return sum_up;				 // is now the average
}

void app_main(void)
{
//    printf("Hello world!\n");
//
//    /* Print chip information */
//    esp_chip_info_t chip_info;
//    esp_chip_info(&chip_info);
//    printf("This is %s chip with %d CPU core(s), WiFi%s%s, ",
//            CONFIG_IDF_TARGET,
//            chip_info.cores,
//            (chip_info.features & CHIP_FEATURE_BT) ? "/BT" : "",
//            (chip_info.features & CHIP_FEATURE_BLE) ? "/BLE" : "");
//
//    printf("silicon revision %d, ", chip_info.revision);
//
//    printf("%dMB %s flash\n", spi_flash_get_chip_size() / (1024 * 1024),
//            (chip_info.features & CHIP_FEATURE_EMB_FLASH) ? "embedded" : "external");
//
//    printf("Minimum free heap size: %d bytes\n", esp_get_minimum_free_heap_size());
//
//    fflush(stdout);

	hx711_event_t hx711ev;
	QueueHandle_t* hx711_events = hx711_init();

	gpio_set_level(PD_SCK_PIN, 0); //enable chip

	while (1) //main loop
	{
		static char c;
		c++;
#define NADC 256ULL
		size_t i=NADC;
		long long adcsumm=0;
		do{
			while (xQueueReceive(
				hx711_events
				,&hx711ev
				, 0)==0);


//			if (xQueueReceive(
//				hx711_events
//				,&hx711ev
//				, 0))
//
//			{
//				writeBuff(&weight_buffer, hx711ev.value);
//			}

		adcsumm += hx711ev.value;//get_mean(&weight_buffer);
		}while(--i);


		printf("\n\rADC:%+09d",(int32_t)(adcsumm/NADC));


		vTaskDelay(10 / portTICK_RATE_MS); //wait
	}


}
