# NeoApps.ai Tutorial

Welcome to the NeoApps.ai tutorial! This guide will walk you through using the drag-and-drop designer to create pages for your app and test the generated backend APIs.

## YouTube Demo Video

Watch our YouTube demo video to see how to use the drag-and-drop designer to create your app pages:

[![Watch the video](https://img.youtube.com/vi/Xa59gzPzNPI/0.jpg)](https://www.youtube.com/watch?v=Xa59gzPzNPI&t=45s)

[NeoApps.ai YouTube Demo](https://www.youtube.com/watch?v=Xa59gzPzNPI&t=45s)

## Architecture Diagram of Generated App

To understand the structure of the applications generated by NeoApps.ai, check out the architecture diagram:

![Architecture Diagram](https://docs.neoapps.ai/assets/images/Architecture_diagram-3c15aa0a3418228b86e43cb556ba1966.png)

## Frontend: React Application

### Drag and Drop Designer Overview

Get started with the drag-and-drop designer to create and customize your app's pages:

- **Overview of the Designer:** [Drag and Drop Designer Overview](https://docs.neoapps.ai/dnd-usage/dnd_dashboard)
- **Configuring the Designer:** [Configure DND](https://docs.neoapps.ai/dnd-usage/working-with-components)
- **Configuring Data Components:** [Configure Data Components](https://docs.neoapps.ai/category/how-to-configure-data-table-components)
- **View and Edit Modes:** [View and Edit Modes](https://docs.neoapps.ai/dnd-usage/view-and-edit-modes)
- **UI Customization:** [UI Customization](https://docs.neoapps.ai/dnd-usage/ui-customization)

## Backend: Swagger API Usage

Learn how to test APIs created in .NET after running your project locally:

- **API Testing Guide:** [How to Test API in .NET](https://docs.neoapps.ai/User%20Guide/api-testing)

## Subscribe to Our YouTube Channel

Stay updated with more tutorials and videos by subscribing to our YouTube channel:

[Subscribe to NeoApps.ai YouTube Channel](https://www.youtube.com/@NeoAppsAI)

### Subscribe Button

Subscribe to our channel for more videos and updates:


We hope this tutorial helps you get started with NeoApps.ai. Feel free to explore more documentation and resources for further assistance!

