#!/bin/bash

# Set the path to the C# solution file
solutionFilePath=../DotNet_Output/solution/NoCodeAppAPI/NoCodeAppAPI.sln

# Set the working directory for the solution file
workingDirectory=./

outputFile=./output.txt

# Set the path to the dotnet executable
dotnetPath=dotnet

$dotnetPath restore $solutionFilePath
$dotnetPath build $solutionFilePath
$dotnetPath run --project $solutionFilePath > $outputFile

# Get the exit code of the process
exitCode=$?

if [ $exitCode -eq 0 ]; then
	echo "Build succeeded"
elif [ $exitCode -eq 1 ]; then
	echo "Build succeeded with some warnings"
	cat $outputFile
else
    echo "Build Failed"
	cat $outputFile
fi
