// Copyright (C) 2024 Jérôme "SirLynix" Leclercq (lynix680@gmail.com)
// This file is part of the "Nazara Engine - Core module"
// For conditions of distribution and use, see copyright notice in Export.hpp

#include <Nazara/Core/ByteArray.hpp>
#include <ostream>

namespace Nz
{
	/*!
	* \ingroup core
	* \class Nz::ByteArray
	* \brief Core class that represents an array of bytes
	*/

	/*!
	* \brief Gives a string representation in base 16
	* \return String in base 16
	*/

	std::string ByteArray::ToHex() const
	{
		std::size_t length = m_array.size() * 2;

		std::string hexOutput(length, '\0');
		for (std::size_t i = 0; i < m_array.size(); ++i)
			std::sprintf(&hexOutput[i * 2], "%02x", m_array[i]);

		return hexOutput;
	}

	/*!
	* \brief Output operator
	* \return The stream
	*
	* \param out The stream
	* \param byteArray The ByteArray to output
	*/

	std::ostream& operator<<(std::ostream& out, const Nz::ByteArray& byteArray)
	{
		out << byteArray.ToHex();
		return out;
	}
}
